/*
 * Decompiled with CFR 0.152.
 */
package troy.autofish;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import troy.autofish.RiftModAutofish;
import troy.autofish.monitor.FishMonitorMP;
import troy.autofish.monitor.FishMonitorMPMotion;
import troy.autofish.monitor.FishMonitorMPSound;

public class Autofish {
    private cft minecraft;
    private FishMonitorMP fishMonitorMP;
    private RiftModAutofish mod;
    private boolean hookExists = false;
    public long hookRemovedAt = 0L;
    public long timeMillis = 0L;
    private long queuedCastAt = 0L;
    private boolean queuedRodSwitch = false;

    public Autofish(RiftModAutofish mod) {
        this.mod = mod;
        this.setDetection();
    }

    public void onMinecraftStart() {
        this.minecraft = cft.s();
    }

    public void onTick(cft minecraft) {
        if (minecraft.g != null && minecraft.i != null && this.mod.getConfig().isAutofishEnabled()) {
            this.timeMillis = System.currentTimeMillis();
            this.checkRodSwitch();
            if (this.holdingFishingRod()) {
                if (minecraft.i.cb != null) {
                    this.hookExists = true;
                    if (!minecraft.x()) {
                        this.fishMonitorMP.hookTick(this, minecraft, minecraft.i.cb);
                    }
                } else {
                    this.removeHook();
                }
                this.checkRecast();
            } else {
                this.removeHook();
                if (!this.hasQueuedRodSwitch()) {
                    this.resetRecast();
                }
            }
        }
    }

    public void handlePacket(iv<?> packet) {
        if (this.mod.getConfig().isAutofishEnabled() && !this.minecraft.x()) {
            this.fishMonitorMP.handlePacket(this, packet, this.minecraft);
        }
    }

    public void handleChat(jn packet) {
        if (this.mod.getConfig().isAutofishEnabled() && !this.minecraft.x() && this.holdingFishingRod() && (this.hookExists || this.timeMillis - this.hookRemovedAt < 1000L)) {
            if (StringUtils.deleteWhitespace((String)this.mod.getConfig().getClearLagRegex()).isEmpty()) {
                return;
            }
            Matcher matcher = Pattern.compile(this.mod.getConfig().getClearLagRegex()).matcher(xw.a((String)packet.b().d()));
            if (matcher.matches()) {
                this.queueRecast();
            }
        }
    }

    public void catchingFishTick(aog angler, int ticksCatchable) {
        if (this.mod.getConfig().isAutofishEnabled() && this.minecraft.x() && this.minecraft.i != null && this.minecraft.i.cb != null && ticksCatchable > 0 && angler.bt().compareTo(this.minecraft.i.bt()) == 0 && !this.hasQueuedRecast()) {
            this.reel();
        }
    }

    public void reel() {
        this.queueRecast();
        this.useRod();
        if (this.mod.getConfig().isMultirod()) {
            this.queueRodSwitch();
        }
    }

    private void checkRecast() {
        if (this.hasQueuedRecast() && this.timeMillis - this.queuedCastAt > this.mod.getConfig().getRecastDelay()) {
            boolean cast = true;
            if (this.mod.getConfig().isNoBreak() && this.getHeldItem().g() >= 63) {
                cast = false;
            }
            if (cast) {
                this.useRod();
            }
            this.resetRecast();
            this.resetRodSwitch();
        }
    }

    public void queueRecast() {
        this.queuedCastAt = this.timeMillis;
    }

    private void removeHook() {
        if (this.hookExists) {
            this.hookExists = false;
            this.hookRemovedAt = this.timeMillis;
            this.fishMonitorMP.handleHookRemoved();
        }
    }

    public boolean hasQueuedRecast() {
        return this.queuedCastAt > 0L;
    }

    public void resetRecast() {
        this.queuedCastAt = 0L;
    }

    private void checkRodSwitch() {
        if (this.hasQueuedRodSwitch() && this.timeMillis - this.queuedCastAt > this.mod.getConfig().getRecastDelay() - 100L) {
            this.switchToFirstRod(this.minecraft.i);
            this.resetRodSwitch();
        }
    }

    private void queueRodSwitch() {
        this.queuedRodSwitch = true;
    }

    private boolean hasQueuedRodSwitch() {
        return this.queuedRodSwitch;
    }

    public void resetRodSwitch() {
        this.queuedRodSwitch = false;
    }

    public void switchToFirstRod(ctj player) {
        aof inventory = player.bB;
        for (int i = 0; i < inventory.a.size(); ++i) {
            ate slot = (ate)inventory.a.get(i);
            if (slot.b() != atf.aY || i < 0 || i >= 9) continue;
            if (this.mod.getConfig().isNoBreak()) {
                if (slot.g() >= 63) continue;
                inventory.d = i;
                return;
            }
            inventory.d = i;
            return;
        }
        this.resetRecast();
        this.resetRodSwitch();
    }

    public void useRod() {
        this.minecraft.e.a((aog)this.minecraft.i, (axy)this.minecraft.g, this.getCorrectHand());
    }

    public boolean holdingFishingRod() {
        return this.isItemFishingRod(this.getHeldItem().b());
    }

    private adk getCorrectHand() {
        if (!this.mod.getConfig().isMultirod() && this.isItemFishingRod(this.minecraft.i.cC().b())) {
            return adk.b;
        }
        return adk.a;
    }

    private ate getHeldItem() {
        if (!this.mod.getConfig().isMultirod() && this.isItemFishingRod(this.minecraft.i.cC().b())) {
            return this.minecraft.i.cC();
        }
        return this.minecraft.i.cB();
    }

    private boolean isItemFishingRod(ata item) {
        return item == atf.aY || item instanceof ast;
    }

    public void setDetection() {
        this.fishMonitorMP = this.mod.getConfig().isUseSoundDetection() ? new FishMonitorMPSound() : new FishMonitorMPMotion();
    }
}

