/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbtt_packedchar")
public class STBTTPackedchar
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X0;
    public static final int Y0;
    public static final int X1;
    public static final int Y1;
    public static final int XOFF;
    public static final int YOFF;
    public static final int XADVANCE;
    public static final int XOFF2;
    public static final int YOFF2;

    STBTTPackedchar(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public STBTTPackedchar(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), STBTTPackedchar.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="unsigned short")
    public short x0() {
        return STBTTPackedchar.nx0(this.address());
    }

    @NativeType(value="unsigned short")
    public short y0() {
        return STBTTPackedchar.ny0(this.address());
    }

    @NativeType(value="unsigned short")
    public short x1() {
        return STBTTPackedchar.nx1(this.address());
    }

    @NativeType(value="unsigned short")
    public short y1() {
        return STBTTPackedchar.ny1(this.address());
    }

    public float xoff() {
        return STBTTPackedchar.nxoff(this.address());
    }

    public float yoff() {
        return STBTTPackedchar.nyoff(this.address());
    }

    public float xadvance() {
        return STBTTPackedchar.nxadvance(this.address());
    }

    public float xoff2() {
        return STBTTPackedchar.nxoff2(this.address());
    }

    public float yoff2() {
        return STBTTPackedchar.nyoff2(this.address());
    }

    public STBTTPackedchar x0(@NativeType(value="unsigned short") short value) {
        STBTTPackedchar.nx0(this.address(), value);
        return this;
    }

    public STBTTPackedchar y0(@NativeType(value="unsigned short") short value) {
        STBTTPackedchar.ny0(this.address(), value);
        return this;
    }

    public STBTTPackedchar x1(@NativeType(value="unsigned short") short value) {
        STBTTPackedchar.nx1(this.address(), value);
        return this;
    }

    public STBTTPackedchar y1(@NativeType(value="unsigned short") short value) {
        STBTTPackedchar.ny1(this.address(), value);
        return this;
    }

    public STBTTPackedchar xoff(float value) {
        STBTTPackedchar.nxoff(this.address(), value);
        return this;
    }

    public STBTTPackedchar yoff(float value) {
        STBTTPackedchar.nyoff(this.address(), value);
        return this;
    }

    public STBTTPackedchar xadvance(float value) {
        STBTTPackedchar.nxadvance(this.address(), value);
        return this;
    }

    public STBTTPackedchar xoff2(float value) {
        STBTTPackedchar.nxoff2(this.address(), value);
        return this;
    }

    public STBTTPackedchar yoff2(float value) {
        STBTTPackedchar.nyoff2(this.address(), value);
        return this;
    }

    public STBTTPackedchar set(short x0, short y0, short x1, short y1, float xoff, float yoff, float xadvance, float xoff2, float yoff2) {
        this.x0(x0);
        this.y0(y0);
        this.x1(x1);
        this.y1(y1);
        this.xoff(xoff);
        this.yoff(yoff);
        this.xadvance(xadvance);
        this.xoff2(xoff2);
        this.yoff2(yoff2);
        return this;
    }

    public STBTTPackedchar set(STBTTPackedchar src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static STBTTPackedchar malloc() {
        return STBTTPackedchar.create(MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static STBTTPackedchar calloc() {
        return STBTTPackedchar.create(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static STBTTPackedchar create() {
        return new STBTTPackedchar(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static STBTTPackedchar create(long address) {
        return new STBTTPackedchar(address, null);
    }

    @Nullable
    public static STBTTPackedchar createSafe(long address) {
        return address == 0L ? null : STBTTPackedchar.create(address);
    }

    public static Buffer malloc(int capacity) {
        return STBTTPackedchar.create(STBTTPackedchar.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBTTPackedchar.create(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(STBTTPackedchar.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : STBTTPackedchar.create(address, capacity);
    }

    public static STBTTPackedchar mallocStack() {
        return STBTTPackedchar.mallocStack(MemoryStack.stackGet());
    }

    public static STBTTPackedchar callocStack() {
        return STBTTPackedchar.callocStack(MemoryStack.stackGet());
    }

    public static STBTTPackedchar mallocStack(MemoryStack stack) {
        return STBTTPackedchar.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBTTPackedchar callocStack(MemoryStack stack) {
        return STBTTPackedchar.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBTTPackedchar.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBTTPackedchar.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBTTPackedchar.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBTTPackedchar.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static short nx0(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)X0));
    }

    public static short ny0(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)Y0));
    }

    public static short nx1(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)X1));
    }

    public static short ny1(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)Y1));
    }

    public static float nxoff(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)XOFF));
    }

    public static float nyoff(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)YOFF));
    }

    public static float nxadvance(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)XADVANCE));
    }

    public static float nxoff2(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)XOFF2));
    }

    public static float nyoff2(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)YOFF2));
    }

    public static void nx0(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)X0), (short)value);
    }

    public static void ny0(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)Y0), (short)value);
    }

    public static void nx1(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)X1), (short)value);
    }

    public static void ny1(long struct, short value) {
        MemoryUtil.memPutShort((long)(struct + (long)Y1), (short)value);
    }

    public static void nxoff(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)XOFF), (float)value);
    }

    public static void nyoff(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)YOFF), (float)value);
    }

    public static void nxadvance(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)XADVANCE), (float)value);
    }

    public static void nxoff2(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)XOFF2), (float)value);
    }

    public static void nyoff2(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)YOFF2), (float)value);
    }

    static {
        Struct.Layout layout = STBTTPackedchar.__struct((Struct.Member[])new Struct.Member[]{STBTTPackedchar.__member((int)2), STBTTPackedchar.__member((int)2), STBTTPackedchar.__member((int)2), STBTTPackedchar.__member((int)2), STBTTPackedchar.__member((int)4), STBTTPackedchar.__member((int)4), STBTTPackedchar.__member((int)4), STBTTPackedchar.__member((int)4), STBTTPackedchar.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X0 = layout.offsetof(0);
        Y0 = layout.offsetof(1);
        X1 = layout.offsetof(2);
        Y1 = layout.offsetof(3);
        XOFF = layout.offsetof(4);
        YOFF = layout.offsetof(5);
        XADVANCE = layout.offsetof(6);
        XOFF2 = layout.offsetof(7);
        YOFF2 = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<STBTTPackedchar, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected STBTTPackedchar newInstance(long address) {
            return new STBTTPackedchar(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="unsigned short")
        public short x0() {
            return STBTTPackedchar.nx0(this.address());
        }

        @NativeType(value="unsigned short")
        public short y0() {
            return STBTTPackedchar.ny0(this.address());
        }

        @NativeType(value="unsigned short")
        public short x1() {
            return STBTTPackedchar.nx1(this.address());
        }

        @NativeType(value="unsigned short")
        public short y1() {
            return STBTTPackedchar.ny1(this.address());
        }

        public float xoff() {
            return STBTTPackedchar.nxoff(this.address());
        }

        public float yoff() {
            return STBTTPackedchar.nyoff(this.address());
        }

        public float xadvance() {
            return STBTTPackedchar.nxadvance(this.address());
        }

        public float xoff2() {
            return STBTTPackedchar.nxoff2(this.address());
        }

        public float yoff2() {
            return STBTTPackedchar.nyoff2(this.address());
        }

        public Buffer x0(@NativeType(value="unsigned short") short value) {
            STBTTPackedchar.nx0(this.address(), value);
            return this;
        }

        public Buffer y0(@NativeType(value="unsigned short") short value) {
            STBTTPackedchar.ny0(this.address(), value);
            return this;
        }

        public Buffer x1(@NativeType(value="unsigned short") short value) {
            STBTTPackedchar.nx1(this.address(), value);
            return this;
        }

        public Buffer y1(@NativeType(value="unsigned short") short value) {
            STBTTPackedchar.ny1(this.address(), value);
            return this;
        }

        public Buffer xoff(float value) {
            STBTTPackedchar.nxoff(this.address(), value);
            return this;
        }

        public Buffer yoff(float value) {
            STBTTPackedchar.nyoff(this.address(), value);
            return this;
        }

        public Buffer xadvance(float value) {
            STBTTPackedchar.nxadvance(this.address(), value);
            return this;
        }

        public Buffer xoff2(float value) {
            STBTTPackedchar.nxoff2(this.address(), value);
            return this;
        }

        public Buffer yoff2(float value) {
            STBTTPackedchar.nyoff2(this.address(), value);
            return this;
        }
    }
}

