/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.villager;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.villager.VillagerData;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VillagerDataStorage {
    private static final VillagerDataStorage INSTANCE = new VillagerDataStorage();
    private final Map<UUID, VillagerData> data = new HashMap<UUID, VillagerData>();
    private UUID lastInteractedUUID;
    private boolean dirty;

    public static VillagerDataStorage getInstance() {
        return INSTANCE;
    }

    public void setLastInteractedUUID(UUID uuid) {
        this.lastInteractedUUID = uuid;
    }

    public boolean hasInteractionTarget() {
        return this.lastInteractedUUID != null;
    }

    @Nullable
    public VillagerData getDataForLastInteractionTarget() {
        return this.getDataFor(this.lastInteractedUUID, true);
    }

    public VillagerData getDataFor(@Nullable UUID uuid, boolean create) {
        VillagerData data;
        VillagerData villagerData = data = uuid != null ? this.data.get(uuid) : null;
        if (data == null && uuid != null && create) {
            this.setLastInteractedUUID(uuid);
            data = new VillagerData(uuid);
            this.data.put(uuid, data);
            this.dirty = true;
        }
        return data;
    }

    public void setTradeListPosition(int position) {
        VillagerData data = this.getDataFor(this.lastInteractedUUID, true);
        if (data != null) {
            data.setTradeListPosition(position);
            this.dirty = true;
        }
    }

    public void setLastPage(int page) {
        VillagerData data = this.getDataFor(this.lastInteractedUUID, true);
        if (data != null) {
            data.setLastPage(page);
            this.dirty = true;
        }
    }

    public void toggleFavorite(int tradeIndex) {
        VillagerData data = this.getDataFor(this.lastInteractedUUID, true);
        if (data != null) {
            data.toggleFavorite(tradeIndex);
            this.dirty = true;
        }
    }

    private void readFromNBT(gy nbt) {
        if (nbt == null || !nbt.c("VillagerData", 9)) {
            return;
        }
        he tagList = nbt.d("VillagerData", 10);
        int count = tagList.size();
        for (int i = 0; i < count; ++i) {
            gy tag = tagList.e(i);
            VillagerData data = VillagerData.fromNBT(tag);
            if (data == null) continue;
            this.data.put(data.getUUID(), data);
        }
    }

    private gy writeToNBT(@Nonnull gy nbt) {
        he tagList = new he();
        for (VillagerData data : this.data.values()) {
            tagList.a((ho)data.toNBT());
        }
        nbt.a("VillagerData", (ho)tagList);
        this.dirty = false;
        return nbt;
    }

    private String getFileName() {
        String worldName = StringUtils.getWorldOrServerName();
        if (worldName != null) {
            return "villager_data_" + worldName + ".nbt";
        }
        return "villager_data.nbt";
    }

    private File getSaveDir() {
        return new File(FileUtils.getMinecraftDirectory(), "itemscroller");
    }

    public void readFromDisk() {
        this.data.clear();
        try {
            File file;
            File saveDir = this.getSaveDir();
            if (saveDir != null && (file = new File(saveDir, this.getFileName())).exists() && file.isFile() && file.canRead()) {
                FileInputStream is = new FileInputStream(file);
                this.readFromNBT(hi.a((InputStream)is));
                is.close();
            }
        }
        catch (Exception e) {
            ItemScroller.logger.warn("Failed to read villager data from file", (Throwable)e);
        }
    }

    public void writeToDisk() {
        if (this.dirty) {
            try {
                File saveDir = this.getSaveDir();
                if (saveDir == null) {
                    return;
                }
                if (!saveDir.exists() && !saveDir.mkdirs()) {
                    ItemScroller.logger.warn("Failed to create the data storage directory '{}'", (Object)saveDir.getPath());
                    return;
                }
                File fileTmp = new File(saveDir, this.getFileName() + ".tmp");
                File fileReal = new File(saveDir, this.getFileName());
                FileOutputStream os = new FileOutputStream(fileTmp);
                hi.a((gy)this.writeToNBT(new gy()), (OutputStream)os);
                os.close();
                if (fileReal.exists()) {
                    fileReal.delete();
                }
                fileTmp.renameTo(fileReal);
                this.dirty = false;
            }
            catch (Exception e) {
                ItemScroller.logger.warn("Failed to write villager data to file!", (Throwable)e);
            }
        }
    }
}

