/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.villager;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public class VillagerData {
    private final UUID uuid;
    private List<Integer> favorites = new ArrayList<Integer>();
    private int tradeListPosition;
    private int lastPage;

    VillagerData(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public int getTradeListPosition() {
        return this.tradeListPosition;
    }

    void setTradeListPosition(int position) {
        this.tradeListPosition = position;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    void setLastPage(int page) {
        this.lastPage = page;
    }

    void toggleFavorite(int tradeIndex) {
        if (this.favorites.contains(tradeIndex)) {
            this.favorites.remove((Object)tradeIndex);
        } else {
            this.favorites.add(tradeIndex);
        }
    }

    public List<Integer> getFavorites() {
        return this.favorites;
    }

    public gy toNBT() {
        gy tag = new gy();
        tag.a("UUIDM", this.uuid.getMostSignificantBits());
        tag.a("UUIDL", this.uuid.getLeastSignificantBits());
        tag.b("ListPosition", this.tradeListPosition);
        tag.b("CurrentPage", this.lastPage);
        he tagList = new he();
        for (Integer val : this.favorites) {
            tagList.a((ho)new hd(val.intValue()));
        }
        tag.a("Favorites", (ho)tagList);
        return tag;
    }

    @Nullable
    public static VillagerData fromNBT(gy tag) {
        if (tag.c("UUIDM", 4) && tag.c("UUIDL", 4)) {
            VillagerData data = new VillagerData(new UUID(tag.i("UUIDM"), tag.i("UUIDL")));
            data.tradeListPosition = tag.h("ListPosition");
            data.lastPage = tag.h("CurrentPage");
            he tagList = tag.d("Favorites", 3);
            int count = tagList.size();
            data.favorites.clear();
            for (int i = 0; i < count; ++i) {
                data.favorites.add(tagList.h(i));
            }
            return data;
        }
        return null;
    }
}

