/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.util;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.event.InputHandler;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.recipes.CraftingRecipe;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.InputUtils;
import fi.dy.masa.itemscroller.util.ItemType;
import fi.dy.masa.itemscroller.util.MoveAction;
import fi.dy.masa.itemscroller.util.MoveAmount;
import fi.dy.masa.itemscroller.villager.VillagerData;
import fi.dy.masa.itemscroller.villager.VillagerDataStorage;
import fi.dy.masa.malilib.util.GuiUtils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class InventoryUtils {
    private static MoveAction activeMoveAction = MoveAction.NONE;
    private static int lastPosX;
    private static int lastPosY;
    private static int slotNumberLast;
    private static final Set<Integer> DRAGGED_SLOTS;
    private static WeakReference<aqx> sourceSlotCandidate;
    private static WeakReference<aqx> sourceSlot;
    private static ate stackInCursorLast;
    public static final ate EMPTY_STACK;

    public static void onSlotChangedCraftingGrid(axy world, aog player, ade craftMatrix, aqt inventoryCraftResult) {
        if (Configs.Generic.CLIENT_CRAFTING_FIX.getBooleanValue() && world.B && world instanceof crg && player instanceof ctj) {
            ate stack = ate.a;
            avk recipe = ((crg)world).E().b(craftMatrix, world);
            if (recipe != null && (recipe.c() || !world.X().b("doLimitedCrafting") || ((ctj)player).z().b(recipe))) {
                inventoryCraftResult.a(recipe);
                stack = recipe.a(craftMatrix);
            }
            inventoryCraftResult.a(0, stack);
        }
    }

    public static String getStackString(ate stack) {
        if (!InventoryUtils.isStackEmpty(stack)) {
            pc rl = fc.s.b((Object)stack.b());
            return String.format("[%s - display: %s - NBT: %s] (%s)", rl != null ? rl.toString() : "null", stack.q().getString(), stack.n() != null ? stack.n().toString() : "<no NBT>", stack.toString());
        }
        return "<empty>";
    }

    public static void debugPrintSlotInfo(cky gui, aqx slot) {
        if (slot == null) {
            ItemScroller.logger.info("slot was null");
            return;
        }
        boolean hasSlot = gui.h.c.contains(slot);
        ade inv = slot.d;
        String stackStr = InventoryUtils.getStackString(slot.d());
        ItemScroller.logger.info(String.format("slot: slotNumber: %d, getSlotIndex(): %d, getHasStack(): %s, slot class: %s, inv class: %s, Container's slot list has slot: %s, stack: %s, numSlots: %d", slot.e, AccessorUtils.getSlotIndex(slot), slot.e(), slot.getClass().getName(), inv != null ? inv.getClass().getName() : "<null>", hasSlot ? " true" : "false", stackStr, gui.h.c.size()));
    }

    private static boolean isValidSlot(aqx slot, cky gui, boolean requireItems) {
        return gui.h != null && gui.h.c != null && slot != null && gui.h.c.contains(slot) && (!requireItems || slot.e()) && !Configs.SLOT_BLACKLIST.contains(slot.getClass().getName());
    }

    public static boolean isCraftingSlot(cky gui, @Nullable aqx slot) {
        return slot != null && CraftingHandler.getCraftingGridSlots(gui, slot) != null;
    }

    private static boolean inventoryExistsAbove(aqx slot, apv container) {
        for (aqx slotTmp : container.c) {
            if (slotTmp.g >= slot.g || InventoryUtils.areSlotsInSameInventory(slot, slotTmp)) continue;
            return true;
        }
        return false;
    }

    public static boolean canShiftPlaceItems(cky gui) {
        aqx slot = AccessorUtils.getSlotUnderMouse(gui);
        cft mc = cft.s();
        ate stackCursor = mc.i.bB.s();
        return slot != null && !InventoryUtils.isStackEmpty(stackCursor) && InventoryUtils.isValidSlot(slot, gui, false) && !slot.e() && slot.a(stackCursor);
    }

    public static boolean tryMoveItems(cky gui, RecipeStorage recipes, boolean scrollingUp) {
        aqx slot = AccessorUtils.getSlotUnderMouse(gui);
        cft mc = cft.s();
        if (slot == null || !InventoryUtils.isStackEmpty(mc.i.bB.s())) {
            return false;
        }
        boolean villagerHandling = Configs.Toggles.SCROLL_VILLAGER.getBooleanValue() && gui instanceof clq && slot instanceof aqp;
        boolean craftingHandling = Configs.Toggles.CRAFTING_FEATURES.getBooleanValue() && InventoryUtils.isCraftingSlot(gui, slot);
        boolean keyActiveMoveEverything = Hotkeys.MODIFIER_MOVE_EVERYTHING.getKeybind().isKeybindHeld();
        boolean keyActiveMoveMatching = Hotkeys.MODIFIER_MOVE_MATCHING.getKeybind().isKeybindHeld();
        boolean keyActiveMoveStacks = Hotkeys.MODIFIER_MOVE_STACK.getKeybind().isKeybindHeld();
        boolean nonSingleMove = keyActiveMoveEverything || keyActiveMoveMatching || keyActiveMoveStacks;
        boolean moveToOtherInventory = scrollingUp;
        if (Configs.Generic.SLOT_POSITION_AWARE_SCROLL_DIRECTION.getBooleanValue()) {
            boolean above = InventoryUtils.inventoryExistsAbove(slot, gui.h);
            boolean bl = moveToOtherInventory = above == scrollingUp;
        }
        if (Configs.Generic.REVERSE_SCROLL_DIRECTION_SINGLE.getBooleanValue() && !nonSingleMove || Configs.Generic.REVERSE_SCROLL_DIRECTION_STACKS.getBooleanValue() && nonSingleMove) {
            moveToOtherInventory = !moveToOtherInventory;
        }
        if (!InventoryUtils.isValidSlot(slot, gui, !villagerHandling && !craftingHandling)) {
            return false;
        }
        if (craftingHandling) {
            return InventoryUtils.tryMoveItemsCrafting(recipes, slot, gui, moveToOtherInventory, keyActiveMoveStacks, keyActiveMoveEverything);
        }
        if (villagerHandling) {
            return InventoryUtils.tryMoveItemsVillager((clq)gui, slot, moveToOtherInventory, keyActiveMoveStacks);
        }
        if (!Configs.Toggles.SCROLL_SINGLE.getBooleanValue() && !nonSingleMove || !Configs.Toggles.SCROLL_STACKS.getBooleanValue() && keyActiveMoveStacks || !Configs.Toggles.SCROLL_MATCHING.getBooleanValue() && keyActiveMoveMatching || !Configs.Toggles.SCROLL_EVERYTHING.getBooleanValue() && keyActiveMoveEverything) {
            return false;
        }
        if (keyActiveMoveEverything) {
            InventoryUtils.tryMoveStacks(slot, gui, false, moveToOtherInventory, false);
        } else {
            if (keyActiveMoveMatching) {
                InventoryUtils.tryMoveStacks(slot, gui, true, moveToOtherInventory, false);
                return true;
            }
            if (keyActiveMoveStacks) {
                InventoryUtils.tryMoveStacks(slot, gui, true, moveToOtherInventory, true);
            } else {
                ate stack = slot.d();
                if (moveToOtherInventory) {
                    InventoryUtils.tryMoveSingleItemToOtherInventory(slot, gui);
                } else if (InventoryUtils.getStackSize(stack) < slot.b(stack)) {
                    InventoryUtils.tryMoveSingleItemToThisInventory(slot, gui);
                }
            }
        }
        return false;
    }

    public static boolean dragMoveItems(cky gui, cft mc, MoveAction action, int mouseX, int mouseY, boolean isClick) {
        if (!InventoryUtils.isStackEmpty(mc.i.bB.s())) {
            lastPosX = mouseX;
            lastPosY = mouseY;
            InventoryUtils.stopDragging();
            return false;
        }
        boolean cancel = false;
        if (isClick && action != MoveAction.NONE) {
            slotNumberLast = -1;
            lastPosX = mouseX;
            lastPosY = mouseY;
            activeMoveAction = action;
            cancel = InventoryUtils.dragMoveFromSlotAtPosition(gui, mouseX, mouseY, action);
        } else {
            action = activeMoveAction;
        }
        if (activeMoveAction != MoveAction.NONE && !cancel) {
            int absY;
            int distX = mouseX - lastPosX;
            int distY = mouseY - lastPosY;
            int absX = Math.abs(distX);
            if (absX > (absY = Math.abs(distY))) {
                int inc = distX > 0 ? 1 : -1;
                int x = lastPosX;
                while (true) {
                    int y = absX != 0 ? lastPosY + (x - lastPosX) * distY / absX : mouseY;
                    InventoryUtils.dragMoveFromSlotAtPosition(gui, x, y, action);
                    if (x != mouseX) {
                        x += inc;
                        continue;
                    }
                    break;
                }
            } else {
                int inc = distY > 0 ? 1 : -1;
                int y = lastPosY;
                while (true) {
                    int x = absY != 0 ? lastPosX + (y - lastPosY) * distX / absY : mouseX;
                    InventoryUtils.dragMoveFromSlotAtPosition(gui, x, y, action);
                    if (y == mouseY) break;
                    y += inc;
                }
            }
        }
        lastPosX = mouseX;
        lastPosY = mouseY;
        aqx slot = AccessorUtils.getSlotAtPosition(gui, mouseX, mouseY);
        if (slot != null) {
            if (gui instanceof clh) {
                int slotNumber;
                boolean isPlayerInv = ((clh)gui).i() == ary.n.a();
                slotNumberLast = slotNumber = isPlayerInv ? AccessorUtils.getSlotIndex(slot) : slot.e;
            } else {
                slotNumberLast = slot.e;
            }
        } else {
            slotNumberLast = -1;
        }
        return cancel;
    }

    public static void stopDragging() {
        activeMoveAction = MoveAction.NONE;
        DRAGGED_SLOTS.clear();
    }

    private static boolean dragMoveFromSlotAtPosition(cky gui, int x, int y, MoveAction action) {
        boolean flag;
        if (gui instanceof clh) {
            return InventoryUtils.dragMoveFromSlotAtPositionCreative(gui, x, y, action);
        }
        aqx slot = AccessorUtils.getSlotAtPosition(gui, x, y);
        cft mc = cft.s();
        MoveAmount amount = InputUtils.getMoveAmount(action);
        boolean bl = flag = slot != null && InventoryUtils.isValidSlot(slot, gui, true) && slot.a((aog)mc.i);
        if (flag && slot.e != slotNumberLast && (amount != MoveAmount.MOVE_ONE || !DRAGGED_SLOTS.contains(slot.e))) {
            switch (action) {
                case MOVE_TO_OTHER_MOVE_ONE: {
                    InventoryUtils.tryMoveSingleItemToOtherInventory(slot, gui);
                    break;
                }
                case MOVE_TO_OTHER_LEAVE_ONE: {
                    InventoryUtils.tryMoveAllButOneItemToOtherInventory(slot, gui);
                    break;
                }
                case MOVE_TO_OTHER_STACKS: {
                    InventoryUtils.shiftClickSlot(gui, slot.e);
                    break;
                }
                case MOVE_TO_OTHER_MATCHING: {
                    InventoryUtils.tryMoveStacks(slot, gui, true, true, false);
                    break;
                }
                case DROP_ONE: {
                    InventoryUtils.clickSlot(gui, slot.e, 0, aqa.e);
                    break;
                }
                case DROP_LEAVE_ONE: {
                    InventoryUtils.leftClickSlot(gui, slot.e);
                    InventoryUtils.rightClickSlot(gui, slot.e);
                    InventoryUtils.dropItemsFromCursor(gui);
                    break;
                }
                case DROP_STACKS: {
                    InventoryUtils.clickSlot(gui, slot.e, 1, aqa.e);
                    break;
                }
                case MOVE_DOWN_MOVE_ONE: 
                case MOVE_DOWN_LEAVE_ONE: 
                case MOVE_DOWN_STACKS: 
                case MOVE_DOWN_MATCHING: {
                    InventoryUtils.tryMoveItemsVertically(gui, slot, false, amount);
                    break;
                }
                case MOVE_UP_MOVE_ONE: 
                case MOVE_UP_LEAVE_ONE: 
                case MOVE_UP_STACKS: 
                case MOVE_UP_MATCHING: {
                    InventoryUtils.tryMoveItemsVertically(gui, slot, true, amount);
                    break;
                }
            }
            DRAGGED_SLOTS.add(slot.e);
        }
        return true;
    }

    private static boolean dragMoveFromSlotAtPositionCreative(cky gui, int x, int y, MoveAction action) {
        int slotNumber;
        boolean isPlayerInv;
        clh guiCreative = (clh)gui;
        aqx slot = AccessorUtils.getSlotAtPosition(gui, x, y);
        boolean bl = isPlayerInv = guiCreative.i() == ary.n.a();
        if (slot == null || slot.getClass() != aqx.class && !isPlayerInv) {
            return false;
        }
        cft mc = cft.s();
        MoveAmount amount = InputUtils.getMoveAmount(action);
        boolean flag = slot != null && InventoryUtils.isValidSlot(slot, gui, true) && slot.a((aog)mc.i);
        boolean cancel = flag && (amount == MoveAmount.LEAVE_ONE || amount == MoveAmount.MOVE_ONE);
        int n = slotNumber = isPlayerInv ? AccessorUtils.getSlotIndex(slot) : slot.e;
        if (flag && slotNumber != slotNumberLast && !DRAGGED_SLOTS.contains(slotNumber)) {
            switch (action) {
                case MOVE_TO_OTHER_MOVE_ONE: 
                case SCROLL_TO_OTHER_MOVE_ONE: {
                    InventoryUtils.leftClickSlot((cky)guiCreative, slot, slotNumber);
                    InventoryUtils.rightClickSlot((cky)guiCreative, slot, slotNumber);
                    InventoryUtils.shiftClickSlot((cky)guiCreative, slot, slotNumber);
                    InventoryUtils.leftClickSlot((cky)guiCreative, slot, slotNumber);
                    cancel = true;
                    break;
                }
                case MOVE_TO_OTHER_LEAVE_ONE: {
                    if (!isPlayerInv) {
                        InventoryUtils.leftClickSlot((cky)guiCreative, slot, slotNumber);
                        InventoryUtils.rightClickSlot((cky)guiCreative, slot, slotNumber);
                        aqx slotFirst = (aqx)gui.h.c.get(0);
                        InventoryUtils.leftClickSlot((cky)guiCreative, slotFirst, slotFirst.e);
                    }
                    cancel = true;
                    break;
                }
                case MOVE_TO_OTHER_STACKS: 
                case SCROLL_TO_OTHER_STACKS: {
                    InventoryUtils.shiftClickSlot(gui, slot, slotNumber);
                    cancel = true;
                    break;
                }
                case DROP_ONE: {
                    InventoryUtils.clickSlot(gui, slot.e, 0, aqa.e);
                    break;
                }
                case DROP_LEAVE_ONE: {
                    InventoryUtils.leftClickSlot(gui, slot.e);
                    InventoryUtils.rightClickSlot(gui, slot.e);
                    InventoryUtils.dropItemsFromCursor(gui);
                    break;
                }
                case DROP_STACKS: {
                    InventoryUtils.clickSlot(gui, slot.e, 1, aqa.e);
                    cancel = true;
                    break;
                }
                case MOVE_DOWN_MOVE_ONE: 
                case MOVE_DOWN_LEAVE_ONE: 
                case MOVE_DOWN_STACKS: {
                    InventoryUtils.tryMoveItemsVertically(gui, slot, false, amount);
                    cancel = true;
                    break;
                }
                case MOVE_UP_MOVE_ONE: 
                case MOVE_UP_LEAVE_ONE: 
                case MOVE_UP_STACKS: {
                    InventoryUtils.tryMoveItemsVertically(gui, slot, true, amount);
                    cancel = true;
                    break;
                }
            }
            DRAGGED_SLOTS.add(slotNumber);
        }
        return cancel;
    }

    public static void dropStacks(cky gui, ate stackReference, aqx slotReference, boolean sameInventory) {
        if (slotReference != null && !InventoryUtils.isStackEmpty(stackReference)) {
            apv container = gui.h;
            stackReference = stackReference.i();
            for (aqx slot : container.c) {
                if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) != sameInventory || !InventoryUtils.areStacksEqual(slot.d(), stackReference)) continue;
                InventoryUtils.dropStack(gui, slot.e);
            }
        }
    }

    public static boolean shiftDropItems(cky gui) {
        ate stackReference = cft.s().i.bB.s();
        if (!InventoryUtils.isStackEmpty(stackReference) && sourceSlot != null) {
            stackReference = stackReference.i();
            InventoryUtils.dropItemsFromCursor(gui);
            InventoryUtils.dropStacks(gui, stackReference, (aqx)sourceSlot.get(), true);
            return true;
        }
        return false;
    }

    public static boolean shiftPlaceItems(aqx slot, cky gui) {
        InventoryUtils.leftClickSlot(gui, slot.e);
        DRAGGED_SLOTS.add(slot.e);
        InventoryUtils.tryMoveStacks(slot, gui, true, false, false);
        return true;
    }

    public static void storeSourceSlotCandidate(aqx slot, cft mc) {
        if (slot != null) {
            ate stackCursor = mc.i.bB.s();
            ate stack = EMPTY_STACK;
            if (!InventoryUtils.isStackEmpty(stackCursor)) {
                stack = new ate((axx)stackCursor.b(), InventoryUtils.getStackSize(stackCursor));
            }
            sourceSlotCandidate = new WeakReference<aqx>(slot);
            stackInCursorLast = stack;
        }
    }

    public static void checkForItemPickup(cky gui, cft mc) {
        ate stackCursor = mc.i.bB.s();
        if (!InventoryUtils.isStackEmpty(stackCursor) && !stackCursor.a(stackInCursorLast) && sourceSlotCandidate != null) {
            sourceSlot = new WeakReference(sourceSlotCandidate.get());
        }
    }

    private static boolean tryMoveItemsVillager(clq gui, aqx slot, boolean moveToOtherInventory, boolean fullStacks) {
        if (fullStacks) {
            if (!moveToOtherInventory) {
                InventoryUtils.tryMoveItemsToMerchantBuySlots(gui, true);
            } else if (slot.e()) {
                InventoryUtils.tryMoveStacks(slot, (cky)gui, true, true, true);
            } else {
                InventoryUtils.tryMoveStacks(slot, (cky)gui, false, true, false);
            }
        } else if (!moveToOtherInventory) {
            InventoryUtils.tryMoveItemsToMerchantBuySlots(gui, false);
        } else if (slot.e()) {
            InventoryUtils.moveOneSetOfItemsFromSlotToPlayerInventory((cky)gui, slot);
        }
        return false;
    }

    public static void villagerClearTradeInputSlots() {
        if (GuiUtils.getCurrentScreen() instanceof clq) {
            clq merchantGui = (clq)GuiUtils.getCurrentScreen();
            aqx slot = merchantGui.h.a(0);
            if (slot.e()) {
                InventoryUtils.shiftClickSlot((cky)merchantGui, slot.e);
            }
            if ((slot = merchantGui.h.a(1)).e()) {
                InventoryUtils.shiftClickSlot((cky)merchantGui, slot.e);
            }
        }
    }

    public static void villagerTradeEverythingPossibleWithCurrentRecipe() {
        if (GuiUtils.getCurrentScreen() instanceof clq) {
            clq merchantGui = (clq)GuiUtils.getCurrentScreen();
            aqx slot = merchantGui.h.a(2);
            do {
                InventoryUtils.tryMoveItemsToMerchantBuySlots(merchantGui, true);
                if (!slot.e()) break;
                InventoryUtils.shiftClickSlot((cky)merchantGui, slot.e);
            } while (!slot.e());
            InventoryUtils.villagerClearTradeInputSlots();
        }
    }

    public static void villagerTradeEverythingPossibleWithAllFavoritedTrades() {
        if (GuiUtils.getCurrentScreen() instanceof clq) {
            clq merchantGui = (clq)GuiUtils.getCurrentScreen();
            VillagerData data = VillagerDataStorage.getInstance().getDataForLastInteractionTarget();
            InventoryUtils.villagerClearTradeInputSlots();
            if (data != null && !data.getFavorites().isEmpty()) {
                int initialPage = AccessorUtils.getSelectedMerchantRecipe(merchantGui);
                for (int index : data.getFavorites()) {
                    InputHandler.changeTradePage(merchantGui, index);
                    InventoryUtils.villagerTradeEverythingPossibleWithCurrentRecipe();
                }
                InputHandler.changeTradePage(merchantGui, initialPage);
            }
        }
    }

    private static boolean tryMoveSingleItemToOtherInventory(aqx slot, cky gui) {
        int targetSlot;
        ate stackOrig = slot.d();
        apv container = gui.h;
        cft mc = cft.s();
        if (!InventoryUtils.isStackEmpty(mc.i.bB.s()) || !slot.a((aog)mc.i) || InventoryUtils.getStackSize(stackOrig) > 1 && !slot.a(stackOrig)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stackOrig) <= stackOrig.c()) {
            return InventoryUtils.clickSlotsToMoveSingleItemByShiftClick(gui, slot.e);
        }
        ate stack = stackOrig.i();
        InventoryUtils.setStackSize(stack, 1);
        ate[] originalStacks = InventoryUtils.getOriginalStacks(container);
        slot.d(stack);
        container.b((aog)mc.i, slot.e);
        if (!slot.e() && (targetSlot = InventoryUtils.getTargetSlot(container, originalStacks)) >= 0) {
            ((aqx)container.c.get(targetSlot)).a(1);
            InventoryUtils.restoreOriginalStacks(container, originalStacks);
            return InventoryUtils.clickSlotsToMoveSingleItem(gui, slot.e, targetSlot);
        }
        slot.d(stackOrig);
        return false;
    }

    private static boolean tryMoveAllButOneItemToOtherInventory(aqx slot, cky gui) {
        cft mc = cft.s();
        ctj player = mc.i;
        ate stackOrig = slot.d().i();
        if (InventoryUtils.getStackSize(stackOrig) == 1 || InventoryUtils.getStackSize(stackOrig) > stackOrig.c() || !slot.a((aog)player) || !slot.a(stackOrig)) {
            return true;
        }
        InventoryUtils.rightClickSlot(gui, slot.e);
        ate stackInCursor = player.bB.s();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return false;
        }
        int stackInCursorSizeOrig = InventoryUtils.getStackSize(stackInCursor);
        int tempSlotNum = -1;
        for (aqx slotTmp : gui.h.c) {
            ate stackInSlot;
            if (slotTmp.e == slot.e || !InventoryUtils.areSlotsInSameInventory(slotTmp, slot, true) || !slotTmp.a(stackInCursor) || !slotTmp.a((aog)player) || !InventoryUtils.isStackEmpty(stackInSlot = slotTmp.d()) && !InventoryUtils.areStacksEqual(stackInSlot, stackInCursor)) continue;
            InventoryUtils.rightClickSlot(gui, slotTmp.e);
            stackInCursor = player.bB.s();
            if (!InventoryUtils.isStackEmpty(stackInCursor) && InventoryUtils.getStackSize(stackInCursor) >= stackInCursorSizeOrig) continue;
            tempSlotNum = slotTmp.e;
            break;
        }
        if (!InventoryUtils.isStackEmpty(player.bB.s())) {
            InventoryUtils.leftClickSlot(gui, slot.e);
        }
        if (tempSlotNum != -1) {
            InventoryUtils.shiftClickSlot(gui, slot.e);
            InventoryUtils.rightClickSlot(gui, tempSlotNum);
            InventoryUtils.rightClickSlot(gui, slot.e);
            if (!InventoryUtils.isStackEmpty(player.bB.s())) {
                InventoryUtils.leftClickSlot(gui, tempSlotNum);
            }
            return true;
        }
        boolean treatHotbarAsDifferent = gui.getClass() == clp.class;
        List<Integer> slots = InventoryUtils.getSlotNumbersOfEmptySlots(gui.h, slot, false, treatHotbarAsDifferent, false);
        if (slots.isEmpty()) {
            slots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.h, slot, false, slot.d(), true, treatHotbarAsDifferent, false);
        }
        if (!slots.isEmpty()) {
            InventoryUtils.leftClickSlot(gui, slot.e);
            InventoryUtils.rightClickSlot(gui, slot.e);
            for (int slotNum : slots) {
                aqx slotTmp = gui.h.a(slotNum);
                stackInCursor = player.bB.s();
                if (InventoryUtils.isStackEmpty(stackInCursor)) {
                    return true;
                }
                if (!slotTmp.a(stackInCursor)) continue;
                InventoryUtils.leftClickSlot(gui, slotNum);
            }
            if (!InventoryUtils.isStackEmpty(stackInCursor)) {
                InventoryUtils.leftClickSlot(gui, slot.e);
            }
        }
        return false;
    }

    private static boolean tryMoveSingleItemToThisInventory(aqx slot, cky gui) {
        apv container = gui.h;
        ate stackOrig = slot.d();
        cft mc = cft.s();
        if (!slot.a(stackOrig)) {
            return false;
        }
        for (int slotNum = container.c.size() - 1; slotNum >= 0; --slotNum) {
            aqx slotTmp = (aqx)container.c.get(slotNum);
            ate stackTmp = slotTmp.d();
            if (InventoryUtils.areSlotsInSameInventory(slotTmp, slot) || InventoryUtils.isStackEmpty(stackTmp) || !slotTmp.a((aog)mc.i) || InventoryUtils.getStackSize(stackTmp) != 1 && !slotTmp.a(stackTmp) || !InventoryUtils.areStacksEqual(stackTmp, stackOrig)) continue;
            return InventoryUtils.clickSlotsToMoveSingleItem(gui, slotTmp.e, slot.e);
        }
        return false;
    }

    public static void tryMoveStacks(aqx slot, cky gui, boolean matchingOnly, boolean toOtherInventory, boolean firstOnly) {
        InventoryUtils.tryMoveStacks(slot.d(), slot, gui, matchingOnly, toOtherInventory, firstOnly);
    }

    private static void tryMoveStacks(ate stackReference, aqx slot, cky gui, boolean matchingOnly, boolean toOtherInventory, boolean firstOnly) {
        int maxSlot;
        apv container = gui.h;
        for (int i = maxSlot = container.c.size() - 1; i >= 0; --i) {
            aqx slotTmp = (aqx)container.c.get(i);
            if (slotTmp.e == slot.e || InventoryUtils.areSlotsInSameInventory(slotTmp, slot) != toOtherInventory || !slotTmp.e() || matchingOnly && !InventoryUtils.areStacksEqual(stackReference, slotTmp.d())) continue;
            boolean success = InventoryUtils.shiftClickSlotWithCheck(gui, slotTmp.e);
            if (!success && Configs.Toggles.SCROLL_STACKS_FALLBACK.getBooleanValue()) {
                InventoryUtils.clickSlotsToMoveItemsFromSlot(slotTmp, gui, toOtherInventory);
            }
            if (!firstOnly) continue;
            return;
        }
        if (toOtherInventory && !InventoryUtils.shiftClickSlotWithCheck(gui, slot.e)) {
            InventoryUtils.clickSlotsToMoveItemsFromSlot(slot, gui, toOtherInventory);
        }
    }

    public static void tryMoveItemsToMerchantBuySlots(clq gui, boolean fillStacks) {
        cft mc = cft.s();
        axf list = gui.h().b_((aog)mc.i);
        int index = AccessorUtils.getSelectedMerchantRecipe(gui);
        if (list == null || list.size() <= index) {
            return;
        }
        axe recipe = (axe)list.get(index);
        if (recipe == null) {
            return;
        }
        ate buy1 = recipe.a();
        ate buy2 = recipe.b();
        if (!InventoryUtils.isStackEmpty(buy1)) {
            InventoryUtils.fillBuySlot((cky)gui, 0, buy1, fillStacks);
        }
        if (!InventoryUtils.isStackEmpty(buy2)) {
            InventoryUtils.fillBuySlot((cky)gui, 1, buy2, fillStacks);
        }
    }

    private static void fillBuySlot(cky gui, int slotNum, ate buyStack, boolean fillStacks) {
        aqx slot = gui.h.a(slotNum);
        ate existingStack = slot.d();
        cft mc = cft.s();
        if (!InventoryUtils.isStackEmpty(existingStack) && !InventoryUtils.areStacksEqual(buyStack, existingStack)) {
            InventoryUtils.shiftClickSlot(gui, slotNum);
        }
        if (InventoryUtils.isStackEmpty(existingStack = slot.d()) || InventoryUtils.areStacksEqual(buyStack, existingStack)) {
            InventoryUtils.moveItemsFromInventory(gui, slotNum, (ade)mc.i.bB, buyStack, fillStacks);
        }
    }

    public static void handleRecipeClick(cky gui, cft mc, RecipeStorage recipes, int hoveredRecipeId, boolean isLeftClick, boolean isRightClick, boolean isPickBlock, boolean isShiftDown) {
        if (isLeftClick || isRightClick) {
            boolean changed = recipes.getSelection() != hoveredRecipeId;
            recipes.changeSelectedRecipe(hoveredRecipeId);
            if (changed) {
                InventoryUtils.clearFirstCraftingGridOfItems(recipes.getSelectedRecipe(), gui, false);
            } else {
                InventoryUtils.tryMoveItemsToFirstCraftingGrid(recipes.getRecipe(hoveredRecipeId), gui, isShiftDown);
            }
            if (isRightClick) {
                aqx outputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
                boolean dropKeyDown = mc.t.ag.d();
                if (outputSlot != null) {
                    if (dropKeyDown) {
                        if (isShiftDown) {
                            if (Configs.Generic.CARPET_CTRL_Q_CRAFTING.getBooleanValue()) {
                                InventoryUtils.dropStack(gui, outputSlot.e);
                            } else {
                                InventoryUtils.dropStacksUntilEmpty(gui, outputSlot.e);
                            }
                        } else {
                            InventoryUtils.dropItem(gui, outputSlot.e);
                        }
                    } else if (isShiftDown) {
                        InventoryUtils.shiftClickSlot(gui, outputSlot.e);
                    } else {
                        InventoryUtils.moveOneSetOfItemsFromSlotToPlayerInventory(gui, outputSlot);
                    }
                }
            }
        } else if (isPickBlock) {
            InventoryUtils.clearFirstCraftingGridOfAllItems(gui);
        }
    }

    public static void tryMoveItemsToFirstCraftingGrid(CraftingRecipe recipe, cky gui, boolean fillStacks) {
        aqx craftingOutputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (craftingOutputSlot != null) {
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, craftingOutputSlot, gui, fillStacks);
        }
    }

    public static void loadRecipeItemsToGridForOutputSlotUnderMouse(CraftingRecipe recipe, cky gui) {
        aqx slot = AccessorUtils.getSlotUnderMouse(gui);
        InventoryUtils.loadRecipeItemsToGridForOutputSlot(recipe, gui, slot);
    }

    private static void loadRecipeItemsToGridForOutputSlot(CraftingRecipe recipe, cky gui, aqx outputSlot) {
        if (outputSlot != null && InventoryUtils.isCraftingSlot(gui, outputSlot) && !InventoryUtils.isStackEmpty(recipe.getResult())) {
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, outputSlot, gui, false);
        }
    }

    private static boolean tryMoveItemsCrafting(RecipeStorage recipes, aqx slot, cky gui, boolean moveToOtherInventory, boolean moveStacks, boolean moveEverything) {
        CraftingRecipe recipe = recipes.getSelectedRecipe();
        ate stackRecipeOutput = recipe.getResult();
        if (moveToOtherInventory) {
            if (slot.e()) {
                if (InventoryUtils.areStacksEqual(slot.d(), stackRecipeOutput)) {
                    if (moveEverything) {
                        InventoryUtils.craftAsManyItemsAsPossible(recipe, slot, gui);
                    } else if (moveStacks) {
                        InventoryUtils.shiftClickSlot(gui, slot.e);
                    } else {
                        InventoryUtils.moveOneSetOfItemsFromSlotToPlayerInventory(gui, slot);
                    }
                }
            } else {
                InventoryUtils.clearCraftingGridOfAllItems(gui, CraftingHandler.getCraftingGridSlots(gui, slot));
            }
        } else if (!moveToOtherInventory && !InventoryUtils.isStackEmpty(stackRecipeOutput)) {
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, slot, gui, moveStacks);
        }
        return false;
    }

    private static void craftAsManyItemsAsPossible(CraftingRecipe recipe, aqx slot, cky gui) {
        ate result = recipe.getResult();
        for (int failSafe = 1024; failSafe > 0 && slot.e() && InventoryUtils.areStacksEqual(slot.d(), result); --failSafe) {
            InventoryUtils.shiftClickSlot(gui, slot.e);
            if (slot.e() && InventoryUtils.areStacksEqual(slot.d(), result)) break;
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, slot, gui, true);
        }
    }

    public static void clearFirstCraftingGridOfItems(CraftingRecipe recipe, cky gui, boolean clearNonMatchingOnly) {
        aqx craftingOutputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (craftingOutputSlot != null) {
            CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, craftingOutputSlot);
            InventoryUtils.clearCraftingGridOfItems(recipe, gui, range, clearNonMatchingOnly);
        }
    }

    public static void clearFirstCraftingGridOfAllItems(cky gui) {
        aqx craftingOutputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (craftingOutputSlot != null) {
            CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, craftingOutputSlot);
            InventoryUtils.clearCraftingGridOfAllItems(gui, range);
        }
    }

    private static boolean clearCraftingGridOfItems(CraftingRecipe recipe, cky gui, CraftingHandler.SlotRange range, boolean clearNonMatchingOnly) {
        int invSlots = gui.h.c.size();
        int rangeSlots = range.getSlotCount();
        int recipeSize = recipe.getRecipeLength();
        int slotCount = Math.min(rangeSlots, recipeSize);
        int i = 0;
        for (int slotNum = range.getFirst(); i < slotCount && slotNum < invSlots; ++i, ++slotNum) {
            aqx slotTmp = gui.h.a(slotNum);
            if (slotTmp == null || !slotTmp.e() || clearNonMatchingOnly && InventoryUtils.areStacksEqual(recipe.getRecipeItems()[i], slotTmp.d())) continue;
            InventoryUtils.shiftClickSlot(gui, slotNum);
            if (!slotTmp.e()) continue;
            return false;
        }
        return true;
    }

    private static boolean clearCraftingGridOfAllItems(cky gui, CraftingHandler.SlotRange range) {
        int invSlots = gui.h.c.size();
        int rangeSlots = range.getSlotCount();
        boolean clearedAll = true;
        int i = 0;
        for (int slotNum = range.getFirst(); i < rangeSlots && slotNum < invSlots; ++i, ++slotNum) {
            aqx slotTmp = gui.h.a(slotNum);
            if (slotTmp == null || !slotTmp.e()) continue;
            InventoryUtils.shiftClickSlot(gui, slotNum);
            if (!slotTmp.e()) continue;
            clearedAll = false;
        }
        return clearedAll;
    }

    private static boolean tryMoveItemsToCraftingGridSlots(CraftingRecipe recipe, aqx slot, cky gui, boolean fillStacks) {
        apv container = gui.h;
        int numSlots = container.c.size();
        CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, slot);
        if (range != null && range.getLast() < numSlots && recipe.getRecipeLength() <= range.getSlotCount()) {
            if (!InventoryUtils.clearCraftingGridOfItems(recipe, gui, range, true)) {
                return false;
            }
            aqx slotGridFirst = container.a(range.getFirst());
            Map<ItemType, List<Integer>> ingredientSlots = ItemType.getSlotsPerItem(recipe.getRecipeItems());
            for (Map.Entry<ItemType, List<Integer>> entry : ingredientSlots.entrySet()) {
                ate ingredientReference = entry.getKey().getStack();
                List<Integer> recipeSlots = entry.getValue();
                ArrayList<Integer> targetSlots = new ArrayList<Integer>();
                for (int s : recipeSlots) {
                    targetSlots.add(s + range.getFirst());
                }
                if (fillStacks) {
                    InventoryUtils.fillCraftingGrid(gui, slotGridFirst, ingredientReference, targetSlots);
                    continue;
                }
                InventoryUtils.moveOneRecipeItemIntoCraftingGrid(gui, slotGridFirst, ingredientReference, targetSlots);
            }
        }
        return false;
    }

    private static void fillCraftingGrid(cky gui, aqx slotGridFirst, ate ingredientReference, List<Integer> targetSlots) {
        apv container = gui.h;
        cft mc = cft.s();
        ctj player = mc.i;
        int slotNum = -1;
        int slotReturn = -1;
        int sizeOrig = 0;
        if (InventoryUtils.isStackEmpty(ingredientReference)) {
            return;
        }
        while ((slotNum = InventoryUtils.getSlotNumberOfLargestMatchingStackFromDifferentInventory(container, slotGridFirst, ingredientReference)) >= 0) {
            if (slotReturn == -1) {
                slotReturn = slotNum;
            }
            InventoryUtils.leftClickSlot(gui, slotNum);
            ate stackCursor = player.bB.s();
            if (!InventoryUtils.areStacksEqual(ingredientReference, stackCursor)) break;
            sizeOrig = InventoryUtils.getStackSize(stackCursor);
            InventoryUtils.dragSplitItemsIntoSlots(gui, targetSlots);
            stackCursor = player.bB.s();
            if (!InventoryUtils.isStackEmpty(stackCursor)) {
                if (InventoryUtils.getStackSize(stackCursor) >= sizeOrig) break;
                InventoryUtils.leftClickSlot(gui, slotReturn);
                if (!InventoryUtils.isStackEmpty(player.bB.s())) {
                    slotReturn = slotNum;
                    InventoryUtils.leftClickSlot(gui, slotReturn);
                }
            }
            if (InventoryUtils.isStackEmpty(player.bB.s())) continue;
            break;
        }
        if (slotNum >= 0 && !InventoryUtils.isStackEmpty(player.bB.s())) {
            InventoryUtils.leftClickSlot(gui, slotNum);
        }
    }

    public static void rightClickCraftOneStack(cky gui) {
        aqx slot = AccessorUtils.getSlotUnderMouse(gui);
        cft mc = cft.s();
        aof inv = mc.i.bB;
        ate stackCursor = inv.s();
        if (slot == null || !slot.e() || !InventoryUtils.isStackEmpty(stackCursor) && !InventoryUtils.areStacksEqual(slot.d(), stackCursor)) {
            return;
        }
        int sizeLast = 0;
        while (true) {
            InventoryUtils.rightClickSlot(gui, slot.e);
            stackCursor = inv.s();
            if (InventoryUtils.isStackEmpty(stackCursor) || InventoryUtils.getStackSize(stackCursor) <= sizeLast || InventoryUtils.getStackSize(stackCursor) >= stackCursor.c() || !InventoryUtils.areStacksEqual(slot.d(), stackCursor)) break;
            sizeLast = InventoryUtils.getStackSize(stackCursor);
        }
    }

    public static void craftEverythingPossibleWithCurrentRecipe(CraftingRecipe recipe, cky gui) {
        CraftingHandler.SlotRange range;
        aqx slot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (slot != null && !InventoryUtils.isStackEmpty(recipe.getResult()) && (range = CraftingHandler.getCraftingGridSlots(gui, slot)) != null) {
            if (!InventoryUtils.clearCraftingGridOfItems(recipe, gui, range, false)) {
                return;
            }
            InventoryUtils.tryMoveItemsToCraftingGridSlots(recipe, slot, gui, true);
            if (slot.e()) {
                InventoryUtils.craftAsManyItemsAsPossible(recipe, slot, gui);
            }
        }
    }

    public static void moveAllCraftingResultsToOtherInventory(CraftingRecipe recipe, cky gui) {
        if (!InventoryUtils.isStackEmpty(recipe.getResult())) {
            aqx slot = null;
            ate stackResult = recipe.getResult().i();
            for (aqx slotTmp : gui.h.c) {
                if (!InventoryUtils.areStacksEqual(slotTmp.d(), stackResult) || !InventoryUtils.inventoryExistsAbove(slotTmp, gui.h)) continue;
                slot = slotTmp;
                break;
            }
            if (slot != null) {
                List<Integer> slots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.h, slot, true, stackResult, false, false, false);
                for (int slotNum : slots) {
                    InventoryUtils.shiftClickSlot(gui, slotNum);
                }
            }
        }
    }

    public static void throwAllCraftingResultsToGround(CraftingRecipe recipe, cky gui) {
        aqx slot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui);
        if (slot != null && !InventoryUtils.isStackEmpty(recipe.getResult())) {
            InventoryUtils.dropStacks(gui, recipe.getResult(), slot, false);
        }
    }

    private static int putSingleItemIntoSlots(cky gui, List<Integer> targetSlots, int startIndex) {
        int slotNum;
        cft mc = cft.s();
        ate stackInCursor = mc.i.bB.s();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return 0;
        }
        int numSlots = gui.h.c.size();
        int numItems = InventoryUtils.getStackSize(stackInCursor);
        int loops = Math.min(numItems, targetSlots.size() - startIndex);
        int count = 0;
        for (int i = 0; i < loops && (slotNum = targetSlots.get(startIndex + i).intValue()) < numSlots; ++i) {
            InventoryUtils.rightClickSlot(gui, slotNum);
            ++count;
        }
        return count;
    }

    public static void moveOneSetOfItemsFromSlotToPlayerInventory(cky gui, aqx slot) {
        List<Integer> slots;
        InventoryUtils.leftClickSlot(gui, slot.e);
        cft mc = cft.s();
        ate stackCursor = mc.i.bB.s();
        if (!InventoryUtils.isStackEmpty(stackCursor) && !InventoryUtils.moveItemFromCursorToSlots(gui, slots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.h, slot, false, stackCursor, true, true, false))) {
            slots = InventoryUtils.getSlotNumbersOfEmptySlotsInPlayerInventory(gui.h, false);
            InventoryUtils.moveItemFromCursorToSlots(gui, slots);
        }
    }

    private static void moveOneRecipeItemIntoCraftingGrid(cky gui, aqx slotGridFirst, ate ingredientReference, List<Integer> targetSlots) {
        int filled;
        apv container = gui.h;
        cft mc = cft.s();
        int slotNum = -1;
        int slotCount = targetSlots.size();
        for (int index = 0; index < slotCount && (slotNum = InventoryUtils.getSlotNumberOfSmallestStackFromDifferentInventory(container, slotGridFirst, ingredientReference, slotCount)) >= 0; index += filled) {
            InventoryUtils.leftClickSlot(gui, slotNum);
            if (!InventoryUtils.areStacksEqual(ingredientReference, mc.i.bB.s())) break;
            filled = InventoryUtils.putSingleItemIntoSlots(gui, targetSlots, index);
            if (filled >= 1) continue;
            break;
        }
        if (slotNum >= 0 && !InventoryUtils.isStackEmpty(mc.i.bB.s())) {
            InventoryUtils.leftClickSlot(gui, slotNum);
        }
    }

    private static boolean moveItemFromCursorToSlots(cky gui, List<Integer> slotNumbers) {
        cft mc = cft.s();
        aof inv = mc.i.bB;
        for (int slotNum : slotNumbers) {
            InventoryUtils.leftClickSlot(gui, slotNum);
            if (!InventoryUtils.isStackEmpty(inv.s())) continue;
            return true;
        }
        return false;
    }

    private static void moveItemsFromInventory(cky gui, int slotTo, ade invSrc, ate stackTemplate, boolean fillStacks) {
        apv container = gui.h;
        for (aqx slot : container.c) {
            if (slot == null || slot.d != invSrc || !InventoryUtils.areStacksEqual(stackTemplate, slot.d())) continue;
            if (fillStacks) {
                if (InventoryUtils.clickSlotsToMoveItems(gui, slot.e, slotTo)) continue;
                break;
            }
            InventoryUtils.clickSlotsToMoveSingleItem(gui, slot.e, slotTo);
            break;
        }
    }

    private static int getSlotNumberOfLargestMatchingStackFromDifferentInventory(apv container, aqx slotReference, ate stackReference) {
        int slotNum = -1;
        int largest = 0;
        for (aqx slot : container.c) {
            int stackSize;
            if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.e() || !InventoryUtils.areStacksEqual(stackReference, slot.d()) || (stackSize = InventoryUtils.getStackSize(slot.d())) <= largest) continue;
            slotNum = slot.e;
            largest = stackSize;
        }
        return slotNum;
    }

    private static int getSlotNumberOfSmallestStackFromDifferentInventory(apv container, aqx slotReference, ate stackReference, int idealSize) {
        int slotNum = -1;
        int smallest = Integer.MAX_VALUE;
        for (aqx slot : container.c) {
            int stackSize;
            if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.e() || !InventoryUtils.areStacksEqual(stackReference, slot.d()) || (stackSize = InventoryUtils.getStackSize(slot.d())) >= smallest || stackSize < idealSize) continue;
            slotNum = slot.e;
            smallest = stackSize;
        }
        if (slotNum == -1) {
            int largest = 0;
            for (aqx slot : container.c) {
                int stackSize;
                if (InventoryUtils.areSlotsInSameInventory(slot, slotReference) || !slot.e() || !InventoryUtils.areStacksEqual(stackReference, slot.d()) || (stackSize = InventoryUtils.getStackSize(slot.d())) <= largest) continue;
                slotNum = slot.e;
                largest = stackSize;
            }
        }
        return slotNum;
    }

    private static List<Integer> getSlotNumbersOfMatchingStacks(apv container, aqx slotReference, boolean sameInventory, ate stackReference, boolean preferPartial, boolean treatHotbarAsDifferent, boolean reverse) {
        int i;
        ArrayList<Integer> slots = new ArrayList<Integer>(64);
        int maxSlot = container.c.size() - 1;
        int increment = reverse ? -1 : 1;
        int n = i = reverse ? maxSlot : 0;
        while (i >= 0 && i <= maxSlot) {
            aqx slot = container.a(i);
            if (slot != null && slot.e() && InventoryUtils.areSlotsInSameInventory(slot, slotReference, treatHotbarAsDifferent) == sameInventory && InventoryUtils.areStacksEqual(slot.d(), stackReference)) {
                if (InventoryUtils.getStackSize(slot.d()) < stackReference.c() == preferPartial) {
                    slots.add(0, slot.e);
                } else {
                    slots.add(slot.e);
                }
            }
            i += increment;
        }
        return slots;
    }

    private static List<Integer> getSlotNumbersOfMatchingStacks(apv container, ate stackReference, boolean preferPartial) {
        ArrayList<Integer> slots = new ArrayList<Integer>(64);
        int maxSlot = container.c.size() - 1;
        for (int i = 0; i <= maxSlot; ++i) {
            aqx slot = container.a(i);
            if (slot == null || !slot.e() || !InventoryUtils.areStacksEqual(slot.d(), stackReference)) continue;
            if (InventoryUtils.getStackSize(slot.d()) < stackReference.c() == preferPartial) {
                slots.add(0, slot.e);
                continue;
            }
            slots.add(slot.e);
        }
        return slots;
    }

    private static List<Integer> getSlotNumbersOfEmptySlots(apv container, aqx slotReference, boolean sameInventory, boolean treatHotbarAsDifferent, boolean reverse) {
        int i;
        ArrayList<Integer> slots = new ArrayList<Integer>(64);
        int maxSlot = container.c.size() - 1;
        int increment = reverse ? -1 : 1;
        int n = i = reverse ? maxSlot : 0;
        while (i >= 0 && i <= maxSlot) {
            aqx slot = container.a(i);
            if (slot != null && !slot.e() && InventoryUtils.areSlotsInSameInventory(slot, slotReference, treatHotbarAsDifferent) == sameInventory) {
                slots.add(slot.e);
            }
            i += increment;
        }
        return slots;
    }

    private static List<Integer> getSlotNumbersOfEmptySlotsInPlayerInventory(apv container, boolean reverse) {
        int i;
        ArrayList<Integer> slots = new ArrayList<Integer>(64);
        int maxSlot = container.c.size() - 1;
        int increment = reverse ? -1 : 1;
        int n = i = reverse ? maxSlot : 0;
        while (i >= 0 && i <= maxSlot) {
            aqx slot = container.a(i);
            if (slot != null && slot.d instanceof aof && !slot.e()) {
                slots.add(slot.e);
            }
            i += increment;
        }
        return slots;
    }

    public static boolean areStacksEqual(ate stack1, ate stack2) {
        return ate.c((ate)stack1, (ate)stack2) && ate.a((ate)stack1, (ate)stack2);
    }

    private static boolean areSlotsInSameInventory(aqx slot1, aqx slot2) {
        return InventoryUtils.areSlotsInSameInventory(slot1, slot2, false);
    }

    private static boolean areSlotsInSameInventory(aqx slot1, aqx slot2, boolean treatHotbarAsDifferent) {
        if (slot1.d == slot2.d) {
            if (treatHotbarAsDifferent && slot1.d instanceof aof) {
                int index1 = AccessorUtils.getSlotIndex(slot1);
                int index2 = AccessorUtils.getSlotIndex(slot2);
                return index1 == 40 || index2 == 40 || index1 < 9 == index2 < 9;
            }
            return true;
        }
        return false;
    }

    private static ate[] getOriginalStacks(apv container) {
        ate[] originalStacks = new ate[container.c.size()];
        for (int i = 0; i < originalStacks.length; ++i) {
            originalStacks[i] = ((aqx)container.c.get(i)).d().i();
        }
        return originalStacks;
    }

    private static void restoreOriginalStacks(apv container, ate[] originalStacks) {
        for (int i = 0; i < originalStacks.length; ++i) {
            ate stackSlot = container.a(i).d();
            if (InventoryUtils.areStacksEqual(stackSlot, originalStacks[i]) && (InventoryUtils.isStackEmpty(stackSlot) || InventoryUtils.getStackSize(stackSlot) == InventoryUtils.getStackSize(originalStacks[i]))) continue;
            container.a(i, originalStacks[i]);
        }
    }

    private static int getTargetSlot(apv container, ate[] originalStacks) {
        List slots = container.c;
        for (int i = 0; i < originalStacks.length; ++i) {
            ate stackOrig = originalStacks[i];
            ate stackNew = ((aqx)slots.get(i)).d();
            if ((!InventoryUtils.isStackEmpty(stackOrig) || InventoryUtils.isStackEmpty(stackNew)) && (InventoryUtils.isStackEmpty(stackOrig) || InventoryUtils.isStackEmpty(stackNew) || InventoryUtils.getStackSize(stackNew) != InventoryUtils.getStackSize(stackOrig) + 1)) continue;
            return i;
        }
        return -1;
    }

    private static void clickSlotsToMoveItemsFromSlot(aqx slotFrom, cky gui, boolean toOtherInventory) {
        cft mc = cft.s();
        ctj player = mc.i;
        InventoryUtils.leftClickSlot(gui, slotFrom.e);
        if (InventoryUtils.isStackEmpty(player.bB.s())) {
            return;
        }
        for (aqx slotDst : gui.h.c) {
            ate stackDst = slotDst.d();
            if (InventoryUtils.areSlotsInSameInventory(slotDst, slotFrom) != toOtherInventory && (InventoryUtils.isStackEmpty(stackDst) || InventoryUtils.areStacksEqual(stackDst, player.bB.s()))) {
                InventoryUtils.leftClickSlot(gui, slotDst.e);
            }
            if (!InventoryUtils.isStackEmpty(player.bB.s())) continue;
            return;
        }
        if (!InventoryUtils.isStackEmpty(player.bB.s())) {
            InventoryUtils.leftClickSlot(gui, slotFrom.e);
        }
    }

    private static boolean clickSlotsToMoveSingleItem(cky gui, int slotFrom, int slotTo) {
        cft mc = cft.s();
        ate stack = ((aqx)gui.h.c.get(slotFrom)).d();
        if (InventoryUtils.isStackEmpty(stack)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stack) > 1) {
            InventoryUtils.rightClickSlot(gui, slotFrom);
        } else {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        InventoryUtils.rightClickSlot(gui, slotTo);
        if (!InventoryUtils.isStackEmpty(mc.i.bB.s())) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return true;
    }

    private static boolean clickSlotsToMoveSingleItemByShiftClick(cky gui, int slotFrom) {
        cft mc = cft.s();
        aqx slot = (aqx)gui.h.c.get(slotFrom);
        ate stack = slot.d();
        if (InventoryUtils.isStackEmpty(stack)) {
            return false;
        }
        if (InventoryUtils.getStackSize(stack) > 1) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
            if (slot.e()) {
                InventoryUtils.leftClickSlot(gui, slotFrom);
                return false;
            }
            InventoryUtils.rightClickSlot(gui, slotFrom);
        }
        InventoryUtils.shiftClickSlot(gui, slotFrom);
        if (!InventoryUtils.isStackEmpty(mc.i.bB.s())) {
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return true;
    }

    private static boolean clickSlotsToMoveItems(cky gui, int slotFrom, int slotTo) {
        cft mc = cft.s();
        ctj player = mc.i;
        InventoryUtils.leftClickSlot(gui, slotFrom);
        if (InventoryUtils.isStackEmpty(player.bB.s())) {
            return false;
        }
        boolean ret = true;
        int size = InventoryUtils.getStackSize(player.bB.s());
        InventoryUtils.leftClickSlot(gui, slotTo);
        if (!InventoryUtils.isStackEmpty(player.bB.s())) {
            ret = InventoryUtils.getStackSize(player.bB.s()) != size;
            InventoryUtils.leftClickSlot(gui, slotFrom);
        }
        return ret;
    }

    public static void dropStacksUntilEmpty(cky gui, int slotNum) {
        if (slotNum >= 0 && slotNum < gui.h.c.size()) {
            aqx slot = gui.h.a(slotNum);
            int failsafe = 64;
            while (failsafe-- > 0 && slot.e()) {
                InventoryUtils.dropStack(gui, slotNum);
            }
        }
    }

    public static void dropStacksWhileHasItem(cky gui, int slotNum, ate stackReference) {
        if (slotNum >= 0 && slotNum < gui.h.c.size()) {
            aqx slot = gui.h.a(slotNum);
            int failsafe = 256;
            while (failsafe-- > 0 && InventoryUtils.areStacksEqual(slot.d(), stackReference)) {
                InventoryUtils.dropStack(gui, slotNum);
            }
        }
    }

    private static boolean shiftClickSlotWithCheck(cky gui, int slotNum) {
        aqx slot = gui.h.a(slotNum);
        if (slot == null || !slot.e()) {
            return false;
        }
        int sizeOrig = InventoryUtils.getStackSize(slot.d());
        InventoryUtils.shiftClickSlot(gui, slotNum);
        return !slot.e() || InventoryUtils.getStackSize(slot.d()) != sizeOrig;
    }

    public static boolean tryMoveItemsVertically(cky gui, aqx slot, boolean moveUp, MoveAmount amount) {
        cft mc = cft.s();
        if (slot == null || !InventoryUtils.isStackEmpty(mc.i.bB.s())) {
            return false;
        }
        List<Integer> slots = InventoryUtils.getVerticallyFurthestSuitableSlotsForStackInSlot(gui.h, slot, moveUp);
        if (slots.isEmpty()) {
            return false;
        }
        if (amount == MoveAmount.FULL_STACKS) {
            InventoryUtils.moveStackToSlots(gui, slot, slots, false);
        } else if (amount == MoveAmount.MOVE_ONE) {
            InventoryUtils.moveOneItemToFirstValidSlot(gui, slot, slots);
        } else if (amount == MoveAmount.LEAVE_ONE) {
            InventoryUtils.moveStackToSlots(gui, slot, slots, true);
        } else if (amount == MoveAmount.ALL_MATCHING) {
            InventoryUtils.moveMatchingStacksToSlots(gui, slot, moveUp);
        }
        return true;
    }

    private static void moveMatchingStacksToSlots(cky gui, aqx slot, boolean moveUp) {
        List<Integer> matchingSlots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.h, slot, true, slot.d(), true, true, false);
        List<Integer> targetSlots = InventoryUtils.getSlotNumbersOfEmptySlots(gui.h, slot, false, true, false);
        targetSlots.addAll(InventoryUtils.getSlotNumbersOfEmptySlots(gui.h, slot, true, true, false));
        targetSlots.addAll(matchingSlots);
        Collections.sort(matchingSlots, new SlotVerticalSorterSlotNumbers(gui.h, !moveUp));
        Collections.sort(targetSlots, new SlotVerticalSorterSlotNumbers(gui.h, moveUp));
        for (int i = 0; i < matchingSlots.size(); ++i) {
            int srcSlotNum = matchingSlots.get(i);
            aqx srcSlot = gui.h.a(srcSlotNum);
            aqx lastSlot = InventoryUtils.moveStackToSlots(gui, srcSlot, targetSlots, false);
            if (lastSlot != null && lastSlot.e != srcSlot.e && lastSlot.g > srcSlot.g != moveUp) continue;
            return;
        }
    }

    private static aqx moveStackToSlots(cky gui, aqx slotFrom, List<Integer> slotsTo, boolean leaveOne) {
        cft mc = cft.s();
        aof inv = mc.i.bB;
        aqx lastSlot = null;
        if (!slotFrom.e()) {
            return null;
        }
        InventoryUtils.leftClickSlot(gui, slotFrom.e);
        if (leaveOne) {
            InventoryUtils.rightClickSlot(gui, slotFrom.e);
        }
        for (int slotNum : slotsTo) {
            if (InventoryUtils.isStackEmpty(inv.s())) break;
            aqx dstSlot = gui.h.a(slotNum);
            if (!dstSlot.a(inv.s()) || dstSlot.e() && !InventoryUtils.areStacksEqual(dstSlot.d(), inv.s())) continue;
            InventoryUtils.leftClickSlot(gui, slotNum);
            lastSlot = dstSlot;
        }
        if (!InventoryUtils.isStackEmpty(inv.s())) {
            InventoryUtils.leftClickSlot(gui, slotFrom.e);
        }
        return lastSlot;
    }

    private static void moveOneItemToFirstValidSlot(cky gui, aqx slotFrom, List<Integer> slotsTo) {
        cft mc = cft.s();
        aof inv = mc.i.bB;
        InventoryUtils.rightClickSlot(gui, slotFrom.e);
        if (InventoryUtils.isStackEmpty(inv.s())) {
            return;
        }
        int sizeOrig = InventoryUtils.getStackSize(inv.s());
        for (int slotNum : slotsTo) {
            InventoryUtils.rightClickSlot(gui, slotNum);
            ate stackCursor = inv.s();
            if (!InventoryUtils.isStackEmpty(stackCursor) && InventoryUtils.getStackSize(stackCursor) == sizeOrig) continue;
            break;
        }
        if (!InventoryUtils.isStackEmpty(inv.s())) {
            InventoryUtils.leftClickSlot(gui, slotFrom.e);
        }
    }

    private static List<Integer> getVerticallyFurthestSuitableSlotsForStackInSlot(apv container, aqx slotIn, boolean above) {
        if (slotIn == null || !slotIn.e()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> slotNumbers = new ArrayList<Integer>();
        ate stackSlot = slotIn.d();
        for (aqx slotTmp : container.c) {
            ate stackTmp;
            if (slotTmp.e == slotIn.e || slotTmp.g == slotIn.g || above != slotTmp.g < slotIn.g || (!InventoryUtils.isStackEmpty(stackTmp = slotTmp.d()) || !slotTmp.a(stackSlot)) && (!InventoryUtils.areStacksEqual(stackTmp, stackSlot) || slotTmp.b(stackTmp) <= InventoryUtils.getStackSize(stackTmp))) continue;
            slotNumbers.add(slotTmp.e);
        }
        Collections.sort(slotNumbers, new SlotVerticalSorterSlotNumbers(container, above));
        return slotNumbers;
    }

    public static void tryClearCursor(cky gui, cft mc) {
        if (!mc.i.bB.i().a()) {
            List<Integer> emptySlots = InventoryUtils.getSlotNumbersOfEmptySlotsInPlayerInventory(gui.h, false);
            if (!emptySlots.isEmpty()) {
                InventoryUtils.leftClickSlot(gui, emptySlots.get(0));
            } else {
                List<Integer> matchingSlots = InventoryUtils.getSlotNumbersOfMatchingStacks(gui.h, mc.i.bB.i(), true);
                if (!matchingSlots.isEmpty()) {
                    for (int slotNum : matchingSlots) {
                        aqx slot = gui.h.a(slotNum);
                        ate stackSlot = slot.d();
                        ate stackCursor = mc.i.bB.i();
                        if (slot == null || !InventoryUtils.areStacksEqual(stackSlot, stackCursor) || stackSlot.C() >= stackCursor.c()) break;
                        InventoryUtils.leftClickSlot(gui, slotNum);
                    }
                }
            }
        }
        if (!mc.i.bB.i().a()) {
            InventoryUtils.dropItemsFromCursor(gui);
        }
    }

    public static void resetLastSlotNumber() {
        slotNumberLast = -1;
    }

    public static MoveAction getActiveMoveAction() {
        return activeMoveAction;
    }

    public static void clickSlot(cky gui, int slotNum, int mouseButton, aqa type) {
        if (slotNum >= 0 && slotNum < gui.h.c.size()) {
            aqx slot = gui.h.a(slotNum);
            InventoryUtils.clickSlot(gui, slot, slotNum, mouseButton, type);
        } else {
            try {
                cft mc = cft.s();
                mc.e.a(gui.h.d, slotNum, mouseButton, type, (aog)mc.i);
            }
            catch (Exception e) {
                ItemScroller.logger.warn("Exception while emulating a slot click: gui: '{}', slotNum: {}, mouseButton; {}, ClickType: {}", (Object)gui.getClass().getName(), (Object)slotNum, (Object)mouseButton, (Object)type, (Object)e);
            }
        }
    }

    public static void clickSlot(cky gui, aqx slot, int slotNum, int mouseButton, aqa type) {
        try {
            AccessorUtils.handleMouseClick(gui, slot, slotNum, mouseButton, type);
        }
        catch (Exception e) {
            ItemScroller.logger.warn("Exception while emulating a slot click: gui: '{}', slotNum: {}, mouseButton; {}, ClickType: {}", (Object)gui.getClass().getName(), (Object)slotNum, (Object)mouseButton, (Object)type, (Object)e);
        }
    }

    public static void leftClickSlot(cky gui, aqx slot, int slotNumber) {
        InventoryUtils.clickSlot(gui, slot, slotNumber, 0, aqa.a);
    }

    public static void rightClickSlot(cky gui, aqx slot, int slotNumber) {
        InventoryUtils.clickSlot(gui, slot, slotNumber, 1, aqa.a);
    }

    public static void shiftClickSlot(cky gui, aqx slot, int slotNumber) {
        InventoryUtils.clickSlot(gui, slot, slotNumber, 0, aqa.b);
    }

    public static void leftClickSlot(cky gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 0, aqa.a);
    }

    public static void rightClickSlot(cky gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 1, aqa.a);
    }

    public static void shiftClickSlot(cky gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 0, aqa.b);
    }

    public static void dropItemsFromCursor(cky gui) {
        InventoryUtils.clickSlot(gui, -999, 0, aqa.a);
    }

    public static void dropItem(cky gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 0, aqa.e);
    }

    public static void dropStack(cky gui, int slotNum) {
        InventoryUtils.clickSlot(gui, slotNum, 1, aqa.e);
    }

    public static void swapSlots(cky gui, int slotNum, int otherSlot) {
        InventoryUtils.clickSlot(gui, slotNum, 0, aqa.c);
        InventoryUtils.clickSlot(gui, otherSlot, 0, aqa.c);
        InventoryUtils.clickSlot(gui, slotNum, 0, aqa.c);
    }

    private static void dragSplitItemsIntoSlots(cky gui, List<Integer> targetSlots) {
        int slotNum;
        cft mc = cft.s();
        ate stackInCursor = mc.i.bB.s();
        if (InventoryUtils.isStackEmpty(stackInCursor)) {
            return;
        }
        if (targetSlots.size() == 1) {
            InventoryUtils.leftClickSlot(gui, targetSlots.get(0));
            return;
        }
        int numSlots = gui.h.c.size();
        int loops = targetSlots.size();
        InventoryUtils.clickSlot(gui, -999, 0, aqa.f);
        for (int i = 0; i < loops && (slotNum = targetSlots.get(i).intValue()) < numSlots; ++i) {
            InventoryUtils.clickSlot(gui, targetSlots.get(i), 1, aqa.f);
        }
        InventoryUtils.clickSlot(gui, -999, 2, aqa.f);
    }

    public static boolean isStackEmpty(ate stack) {
        return stack.a();
    }

    public static int getStackSize(ate stack) {
        return stack.C();
    }

    public static void setStackSize(ate stack, int size) {
        stack.e(size);
    }

    static {
        DRAGGED_SLOTS = new HashSet<Integer>();
        sourceSlotCandidate = null;
        sourceSlot = null;
        stackInCursorLast = ate.a;
        EMPTY_STACK = ate.a;
    }

    private static class SlotVerticalSorterSlotNumbers
    implements Comparator<Integer> {
        private final apv container;
        private final boolean topToBottom;

        public SlotVerticalSorterSlotNumbers(apv container, boolean topToBottom) {
            this.container = container;
            this.topToBottom = topToBottom;
        }

        @Override
        public int compare(Integer slotNum1, Integer slotNum2) {
            aqx slot1 = this.container.a(slotNum1.intValue());
            aqx slot2 = this.container.a(slotNum2.intValue());
            if (slot1.g == slot2.g) {
                return slot1.e < slot2.e == this.topToBottom ? -1 : 1;
            }
            return slot1.g < slot2.g == this.topToBottom ? -1 : 1;
        }
    }
}

