/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.util;

import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.event.KeybindCallbacks;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.itemscroller.util.MoveAction;
import fi.dy.masa.itemscroller.util.MoveAmount;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.util.GuiUtils;

public class InputUtils {
    public static boolean isRecipeViewOpen() {
        return GuiUtils.getCurrentScreen() != null && Hotkeys.KEY_RECIPE_VIEW.getKeybind().isKeybindHeld() && KeybindCallbacks.getInstance().functionalityEnabled() && CraftingHandler.isCraftingGui(GuiUtils.getCurrentScreen());
    }

    public static boolean canShiftDropItems(cky gui, cft mc, int mouseX, int mouseY) {
        if (!InventoryUtils.isStackEmpty(mc.i.bB.s())) {
            int left = AccessorUtils.getGuiLeft(gui);
            int top = AccessorUtils.getGuiTop(gui);
            int xSize = AccessorUtils.getGuiXSize(gui);
            int ySize = AccessorUtils.getGuiYSize(gui);
            boolean isOutsideGui = mouseX < left || mouseY < top || mouseX >= left + xSize || mouseY >= top + ySize;
            return isOutsideGui && AccessorUtils.getSlotAtPosition(gui, mouseX - left, mouseY - top) == null;
        }
        return false;
    }

    public static MoveAction getDragMoveAction(IKeybind key) {
        if (key == Hotkeys.KEY_DRAG_FULL_STACKS.getKeybind()) {
            return MoveAction.MOVE_TO_OTHER_STACKS;
        }
        if (key == Hotkeys.KEY_DRAG_LEAVE_ONE.getKeybind()) {
            return MoveAction.MOVE_TO_OTHER_LEAVE_ONE;
        }
        if (key == Hotkeys.KEY_DRAG_MOVE_ONE.getKeybind()) {
            return MoveAction.MOVE_TO_OTHER_MOVE_ONE;
        }
        if (key == Hotkeys.KEY_DRAG_MATCHING.getKeybind()) {
            return MoveAction.MOVE_TO_OTHER_MATCHING;
        }
        if (key == Hotkeys.KEY_DRAG_DROP_STACKS.getKeybind()) {
            return MoveAction.DROP_STACKS;
        }
        if (key == Hotkeys.KEY_DRAG_DROP_LEAVE_ONE.getKeybind()) {
            return MoveAction.DROP_LEAVE_ONE;
        }
        if (key == Hotkeys.KEY_DRAG_DROP_SINGLE.getKeybind()) {
            return MoveAction.DROP_ONE;
        }
        if (key == Hotkeys.KEY_WS_MOVE_UP_STACKS.getKeybind()) {
            return MoveAction.MOVE_UP_STACKS;
        }
        if (key == Hotkeys.KEY_WS_MOVE_UP_MATCHING.getKeybind()) {
            return MoveAction.MOVE_UP_MATCHING;
        }
        if (key == Hotkeys.KEY_WS_MOVE_UP_LEAVE_ONE.getKeybind()) {
            return MoveAction.MOVE_UP_LEAVE_ONE;
        }
        if (key == Hotkeys.KEY_WS_MOVE_UP_SINGLE.getKeybind()) {
            return MoveAction.MOVE_UP_MOVE_ONE;
        }
        if (key == Hotkeys.KEY_WS_MOVE_DOWN_STACKS.getKeybind()) {
            return MoveAction.MOVE_DOWN_STACKS;
        }
        if (key == Hotkeys.KEY_WS_MOVE_DOWN_MATCHING.getKeybind()) {
            return MoveAction.MOVE_DOWN_MATCHING;
        }
        if (key == Hotkeys.KEY_WS_MOVE_DOWN_LEAVE_ONE.getKeybind()) {
            return MoveAction.MOVE_DOWN_LEAVE_ONE;
        }
        if (key == Hotkeys.KEY_WS_MOVE_DOWN_SINGLE.getKeybind()) {
            return MoveAction.MOVE_DOWN_MOVE_ONE;
        }
        return MoveAction.NONE;
    }

    public static boolean isActionKeyActive(MoveAction action) {
        switch (action) {
            case MOVE_TO_OTHER_STACKS: {
                return Hotkeys.KEY_DRAG_FULL_STACKS.getKeybind().isKeybindHeld();
            }
            case MOVE_TO_OTHER_LEAVE_ONE: {
                return Hotkeys.KEY_DRAG_LEAVE_ONE.getKeybind().isKeybindHeld();
            }
            case MOVE_TO_OTHER_MOVE_ONE: {
                return Hotkeys.KEY_DRAG_MOVE_ONE.getKeybind().isKeybindHeld();
            }
            case MOVE_TO_OTHER_MATCHING: {
                return Hotkeys.KEY_DRAG_MATCHING.getKeybind().isKeybindHeld();
            }
            case MOVE_TO_OTHER_EVERYTHING: {
                return Hotkeys.KEY_MOVE_EVERYTHING.getKeybind().isKeybindHeld();
            }
            case DROP_STACKS: {
                return Hotkeys.KEY_DRAG_DROP_STACKS.getKeybind().isKeybindHeld();
            }
            case DROP_LEAVE_ONE: {
                return Hotkeys.KEY_DRAG_DROP_LEAVE_ONE.getKeybind().isKeybindHeld();
            }
            case DROP_ONE: {
                return Hotkeys.KEY_DRAG_DROP_SINGLE.getKeybind().isKeybindHeld();
            }
            case MOVE_UP_STACKS: {
                return Hotkeys.KEY_WS_MOVE_UP_STACKS.getKeybind().isKeybindHeld();
            }
            case MOVE_UP_MATCHING: {
                return Hotkeys.KEY_WS_MOVE_UP_MATCHING.getKeybind().isKeybindHeld();
            }
            case MOVE_UP_LEAVE_ONE: {
                return Hotkeys.KEY_WS_MOVE_UP_LEAVE_ONE.getKeybind().isKeybindHeld();
            }
            case MOVE_UP_MOVE_ONE: {
                return Hotkeys.KEY_WS_MOVE_UP_SINGLE.getKeybind().isKeybindHeld();
            }
            case MOVE_DOWN_STACKS: {
                return Hotkeys.KEY_WS_MOVE_DOWN_STACKS.getKeybind().isKeybindHeld();
            }
            case MOVE_DOWN_MATCHING: {
                return Hotkeys.KEY_WS_MOVE_DOWN_MATCHING.getKeybind().isKeybindHeld();
            }
            case MOVE_DOWN_LEAVE_ONE: {
                return Hotkeys.KEY_WS_MOVE_DOWN_LEAVE_ONE.getKeybind().isKeybindHeld();
            }
            case MOVE_DOWN_MOVE_ONE: {
                return Hotkeys.KEY_WS_MOVE_DOWN_SINGLE.getKeybind().isKeybindHeld();
            }
        }
        return false;
    }

    public static MoveAmount getMoveAmount(MoveAction action) {
        switch (action) {
            case MOVE_TO_OTHER_MOVE_ONE: 
            case DROP_ONE: 
            case MOVE_UP_MOVE_ONE: 
            case MOVE_DOWN_MOVE_ONE: 
            case SCROLL_TO_OTHER_MOVE_ONE: {
                return MoveAmount.MOVE_ONE;
            }
            case MOVE_TO_OTHER_LEAVE_ONE: 
            case DROP_LEAVE_ONE: 
            case MOVE_UP_LEAVE_ONE: 
            case MOVE_DOWN_LEAVE_ONE: {
                return MoveAmount.LEAVE_ONE;
            }
            case MOVE_TO_OTHER_STACKS: 
            case DROP_STACKS: 
            case MOVE_UP_STACKS: 
            case MOVE_DOWN_STACKS: 
            case SCROLL_TO_OTHER_STACKS: {
                return MoveAmount.FULL_STACKS;
            }
            case MOVE_TO_OTHER_MATCHING: 
            case MOVE_UP_MATCHING: 
            case MOVE_DOWN_MATCHING: 
            case SCROLL_TO_OTHER_MATCHING: 
            case DROP_ALL_MATCHING: {
                return MoveAmount.ALL_MATCHING;
            }
            case MOVE_TO_OTHER_EVERYTHING: 
            case SCROLL_TO_OTHER_EVERYTHING: {
                return MoveAmount.EVERYTHING;
            }
        }
        return MoveAmount.NONE;
    }

    public static boolean isAttack(int keyCode) {
        return keyCode == KeybindMulti.getKeyCode((cfp)cft.s().t.ai);
    }

    public static boolean isUse(int keyCode) {
        return keyCode == KeybindMulti.getKeyCode((cfp)cft.s().t.ah);
    }

    public static boolean isPickBlock(int keyCode) {
        return keyCode == KeybindMulti.getKeyCode((cfp)cft.s().t.aj);
    }
}

