/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.recipes;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.recipes.CraftingRecipe;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public class RecipeStorage {
    private static final RecipeStorage INSTANCE = new RecipeStorage(144);
    private final CraftingRecipe[] recipes;
    private int selected;
    private boolean dirty;

    public static RecipeStorage getInstance() {
        return INSTANCE;
    }

    public RecipeStorage(int recipeCount) {
        this.recipes = new CraftingRecipe[recipeCount];
        this.initRecipes();
    }

    private void initRecipes() {
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i] = new CraftingRecipe();
        }
    }

    public int getSelection() {
        return this.selected;
    }

    public void changeSelectedRecipe(int index) {
        if (index >= 0 && index < this.recipes.length) {
            this.selected = index;
            this.dirty = true;
        }
    }

    public void scrollSelection(boolean forward) {
        this.changeSelectedRecipe(this.selected + (forward ? 1 : -1));
    }

    public int getFirstVisibleRecipeId() {
        return this.getCurrentRecipePage() * this.getRecipeCountPerPage();
    }

    public int getTotalRecipeCount() {
        return this.recipes.length;
    }

    public int getRecipeCountPerPage() {
        return 18;
    }

    public int getCurrentRecipePage() {
        return this.getSelection() / this.getRecipeCountPerPage();
    }

    @Nonnull
    public CraftingRecipe getRecipe(int index) {
        if (index >= 0 && index < this.recipes.length) {
            return this.recipes[index];
        }
        return this.recipes[0];
    }

    @Nonnull
    public CraftingRecipe getSelectedRecipe() {
        return this.getRecipe(this.getSelection());
    }

    public void storeCraftingRecipeToCurrentSelection(aqx slot, cky gui, boolean clearIfEmpty) {
        this.storeCraftingRecipe(this.getSelection(), slot, gui, clearIfEmpty);
    }

    public void storeCraftingRecipe(int index, aqx slot, cky gui, boolean clearIfEmpty) {
        this.getRecipe(index).storeCraftingRecipe(slot, gui, clearIfEmpty);
        this.dirty = true;
    }

    public void clearRecipe(int index) {
        this.getRecipe(index).clearRecipe();
        this.dirty = true;
    }

    private void readFromNBT(gy nbt) {
        if (nbt == null || !nbt.c("Recipes", 9)) {
            return;
        }
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i].clearRecipe();
        }
        he tagList = nbt.d("Recipes", 10);
        int count = tagList.size();
        for (int i = 0; i < count; ++i) {
            gy tag = tagList.e(i);
            byte index = tag.f("RecipeIndex");
            if (index < 0 || index >= this.recipes.length) continue;
            this.recipes[index].readFromNBT(tag);
        }
        this.changeSelectedRecipe(nbt.f("Selected"));
    }

    private gy writeToNBT(@Nonnull gy nbt) {
        he tagRecipes = new he();
        for (int i = 0; i < this.recipes.length; ++i) {
            if (!this.recipes[i].isValid()) continue;
            gy tag = new gy();
            tag.a("RecipeIndex", (byte)i);
            this.recipes[i].writeToNBT(tag);
            tagRecipes.a((ho)tag);
        }
        nbt.a("Recipes", (ho)tagRecipes);
        nbt.a("Selected", (byte)this.selected);
        return nbt;
    }

    private String getFileName() {
        String worldName;
        if (!Configs.Generic.SCROLL_CRAFT_RECIPE_FILE_GLOBAL.getBooleanValue() && (worldName = StringUtils.getWorldOrServerName()) != null) {
            return "recipes_" + worldName + ".nbt";
        }
        return "recipes.nbt";
    }

    private File getSaveDir() {
        return new File(FileUtils.getMinecraftDirectory(), "itemscroller");
    }

    public void readFromDisk() {
        try {
            File file;
            File saveDir = this.getSaveDir();
            if (saveDir != null && (file = new File(saveDir, this.getFileName())).exists() && file.isFile() && file.canRead()) {
                FileInputStream is = new FileInputStream(file);
                this.readFromNBT(hi.a((InputStream)is));
                is.close();
            }
        }
        catch (Exception e) {
            ItemScroller.logger.warn("Failed to read recipes from file", (Throwable)e);
        }
    }

    public void writeToDisk() {
        if (this.dirty) {
            try {
                File saveDir = this.getSaveDir();
                if (saveDir == null) {
                    return;
                }
                if (!saveDir.exists() && !saveDir.mkdirs()) {
                    ItemScroller.logger.warn("Failed to create the recipe storage directory '{}'", (Object)saveDir.getPath());
                    return;
                }
                File fileTmp = new File(saveDir, this.getFileName() + ".tmp");
                File fileReal = new File(saveDir, this.getFileName());
                FileOutputStream os = new FileOutputStream(fileTmp);
                hi.a((gy)this.writeToNBT(new gy()), (OutputStream)os);
                os.close();
                if (fileReal.exists()) {
                    fileReal.delete();
                }
                fileTmp.renameTo(fileReal);
                this.dirty = false;
            }
            catch (Exception e) {
                ItemScroller.logger.warn("Failed to write recipes to file!", (Throwable)e);
            }
        }
    }
}

