/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.recipes;

import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import javax.annotation.Nonnull;

public class CraftingRecipe {
    private ate result = InventoryUtils.EMPTY_STACK;
    private ate[] recipe = new ate[9];

    public CraftingRecipe() {
        this.ensureRecipeSizeAndClearRecipe(9);
    }

    public void ensureRecipeSize(int size) {
        if (this.getRecipeLength() != size) {
            this.recipe = new ate[size];
        }
    }

    public void clearRecipe() {
        for (int i = 0; i < this.recipe.length; ++i) {
            this.recipe[i] = InventoryUtils.EMPTY_STACK;
        }
        this.result = InventoryUtils.EMPTY_STACK;
    }

    public void ensureRecipeSizeAndClearRecipe(int size) {
        this.ensureRecipeSize(size);
        this.clearRecipe();
    }

    public void storeCraftingRecipe(aqx slot, cky gui, boolean clearIfEmpty) {
        CraftingHandler.SlotRange range = CraftingHandler.getCraftingGridSlots(gui, slot);
        if (range != null) {
            if (slot.e()) {
                int gridSize = range.getSlotCount();
                int numSlots = gui.h.c.size();
                this.ensureRecipeSizeAndClearRecipe(gridSize);
                int i = 0;
                for (int s = range.getFirst(); i < gridSize && s < numSlots; ++i, ++s) {
                    aqx slotTmp = gui.h.a(s);
                    this.recipe[i] = slotTmp.e() ? slotTmp.d().i() : InventoryUtils.EMPTY_STACK;
                }
                this.result = slot.d().i();
            } else if (clearIfEmpty) {
                this.clearRecipe();
            }
        }
    }

    public void copyRecipeFrom(CraftingRecipe other) {
        int size = other.getRecipeLength();
        ate[] otherRecipe = other.getRecipeItems();
        this.ensureRecipeSizeAndClearRecipe(size);
        for (int i = 0; i < size; ++i) {
            this.recipe[i] = !InventoryUtils.isStackEmpty(otherRecipe[i]) ? otherRecipe[i].i() : InventoryUtils.EMPTY_STACK;
        }
        this.result = !InventoryUtils.isStackEmpty(other.getResult()) ? other.getResult().i() : InventoryUtils.EMPTY_STACK;
    }

    public void readFromNBT(@Nonnull gy nbt) {
        if (nbt.c("Result", 10) && nbt.c("Ingredients", 9)) {
            he tagIngredients = nbt.d("Ingredients", 10);
            int count = tagIngredients.size();
            int length = nbt.h("Length");
            if (length > 0) {
                this.ensureRecipeSizeAndClearRecipe(length);
            }
            for (int i = 0; i < count; ++i) {
                gy tag = tagIngredients.e(i);
                int slot = tag.h("Slot");
                if (slot < 0 || slot >= this.recipe.length) continue;
                this.recipe[slot] = ate.a((gy)tag);
            }
            this.result = ate.a((gy)nbt.p("Result"));
        }
    }

    @Nonnull
    public gy writeToNBT(@Nonnull gy nbt) {
        if (this.isValid()) {
            gy tag = new gy();
            this.result.b(tag);
            nbt.b("Length", this.recipe.length);
            nbt.a("Result", (ho)tag);
            he tagIngredients = new he();
            for (int i = 0; i < this.recipe.length; ++i) {
                if (InventoryUtils.isStackEmpty(this.recipe[i])) continue;
                tag = new gy();
                tag.b("Slot", i);
                this.recipe[i].b(tag);
                tagIngredients.a((ho)tag);
            }
            nbt.a("Ingredients", (ho)tagIngredients);
        }
        return nbt;
    }

    public ate getResult() {
        return this.result;
    }

    public int getRecipeLength() {
        return this.recipe.length;
    }

    public ate[] getRecipeItems() {
        return this.recipe;
    }

    public boolean isValid() {
        return !InventoryUtils.isStackEmpty(this.getResult());
    }
}

