/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.gui.widgets;

import fi.dy.masa.itemscroller.event.InputHandler;
import fi.dy.masa.itemscroller.gui.widgets.Icons;
import fi.dy.masa.itemscroller.gui.widgets.WidgetTradeEntry;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.itemscroller.villager.VillagerData;
import fi.dy.masa.itemscroller.villager.VillagerDataStorage;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiScrollBar;
import fi.dy.masa.malilib.gui.interfaces.IGuiIcon;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class WidgetTradeList
extends WidgetBase {
    private final GuiScrollBar scrollBar;
    private final clq parentGui;
    private final VillagerDataStorage storage;
    private final ArrayList<WidgetTradeEntry> entryList = new ArrayList();
    private final VillagerData data;
    private axf recipeList;
    private int scrollBarTotalHeight;

    public WidgetTradeList(int x, int y, clq parentGui, VillagerData data) {
        super(x, y, 106, 166);
        this.scrollBar = new GuiScrollBar((IGuiIcon)Icons.SCROLL_BAR_6).setRenderBarBackground(false);
        this.parentGui = parentGui;
        this.storage = VillagerDataStorage.getInstance();
        this.data = data;
    }

    private void lazySetRecipeList() {
        if (this.recipeList == null) {
            this.recipeList = this.parentGui.h().b_((aog)this.mc.i);
            if (this.recipeList != null) {
                int max = Math.max(0, this.recipeList.size() - 7);
                this.scrollBar.setMaxValue(max);
                this.scrollBar.setValue(this.data.getTradeListPosition());
                this.scrollBarTotalHeight = Math.max(140, this.recipeList.size() * 20);
                this.reCreateEntryWidgets();
            }
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.x + 5 && mouseX <= this.x + 99 && mouseY >= this.y + 18 && mouseY <= this.y + 157;
    }

    protected boolean onMouseClickedImpl(int mouseX, int mouseY, int mouseButton) {
        if (this.scrollBar.wasMouseOver()) {
            this.scrollBar.setIsDragging(true);
            return true;
        }
        if (mouseX <= this.x + 92) {
            int recipeIndex;
            int relY = mouseY - (this.y + 18);
            int listIndex = relY / 20;
            WidgetTradeEntry entry = listIndex >= 0 && listIndex < this.entryList.size() ? this.entryList.get(listIndex) : null;
            int n = recipeIndex = entry != null ? entry.getListIndex() : -1;
            if (recipeIndex >= 0) {
                if (mouseButton == 2) {
                    this.storage.toggleFavorite(recipeIndex);
                    this.reCreateEntryWidgets();
                } else {
                    boolean samePage = AccessorUtils.getSelectedMerchantRecipe(this.parentGui) == recipeIndex;
                    InputHandler.changeTradePage(this.parentGui, recipeIndex);
                    if (GuiBase.isShiftDown() || samePage || mouseButton == 1) {
                        InventoryUtils.villagerClearTradeInputSlots();
                        if (mouseButton == 1) {
                            InventoryUtils.villagerTradeEverythingPossibleWithCurrentRecipe();
                        } else {
                            InventoryUtils.tryMoveItemsToMerchantBuySlots(this.parentGui, true);
                        }
                    }
                }
            }
        }
        return true;
    }

    public void onMouseReleasedImpl(int mouseX, int mouseY, int mouseButton) {
        this.scrollBar.setIsDragging(false);
    }

    public boolean onMouseScrolledImpl(int mouseX, int mouseY, double mouseWheelDelta) {
        this.scrollBar.offsetValue(mouseWheelDelta < 0.0 ? 1 : -1);
        return true;
    }

    public void render(int mouseX, int mouseY, boolean selected) {
        this.lazySetRecipeList();
        if (this.recipeList != null) {
            int currentPage = AccessorUtils.getSelectedMerchantRecipe(this.parentGui);
            currentPage = Math.min(currentPage, this.recipeList.size() - 1);
            this.updateDataStorage(currentPage);
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderUtils.disableItemLighting();
            this.bindTexture(Icons.TEXTURE);
            RenderUtils.drawTexturedRect((int)this.x, (int)this.y, (int)0, (int)0, (int)this.width, (int)166);
            String str = StringUtils.translate((String)"itemscroller.gui.label.trades", (Object[])new Object[0]);
            int w = this.getStringWidth(str);
            this.drawString(this.x + this.width / 2 - w / 2, this.y + 6, -12566464, str);
            this.scrollBar.render(mouseX, mouseY, 0.0f, this.x + 93, this.y + 17, 8, 142, this.scrollBarTotalHeight);
            for (WidgetTradeEntry entry : this.entryList) {
                entry.render(mouseX, mouseY, currentPage == entry.getListIndex());
            }
            for (WidgetTradeEntry entry : this.entryList) {
                if (!entry.isMouseOver(mouseX, mouseY)) continue;
                entry.postRenderHovered(mouseX, mouseY, false);
            }
        }
    }

    private void reCreateEntryWidgets() {
        if (this.recipeList != null) {
            this.entryList.clear();
            ArrayList<Object> list = new ArrayList<Object>();
            List<Integer> favorites = this.data.getFavorites();
            if (!favorites.isEmpty()) {
                for (int index : favorites) {
                    if (index < 0 || index >= this.recipeList.size()) continue;
                    list.add(this.recipeList.get(index));
                }
                for (int i = 0; i < this.recipeList.size(); ++i) {
                    if (favorites.contains(i)) continue;
                    list.add(this.recipeList.get(i));
                }
            } else {
                list.addAll((Collection<Object>)this.recipeList);
            }
            int scrollBarPos = this.scrollBar.getValue();
            int last = Math.min(scrollBarPos + 7, list.size());
            int x = this.x + 5;
            for (int index = scrollBarPos; index < last; ++index) {
                int y = this.y + (index - scrollBarPos) * 20 + 18;
                axe recipe = (axe)list.get(index);
                this.entryList.add(new WidgetTradeEntry(x, y, 88, 20, recipe, this.recipeList.indexOf((Object)recipe), this.data));
            }
        }
    }

    private void updateDataStorage(int currentPage) {
        int oldPosition = this.data.getTradeListPosition();
        int newPosition = this.scrollBar.getValue();
        if (this.data.getLastPage() != currentPage) {
            this.storage.setLastPage(currentPage);
        }
        if (newPosition != oldPosition) {
            this.storage.setTradeListPosition(newPosition);
            this.reCreateEntryWidgets();
        }
    }
}

