/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.event;

import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.recipes.CraftingRecipe;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.InputUtils;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.nio.FloatBuffer;

public class RenderEventHandler {
    private static final RenderEventHandler INSTANCE = new RenderEventHandler();
    private static final cee LIGHT0_POS = new cee(0.2, 1.0, -0.7).a();
    private static final cee LIGHT1_POS = new cee(-0.2, 1.0, 0.7).a();
    private final cft mc = cft.s();
    private int recipeListX;
    private int recipeListY;
    private int recipesPerColumn;
    private int columnWidth;
    private int columns;
    private int numberTextWidth;
    private int gapColumn;
    private int entryHeight;
    private double scale;

    public static RenderEventHandler instance() {
        return INSTANCE;
    }

    public void onDrawBackgroundPost() {
        if (GuiUtils.getCurrentScreen() instanceof cky && InputUtils.isRecipeViewOpen()) {
            cky gui = (cky)GuiUtils.getCurrentScreen();
            RecipeStorage recipes = RecipeStorage.getInstance();
            int first = recipes.getFirstVisibleRecipeId();
            int countPerPage = recipes.getRecipeCountPerPage();
            int lastOnPage = first + countPerPage - 1;
            this.calculateRecipePositions(gui);
            cua.G();
            cua.c((float)this.recipeListX, (float)this.recipeListY, (float)0.0f);
            cua.a((double)this.scale, (double)this.scale, (double)1.0);
            String str = StringUtils.translate((String)"itemscroller.gui.label.recipe_page", (Object[])new Object[]{first / countPerPage + 1, recipes.getTotalRecipeCount() / countPerPage});
            this.mc.l.b(str, 16.0f, -12.0f, -1061109568);
            int i = 0;
            for (int recipeId = first; recipeId <= lastOnPage; ++recipeId) {
                ate stack = recipes.getRecipe(recipeId).getResult();
                boolean selected = recipeId == recipes.getSelection();
                int row = i % this.recipesPerColumn;
                int column = i / this.recipesPerColumn;
                this.renderStoredRecipeStack(stack, recipeId, row, column, gui, selected);
                ++i;
            }
            if (Configs.Generic.CRAFTING_RENDER_RECIPE_ITEMS.getBooleanValue()) {
                int mouseY;
                int mouseX = fi.dy.masa.malilib.util.InputUtils.getMouseX();
                int recipeId = this.getHoveredRecipeId(mouseX, mouseY = fi.dy.masa.malilib.util.InputUtils.getMouseY(), recipes, gui);
                CraftingRecipe recipe = recipeId >= 0 ? recipes.getRecipe(recipeId) : recipes.getSelectedRecipe();
                this.renderRecipeItems(recipe, recipes.getRecipeCountPerPage(), gui);
            }
            cua.H();
            cua.m();
        }
    }

    public void onDrawScreenPost() {
        if (GuiUtils.getCurrentScreen() instanceof cky && InputUtils.isRecipeViewOpen()) {
            CraftingRecipe recipe;
            ate stack;
            int mouseY;
            cky gui = (cky)GuiUtils.getCurrentScreen();
            RecipeStorage recipes = RecipeStorage.getInstance();
            int mouseX = fi.dy.masa.malilib.util.InputUtils.getMouseX();
            int recipeId = this.getHoveredRecipeId(mouseX, mouseY = fi.dy.masa.malilib.util.InputUtils.getMouseY(), recipes, gui);
            if (recipeId >= 0) {
                CraftingRecipe recipe2 = recipes.getRecipe(recipeId);
                this.renderHoverTooltip(mouseX, mouseY, recipe2, gui);
            } else if (Configs.Generic.CRAFTING_RENDER_RECIPE_ITEMS.getBooleanValue() && !InventoryUtils.isStackEmpty(stack = this.getHoveredRecipeIngredient(mouseX, mouseY, recipe = recipes.getSelectedRecipe(), recipes.getRecipeCountPerPage(), gui))) {
                InventoryOverlay.renderStackToolTip((int)mouseX, (int)mouseY, (ate)stack, (cft)this.mc);
            }
        }
    }

    private void calculateRecipePositions(cky gui) {
        RecipeStorage recipes = RecipeStorage.getInstance();
        int gapHorizontal = 2;
        int gapVertical = 2;
        int stackBaseHeight = 16;
        int guiLeft = AccessorUtils.getGuiLeft(gui);
        this.recipesPerColumn = 9;
        this.columns = (int)Math.ceil((double)recipes.getRecipeCountPerPage() / (double)this.recipesPerColumn);
        this.numberTextWidth = 12;
        this.gapColumn = 4;
        int usableHeight = GuiUtils.getScaledWindowHeight();
        int usableWidth = guiLeft;
        double gapScaleVertical = 0.8888888888888888;
        int maxStackDimensionsVertical = (int)((double)usableHeight / ((double)this.recipesPerColumn + 1.2) * gapScaleVertical);
        double gapScaleHorizontal = 0.8888888888888888;
        int maxStackDimensionsHorizontal = (int)((double)(usableWidth - this.columns * (this.numberTextWidth + this.gapColumn)) / ((double)(this.columns + 3) + 0.8) * gapScaleHorizontal);
        int stackDimensions = Math.min(maxStackDimensionsVertical, maxStackDimensionsHorizontal);
        this.scale = (int)Math.ceil((double)stackDimensions / 16.0);
        this.entryHeight = 18;
        this.recipeListX = guiLeft - (int)((double)(this.columns * (16 + this.numberTextWidth + this.gapColumn) + 2) * this.scale);
        this.recipeListY = (int)((double)this.entryHeight * this.scale);
        this.columnWidth = 16 + this.numberTextWidth + this.gapColumn;
    }

    private void renderHoverTooltip(int mouseX, int mouseY, CraftingRecipe recipe, cky gui) {
        ate stack = recipe.getResult();
        if (!InventoryUtils.isStackEmpty(stack)) {
            InventoryOverlay.renderStackToolTip((int)mouseX, (int)mouseY, (ate)stack, (cft)this.mc);
        }
    }

    public int getHoveredRecipeId(int mouseX, int mouseY, RecipeStorage recipes, cky gui) {
        if (InputUtils.isRecipeViewOpen()) {
            this.calculateRecipePositions(gui);
            int stackDimensions = (int)(16.0 * this.scale);
            for (int column = 0; column < this.columns; ++column) {
                int startX = this.recipeListX + (int)((double)(column * this.columnWidth + this.gapColumn + this.numberTextWidth) * this.scale);
                if (mouseX < startX || mouseX > startX + stackDimensions) continue;
                for (int row = 0; row < this.recipesPerColumn; ++row) {
                    int startY = this.recipeListY + (int)((double)(row * this.entryHeight) * this.scale);
                    if (mouseY < startY || mouseY > startY + stackDimensions) continue;
                    return recipes.getFirstVisibleRecipeId() + column * this.recipesPerColumn + row;
                }
            }
        }
        return -1;
    }

    private void renderStoredRecipeStack(ate stack, int recipeId, int row, int column, cky gui, boolean selected) {
        cgk font = this.mc.l;
        String indexStr = String.valueOf(recipeId + 1);
        int x = column * this.columnWidth + this.gapColumn + this.numberTextWidth;
        int y = row * this.entryHeight;
        this.renderStackAt(stack, x, y, selected);
        double scale = 0.75;
        x = x - (int)((double)font.a(indexStr) * scale) - 2;
        y = row * this.entryHeight + this.entryHeight / 2 - font.a / 2;
        cua.G();
        cua.c((float)x, (float)y, (float)0.0f);
        cua.a((double)scale, (double)scale, (double)0.0);
        font.b(indexStr, 0.0f, 0.0f, 0xC0C0C0);
        cua.H();
    }

    private void renderRecipeItems(CraftingRecipe recipe, int recipeCountPerPage, cky gui) {
        ate[] items = recipe.getRecipeItems();
        int recipeDimensions = (int)Math.ceil(Math.sqrt(recipe.getRecipeLength()));
        int x = -49;
        int y = 3 * this.entryHeight;
        int i = 0;
        for (int row = 0; row < recipeDimensions; ++row) {
            int col = 0;
            while (col < recipeDimensions) {
                int xOff = col * 17;
                int yOff = row * 17;
                this.renderStackAt(items[i], x + xOff, y + yOff, false);
                ++col;
                ++i;
            }
        }
    }

    private ate getHoveredRecipeIngredient(int mouseX, int mouseY, CraftingRecipe recipe, int recipeCountPerPage, cky gui) {
        int recipeDimensions = (int)Math.ceil(Math.sqrt(recipe.getRecipeLength()));
        int scaledStackDimensions = (int)(16.0 * this.scale);
        int scaledGridEntry = (int)(17.0 * this.scale);
        int x = this.recipeListX - (int)(49.0 * this.scale);
        int y = this.recipeListY + (int)((double)(3 * this.entryHeight) * this.scale);
        if (mouseX >= x && mouseX <= x + recipeDimensions * scaledGridEntry && mouseY >= y && mouseY <= y + recipeDimensions * scaledGridEntry) {
            int i = 0;
            for (int row = 0; row < recipeDimensions; ++row) {
                int col = 0;
                while (col < recipeDimensions) {
                    int xOff = col * scaledGridEntry;
                    int yOff = row * scaledGridEntry;
                    int xStart = x + xOff;
                    int yStart = y + yOff;
                    if (mouseX >= xStart && mouseX < xStart + scaledStackDimensions && mouseY >= yStart && mouseY < yStart + scaledStackDimensions) {
                        return recipe.getRecipeItems()[i];
                    }
                    ++col;
                    ++i;
                }
            }
        }
        return ate.a;
    }

    private void renderStackAt(ate stack, int x, int y, boolean border) {
        cua.G();
        cua.g();
        int w = 16;
        if (border) {
            RenderUtils.drawRect((int)(x - 1), (int)(y - 1), (int)17, (int)1, (int)-1);
            RenderUtils.drawRect((int)(x - 1), (int)y, (int)1, (int)17, (int)-1);
            RenderUtils.drawRect((int)(x + 16), (int)(y - 1), (int)1, (int)17, (int)-1);
            RenderUtils.drawRect((int)x, (int)(y + 16), (int)17, (int)1, (int)-1);
            RenderUtils.drawRect((int)x, (int)y, (int)16, (int)16, (int)0x20FFFFFF);
        } else {
            RenderUtils.drawRect((int)x, (int)y, (int)16, (int)16, (int)0x20FFFFFF);
        }
        if (!InventoryUtils.isStackEmpty(stack)) {
            RenderEventHandler.enableGUIStandardItemLighting((float)this.scale);
            stack = stack.i();
            InventoryUtils.setStackSize(stack, 1);
            this.mc.V().b += 100.0f;
            this.mc.V().a((afa)this.mc.i, stack, x, y);
            this.mc.V().b -= 100.0f;
        }
        RenderUtils.disableItemLighting();
        cua.l();
        cua.H();
    }

    public static void enableGUIStandardItemLighting(float scale) {
        cua.G();
        cua.b((float)-30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        cua.b((float)165.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        RenderEventHandler.enableStandardItemLighting(scale);
        cua.H();
    }

    public static void enableStandardItemLighting(float scale) {
        cua.f();
        cua.a((int)0);
        cua.a((int)1);
        cua.h();
        cua.a((int)1032, (int)5634);
        cua.a((int)16384, (int)4611, (FloatBuffer)cfr.a((float)((float)RenderEventHandler.LIGHT0_POS.b), (float)((float)RenderEventHandler.LIGHT0_POS.c), (float)((float)RenderEventHandler.LIGHT0_POS.d), (float)0.0f));
        float lightStrength = 0.3f * scale;
        cua.a((int)16384, (int)4609, (FloatBuffer)cfr.a((float)lightStrength, (float)lightStrength, (float)lightStrength, (float)1.0f));
        cua.a((int)16384, (int)4608, (FloatBuffer)cfr.a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        cua.a((int)16384, (int)4610, (FloatBuffer)cfr.a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        cua.a((int)16385, (int)4611, (FloatBuffer)cfr.a((float)((float)RenderEventHandler.LIGHT1_POS.b), (float)((float)RenderEventHandler.LIGHT1_POS.c), (float)((float)RenderEventHandler.LIGHT1_POS.d), (float)0.0f));
        cua.a((int)16385, (int)4609, (FloatBuffer)cfr.a((float)lightStrength, (float)lightStrength, (float)lightStrength, (float)1.0f));
        cua.a((int)16385, (int)4608, (FloatBuffer)cfr.a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        cua.a((int)16385, (int)4610, (FloatBuffer)cfr.a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        cua.j((int)7424);
        float ambientLightStrength = 0.4f;
        cua.a((int)2899, (FloatBuffer)cfr.a((float)ambientLightStrength, (float)ambientLightStrength, (float)ambientLightStrength, (float)1.0f));
    }
}

