/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.event;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.config.Hotkeys;
import fi.dy.masa.itemscroller.gui.GuiConfigs;
import fi.dy.masa.itemscroller.recipes.CraftingHandler;
import fi.dy.masa.itemscroller.recipes.CraftingRecipe;
import fi.dy.masa.itemscroller.recipes.RecipeStorage;
import fi.dy.masa.itemscroller.util.AccessorUtils;
import fi.dy.masa.itemscroller.util.InputUtils;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import fi.dy.masa.itemscroller.util.MoveAction;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyAction;
import fi.dy.masa.malilib.util.GuiUtils;

public class KeybindCallbacks
implements IHotkeyCallback {
    private static final KeybindCallbacks INSTANCE = new KeybindCallbacks();
    private boolean disabled;

    public static KeybindCallbacks getInstance() {
        return INSTANCE;
    }

    private KeybindCallbacks() {
    }

    public void setCallbacks() {
        for (ConfigHotkey hotkey : Hotkeys.HOTKEY_LIST) {
            hotkey.getKeybind().setCallback((IHotkeyCallback)this);
        }
    }

    public boolean functionalityEnabled() {
        return !this.disabled;
    }

    public boolean onKeyAction(KeyAction action, IKeybind key) {
        cft mc = cft.s();
        if (key == Hotkeys.KEY_MAIN_TOGGLE.getKeybind()) {
            boolean bl = this.disabled = !this.disabled;
            if (this.disabled) {
                mc.i.a(wj.fD, 0.8f, 0.8f);
            } else {
                mc.i.a(wj.fK, 0.5f, 1.0f);
            }
            return true;
        }
        if (key == Hotkeys.KEY_OPEN_CONFIG_GUI.getKeybind()) {
            GuiBase.openGui((ckd)new GuiConfigs());
            return true;
        }
        if (this.disabled || mc == null || mc.i == null || !(GuiUtils.getCurrentScreen() instanceof cky)) {
            return false;
        }
        cky gui = (cky)GuiUtils.getCurrentScreen();
        aqx slot = AccessorUtils.getSlotUnderMouse(gui);
        RecipeStorage recipes = RecipeStorage.getInstance();
        MoveAction moveAction = InputUtils.getDragMoveAction(key);
        if (slot != null) {
            if (moveAction != MoveAction.NONE) {
                int mouseX = fi.dy.masa.malilib.util.InputUtils.getMouseX();
                int mouseY = fi.dy.masa.malilib.util.InputUtils.getMouseY();
                return InventoryUtils.dragMoveItems(gui, mc, moveAction, mouseX, mouseY, true);
            }
            if (key == Hotkeys.KEY_MOVE_EVERYTHING.getKeybind()) {
                InventoryUtils.tryMoveStacks(slot, gui, false, true, false);
                return true;
            }
            if (key == Hotkeys.KEY_DROP_ALL_MATCHING.getKeybind()) {
                if (Configs.Toggles.DROP_MATCHING.getBooleanValue() && !Configs.GUI_BLACKLIST.contains(gui.getClass().getName()) && slot.e()) {
                    InventoryUtils.dropStacks(gui, slot.d(), slot, true);
                    return true;
                }
            } else if (key == Hotkeys.KEY_MOVE_STACK_TO_OFFHAND.getKeybind() && gui instanceof clp && slot != null) {
                InventoryUtils.swapSlots(gui, slot.e, 45);
                return true;
            }
        }
        if (key == Hotkeys.KEY_CRAFT_EVERYTHING.getKeybind()) {
            InventoryUtils.craftEverythingPossibleWithCurrentRecipe(recipes.getSelectedRecipe(), gui);
            return true;
        }
        if (key == Hotkeys.KEY_THROW_CRAFT_RESULTS.getKeybind()) {
            InventoryUtils.throwAllCraftingResultsToGround(recipes.getSelectedRecipe(), gui);
            return true;
        }
        if (key == Hotkeys.KEY_MOVE_CRAFT_RESULTS.getKeybind()) {
            InventoryUtils.moveAllCraftingResultsToOtherInventory(recipes.getSelectedRecipe(), gui);
            return true;
        }
        if (key == Hotkeys.KEY_STORE_RECIPE.getKeybind()) {
            if (InputUtils.isRecipeViewOpen() && InventoryUtils.isCraftingSlot(gui, slot)) {
                recipes.storeCraftingRecipeToCurrentSelection(slot, gui, true);
                return true;
            }
        } else {
            if (key == Hotkeys.KEY_VILLAGER_TRADE_FAVORITES.getKeybind()) {
                InventoryUtils.villagerTradeEverythingPossibleWithAllFavoritedTrades();
                return true;
            }
            if (key == Hotkeys.KEY_SLOT_DEBUG.getKeybind()) {
                if (slot != null) {
                    InventoryUtils.debugPrintSlotInfo(gui, slot);
                } else {
                    ItemScroller.logger.info("GUI class: {}", (Object)gui.getClass().getName());
                }
                return true;
            }
        }
        return false;
    }

    public void onTick(cft mc) {
        ckd guiScreen;
        cky gui;
        aqx outputSlot;
        if (!this.disabled && mc != null && mc.i != null && GuiUtils.getCurrentScreen() instanceof cky && !(GuiUtils.getCurrentScreen() instanceof clh) && !Configs.GUI_BLACKLIST.contains(GuiUtils.getCurrentScreen().getClass().getName()) && Hotkeys.KEY_MASS_CRAFT.getKeybind().isKeybindHeld() && (outputSlot = CraftingHandler.getFirstCraftingOutputSlotForGui(gui = (cky)(guiScreen = GuiUtils.getCurrentScreen()))) != null) {
            CraftingRecipe recipe = RecipeStorage.getInstance().getSelectedRecipe();
            InventoryUtils.tryClearCursor(gui, mc);
            InventoryUtils.throwAllCraftingResultsToGround(recipe, gui);
            InventoryUtils.tryMoveItemsToFirstCraftingGrid(recipe, gui, true);
            int failsafe = 0;
            while (++failsafe < 40 && InventoryUtils.areStacksEqual(outputSlot.d(), recipe.getResult())) {
                if (Configs.Generic.CARPET_CTRL_Q_CRAFTING.getBooleanValue()) {
                    InventoryUtils.dropStack(gui, outputSlot.e);
                } else {
                    InventoryUtils.dropStacksWhileHasItem(gui, outputSlot.e, recipe.getResult());
                }
                InventoryUtils.tryClearCursor(gui, mc);
                InventoryUtils.throwAllCraftingResultsToGround(recipe, gui);
                InventoryUtils.tryMoveItemsToFirstCraftingGrid(recipe, gui, true);
            }
        }
    }
}

