/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.util.WorldUtils;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class StringUtils {
    public static int getColor(String colorStr, int defaultColor) {
        Pattern pattern = Pattern.compile("(?:0x|#)([a-fA-F0-9]{1,8})");
        Matcher matcher = pattern.matcher(colorStr);
        if (matcher.matches()) {
            try {
                return (int)Long.parseLong(matcher.group(1), 16);
            }
            catch (NumberFormatException e) {
                return defaultColor;
            }
        }
        try {
            return Integer.parseInt(colorStr, 10);
        }
        catch (NumberFormatException e) {
            return defaultColor;
        }
    }

    public static String splitCamelCase(String str) {
        if ((str = str.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " ")).length() > 1 && str.charAt(0) > 'Z') {
            str = str.substring(0, 1).toUpperCase(Locale.ROOT) + str.substring(1);
        }
        return str;
    }

    public static void sendOpenFileChatMessage(aer sender, String messageKey, File file) {
        iq name = new iq(file.getName());
        name.b().a(new ii(ii.a.b, file.getAbsolutePath()));
        name.b().d(Boolean.valueOf(true));
        sender.a((ij)new ir(messageKey, new Object[]{name}));
    }

    public static void splitTextToLines(List<String> linesOut, String textIn, int maxLineLength) {
        String[] lines;
        for (String line : lines = textIn.split("\\\\n")) {
            String[] parts = line.split(" ");
            StringBuilder sb = new StringBuilder(256);
            int spaceWidth = StringUtils.getStringWidth(" ");
            int lineWidth = 0;
            for (String str : parts) {
                int width = StringUtils.getStringWidth(str);
                if (lineWidth + width + spaceWidth > maxLineLength) {
                    if (lineWidth > 0) {
                        linesOut.add(sb.toString());
                        sb = new StringBuilder(256);
                        lineWidth = 0;
                    }
                    if (width > maxLineLength) {
                        int chars = str.length();
                        for (int i = 0; i < chars; ++i) {
                            String c = str.substring(i, i + 1);
                            if ((lineWidth += StringUtils.getStringWidth(c)) > maxLineLength) {
                                linesOut.add(sb.toString());
                                sb = new StringBuilder(256);
                                lineWidth = 0;
                            }
                            sb.append(c);
                        }
                        linesOut.add(sb.toString());
                        sb = new StringBuilder(256);
                        lineWidth = 0;
                    }
                }
                if (lineWidth > 0) {
                    sb.append(" ");
                }
                if (width > maxLineLength) continue;
                sb.append(str);
                lineWidth += width + spaceWidth;
            }
            linesOut.add(sb.toString());
        }
    }

    public static String getClampedDisplayStringStrlen(List<String> list, int maxWidth, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(prefix);
        int width = prefix.length() + suffix.length();
        int size = list.size();
        if (size > 0) {
            for (int i = 0; i < size && width < maxWidth; ++i) {
                String str;
                int len;
                int end;
                if (i > 0) {
                    sb.append(", ");
                    width += 2;
                }
                if ((end = Math.min(len = (str = list.get(i)).length(), maxWidth - width)) < len) {
                    end = Math.max(0, Math.min(len, maxWidth - width - 3));
                    if (end >= 1) {
                        sb.append(str.substring(0, end));
                    }
                    sb.append("...");
                    width += end + 3;
                    continue;
                }
                sb.append(str);
                width += len;
            }
        } else {
            sb.append("<empty>");
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static String getClampedDisplayStringRenderlen(List<String> list, int maxWidth, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(prefix);
        String entrySep = ", ";
        String dots = " ...";
        int listSize = list.size();
        int widthSep = StringUtils.getStringWidth(entrySep);
        int widthDots = StringUtils.getStringWidth(dots);
        int width = StringUtils.getStringWidth(prefix) + StringUtils.getStringWidth(suffix);
        if (listSize > 0) {
            int len;
            for (int listIndex = 0; listIndex < listSize && width < maxWidth; width += len, ++listIndex) {
                String c;
                int charWidth;
                String str;
                if (listIndex > 0) {
                    sb.append(entrySep);
                    width += widthSep;
                }
                if (width + (len = StringUtils.getStringWidth(str = list.get(listIndex))) <= maxWidth) {
                    sb.append(str);
                    continue;
                }
                for (int i = 0; i < str.length() && width + (charWidth = StringUtils.getStringWidth(c = str.substring(i, i + 1))) + widthDots <= maxWidth; ++i) {
                    sb.append(c);
                    width += charWidth;
                }
                sb.append(dots);
                width += widthDots;
                break;
            }
        } else {
            sb.append("<empty>");
        }
        sb.append(suffix);
        return sb.toString();
    }

    @Nullable
    public static String getWorldOrServerName() {
        cft mc = cft.s();
        if (mc.x()) {
            dgh server = mc.y();
            if (server != null) {
                return server.I();
            }
        } else {
            crj server = mc.v();
            if (server != null) {
                return server.b.replace(':', '_');
            }
        }
        return null;
    }

    public static String getStorageFileName(boolean globalData, String prefix, String suffix, String defaultName) {
        String name = StringUtils.getWorldOrServerName();
        if (name != null) {
            if (globalData) {
                return prefix + name + suffix;
            }
            crg world = cft.s().g;
            if (world != null) {
                return prefix + name + "_dim" + WorldUtils.getDimensionId((axy)world) + suffix;
            }
        }
        return prefix + defaultName + suffix;
    }

    public static String translate(String translationKey, Object ... args) {
        return dej.a((String)translationKey, (Object[])args);
    }

    public static int getFontHeight() {
        return cft.s().l.a;
    }

    public static int getStringWidth(String text) {
        return cft.s().l.a(text);
    }

    public static void drawString(int x, int y, int color, String text) {
        cft.s().l.b(text, (float)x, (float)y, color);
    }
}

