/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

public class PositionUtils {
    public static cee modifyValue(CoordinateType type, cee valueIn, double amount) {
        switch (type) {
            case X: {
                return new cee(valueIn.b + amount, valueIn.c, valueIn.d);
            }
            case Y: {
                return new cee(valueIn.b, valueIn.c + amount, valueIn.d);
            }
            case Z: {
                return new cee(valueIn.b, valueIn.c, valueIn.d + amount);
            }
        }
        return valueIn;
    }

    public static el modifyValue(CoordinateType type, el valueIn, int amount) {
        switch (type) {
            case X: {
                return new el(valueIn.o() + amount, valueIn.p(), valueIn.q());
            }
            case Y: {
                return new el(valueIn.o(), valueIn.p() + amount, valueIn.q());
            }
            case Z: {
                return new el(valueIn.o(), valueIn.q(), valueIn.q() + amount);
            }
        }
        return valueIn;
    }

    public static cee setValue(CoordinateType type, cee valueIn, double newValue) {
        switch (type) {
            case X: {
                return new cee(newValue, valueIn.c, valueIn.d);
            }
            case Y: {
                return new cee(valueIn.b, newValue, valueIn.d);
            }
            case Z: {
                return new cee(valueIn.b, valueIn.c, newValue);
            }
        }
        return valueIn;
    }

    public static el setValue(CoordinateType type, el valueIn, int newValue) {
        switch (type) {
            case X: {
                return new el(newValue, valueIn.p(), valueIn.q());
            }
            case Y: {
                return new el(valueIn.o(), newValue, valueIn.q());
            }
            case Z: {
                return new el(valueIn.o(), valueIn.q(), newValue);
            }
        }
        return valueIn;
    }

    public static eq getClosestLookingDirection(aer entity) {
        return PositionUtils.getClosestLookingDirection(entity, 60.0f);
    }

    public static eq getClosestLookingDirection(aer entity, float verticalThreshold) {
        if (entity.x >= verticalThreshold) {
            return eq.a;
        }
        if (entity.x <= -verticalThreshold) {
            return eq.b;
        }
        return entity.bA();
    }

    public static el getPositionInfrontOfEntity(aer entity) {
        return PositionUtils.getPositionInfrontOfEntity(entity, 60.0f);
    }

    public static el getPositionInfrontOfEntity(aer entity, float verticalThreshold) {
        el pos = new el(entity.q, entity.r, entity.s);
        if (entity.x >= verticalThreshold) {
            return pos.b();
        }
        if (entity.x <= -verticalThreshold) {
            return new el(entity.q, Math.ceil(entity.bD().e), entity.s);
        }
        double y = Math.floor(entity.r + (double)entity.bF());
        switch (entity.bA()) {
            case f: {
                return new el((int)Math.ceil(entity.q + (double)(entity.H / 2.0f)), (int)y, (int)Math.floor(entity.s));
            }
            case e: {
                return new el((int)Math.floor(entity.q - (double)(entity.H / 2.0f)) - 1, (int)y, (int)Math.floor(entity.s));
            }
            case d: {
                return new el((int)Math.floor(entity.q), (int)y, (int)Math.ceil(entity.s + (double)(entity.H / 2.0f)));
            }
            case c: {
                return new el((int)Math.floor(entity.q), (int)y, (int)Math.floor(entity.s - (double)(entity.H / 2.0f)) - 1);
            }
        }
        return pos;
    }

    public static cee getHitVecCenter(el basePos, eq facing) {
        int x = basePos.o();
        int y = basePos.p();
        int z = basePos.q();
        switch (facing) {
            case b: {
                return new cee((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
            case a: {
                return new cee((double)x + 0.5, (double)y, (double)z + 0.5);
            }
            case c: {
                return new cee((double)x + 0.5, (double)y + 0.5, (double)z);
            }
            case d: {
                return new cee((double)x + 0.5, (double)y + 0.5, (double)(z + 1));
            }
            case e: {
                return new cee((double)x, (double)y + 0.5, (double)z);
            }
            case f: {
                return new cee((double)(x + 1), (double)y + 0.5, (double)(z + 1));
            }
        }
        return new cee((double)x, (double)y, (double)z);
    }

    public static HitPart getHitPart(eq originalSide, eq playerFacingH, el pos, cee hitVec) {
        cee positions = PositionUtils.getHitPartPositions(originalSide, playerFacingH, pos, hitVec);
        double posH = positions.b;
        double posV = positions.c;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (offH > offV) {
                return posH < 0.5 ? HitPart.LEFT : HitPart.RIGHT;
            }
            return posV < 0.5 ? HitPart.BOTTOM : HitPart.TOP;
        }
        return HitPart.CENTER;
    }

    private static cee getHitPartPositions(eq originalSide, eq playerFacingH, el pos, cee hitVec) {
        double x = hitVec.b - (double)pos.o();
        double y = hitVec.c - (double)pos.p();
        double z = hitVec.d - (double)pos.q();
        double posH = 0.0;
        double posV = 0.0;
        switch (originalSide) {
            case b: 
            case a: {
                switch (playerFacingH) {
                    case c: {
                        posH = x;
                        posV = 1.0 - z;
                        break;
                    }
                    case d: {
                        posH = 1.0 - x;
                        posV = z;
                        break;
                    }
                    case e: {
                        posH = 1.0 - z;
                        posV = 1.0 - x;
                        break;
                    }
                    case f: {
                        posH = z;
                        posV = x;
                        break;
                    }
                }
                if (originalSide != eq.a) break;
                posV = 1.0 - posV;
                break;
            }
            case d: 
            case c: {
                posH = originalSide.c() == eq.b.a ? x : 1.0 - x;
                posV = y;
                break;
            }
            case f: 
            case e: {
                posH = originalSide.c() == eq.b.b ? z : 1.0 - z;
                posV = y;
            }
        }
        return new cee(posH, posV, 0.0);
    }

    public static eq getTargetedDirection(eq side, eq playerFacingH, el pos, cee hitVec) {
        cee positions = PositionUtils.getHitPartPositions(side, playerFacingH, pos, hitVec);
        double posH = positions.b;
        double posV = positions.c;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (side.k() == eq.a.b) {
                if (offH > offV) {
                    return posH < 0.5 ? playerFacingH.f() : playerFacingH.e();
                }
                if (side == eq.a) {
                    return posV > 0.5 ? playerFacingH.d() : playerFacingH;
                }
                return posV < 0.5 ? playerFacingH.d() : playerFacingH;
            }
            if (offH > offV) {
                return posH < 0.5 ? side.e() : side.f();
            }
            return posV < 0.5 ? eq.a : eq.b;
        }
        return side;
    }

    public static enum CoordinateType {
        X,
        Y,
        Z;

    }

    public static enum HitPart {
        CENTER,
        LEFT,
        RIGHT,
        BOTTOM,
        TOP;

    }
}

