/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.LayerMode;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.SubChunkPos;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class LayerRange {
    public static final int WORLD_HORIZONTAL_SIZE_MAX = 30000000;
    public static final int WORLD_HORIZONTAL_SIZE_MIN = -30000000;
    public static final int WORLD_VERTICAL_SIZE_MAX = 255;
    public static final int WORLD_VERTICAL_SIZE_MIN = 0;
    protected final IRangeChangeListener refresher;
    protected LayerMode layerMode = LayerMode.ALL;
    protected eq.a axis = eq.a.b;
    protected int layerSingle = 0;
    protected int layerAbove = 0;
    protected int layerBelow = 0;
    protected int layerRangeMin = 0;
    protected int layerRangeMax = 0;
    protected boolean hotkeyRangeMin;
    protected boolean hotkeyRangeMax;

    public LayerRange(IRangeChangeListener refresher) {
        this.refresher = refresher;
    }

    public LayerMode getLayerMode() {
        return this.layerMode;
    }

    public eq.a getAxis() {
        return this.axis;
    }

    public boolean getMoveLayerRangeMin() {
        return this.hotkeyRangeMin;
    }

    public boolean getMoveLayerRangeMax() {
        return this.hotkeyRangeMax;
    }

    public void toggleHotkeyMoveRangeMin() {
        this.hotkeyRangeMin = !this.hotkeyRangeMin;
    }

    public void toggleHotkeyMoveRangeMax() {
        this.hotkeyRangeMax = !this.hotkeyRangeMax;
    }

    public int getLayerSingle() {
        return this.layerSingle;
    }

    public int getLayerAbove() {
        return this.layerAbove;
    }

    public int getLayerBelow() {
        return this.layerBelow;
    }

    public int getLayerRangeMin() {
        return this.layerRangeMin;
    }

    public int getLayerRangeMax() {
        return this.layerRangeMax;
    }

    public int getLayerMin() {
        switch (this.layerMode) {
            case ALL: {
                return LayerRange.getWorldMinValueForAxis(this.axis);
            }
            case SINGLE_LAYER: {
                return this.layerSingle;
            }
            case ALL_ABOVE: {
                return this.layerAbove;
            }
            case ALL_BELOW: {
                return LayerRange.getWorldMinValueForAxis(this.axis);
            }
            case LAYER_RANGE: {
                return this.layerRangeMin;
            }
        }
        return -30000000;
    }

    public int getLayerMax() {
        switch (this.layerMode) {
            case ALL: {
                return LayerRange.getWorldMaxValueForAxis(this.axis);
            }
            case SINGLE_LAYER: {
                return this.layerSingle;
            }
            case ALL_ABOVE: {
                return LayerRange.getWorldMaxValueForAxis(this.axis);
            }
            case ALL_BELOW: {
                return this.layerBelow;
            }
            case LAYER_RANGE: {
                return this.layerRangeMax;
            }
        }
        return 30000000;
    }

    public int getCurrentLayerValue(boolean isSecondValue) {
        switch (this.layerMode) {
            case SINGLE_LAYER: {
                return this.layerSingle;
            }
            case ALL_ABOVE: {
                return this.layerAbove;
            }
            case ALL_BELOW: {
                return this.layerBelow;
            }
            case LAYER_RANGE: {
                return isSecondValue ? this.layerRangeMax : this.layerRangeMin;
            }
        }
        return 0;
    }

    public static int getWorldMinValueForAxis(eq.a axis) {
        switch (axis) {
            case b: {
                return 0;
            }
        }
        return -30000000;
    }

    public static int getWorldMaxValueForAxis(eq.a axis) {
        switch (axis) {
            case b: {
                return 255;
            }
        }
        return 30000000;
    }

    public void setLayerMode(LayerMode mode) {
        this.setLayerMode(mode, true);
    }

    public void setLayerMode(LayerMode mode, boolean printMessage) {
        this.layerMode = mode;
        this.refresher.updateAll();
        if (printMessage) {
            String val = a.k.toString() + mode.getDisplayName();
            InfoUtils.printActionbarMessage("malilib.message.set_layer_mode_to", val);
        }
    }

    public void setAxis(eq.a axis) {
        this.axis = axis;
        this.refresher.updateAll();
        String val = a.k.toString() + axis.m();
        InfoUtils.printActionbarMessage("malilib.message.set_layer_axis_to", val);
    }

    public void setLayerSingle(int layer) {
        int old = this.layerSingle;
        if ((layer = this.getWorldLimitsClampedValue(layer)) != old) {
            this.markAffectedLayersForRenderUpdate();
            this.layerSingle = layer;
            this.markAffectedLayersForRenderUpdate();
        }
    }

    public void setLayerAbove(int layer) {
        int old = this.layerAbove;
        if ((layer = this.getWorldLimitsClampedValue(layer)) != old) {
            this.layerAbove = layer;
            this.updateLayersBetween(old, layer);
        }
    }

    public void setLayerBelow(int layer) {
        int old = this.layerBelow;
        if ((layer = this.getWorldLimitsClampedValue(layer)) != old) {
            this.layerBelow = layer;
            this.updateLayersBetween(old, layer);
        }
    }

    public boolean setLayerRangeMin(int layer) {
        return this.setLayerRangeMin(layer, false);
    }

    public boolean setLayerRangeMax(int layer) {
        return this.setLayerRangeMax(layer, false);
    }

    protected boolean setLayerRangeMin(int layer, boolean force) {
        int old = this.layerRangeMin;
        layer = this.getWorldLimitsClampedValue(layer);
        if (!force) {
            layer = Math.min(layer, this.layerRangeMax);
        }
        if (layer != old) {
            this.layerRangeMin = layer;
            this.updateLayersBetween(old, layer);
        }
        return layer != old;
    }

    protected boolean setLayerRangeMax(int layer, boolean force) {
        int old = this.layerRangeMax;
        layer = this.getWorldLimitsClampedValue(layer);
        if (!force) {
            layer = Math.max(layer, this.layerRangeMin);
        }
        if (layer != old) {
            this.layerRangeMax = layer;
            this.updateLayersBetween(old, layer);
        }
        return layer != old;
    }

    public void setToPosition(aer entity) {
        int pos = 0;
        switch (this.axis) {
            case a: {
                pos = (int)entity.q;
                break;
            }
            case b: {
                pos = (int)entity.r;
                break;
            }
            case c: {
                pos = (int)entity.s;
            }
        }
        switch (this.layerMode) {
            case SINGLE_LAYER: {
                this.setLayerSingle(pos);
                break;
            }
            case ALL_ABOVE: {
                this.setLayerAbove(pos);
                break;
            }
            case ALL_BELOW: {
                this.setLayerBelow(pos);
                break;
            }
            case LAYER_RANGE: {
                Pair<Boolean, Boolean> moveMinMax = this.getMoveMinMax(entity);
                if (((Boolean)moveMinMax.getLeft()).booleanValue()) {
                    this.setLayerRangeMin(pos, true);
                }
                if (!((Boolean)moveMinMax.getRight()).booleanValue()) break;
                this.setLayerRangeMax(pos, true);
                break;
            }
        }
    }

    protected void markAffectedLayersForRenderUpdate() {
        int val2;
        int val1;
        switch (this.layerMode) {
            case ALL: {
                this.refresher.updateAll();
                return;
            }
            case SINGLE_LAYER: {
                val1 = this.layerSingle;
                val2 = this.layerSingle;
                break;
            }
            case ALL_ABOVE: {
                val1 = this.layerAbove;
                val2 = this.axis == eq.a.b ? 255 : 30000000;
                break;
            }
            case ALL_BELOW: {
                val1 = this.axis == eq.a.b ? 0 : -30000000;
                val2 = this.layerBelow;
                break;
            }
            case LAYER_RANGE: {
                val1 = this.layerRangeMin;
                val2 = this.layerRangeMax;
                break;
            }
            default: {
                return;
            }
        }
        this.updateLayersBetween(val1, val2);
    }

    protected void updateLayersBetween(int layer1, int layer2) {
        int layerMin = Math.min(layer1, layer2);
        int layerMax = Math.max(layer1, layer2);
        switch (this.axis) {
            case a: {
                this.refresher.updateBetweenX(layerMin, layerMax);
                break;
            }
            case b: {
                this.refresher.updateBetweenY(layerMin, layerMax);
                break;
            }
            case c: {
                this.refresher.updateBetweenZ(layerMin, layerMax);
            }
        }
    }

    public boolean moveLayer(int amount) {
        String axisName = this.axis.m().toLowerCase();
        String strTo = GuiBase.TXT_GREEN + axisName + " = ";
        switch (this.layerMode) {
            case ALL: {
                return false;
            }
            case SINGLE_LAYER: {
                this.setLayerSingle(this.layerSingle + amount);
                String val = strTo + this.layerSingle;
                InfoUtils.printActionbarMessage("malilib.message.set_layer_to", val);
                break;
            }
            case ALL_ABOVE: {
                this.setLayerAbove(this.layerAbove + amount);
                String val = strTo + this.layerAbove;
                InfoUtils.printActionbarMessage("malilib.message.moved_min_layer_to", val);
                break;
            }
            case ALL_BELOW: {
                this.setLayerBelow(this.layerBelow + amount);
                String val = strTo + this.layerBelow;
                InfoUtils.printActionbarMessage("malilib.message.moved_max_layer_to", val);
                break;
            }
            case LAYER_RANGE: {
                ctj player = cft.s().i;
                if (player == null) break;
                this.moveLayerRange(amount, false, (aog)player, true);
                break;
            }
        }
        return true;
    }

    protected void moveLayerRange(int amount, boolean force, aog player, boolean printMessage) {
        Pair<Boolean, Boolean> moveMinMax = this.getMoveMinMax((aer)player);
        boolean moveMin = (Boolean)moveMinMax.getLeft();
        boolean moveMax = (Boolean)moveMinMax.getRight();
        boolean moved = false;
        if (moveMin) {
            moved |= this.setLayerRangeMin(this.layerRangeMin + amount, force);
        }
        if (moveMax) {
            moved |= this.setLayerRangeMax(this.layerRangeMax + amount, force);
        }
        if (printMessage && moved) {
            String axisName = this.axis.m().toLowerCase();
            if (moveMin && moveMax) {
                InfoUtils.printActionbarMessage("malilib.message.moved_layer_range", String.valueOf(amount), axisName);
            } else {
                String val1 = moveMin ? StringUtils.translate("malilib.message.layer_range.range_min", new Object[0]) : StringUtils.translate("malilib.message.layer_range.range_max", new Object[0]);
                InfoUtils.printActionbarMessage("malilib.message.moved_layer_range_boundary", val1, String.valueOf(amount), axisName);
            }
        }
    }

    protected Pair<Boolean, Boolean> getMoveMinMax(aer entity) {
        double playerPos = this.axis == eq.a.b ? entity.r : (this.axis == eq.a.a ? entity.q : entity.s);
        double min = (double)this.layerRangeMin + 0.5;
        double max = (double)this.layerRangeMax + 0.5;
        boolean minClosest = Math.abs(playerPos - min) < Math.abs(playerPos - max) || playerPos < min;
        boolean moveMin = this.hotkeyRangeMin || minClosest && !this.hotkeyRangeMax;
        boolean moveMax = this.hotkeyRangeMax || !minClosest && !this.hotkeyRangeMin;
        return Pair.of((Object)moveMin, (Object)moveMax);
    }

    public String getCurrentLayerString() {
        switch (this.layerMode) {
            case ALL: {
                return "";
            }
            case SINGLE_LAYER: {
                return String.valueOf(this.layerSingle);
            }
            case ALL_ABOVE: {
                return String.valueOf(this.layerAbove);
            }
            case ALL_BELOW: {
                return String.valueOf(this.layerBelow);
            }
            case LAYER_RANGE: {
                return String.format("%d ... %s", this.layerRangeMin, this.layerRangeMax);
            }
        }
        return "";
    }

    protected int getWorldLimitsClampedValue(int value) {
        if (this.axis == eq.a.b) {
            return xq.a((int)value, (int)0, (int)255);
        }
        return xq.a((int)value, (int)-30000000, (int)30000000);
    }

    public boolean isPositionWithinRange(el pos) {
        return this.isPositionWithinRange(pos.o(), pos.p(), pos.q());
    }

    public boolean isPositionWithinRange(int x, int y, int z) {
        switch (this.layerMode) {
            case ALL: {
                return true;
            }
            case SINGLE_LAYER: {
                switch (this.axis) {
                    case a: {
                        return x == this.layerSingle;
                    }
                    case b: {
                        return y == this.layerSingle;
                    }
                    case c: {
                        return z == this.layerSingle;
                    }
                }
                break;
            }
            case ALL_ABOVE: {
                switch (this.axis) {
                    case a: {
                        return x >= this.layerAbove;
                    }
                    case b: {
                        return y >= this.layerAbove;
                    }
                    case c: {
                        return z >= this.layerAbove;
                    }
                }
                break;
            }
            case ALL_BELOW: {
                switch (this.axis) {
                    case a: {
                        return x <= this.layerBelow;
                    }
                    case b: {
                        return y <= this.layerBelow;
                    }
                    case c: {
                        return z <= this.layerBelow;
                    }
                }
                break;
            }
            case LAYER_RANGE: {
                switch (this.axis) {
                    case a: {
                        return x >= this.layerRangeMin && x <= this.layerRangeMax;
                    }
                    case b: {
                        return y >= this.layerRangeMin && y <= this.layerRangeMax;
                    }
                    case c: {
                        return z >= this.layerRangeMin && z <= this.layerRangeMax;
                    }
                }
            }
        }
        return false;
    }

    public boolean isPositionAtRenderEdgeOnSide(el pos, eq side) {
        switch (this.axis) {
            case a: {
                return side == eq.e && pos.o() == this.getLayerMin() || side == eq.f && pos.o() == this.getLayerMax();
            }
            case b: {
                return side == eq.a && pos.p() == this.getLayerMin() || side == eq.b && pos.p() == this.getLayerMax();
            }
            case c: {
                return side == eq.c && pos.q() == this.getLayerMin() || side == eq.d && pos.q() == this.getLayerMax();
            }
        }
        return false;
    }

    public boolean intersects(SubChunkPos pos) {
        switch (this.axis) {
            case a: {
                int xMin = pos.o() << 4;
                int xMax = (pos.o() << 4) + 15;
                return !(xMax < this.getLayerMin() || xMin > this.getLayerMax());
            }
            case b: {
                int yMin = pos.p() << 4;
                int yMax = (pos.p() << 4) + 15;
                return !(yMax < this.getLayerMin() || yMin > this.getLayerMax());
            }
            case c: {
                int zMin = pos.q() << 4;
                int zMax = (pos.q() << 4) + 15;
                return !(zMax < this.getLayerMin() || zMin > this.getLayerMax());
            }
        }
        return false;
    }

    public boolean intersects(IntBoundingBox box) {
        switch (this.axis) {
            case a: {
                return !(box.maxX < this.getLayerMin() || box.minX > this.getLayerMax());
            }
            case b: {
                return !(box.maxY < this.getLayerMin() || box.minY > this.getLayerMax());
            }
            case c: {
                return !(box.maxZ < this.getLayerMin() || box.minZ > this.getLayerMax());
            }
        }
        return false;
    }

    public boolean intersectsBox(el posMin, el posMax) {
        return this.intersectsBox(posMin.o(), posMin.p(), posMin.q(), posMax.o(), posMax.p(), posMax.q());
    }

    public boolean intersectsBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case a: {
                return !(maxX < this.getLayerMin() || minX > this.getLayerMax());
            }
            case b: {
                return !(maxY < this.getLayerMin() || minY > this.getLayerMax());
            }
            case c: {
                return !(maxZ < this.getLayerMin() || minZ > this.getLayerMax());
            }
        }
        return false;
    }

    public int getClampedValue(int value, eq.a type) {
        if (this.axis == type) {
            return xq.a((int)value, (int)this.getLayerMin(), (int)this.getLayerMax());
        }
        return xq.a((int)value, (int)LayerRange.getWorldMinValueForAxis(type), (int)LayerRange.getWorldMaxValueForAxis(type));
    }

    @Nullable
    public IntBoundingBox getClampedRenderBoundingBox(IntBoundingBox box) {
        if (!this.intersects(box)) {
            return null;
        }
        switch (this.axis) {
            case a: {
                int xMin = Math.max(box.minX, this.getLayerMin());
                int xMax = Math.min(box.maxX, this.getLayerMax());
                return IntBoundingBox.createProper(xMin, box.minY, box.minZ, xMax, box.maxY, box.maxZ);
            }
            case b: {
                int yMin = Math.max(box.minY, this.getLayerMin());
                int yMax = Math.min(box.maxY, this.getLayerMax());
                return IntBoundingBox.createProper(box.minX, yMin, box.minZ, box.maxX, yMax, box.maxZ);
            }
            case c: {
                int zMin = Math.max(box.minZ, this.getLayerMin());
                int zMax = Math.min(box.maxZ, this.getLayerMax());
                return IntBoundingBox.createProper(box.minX, box.minY, zMin, box.maxX, box.maxY, zMax);
            }
        }
        return null;
    }

    @Nullable
    public IntBoundingBox getClampedArea(el posMin, el posMax) {
        return this.getClampedArea(posMin.o(), posMin.p(), posMin.q(), posMax.o(), posMax.p(), posMax.q());
    }

    @Nullable
    public IntBoundingBox getClampedArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (!this.intersectsBox(minX, minY, minZ, maxX, maxY, maxZ)) {
            return null;
        }
        switch (this.axis) {
            case a: {
                int xMin = Math.max(minX, this.getLayerMin());
                int xMax = Math.min(maxX, this.getLayerMax());
                return IntBoundingBox.createProper(xMin, minY, minZ, xMax, maxY, maxZ);
            }
            case b: {
                int yMin = Math.max(minY, this.getLayerMin());
                int yMax = Math.min(maxY, this.getLayerMax());
                return IntBoundingBox.createProper(minX, yMin, minZ, maxX, yMax, maxZ);
            }
            case c: {
                int zMin = Math.max(minZ, this.getLayerMin());
                int zMax = Math.min(maxZ, this.getLayerMax());
                return IntBoundingBox.createProper(minX, minY, zMin, maxX, maxY, zMax);
            }
        }
        return null;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("mode", (JsonElement)new JsonPrimitive(this.layerMode.name()));
        obj.add("axis", (JsonElement)new JsonPrimitive(this.axis.name()));
        obj.add("layer_single", (JsonElement)new JsonPrimitive((Number)this.layerSingle));
        obj.add("layer_above", (JsonElement)new JsonPrimitive((Number)this.layerAbove));
        obj.add("layer_below", (JsonElement)new JsonPrimitive((Number)this.layerBelow));
        obj.add("layer_range_min", (JsonElement)new JsonPrimitive((Number)this.layerRangeMin));
        obj.add("layer_range_max", (JsonElement)new JsonPrimitive((Number)this.layerRangeMax));
        obj.add("hotkey_range_min", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.hotkeyRangeMin)));
        obj.add("hotkey_range_max", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.hotkeyRangeMax)));
        return obj;
    }

    public static LayerRange createFromJson(JsonObject obj, IRangeChangeListener refresher) {
        LayerRange range = new LayerRange(refresher);
        range.fromJson(obj);
        return range;
    }

    public void fromJson(JsonObject obj) {
        this.layerMode = LayerMode.fromStringStatic(JsonUtils.getString(obj, "mode"));
        this.axis = eq.a.a((String)JsonUtils.getString(obj, "axis"));
        if (this.axis == null) {
            this.axis = eq.a.b;
        }
        this.layerSingle = JsonUtils.getInteger(obj, "layer_single");
        this.layerAbove = JsonUtils.getInteger(obj, "layer_above");
        this.layerBelow = JsonUtils.getInteger(obj, "layer_below");
        this.layerRangeMin = JsonUtils.getInteger(obj, "layer_range_min");
        this.layerRangeMax = JsonUtils.getInteger(obj, "layer_range_max");
        this.hotkeyRangeMin = JsonUtils.getBoolean(obj, "hotkey_range_min");
        this.hotkeyRangeMax = JsonUtils.getBoolean(obj, "hotkey_range_max");
    }
}

