/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.util.ItemType;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;

public class InventoryUtils {
    private static final ez<ate> EMPTY_LIST = ez.a();

    public static boolean areStacksEqual(ate stack1, ate stack2) {
        return ate.c((ate)stack1, (ate)stack2) && ate.a((ate)stack1, (ate)stack2);
    }

    public static boolean areStacksEqualIgnoreDurability(ate stack1, ate stack2) {
        return ate.d((ate)stack1, (ate)stack2) && ate.a((ate)stack1, (ate)stack2);
    }

    public static void swapSlots(apv container, int slotNum, int hotbarSlot) {
        cft mc = cft.s();
        mc.e.a(container.d, slotNum, hotbarSlot, aqa.c, (aog)mc.i);
    }

    public static boolean isRegularInventorySlot(int slotNumber, boolean allowOffhand) {
        return slotNumber > 8 && (allowOffhand || slotNumber < 45);
    }

    public static int findEmptySlotInPlayerInventory(apv containerPlayer, boolean allowOffhand, boolean reverse) {
        int startSlot = reverse ? containerPlayer.c.size() - 1 : 0;
        int endSlot = reverse ? -1 : containerPlayer.c.size();
        int increment = reverse ? -1 : 1;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            aqx slot = (aqx)containerPlayer.c.get(slotNum);
            ate stackSlot = slot.d();
            if (!stackSlot.a() || !InventoryUtils.isRegularInventorySlot(slot.e, allowOffhand)) continue;
            return slot.e;
        }
        return -1;
    }

    public static int findSlotWithItem(apv container, ate stackReference, boolean reverse) {
        int startSlot = reverse ? container.c.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.c.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof aqm;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            aqx slot = (aqx)container.c.get(slotNum);
            if (isPlayerInv && !InventoryUtils.isRegularInventorySlot(slot.e, false) || !InventoryUtils.areStacksEqualIgnoreDurability(slot.d(), stackReference)) continue;
            return slot.e;
        }
        return -1;
    }

    public static boolean swapItemToMainHand(ate stackReference, cft mc) {
        ctj player = mc.i;
        boolean isCreative = player.bV.d;
        if (InventoryUtils.areStacksEqual(stackReference, player.cB())) {
            return false;
        }
        if (isCreative) {
            player.bB.a(stackReference);
            mc.e.a(player.b(adk.a), 36 + player.bB.d);
            return true;
        }
        int slot = InventoryUtils.findSlotWithItem(player.bD, stackReference, true);
        if (slot != -1) {
            int currentHotbarSlot = player.bB.d;
            mc.e.a(player.bD.d, slot, currentHotbarSlot, aqa.c, (aog)mc.i);
            return true;
        }
        return false;
    }

    public static boolean shulkerBoxHasItems(ate stackShulkerBox) {
        gy tag;
        gy nbt = stackShulkerBox.n();
        if (nbt != null && nbt.c("BlockEntityTag", 10) && (tag = nbt.p("BlockEntityTag")).c("Items", 9)) {
            he tagList = tag.d("Items", 10);
            return tagList.size() > 0;
        }
        return false;
    }

    public static ez<ate> getStoredItems(ate stackIn) {
        gy tagBlockEntity;
        gy nbt = stackIn.n();
        if (nbt != null && nbt.c("BlockEntityTag", 10) && (tagBlockEntity = nbt.p("BlockEntityTag")).c("Items", 9)) {
            ez items = ez.a();
            he tagList = tagBlockEntity.d("Items", 10);
            int count = tagList.size();
            for (int i = 0; i < count; ++i) {
                ate stack = ate.a((gy)tagList.e(i));
                if (stack.a()) continue;
                items.add((Object)stack);
            }
            return items;
        }
        return ez.a();
    }

    public static ez<ate> getStoredItems(ate stackIn, int slotCount) {
        gy tagBlockEntity;
        gy nbt = stackIn.n();
        if (nbt != null && nbt.c("BlockEntityTag", 10) && (tagBlockEntity = nbt.p("BlockEntityTag")).c("Items", 9)) {
            he tagList = tagBlockEntity.d("Items", 10);
            int count = tagList.size();
            byte maxSlot = -1;
            if (slotCount <= 0) {
                for (int i = 0; i < count; ++i) {
                    gy tag = tagList.e(i);
                    byte slot = tag.f("Slot");
                    if (slot <= maxSlot) continue;
                    maxSlot = slot;
                }
                slotCount = maxSlot + 1;
            }
            ez items = ez.a((int)slotCount, (Object)ate.a);
            for (int i = 0; i < count; ++i) {
                gy tag = tagList.e(i);
                ate stack = ate.a((gy)tag);
                byte slot = tag.f("Slot");
                if (slot < 0 || slot >= items.size() || stack.a()) continue;
                items.set((int)slot, (Object)stack);
            }
            return items;
        }
        return EMPTY_LIST;
    }

    public static Object2IntOpenHashMap<ItemType> getStoredItemCounts(ate stackShulkerBox) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        ez<ate> items = InventoryUtils.getStoredItems(stackShulkerBox);
        for (int slot = 0; slot < items.size(); ++slot) {
            ate stack = (ate)items.get(slot);
            if (stack.a()) continue;
            map.addTo((Object)new ItemType(stack), stack.C());
        }
        return map;
    }

    public static Object2IntOpenHashMap<ItemType> getInventoryItemCounts(ade inv) {
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        int slots = inv.T_();
        for (int slot = 0; slot < slots; ++slot) {
            ate stack = inv.a(slot);
            if (stack.a()) continue;
            map.addTo((Object)new ItemType(stack, false, true), stack.C());
            if (!(stack.b() instanceof arj) || !(((arj)stack.b()).d() instanceof bhi) || !InventoryUtils.shulkerBoxHasItems(stack)) continue;
            Object2IntOpenHashMap<ItemType> boxCounts = InventoryUtils.getStoredItemCounts(stack);
            for (ItemType type : boxCounts.keySet()) {
                map.addTo((Object)type, boxCounts.getInt((Object)type));
            }
        }
        return map;
    }

    public static ade getAsInventory(ez<ate> items) {
        adt inv = new adt((ij)new iq(""), items.size());
        for (int slot = 0; slot < items.size(); ++slot) {
            inv.a(slot, (ate)items.get(slot));
        }
        return inv;
    }
}

