/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

public class IntBoundingBox {
    public final int minX;
    public final int minY;
    public final int minZ;
    public final int maxX;
    public final int maxY;
    public final int maxZ;

    public IntBoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public boolean containsPos(ff pos) {
        return pos.o() >= this.minX && pos.o() <= this.maxX && pos.q() >= this.minZ && pos.q() <= this.maxZ && pos.p() >= this.minY && pos.p() <= this.maxY;
    }

    public boolean intersects(IntBoundingBox box) {
        return this.maxX >= box.minX && this.minX <= box.maxX && this.maxZ >= box.minZ && this.minZ <= box.maxZ && this.maxY >= box.minY && this.minY <= box.maxY;
    }

    public bwf toVanillaBox() {
        return new bwf(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public hc toNBTIntArray() {
        return new hc(new int[]{this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ});
    }

    public static IntBoundingBox fromVanillaBox(bwf box) {
        return IntBoundingBox.createProper(box.a, box.b, box.c, box.d, box.e, box.f);
    }

    public static IntBoundingBox createProper(int x1, int y1, int z1, int x2, int y2, int z2) {
        return new IntBoundingBox(Math.min(x1, x2), Math.min(y1, y2), Math.min(z1, z2), Math.max(x1, x2), Math.max(y1, y2), Math.max(z1, z2));
    }

    public static IntBoundingBox fromArray(int[] coords) {
        if (coords.length == 6) {
            return new IntBoundingBox(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
        }
        return new IntBoundingBox(0, 0, 0, 0, 0, 0);
    }
}

