/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

public class Color4f {
    public static final Color4f ZERO = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    public final float r;
    public final float g;
    public final float b;
    public final float a;
    public final int intValue;

    public Color4f(float r2, float g, float b2) {
        this(r2, g, b2, 1.0f);
    }

    public Color4f(float r2, float g, float b2, float a2) {
        if (r2 == -0.0f) {
            r2 = 0.0f;
        }
        if (g == -0.0f) {
            g = 0.0f;
        }
        if (b2 == -0.0f) {
            b2 = 0.0f;
        }
        if (a2 == -0.0f) {
            a2 = 0.0f;
        }
        this.r = r2;
        this.g = g;
        this.b = b2;
        this.a = a2;
        this.intValue = (int)(a2 * 255.0f) << 24 | (int)(r2 * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b2 * 255.0f);
    }

    public static Color4f fromColor(int color) {
        float alpha = (float)((color & 0xFF000000) >>> 24) / 255.0f;
        return Color4f.fromColor(color, alpha);
    }

    public static Color4f fromColor(int color, float alpha) {
        float r2 = (float)((color & 0xFF0000) >>> 16) / 255.0f;
        float g = (float)((color & 0xFF000) >>> 8) / 255.0f;
        float b2 = (float)(color & 0xFF) / 255.0f;
        return new Color4f(r2, g, b2, alpha);
    }

    public static Color4f fromColor(Color4f color, float alpha) {
        return new Color4f(color.r, color.g, color.b, alpha);
    }
}

