/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;

public class RenderUtils {
    public static final pc TEXTURE_MAP_BACKGROUND = new pc("textures/map/map_background.png");
    private static final Random RAND = new Random();

    public static void setupBlend() {
        cua.m();
        cua.a((cua.r)cua.r.l, (cua.l)cua.l.j, (cua.r)cua.r.e, (cua.l)cua.l.n);
    }

    public static void bindTexture(pc texture) {
        RenderUtils.mc().E().a(texture);
    }

    public static void color(float r2, float g, float b2, float a2) {
        cua.c((float)r2, (float)g, (float)b2, (float)a2);
    }

    public static void disableItemLighting() {
        cfr.a();
    }

    public static void enableItemLighting() {
        cfr.b();
    }

    public static void enableGuiItemLighting() {
        cfr.c();
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder) {
        RenderUtils.drawOutlinedBox(x, y, width, height, colorBg, colorBorder, 0.0f);
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, width, height, colorBg, zLevel);
        RenderUtils.drawOutline(x - 1, y - 1, width + 2, height + 2, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - 1, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y, width - 2, 1, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y + height - 1, width - 2, 1, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, borderWidth, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - borderWidth, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        RenderUtils.drawTexturedRect(x, y, u, v, width, height, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color, float zLevel) {
        float a2 = (float)(color >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(color & 0xFF) / 255.0f;
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        cua.z();
        RenderUtils.setupBlend();
        RenderUtils.color(r2, g, b2, a2);
        buffer.a(7, ddu.k);
        buffer.b((double)x, (double)y, (double)zLevel).d();
        buffer.b((double)x, (double)(y + height), (double)zLevel).d();
        buffer.b((double)(x + width), (double)(y + height), (double)zLevel).d();
        buffer.b((double)(x + width), (double)y, (double)zLevel).d();
        tessellator.b();
        cua.y();
        cua.l();
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float pixelWidth = 0.00390625f;
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        buffer.a(7, ddu.m);
        buffer.b((double)x, (double)(y + height), (double)zLevel).a((double)((float)u * pixelWidth), (double)((float)(v + height) * pixelWidth)).d();
        buffer.b((double)(x + width), (double)(y + height), (double)zLevel).a((double)((float)(u + width) * pixelWidth), (double)((float)(v + height) * pixelWidth)).d();
        buffer.b((double)(x + width), (double)y, (double)zLevel).a((double)((float)(u + width) * pixelWidth), (double)((float)v * pixelWidth)).d();
        buffer.b((double)x, (double)y, (double)zLevel).a((double)((float)u * pixelWidth), (double)((float)v * pixelWidth)).d();
        tessellator.b();
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, ctq buffer) {
        RenderUtils.drawTexturedRectBatched(x, y, u, v, width, height, 0.0f, buffer);
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, float zLevel, ctq buffer) {
        float pixelWidth = 0.00390625f;
        buffer.b((double)x, (double)(y + height), (double)zLevel).a((double)((float)u * pixelWidth), (double)((float)(v + height) * pixelWidth)).d();
        buffer.b((double)(x + width), (double)(y + height), (double)zLevel).a((double)((float)(u + width) * pixelWidth), (double)((float)(v + height) * pixelWidth)).d();
        buffer.b((double)(x + width), (double)y, (double)zLevel).a((double)((float)(u + width) * pixelWidth), (double)((float)v * pixelWidth)).d();
        buffer.b((double)x, (double)y, (double)zLevel).a((double)((float)u * pixelWidth), (double)((float)v * pixelWidth)).d();
    }

    public static void drawHoverText(int x, int y, List<String> textLines) {
        cft mc = RenderUtils.mc();
        if (!textLines.isEmpty() && GuiUtils.getCurrentScreen() != null) {
            cgk font = mc.l;
            cua.E();
            RenderUtils.disableItemLighting();
            cua.g();
            cua.j();
            int maxLineLength = 0;
            int maxWidth = GuiUtils.getCurrentScreen().m;
            ArrayList<String> linesNew = new ArrayList<String>();
            for (String lineOrig : textLines) {
                String[] lines;
                for (String line : lines = lineOrig.split("\\n")) {
                    int length = font.a(line);
                    if (length > maxLineLength) {
                        maxLineLength = length;
                    }
                    linesNew.add(line);
                }
            }
            textLines = linesNew;
            int lineHeight = font.a + 1;
            int textHeight = textLines.size() * lineHeight - 2;
            int textStartX = x + 4;
            int textStartY = Math.max(8, y - textHeight - 6);
            if (textStartX + maxLineLength + 6 > maxWidth) {
                textStartX = Math.max(2, maxWidth - maxLineLength - 8);
            }
            double zLevel = 300.0;
            int borderColor = -267386864;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 4, textStartX + maxLineLength + 3, textStartY - 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 3, textStartX + maxLineLength + 3, textStartY + textHeight + 4, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 4, textStartY - 3, textStartX - 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 3, textStartY - 3, textStartX + maxLineLength + 4, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            int fillColor1 = 0x505000FF;
            int fillColor2 = 1344798847;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3 + 1, textStartX - 3 + 1, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 2, textStartY - 3 + 1, textStartX + maxLineLength + 3, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY - 3 + 1, zLevel, fillColor1, fillColor1);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 2, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, fillColor2, fillColor2);
            for (int i = 0; i < textLines.size(); ++i) {
                String str = textLines.get(i);
                font.a(str, (float)textStartX, (float)textStartY, -1);
                textStartY += lineHeight;
            }
            cua.f();
            cua.k();
            cfr.b();
            cua.D();
        }
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, double zLevel, int startColor, int endColor) {
        float sa = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float sr = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float sg = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float sb = (float)(startColor & 0xFF) / 255.0f;
        float ea = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float er = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float eg = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float eb = (float)(endColor & 0xFF) / 255.0f;
        cua.z();
        cua.d();
        RenderUtils.setupBlend();
        cua.j((int)7425);
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        buffer.a(7, ddu.l);
        buffer.b((double)right, (double)top, zLevel).a(sr, sg, sb, sa).d();
        buffer.b((double)left, (double)top, zLevel).a(sr, sg, sb, sa).d();
        buffer.b((double)left, (double)bottom, zLevel).a(er, eg, eb, ea).d();
        buffer.b((double)right, (double)bottom, zLevel).a(er, eg, eb, ea).d();
        tessellator.b();
        cua.j((int)7424);
        cua.l();
        cua.e();
        cua.y();
    }

    public static void drawCenteredString(int x, int y, int color, String text) {
        cgk textRenderer = RenderUtils.mc().l;
        textRenderer.a(text, (float)(x - textRenderer.a(text) / 2), (float)y, color);
    }

    public static void drawHorizontalLine(int x, int y, int width, int color) {
        RenderUtils.drawRect(x, y, width, 1, color);
    }

    public static void drawVerticalLine(int x, int y, int height, int color) {
        RenderUtils.drawRect(x, y, 1, height, color);
    }

    public static void renderSprite(int x, int y, int width, int height, String texture) {
        if (texture != null) {
            cua.g();
            ddm sprite = RenderUtils.mc().K().a(texture);
            RenderUtils.mc().q.a(x, y, sprite, width, height);
        }
    }

    public static void renderText(int x, int y, int color, String text) {
        String[] parts = text.split("\\\\n");
        cgk textRenderer = RenderUtils.mc().l;
        for (String line : parts) {
            textRenderer.a(line, (float)x, (float)y, color);
            y += textRenderer.a + 1;
        }
    }

    public static void renderText(int x, int y, int color, List<String> lines) {
        if (!lines.isEmpty()) {
            cgk textRenderer = RenderUtils.mc().l;
            for (String line : lines) {
                textRenderer.b(line, (float)x, (float)y, color);
                y += textRenderer.a + 2;
            }
        }
    }

    public static int renderText(int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, List<String> lines) {
        cgk fontRenderer = RenderUtils.mc().l;
        int scaledWidth = GuiUtils.getScaledWindowWidth();
        int lineHeight = fontRenderer.a + 2;
        int contentHeight = lines.size() * lineHeight - 2;
        int bgMargin = 2;
        if (scale == 0.0) {
            return 0;
        }
        if (scale != 1.0) {
            if (scale != 0.0) {
                xOff = (int)((double)xOff * scale);
                yOff = (int)((double)yOff * scale);
            }
            cua.G();
            cua.a((double)scale, (double)scale, (double)0.0);
        }
        double posX = xOff + bgMargin;
        double posY = yOff + bgMargin;
        posY = RenderUtils.getHudPosY((int)posY, yOff, contentHeight, scale, alignment);
        posY += (double)RenderUtils.getHudOffsetForPotions(alignment, scale, (aog)RenderUtils.mc().i);
        for (String line : lines) {
            int width = fontRenderer.a(line);
            switch (alignment) {
                case TOP_RIGHT: 
                case BOTTOM_RIGHT: {
                    posX = (double)scaledWidth / scale - (double)width - (double)xOff - (double)bgMargin;
                    break;
                }
                case CENTER: {
                    posX = (double)scaledWidth / scale / 2.0 - (double)(width / 2) - (double)xOff;
                    break;
                }
            }
            int x = (int)posX;
            int y = (int)posY;
            posY += (double)lineHeight;
            if (useBackground) {
                RenderUtils.drawRect(x - bgMargin, y - bgMargin, width + bgMargin, bgMargin + fontRenderer.a, bgColor);
            }
            if (useShadow) {
                fontRenderer.a(line, (float)x, (float)y, textColor);
                continue;
            }
            fontRenderer.b(line, (float)x, (float)y, textColor);
        }
        if (scale != 1.0) {
            cua.H();
        }
        return contentHeight + bgMargin * 2;
    }

    public static int getHudOffsetForPotions(HudAlignment alignment, double scale, aog player) {
        if (alignment == HudAlignment.TOP_RIGHT) {
            if (scale == 0.0) {
                return 0;
            }
            Collection effects = player.cn();
            if (!effects.isEmpty()) {
                int y1 = 0;
                int y2 = 0;
                for (aek effect : effects) {
                    aej potion = effect.a();
                    if (!effect.e() || !potion.e()) continue;
                    if (potion.k()) {
                        y1 = 26;
                        continue;
                    }
                    y2 = 52;
                    break;
                }
                return (int)((double)Math.max(y1, y2) / scale);
            }
        }
        return 0;
    }

    public static int getHudPosY(int yOrig, int yOffset, int contentHeight, double scale, HudAlignment alignment) {
        int scaledHeight = GuiUtils.getScaledWindowHeight();
        int posY = yOrig;
        switch (alignment) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                posY = (int)((double)scaledHeight / scale - (double)contentHeight - (double)yOffset);
                break;
            }
            case CENTER: {
                posY = (int)((double)scaledHeight / scale / 2.0 - (double)contentHeight / 2.0 + (double)yOffset);
                break;
            }
        }
        return posY;
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(el pos, Color4f color, double expand, ctq buffer) {
        double minX = (double)pos.o() - expand;
        double minY = (double)pos.p() - expand;
        double minZ = (double)pos.q() - expand;
        double maxX = (double)pos.o() + expand + 1.0;
        double maxY = (double)pos.p() + expand + 1.0;
        double maxZ = (double)pos.q() + expand + 1.0;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(el pos, Color4f color, double expand, ctq buffer) {
        double minX = (double)pos.o() - expand;
        double minY = (double)pos.p() - expand;
        double minZ = (double)pos.q() - expand;
        double maxX = (double)pos.o() + expand + 1.0;
        double maxY = (double)pos.p() + expand + 1.0;
        double maxZ = (double)pos.q() + expand + 1.0;
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBoxAllSidesBatchedQuads(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, ctq buffer) {
        RenderUtils.drawBoxHorizontalSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxTopBatchedQuads(minX, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxBottomBatchedQuads(minX, minY, minZ, maxX, maxZ, color, buffer);
    }

    public static void drawBoxWithEdgesBatched(el posMin, el posMax, Color4f colorLines, Color4f colorSides, ctq bufferQuads, ctq bufferLines) {
        double x1 = posMin.o();
        double y1 = posMin.p();
        double z1 = posMin.q();
        double x2 = posMax.o() + 1;
        double y2 = posMax.p() + 1;
        double z2 = posMax.q() + 1;
        RenderUtils.drawBoxAllSidesBatchedQuads(x1, y1, z1, x2, y2, z2, colorSides, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(x1, y1, z1, x2, y2, z2, colorLines, bufferLines);
    }

    public static void drawBoxHorizontalSidesBatchedQuads(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, ctq buffer) {
        buffer.b(minX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
    }

    public static void drawBoxTopBatchedQuads(double minX, double minZ, double maxX, double maxY, double maxZ, Color4f color, ctq buffer) {
        buffer.b(minX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
    }

    public static void drawBoxBottomBatchedQuads(double minX, double minY, double minZ, double maxX, double maxZ, Color4f color, ctq buffer) {
        buffer.b(maxX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
    }

    public static void drawBoxAllEdgesBatchedLines(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, ctq buffer) {
        buffer.b(minX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
    }

    public static void drawBox(IntBoundingBox bb, Color4f color, ctq bufferQuads, ctq bufferLines) {
        double minX = bb.minX;
        double minY = bb.minY;
        double minZ = bb.minZ;
        double maxX = bb.maxX + 1;
        double maxY = bb.maxY + 1;
        double maxZ = bb.maxZ + 1;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, bufferLines);
    }

    public static void drawBox(bwf bb, Color4f color, ctq bufferQuads, ctq bufferLines) {
        double minX = bb.a;
        double minY = bb.b;
        double minZ = bb.c;
        double maxX = bb.d + 1;
        double maxY = bb.e + 1;
        double maxZ = bb.f + 1;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, bufferLines);
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float scale) {
        aer entity = RenderUtils.mc().S();
        if (entity != null) {
            RenderUtils.drawTextPlate(text, x, y, z, entity.w, entity.x, scale, -1, 0x40000000, true);
        }
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float yaw, float pitch, float scale, int textColor, int bgColor, boolean disableDepth) {
        cgk textRenderer = RenderUtils.mc().l;
        cua.a((int)516, (float)0.1f);
        cua.G();
        cua.b((double)x, (double)y, (double)z);
        cua.a((float)0.0f, (float)1.0f, (float)0.0f);
        cua.b((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        cua.b((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        cua.b((float)(-scale), (float)(-scale), (float)scale);
        cua.g();
        cua.r();
        if (disableDepth) {
            cua.a((boolean)false);
            cua.j();
        }
        RenderUtils.setupBlend();
        cua.z();
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        int maxLineLen = 0;
        for (String line : text) {
            maxLineLen = Math.max(maxLineLen, textRenderer.a(line));
        }
        int strLenHalf = maxLineLen / 2;
        int textHeight = textRenderer.a * text.size() - 1;
        float bga = (float)(bgColor >>> 24 & 0xFF) * 255.0f;
        float bgr = (float)(bgColor >>> 16 & 0xFF) * 255.0f;
        float bgg = (float)(bgColor >>> 8 & 0xFF) * 255.0f;
        float bgb = (float)(bgColor & 0xFF) * 255.0f;
        buffer.a(7, ddu.l);
        buffer.b((double)(-strLenHalf - 1), -1.0, 0.0).a(bgr, bgg, bgb, bga).d();
        buffer.b((double)(-strLenHalf - 1), (double)textHeight, 0.0).a(bgr, bgg, bgb, bga).d();
        buffer.b((double)strLenHalf, (double)textHeight, 0.0).a(bgr, bgg, bgb, bga).d();
        buffer.b((double)strLenHalf, -1.0, 0.0).a(bgr, bgg, bgb, bga).d();
        tessellator.b();
        cua.y();
        int textY = 0;
        if (!disableDepth) {
            cua.s();
            cua.a((float)-0.6f, (float)-1.2f);
        }
        for (String line : text) {
            if (disableDepth) {
                cua.a((boolean)false);
                cua.j();
            }
            textRenderer.b(line, (float)(-strLenHalf), (float)textY, 0x20000000 | textColor & 0xFFFFFF);
            cua.k();
            cua.a((boolean)true);
            textRenderer.b(line, (float)(-strLenHalf), (float)textY, textColor);
            textY += textRenderer.a;
        }
        if (!disableDepth) {
            cua.a((float)0.0f, (float)0.0f);
            cua.t();
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        cua.q();
        cua.l();
        cua.H();
    }

    public static void renderBlockTargetingOverlay(aer entity, el pos, eq side, cee hitVec, Color4f color, float partialTicks) {
        eq playerFacing = entity.bA();
        PositionUtils.HitPart part = PositionUtils.getHitPart(side, playerFacing, pos, hitVec);
        double dx = entity.N + (entity.q - entity.N) * (double)partialTicks;
        double dy = entity.O + (entity.r - entity.O) * (double)partialTicks;
        double dz = entity.P + (entity.s - entity.P) * (double)partialTicks;
        double x = (double)pos.o() + 0.5 - dx;
        double y = (double)pos.p() + 0.5 - dy;
        double z = (double)pos.q() + 0.5 - dz;
        cua.G();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing);
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        float quadAlpha = 0.18f;
        float ha = color.a;
        float hr = color.r;
        float hg = color.g;
        float hb = color.b;
        buffer.a(7, ddu.l);
        buffer.b(x - 0.5, y - 0.5, z).a(1.0f, 1.0f, 1.0f, quadAlpha).d();
        buffer.b(x + 0.5, y - 0.5, z).a(1.0f, 1.0f, 1.0f, quadAlpha).d();
        buffer.b(x + 0.5, y + 0.5, z).a(1.0f, 1.0f, 1.0f, quadAlpha).d();
        buffer.b(x - 0.5, y + 0.5, z).a(1.0f, 1.0f, 1.0f, quadAlpha).d();
        switch (part) {
            case CENTER: {
                buffer.b(x - 0.25, y - 0.25, z).a(hr, hg, hb, ha).d();
                buffer.b(x + 0.25, y - 0.25, z).a(hr, hg, hb, ha).d();
                buffer.b(x + 0.25, y + 0.25, z).a(hr, hg, hb, ha).d();
                buffer.b(x - 0.25, y + 0.25, z).a(hr, hg, hb, ha).d();
                break;
            }
            case LEFT: {
                buffer.b(x - 0.5, y - 0.5, z).a(hr, hg, hb, ha).d();
                buffer.b(x - 0.25, y - 0.25, z).a(hr, hg, hb, ha).d();
                buffer.b(x - 0.25, y + 0.25, z).a(hr, hg, hb, ha).d();
                buffer.b(x - 0.5, y + 0.5, z).a(hr, hg, hb, ha).d();
                break;
            }
            case RIGHT: {
                buffer.b(x + 0.5, y - 0.5, z).a(hr, hg, hb, ha).d();
                buffer.b(x + 0.25, y - 0.25, z).a(hr, hg, hb, ha).d();
                buffer.b(x + 0.25, y + 0.25, z).a(hr, hg, hb, ha).d();
                buffer.b(x + 0.5, y + 0.5, z).a(hr, hg, hb, ha).d();
                break;
            }
            case TOP: {
                buffer.b(x - 0.5, y + 0.5, z).a(hr, hg, hb, ha).d();
                buffer.b(x - 0.25, y + 0.25, z).a(hr, hg, hb, ha).d();
                buffer.b(x + 0.25, y + 0.25, z).a(hr, hg, hb, ha).d();
                buffer.b(x + 0.5, y + 0.5, z).a(hr, hg, hb, ha).d();
                break;
            }
            case BOTTOM: {
                buffer.b(x - 0.5, y - 0.5, z).a(hr, hg, hb, ha).d();
                buffer.b(x - 0.25, y - 0.25, z).a(hr, hg, hb, ha).d();
                buffer.b(x + 0.25, y - 0.25, z).a(hr, hg, hb, ha).d();
                buffer.b(x + 0.5, y - 0.5, z).a(hr, hg, hb, ha).d();
                break;
            }
        }
        tessellator.b();
        cua.d((float)1.6f);
        buffer.a(2, ddu.l);
        buffer.b(x - 0.25, y - 0.25, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        buffer.b(x + 0.25, y - 0.25, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        buffer.b(x + 0.25, y + 0.25, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        buffer.b(x - 0.25, y + 0.25, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        tessellator.b();
        buffer.a(1, ddu.l);
        buffer.b(x - 0.5, y - 0.5, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        buffer.b(x - 0.25, y - 0.25, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        buffer.b(x - 0.5, y + 0.5, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        buffer.b(x - 0.25, y + 0.25, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        buffer.b(x + 0.5, y - 0.5, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        buffer.b(x + 0.25, y - 0.25, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        buffer.b(x + 0.5, y + 0.5, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        buffer.b(x + 0.25, y + 0.25, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        tessellator.b();
        cua.H();
    }

    public static void renderBlockTargetingOverlaySimple(aer entity, el pos, eq side, Color4f color, float partialTicks) {
        eq playerFacing = entity.bA();
        double dx = entity.N + (entity.q - entity.N) * (double)partialTicks;
        double dy = entity.O + (entity.r - entity.O) * (double)partialTicks;
        double dz = entity.P + (entity.s - entity.P) * (double)partialTicks;
        double x = (double)pos.o() + 0.5 - dx;
        double y = (double)pos.p() + 0.5 - dy;
        double z = (double)pos.q() + 0.5 - dz;
        cua.G();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing);
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        float a2 = color.a;
        float r2 = color.r;
        float g = color.g;
        float b2 = color.b;
        buffer.a(7, ddu.l);
        buffer.b(x - 0.5, y - 0.5, z).a(r2, g, b2, a2).d();
        buffer.b(x + 0.5, y - 0.5, z).a(r2, g, b2, a2).d();
        buffer.b(x + 0.5, y + 0.5, z).a(r2, g, b2, a2).d();
        buffer.b(x - 0.5, y + 0.5, z).a(r2, g, b2, a2).d();
        tessellator.b();
        cua.d((float)1.6f);
        buffer.a(2, ddu.l);
        buffer.b(x - 0.375, y - 0.375, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        buffer.b(x + 0.375, y - 0.375, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        buffer.b(x + 0.375, y + 0.375, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        buffer.b(x - 0.375, y + 0.375, z).a(1.0f, 1.0f, 1.0f, 1.0f).d();
        tessellator.b();
        cua.H();
    }

    private static void blockTargetingOverlayTranslations(double x, double y, double z, eq side, eq playerFacing) {
        cua.b((double)x, (double)y, (double)z);
        switch (side) {
            case a: {
                cua.b((float)(180.0f - playerFacing.l()), (float)0.0f, (float)1.0f, (float)0.0f);
                cua.b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case b: {
                cua.b((float)(180.0f - playerFacing.l()), (float)0.0f, (float)1.0f, (float)0.0f);
                cua.b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case c: {
                cua.b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case d: {
                cua.b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case e: {
                cua.b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case f: {
                cua.b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        cua.b((double)(-x), (double)(-y), (double)(-z + 0.501));
    }

    public static void renderMapPreview(ate stack, int x, int y, int dimensions) {
        if (stack.b() instanceof atj && GuiBase.isShiftDown()) {
            cua.G();
            cua.g();
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            int y1 = y - dimensions - 20;
            int y2 = y1 + dimensions;
            int x1 = x + 8;
            int x2 = x1 + dimensions;
            int z = 300;
            RenderUtils.bindTexture(TEXTURE_MAP_BACKGROUND);
            cum tessellator = cum.a();
            ctq buffer = tessellator.c();
            buffer.a(7, ddu.m);
            buffer.b((double)x1, (double)y2, (double)z).a(0.0, 1.0).d();
            buffer.b((double)x2, (double)y2, (double)z).a(1.0, 1.0).d();
            buffer.b((double)x2, (double)y1, (double)z).a(1.0, 0.0).d();
            buffer.b((double)x1, (double)y1, (double)z).a(0.0, 0.0).d();
            tessellator.b();
            cbs mapdata = atj.a((ate)stack, (axy)RenderUtils.mc().g);
            if (mapdata != null) {
                z = 310;
                double scale = (double)(dimensions - 16) / 128.0;
                cua.c((float)(x1 += 8), (float)(y1 += 8), (float)z);
                cua.a((double)scale, (double)scale, (double)0.0);
                RenderUtils.mc().n.k().a(mapdata, false);
            }
            cua.f();
            cua.H();
        }
    }

    public static void renderShulkerBoxPreview(ate stack, int x, int y, boolean useBgColors) {
        if (stack.m()) {
            ez<ate> items = InventoryUtils.getStoredItems(stack, -1);
            if (items.size() == 0) {
                return;
            }
            cua.G();
            RenderUtils.disableItemLighting();
            cua.c((float)0.0f, (float)0.0f, (float)700.0f);
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            x += 8;
            y -= props.height + 18;
            if (stack.b() instanceof arj && ((arj)stack.b()).d() instanceof bhi) {
                RenderUtils.setShulkerboxBackgroundTintColor((bhi)((arj)stack.b()).d(), useBgColors);
            } else {
                RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            }
            InventoryOverlay.renderInventoryBackground(type, x, y, props.slotsPerRow, items.size(), RenderUtils.mc());
            RenderUtils.enableGuiItemLighting();
            cua.k();
            cua.D();
            ade inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc());
            cua.j();
            cua.H();
        }
    }

    public static void setShulkerboxBackgroundTintColor(@Nullable bhi block, boolean useBgColors) {
        if (block != null && useBgColors) {
            asc dye = block.d() != null ? block.d() : asc.k;
            float[] colors = dye.d();
            RenderUtils.color(colors[0], colors[1], colors[2], 1.0f);
        } else {
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static void renderModelInGui(int x, int y, dez model, blc state, float zLevel) {
        if (state.c() == bct.a) {
            return;
        }
        cua.G();
        RenderUtils.bindTexture(ddl.f);
        RenderUtils.mc().E().b(ddl.f).b(false, false);
        cua.D();
        cua.e();
        cua.a((int)516, (float)0.1f);
        cua.m();
        cua.a((cua.r)cua.r.l, (cua.l)cua.l.j);
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderUtils.setupGuiTransform(x, y, model.b(), zLevel);
        cua.b((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        cua.b((float)225.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        cua.b((float)0.625f, (float)0.625f, (float)0.625f);
        RenderUtils.renderModel(model, state);
        cua.d();
        cua.E();
        cua.g();
        cua.H();
    }

    public static void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d, float zLevel) {
        cua.c((float)xPosition, (float)yPosition, (float)(100.0f + zLevel));
        cua.c((float)8.0f, (float)8.0f, (float)0.0f);
        cua.b((float)1.0f, (float)-1.0f, (float)1.0f);
        cua.b((float)16.0f, (float)16.0f, (float)16.0f);
        if (isGui3d) {
            cua.f();
        } else {
            cua.g();
        }
    }

    private static void renderModel(dez model, blc state) {
        cua.G();
        cua.c((float)-0.5f, (float)-0.5f, (float)-0.5f);
        int color = -1;
        if (!model.c()) {
            cum tessellator = cum.a();
            ctq bufferbuilder = tessellator.c();
            bufferbuilder.a(7, ddu.h);
            for (eq enumfacing : eq.values()) {
                RAND.setSeed(0L);
                RenderUtils.renderQuads(bufferbuilder, model.a(state, enumfacing, RAND), state, color);
            }
            RAND.setSeed(0L);
            RenderUtils.renderQuads(bufferbuilder, model.a(state, null, RAND), state, color);
            tessellator.b();
        }
        cua.H();
    }

    private static void renderQuads(ctq renderer, List<cux> quads, blc state, int color) {
        int quadCount = quads.size();
        for (int i = 0; i < quadCount; ++i) {
            cux quad = quads.get(i);
            RenderUtils.renderQuad(renderer, quad, state, -1);
        }
    }

    private static void renderQuad(ctq buffer, cux quad, blc state, int color) {
        buffer.a(quad.b());
        buffer.a(color);
        if (quad.c()) {
            cgf blockColors = RenderUtils.mc().ad();
            int m = blockColors.a(state, null, null, quad.d());
            float r2 = (float)(m >>> 16 & 0xFF) / 255.0f;
            float g = (float)(m >>> 8 & 0xFF) / 255.0f;
            float b2 = (float)(m & 0xFF) / 255.0f;
            buffer.a(r2, g, b2, 4);
            buffer.a(r2, g, b2, 3);
            buffer.a(r2, g, b2, 2);
            buffer.a(r2, g, b2, 1);
        }
        RenderUtils.putQuadNormal(buffer, quad);
    }

    private static void putQuadNormal(ctq renderer, cux quad) {
        ff direction = quad.e().n();
        renderer.b((float)direction.o(), (float)direction.p(), (float)direction.q());
    }

    private static cft mc() {
        return cft.s();
    }
}

