/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import fi.dy.masa.malilib.render.RenderUtils;
import java.util.ArrayList;
import java.util.List;

public class InventoryOverlay {
    public static final pc TEXTURE_BREWING_STAND = new pc("textures/gui/container/brewing_stand.png");
    public static final pc TEXTURE_DISPENSER = new pc("textures/gui/container/dispenser.png");
    public static final pc TEXTURE_DOUBLE_CHEST = new pc("textures/gui/container/generic_54.png");
    public static final pc TEXTURE_FURNACE = new pc("textures/gui/container/furnace.png");
    public static final pc TEXTURE_HOPPER = new pc("textures/gui/container/hopper.png");
    public static final pc TEXTURE_PLAYER_INV = new pc("textures/gui/container/hopper.png");
    public static final pc TEXTURE_SINGLE_CHEST = new pc("textures/gui/container/shulker_box.png");
    public static final InventoryProperties INV_PROPS_TEMP = new InventoryProperties();
    private static final String[] EMPTY_SLOT_TEXTURES = new String[]{"item/empty_armor_slot_boots", "item/empty_armor_slot_leggings", "item/empty_armor_slot_chestplate", "item/empty_armor_slot_helmet"};
    private static final aew[] VALID_EQUIPMENT_SLOTS = new aew[]{aew.f, aew.e, aew.d, aew.c};

    public static void renderInventoryBackground(InventoryRenderType type, int x, int y, int slotsPerRow, int totalSlots, cft mc) {
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        buffer.a(7, ddu.m);
        if (type == InventoryRenderType.FURNACE) {
            RenderUtils.bindTexture(TEXTURE_FURNACE);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 4, 64, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y, 84, 0, 92, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 64, 0, 162, 92, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x + 92, y + 4, 172, 102, 4, 64, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y + 4, 52, 13, 88, 60, buffer);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            RenderUtils.bindTexture(TEXTURE_BREWING_STAND);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 4, 68, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y, 63, 0, 113, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 68, 0, 162, 113, 4, buffer);
            RenderUtils.drawTexturedRectBatched(x + 113, y + 4, 172, 98, 4, 68, buffer);
            RenderUtils.drawTexturedRectBatched(x + 4, y + 4, 13, 13, 109, 64, buffer);
        } else if (type == InventoryRenderType.DISPENSER) {
            RenderUtils.bindTexture(TEXTURE_DISPENSER);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 115, 0, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 61, 0, 159, 61, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 61, y + 7, 169, 105, 7, 61, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 61, 16, 54, 54, buffer);
        } else if (type == InventoryRenderType.HOPPER) {
            RenderUtils.bindTexture(TEXTURE_HOPPER);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 25, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 79, 0, 97, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 25, 0, 126, 97, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 97, y + 7, 169, 108, 7, 25, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 43, 19, 90, 18, buffer);
        } else if (type == InventoryRenderType.VILLAGER) {
            RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 79, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 133, 0, 43, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + 79, 0, 215, 43, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + 43, y + 7, 169, 143, 7, 79, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 36, 72, buffer);
        } else if (type == InventoryRenderType.FIXED_27) {
            InventoryOverlay.renderInventoryBackground27(x, y, buffer, mc);
        } else if (type == InventoryRenderType.FIXED_54) {
            InventoryOverlay.renderInventoryBackground54(x, y, buffer, mc);
        } else {
            RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
            int rows = (int)Math.ceil((double)totalSlots / (double)slotsPerRow);
            int bgw = Math.min(totalSlots, slotsPerRow) * 18 + 7;
            int bgh = rows * 18 + 7;
            RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, bgh, buffer);
            RenderUtils.drawTexturedRectBatched(x + 7, y, 176 - bgw, 0, bgw, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x, y + bgh, 0, 215, bgw, 7, buffer);
            RenderUtils.drawTexturedRectBatched(x + bgw, y + 7, 169, 222 - bgh, 7, bgh, buffer);
            for (int row = 0; row < rows; ++row) {
                int rowLen = xq.a((int)(totalSlots - row * slotsPerRow), (int)1, (int)slotsPerRow);
                RenderUtils.drawTexturedRectBatched(x + 7, y + row * 18 + 7, 7, 17, rowLen * 18, 18, buffer);
                if (rows <= 1 || rowLen >= slotsPerRow) continue;
                RenderUtils.drawTexturedRectBatched(x + rowLen * 18 + 7, y + row * 18 + 7, 7, 3, (slotsPerRow - rowLen) * 18, 9, buffer);
                RenderUtils.drawTexturedRectBatched(x + rowLen * 18 + 7, y + row * 18 + 16, 7, 3, (slotsPerRow - rowLen) * 18, 9, buffer);
            }
        }
        tessellator.b();
    }

    public static void renderInventoryBackground27(int x, int y, ctq buffer, cft mc) {
        RenderUtils.bindTexture(TEXTURE_SINGLE_CHEST);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 61, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y, 7, 0, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 61, 0, 159, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x + 169, y + 7, 169, 105, 7, 61, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 162, 54, buffer);
    }

    public static void renderInventoryBackground54(int x, int y, ctq buffer, cft mc) {
        RenderUtils.bindTexture(TEXTURE_DOUBLE_CHEST);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 7, 115, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y, 7, 0, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 115, 0, 215, 169, 7, buffer);
        RenderUtils.drawTexturedRectBatched(x + 169, y + 7, 169, 107, 7, 115, buffer);
        RenderUtils.drawTexturedRectBatched(x + 7, y + 7, 7, 17, 162, 108, buffer);
    }

    public static void renderEquipmentOverlayBackground(int x, int y, afa entity) {
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        buffer.a(7, ddu.m);
        RenderUtils.bindTexture(TEXTURE_DISPENSER);
        RenderUtils.drawTexturedRectBatched(x, y, 0, 0, 50, 83, buffer);
        RenderUtils.drawTexturedRectBatched(x + 50, y, 173, 0, 3, 83, buffer);
        RenderUtils.drawTexturedRectBatched(x, y + 83, 0, 163, 50, 3, buffer);
        RenderUtils.drawTexturedRectBatched(x + 50, y + 83, 173, 163, 3, 3, buffer);
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            RenderUtils.drawTexturedRectBatched(x + xOff, y + yOff, 61, 16, 18, 18, buffer);
            ++i;
            yOff += 18;
        }
        RenderUtils.drawTexturedRectBatched(x + 28, y + 36 + 7, 61, 16, 18, 18, buffer);
        RenderUtils.drawTexturedRectBatched(x + 28, y + 54 + 7, 61, 16, 18, 18, buffer);
        tessellator.b();
        RenderUtils.bindTexture(ddl.f);
        if (entity.b(aew.b).a()) {
            String texture = "minecraft:item/empty_armor_slot_shield";
            RenderUtils.renderSprite(x + 28 + 1, y + 54 + 7 + 1, 16, 16, texture);
        }
        i = 0;
        xOff = 7;
        yOff = 7;
        while (i < 4) {
            aew eqSlot = VALID_EQUIPMENT_SLOTS[i];
            if (entity.b(eqSlot).a()) {
                String texture = EMPTY_SLOT_TEXTURES[eqSlot.b()];
                RenderUtils.renderSprite(x + xOff + 1, y + yOff + 1, 16, 16, texture);
            }
            ++i;
            yOff += 18;
        }
    }

    public static InventoryRenderType getInventoryType(ade inv) {
        if (inv instanceof bkb) {
            return InventoryRenderType.FIXED_27;
        }
        if (inv instanceof add) {
            return InventoryRenderType.FIXED_54;
        }
        if (inv instanceof bju) {
            return InventoryRenderType.FURNACE;
        }
        if (inv instanceof bjk) {
            return InventoryRenderType.BREWING_STAND;
        }
        if (inv instanceof bjq) {
            return InventoryRenderType.DISPENSER;
        }
        if (inv instanceof bjw) {
            return InventoryRenderType.HOPPER;
        }
        if (inv instanceof aqk) {
            return InventoryRenderType.HORSE;
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryRenderType getInventoryType(ate stack) {
        ata item = stack.b();
        if (item instanceof arj) {
            bcs block = ((arj)item).d();
            if (block instanceof bhi || block instanceof bdh) {
                return InventoryRenderType.FIXED_27;
            }
            if (block instanceof bex) {
                return InventoryRenderType.FURNACE;
            }
            if (block instanceof bec) {
                return InventoryRenderType.DISPENSER;
            }
            if (block instanceof bfh) {
                return InventoryRenderType.HOPPER;
            }
            if (block instanceof bcx) {
                return InventoryRenderType.BREWING_STAND;
            }
        }
        return InventoryRenderType.GENERIC;
    }

    public static InventoryProperties getInventoryPropsTemp(InventoryRenderType type, int totalSlots) {
        InventoryOverlay.INV_PROPS_TEMP.totalSlots = totalSlots;
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 96;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 127;
            InventoryOverlay.INV_PROPS_TEMP.height = 72;
        } else if (type == InventoryRenderType.DISPENSER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HORSE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = Math.max(1, totalSlots / 3);
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = totalSlots * 18 / 3 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryRenderType.HOPPER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 5;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 105;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryRenderType.VILLAGER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 2;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 50;
            InventoryOverlay.INV_PROPS_TEMP.height = 86;
        } else {
            if (type == InventoryRenderType.FIXED_27) {
                totalSlots = 27;
            } else if (type == InventoryRenderType.FIXED_54) {
                totalSlots = 54;
            }
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
        }
        return INV_PROPS_TEMP;
    }

    public static void renderInventoryStacks(InventoryRenderType type, ade inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, cft mc) {
        if (type == InventoryRenderType.FURNACE) {
            InventoryOverlay.renderStackAt(inv.a(0), startX + 8, startY + 8, 1.0f, mc);
            InventoryOverlay.renderStackAt(inv.a(1), startX + 8, startY + 44, 1.0f, mc);
            InventoryOverlay.renderStackAt(inv.a(2), startX + 68, startY + 26, 1.0f, mc);
        } else if (type == InventoryRenderType.BREWING_STAND) {
            InventoryOverlay.renderStackAt(inv.a(0), startX + 47, startY + 42, 1.0f, mc);
            InventoryOverlay.renderStackAt(inv.a(1), startX + 70, startY + 49, 1.0f, mc);
            InventoryOverlay.renderStackAt(inv.a(2), startX + 93, startY + 42, 1.0f, mc);
            InventoryOverlay.renderStackAt(inv.a(3), startX + 70, startY + 8, 1.0f, mc);
            InventoryOverlay.renderStackAt(inv.a(4), startX + 8, startY + 8, 1.0f, mc);
        } else {
            int slots = inv.T_();
            int x = startX;
            int y = startY;
            if (maxSlots < 0) {
                maxSlots = slots;
            }
            int slot = startSlot;
            int i = 0;
            while (slot < slots && i < maxSlots) {
                for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                    ate stack = inv.a(slot);
                    if (!stack.a()) {
                        InventoryOverlay.renderStackAt(stack, x, y, 1.0f, mc);
                    }
                    x += 18;
                }
                x = startX;
                y += 18;
            }
        }
    }

    public static void renderEquipmentStacks(afa entity, int x, int y, cft mc) {
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            aew eqSlot = VALID_EQUIPMENT_SLOTS[i];
            ate stack = entity.b(eqSlot);
            if (!stack.a()) {
                InventoryOverlay.renderStackAt(stack, x + xOff + 1, y + yOff + 1, 1.0f, mc);
            }
            ++i;
            yOff += 18;
        }
        ate stack = entity.b(aew.a);
        if (!stack.a()) {
            InventoryOverlay.renderStackAt(stack, x + 28, y + 36 + 7 + 1, 1.0f, mc);
        }
        if (!(stack = entity.b(aew.b)).a()) {
            InventoryOverlay.renderStackAt(stack, x + 28, y + 54 + 7 + 1, 1.0f, mc);
        }
    }

    public static void renderItemStacks(ez<ate> items, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, cft mc) {
        int slots = items.size();
        int x = startX;
        int y = startY;
        if (maxSlots < 0) {
            maxSlots = slots;
        }
        int slot = startSlot;
        int i = 0;
        while (slot < slots && i < maxSlots) {
            for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                ate stack = (ate)items.get(slot);
                if (!stack.a()) {
                    InventoryOverlay.renderStackAt(stack, x, y, 1.0f, mc);
                }
                x += 18;
            }
            x = startX;
            y += 18;
        }
    }

    public static void renderStackAt(ate stack, float x, float y, float scale, cft mc) {
        cua.G();
        cua.c((float)x, (float)y, (float)0.0f);
        cua.b((float)scale, (float)scale, (float)1.0f);
        cua.g();
        RenderUtils.enableGuiItemLighting();
        mc.V().b += 100.0f;
        mc.V().a((afa)mc.i, stack, 0, 0);
        mc.V().a(mc.l, stack, 0, 0, null);
        mc.V().b -= 100.0f;
        RenderUtils.disableItemLighting();
        cua.H();
    }

    public static void renderStackToolTip(int x, int y, ate stack, cft mc) {
        List list = stack.a((aog)mc.i, (aum)(mc.t.z ? aum.a.b : aum.a.a));
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                lines.add(stack.u().e + ((ij)list.get(i)).getString());
                continue;
            }
            lines.add(a.h + ((ij)list.get(i)).getString());
        }
        RenderUtils.drawHoverText(x, y, lines);
    }

    public static enum InventoryRenderType {
        BREWING_STAND,
        DISPENSER,
        FURNACE,
        HOPPER,
        HORSE,
        FIXED_27,
        FIXED_54,
        VILLAGER,
        GENERIC;

    }

    public static class InventoryProperties {
        public int totalSlots = 1;
        public int width = 176;
        public int height = 83;
        public int slotsPerRow = 9;
        public int slotOffsetX = 8;
        public int slotOffsetY = 8;
    }
}

