/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui;

import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.IMessageConsumer;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetLabel;
import fi.dy.masa.malilib.gui.wrappers.TextFieldWrapper;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.render.MessageRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.InputUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public abstract class GuiBase
extends ckd
implements IMessageConsumer,
IStringConsumer {
    public static final String TXT_AQUA = a.l.toString();
    public static final String TXT_BLACK = a.a.toString();
    public static final String TXT_BLUE = a.j.toString();
    public static final String TXT_GOLD = a.g.toString();
    public static final String TXT_GRAY = a.h.toString();
    public static final String TXT_GREEN = a.k.toString();
    public static final String TXT_RED = a.m.toString();
    public static final String TXT_WHITE = a.p.toString();
    public static final String TXT_YELLOW = a.o.toString();
    public static final String TXT_BOLD = a.r.toString();
    public static final String TXT_ITALIC = a.u.toString();
    public static final String TXT_RST = a.v.toString();
    public static final String TXT_STRIKETHROUGH = a.s.toString();
    public static final String TXT_UNDERLINE = a.t.toString();
    public static final String TXT_DARK_AQUA = a.d.toString();
    public static final String TXT_DARK_BLUE = a.b.toString();
    public static final String TXT_DARK_GRAY = a.i.toString();
    public static final String TXT_DARK_GREEN = a.c.toString();
    public static final String TXT_DARK_PURPLE = a.f.toString();
    public static final String TXT_DARK_RED = a.e.toString();
    public static final String TXT_LIGHT_PURPLE = a.n.toString();
    protected static final String BUTTON_LABEL_ADD = TXT_DARK_GREEN + "+" + TXT_RST;
    protected static final String BUTTON_LABEL_REMOVE = TXT_DARK_RED + "-" + TXT_RST;
    public static final int COLOR_WHITE = -1;
    public static final int TOOLTIP_BACKGROUND = -1342177280;
    public static final int COLOR_HORIZONTAL_BAR = -6710887;
    protected static final int LEFT = 20;
    protected static final int TOP = 10;
    public final cft k = cft.s();
    public final cgk textRenderer;
    public final int fontHeight;
    private final List<ButtonBase> buttons;
    private final List<WidgetBase> widgets;
    private final List<TextFieldWrapper<? extends GuiTextFieldGeneric>> textFields;
    private final MessageRenderer messageRenderer;
    protected WidgetBase hoveredWidget;
    protected String title;
    protected boolean useTitleHierarchy;
    private int keyInputCount;
    @Nullable
    private ckd parent;

    public GuiBase() {
        this.textRenderer = this.k.l;
        this.fontHeight = this.textRenderer.a;
        this.buttons = new ArrayList<ButtonBase>();
        this.widgets = new ArrayList<WidgetBase>();
        this.textFields = new ArrayList<TextFieldWrapper<? extends GuiTextFieldGeneric>>();
        this.messageRenderer = new MessageRenderer(-587202560, -6710887);
        this.hoveredWidget = null;
        this.title = "";
        this.useTitleHierarchy = true;
    }

    public GuiBase setParent(@Nullable ckd parent) {
        if (parent == null || parent.getClass() != this.getClass()) {
            this.parent = parent;
        }
        return this;
    }

    @Nullable
    public ckd getParent() {
        return this.parent;
    }

    public String getTitle() {
        return this.useTitleHierarchy && this.parent instanceof GuiBase ? ((GuiBase)this.parent).getTitle() + " => " + this.title : this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void n() {
        cft.s().v.a(false);
    }

    public boolean e() {
        return false;
    }

    public void c() {
        super.c();
        this.clearElements();
    }

    protected void closeGui(boolean showParent) {
        if (showParent) {
            this.k.a(this.parent);
        } else {
            this.g();
        }
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.drawScreenBackground(mouseX, mouseY);
        this.drawTitle(mouseX, mouseY, partialTicks);
        this.drawWidgets(mouseX, mouseY);
        this.drawTextFields(mouseX, mouseY);
        this.drawButtons(mouseX, mouseY, partialTicks);
        this.drawContents(mouseX, mouseY, partialTicks);
        this.drawButtonHoverTexts(mouseX, mouseY, partialTicks);
        this.drawHoveredWidget(mouseX, mouseY);
        this.drawGuiMessages();
    }

    public boolean mouseScrolled(double amount) {
        int mouseX = InputUtils.getMouseX();
        int mouseY = InputUtils.getMouseY();
        if (amount == 0.0 || this.onMouseScrolled(mouseX, mouseY, amount)) {
            return super.mouseScrolled(amount);
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.onMouseClicked((int)mouseX, (int)mouseY, mouseButton)) {
            return super.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (!this.onMouseReleased((int)mouseX, (int)mouseY, mouseButton)) {
            return super.mouseReleased(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        ++this.keyInputCount;
        if (this.onKeyTyped(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char charIn, int modifiers) {
        if (this.keyInputCount <= 0) {
            return true;
        }
        if (this.onCharTyped(charIn, modifiers)) {
            return true;
        }
        return super.charTyped(charIn, modifiers);
    }

    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        for (ButtonBase button : this.buttons) {
            if (!button.onMouseClicked(mouseX, mouseY, mouseButton)) continue;
            return true;
        }
        boolean handled = false;
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            if (!entry.mouseClicked(mouseX, mouseY, mouseButton)) continue;
            handled = true;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.isMouseOver(mouseX, mouseY) || !widget.onMouseClicked(mouseX, mouseY, mouseButton)) continue;
                handled = true;
                break;
            }
        }
        return handled;
    }

    public boolean onMouseReleased(int mouseX, int mouseY, int mouseButton) {
        for (WidgetBase widget : this.widgets) {
            widget.onMouseReleased(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean onMouseScrolled(int mouseX, int mouseY, double mouseWheelDelta) {
        for (ButtonBase button : this.buttons) {
            if (!button.onMouseScrolled(mouseX, mouseY, mouseWheelDelta)) continue;
            return true;
        }
        for (WidgetBase widget : this.widgets) {
            if (!widget.onMouseScrolled(mouseX, mouseY, mouseWheelDelta)) continue;
            return true;
        }
        return false;
    }

    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        boolean handled = false;
        int selected = -1;
        for (int i = 0; i < this.textFields.size(); ++i) {
            TextFieldWrapper<? extends GuiTextFieldGeneric> entry = this.textFields.get(i);
            if (!entry.isFocused()) continue;
            if (keyCode == 258) {
                entry.setFocused(false);
                selected = i;
            } else {
                entry.onKeyTyped(keyCode, scanCode, modifiers);
            }
            handled = keyCode != 256;
            break;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.onKeyTyped(keyCode, scanCode, modifiers)) continue;
                handled = true;
                break;
            }
        }
        if (!handled && keyCode == 256) {
            this.closeGui(!GuiBase.isShiftDown());
            return true;
        }
        if (selected >= 0) {
            selected = GuiBase.isShiftDown() ? (selected > 0 ? selected - 1 : this.textFields.size() - 1) : (selected + 1) % this.textFields.size();
            this.textFields.get(selected).setFocused(true);
        }
        return handled;
    }

    public boolean onCharTyped(char charIn, int modifiers) {
        boolean handled = false;
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            if (!entry.onCharTyped(charIn, modifiers)) continue;
            handled = true;
            break;
        }
        if (!handled) {
            for (WidgetBase widget : this.widgets) {
                if (!widget.onCharTyped(charIn, modifiers)) continue;
                handled = true;
                break;
            }
        }
        return handled;
    }

    @Override
    public void setString(String string) {
        this.messageRenderer.addMessage(3000, string, new Object[0]);
    }

    @Override
    public void addMessage(Message.MessageType type, String messageKey, Object ... args) {
        this.addGuiMessage(type, 5000, messageKey, args);
    }

    @Override
    public void addMessage(Message.MessageType type, int lifeTime, String messageKey, Object ... args) {
        this.addGuiMessage(type, lifeTime, messageKey, args);
    }

    public void addGuiMessage(Message.MessageType type, int displayTimeMs, String messageKey, Object ... args) {
        this.messageRenderer.addMessage(type, displayTimeMs, messageKey, args);
    }

    public void setNextMessageType(Message.MessageType type) {
        this.messageRenderer.setNextMessageType(type);
    }

    protected void drawGuiMessages() {
        this.messageRenderer.drawMessages(this.m / 2, this.n / 2);
    }

    public void bindTexture(pc texture) {
        this.k.E().a(texture);
    }

    public <T extends ButtonBase> T addButton(T button, IButtonActionListener listener) {
        button.setActionListener(listener);
        this.buttons.add(button);
        return button;
    }

    public <T extends GuiTextFieldGeneric> TextFieldWrapper<T> addTextField(T textField, @Nullable ITextFieldListener<T> listener) {
        TextFieldWrapper<T> wrapper = new TextFieldWrapper<T>(textField, listener);
        this.textFields.add(wrapper);
        return wrapper;
    }

    public <T extends WidgetBase> T addWidget(T widget) {
        this.widgets.add(widget);
        return widget;
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, String ... lines) {
        return this.addLabel(x, y, width, height, textColor, Arrays.asList(lines));
    }

    public WidgetLabel addLabel(int x, int y, int width, int height, int textColor, List<String> lines) {
        if (lines.size() > 0 && width == -1) {
            for (String line : lines) {
                width = Math.max(width, this.getStringWidth(line));
            }
        }
        return this.addWidget(new WidgetLabel(x, y, width, height, textColor, lines));
    }

    protected boolean removeWidget(WidgetBase widget) {
        if (widget != null && this.widgets.contains(widget)) {
            this.widgets.remove(widget);
            return true;
        }
        return false;
    }

    protected void clearElements() {
        this.clearWidgets();
        this.clearButtons();
        this.clearTextFields();
    }

    protected void clearWidgets() {
        this.widgets.clear();
    }

    protected void clearButtons() {
        this.buttons.clear();
    }

    protected void clearTextFields() {
        this.textFields.clear();
    }

    protected void drawScreenBackground(int mouseX, int mouseY) {
        GuiBase.a((int)0, (int)0, (int)this.m, (int)this.n, (int)-1342177280);
    }

    protected void drawTitle(int mouseX, int mouseY, float partialTicks) {
        this.drawString(this.getTitle(), 20, 10, -1);
    }

    protected void drawContents(int mouseX, int mouseY, float partialTicks) {
    }

    protected void drawButtons(int mouseX, int mouseY, float partialTicks) {
        for (ButtonBase button : this.buttons) {
            button.render(mouseX, mouseY, button.isMouseOver());
        }
    }

    protected void drawTextFields(int mouseX, int mouseY) {
        for (TextFieldWrapper<? extends GuiTextFieldGeneric> entry : this.textFields) {
            entry.draw(mouseX, mouseY);
        }
    }

    protected void drawWidgets(int mouseX, int mouseY) {
        this.hoveredWidget = null;
        if (!this.widgets.isEmpty()) {
            for (WidgetBase widget : this.widgets) {
                widget.render(mouseX, mouseY, false);
                if (!widget.isMouseOver(mouseX, mouseY)) continue;
                this.hoveredWidget = widget;
            }
        }
    }

    protected void drawButtonHoverTexts(int mouseX, int mouseY, float partialTicks) {
        for (ButtonBase button : this.buttons) {
            if (!button.hasHoverText() || !button.isMouseOver()) continue;
            RenderUtils.drawHoverText(mouseX, mouseY, button.getHoverStrings());
        }
        RenderUtils.disableItemLighting();
    }

    protected void drawHoveredWidget(int mouseX, int mouseY) {
        if (this.hoveredWidget != null) {
            this.hoveredWidget.postRenderHovered(mouseX, mouseY, false);
            RenderUtils.disableItemLighting();
        }
    }

    public static boolean isMouseOver(int mouseX, int mouseY, int x, int y, int width, int height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public int getStringWidth(String text) {
        return this.textRenderer.a(text);
    }

    public void drawString(String text, int x, int y, int color) {
        this.textRenderer.b(text, (float)x, (float)y, color);
    }

    public void drawStringWithShadow(String text, int x, int y, int color) {
        this.textRenderer.a(text, (float)x, (float)y, color);
    }

    public int getMaxPrettyNameLength(List<? extends IConfigBase> configs) {
        int width = 0;
        for (IConfigBase iConfigBase : configs) {
            width = Math.max(width, this.getStringWidth(iConfigBase.getPrettyName()));
        }
        return width;
    }

    public static void openGui(ckd gui) {
        cft.s().a(gui);
    }

    public static boolean isShiftDown() {
        return GuiBase.q();
    }

    public static boolean isCtrlDown() {
        return GuiBase.p();
    }

    public static boolean isAltDown() {
        return GuiBase.r();
    }
}

