/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.event;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IInputManager;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.hotkeys.KeybindCategory;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class InputEventHandler
implements IKeybindManager,
IInputManager {
    private static final InputEventHandler INSTANCE = new InputEventHandler();
    private final Multimap<Integer, IKeybind> hotkeyMap = ArrayListMultimap.create();
    private final List<KeybindCategory> allKeybinds = new ArrayList<KeybindCategory>();
    private final IntOpenHashSet modifierKeys = new IntOpenHashSet();
    private final List<IKeybindProvider> keybindProviders = new ArrayList<IKeybindProvider>();
    private final List<IKeyboardInputHandler> keyboardHandlers = new ArrayList<IKeyboardInputHandler>();
    private final List<IMouseInputHandler> mouseHandlers = new ArrayList<IMouseInputHandler>();

    private InputEventHandler() {
        this.modifierKeys.add(340);
        this.modifierKeys.add(344);
        this.modifierKeys.add(341);
        this.modifierKeys.add(345);
        this.modifierKeys.add(342);
        this.modifierKeys.add(346);
    }

    public static IKeybindManager getKeybindManager() {
        return INSTANCE;
    }

    public static IInputManager getInputManager() {
        return INSTANCE;
    }

    @Override
    public void registerKeybindProvider(IKeybindProvider provider) {
        if (!this.keybindProviders.contains(provider)) {
            this.keybindProviders.add(provider);
        }
        provider.addHotkeys(this);
    }

    @Override
    public void unregisterKeybindProvider(IKeybindProvider provider) {
        this.keybindProviders.remove(provider);
    }

    @Override
    public List<KeybindCategory> getKeybindCategories() {
        return this.allKeybinds;
    }

    @Override
    public void updateUsedKeys() {
        this.hotkeyMap.clear();
        for (IKeybindProvider handler : this.keybindProviders) {
            handler.addKeysToMap(this);
        }
    }

    @Override
    public void addKeybindToMap(IKeybind keybind) {
        List<Integer> keys = keybind.getKeys();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            this.hotkeyMap.put((Object)key, (Object)keybind);
        }
    }

    @Override
    public void addHotkeysForCategory(String modName, String keyCategory, List<? extends IHotkey> hotkeys) {
        KeybindCategory cat = new KeybindCategory(modName, keyCategory, hotkeys);
        this.allKeybinds.remove(cat);
        this.allKeybinds.add(cat);
    }

    @Override
    public void registerKeyboardInputHandler(IKeyboardInputHandler handler) {
        if (!this.keyboardHandlers.contains(handler)) {
            this.keyboardHandlers.add(handler);
        }
    }

    @Override
    public void unregisterKeyboardInputHandler(IKeyboardInputHandler handler) {
        this.keyboardHandlers.remove(handler);
    }

    @Override
    public void registerMouseInputHandler(IMouseInputHandler handler) {
        if (!this.mouseHandlers.contains(handler)) {
            this.mouseHandlers.add(handler);
        }
    }

    @Override
    public void unregisterMouseInputHandler(IMouseInputHandler handler) {
        this.mouseHandlers.remove(handler);
    }

    public boolean onKeyInput(int keyCode, int scanCode, int modifiers, boolean eventKeyState) {
        KeybindMulti.onKeyInputPre(keyCode, scanCode, modifiers, eventKeyState);
        boolean cancel = this.checkKeyBindsForChanges(keyCode);
        if (!this.keyboardHandlers.isEmpty()) {
            for (IKeyboardInputHandler handler : this.keyboardHandlers) {
                if (!handler.onKeyInput(keyCode, scanCode, modifiers, eventKeyState)) continue;
                return true;
            }
        }
        return cancel && !this.isModifierKey(keyCode);
    }

    public boolean onMouseClick(int mouseX, int mouseY, int eventButton, boolean eventButtonState) {
        boolean cancel = false;
        if (eventButton != -1) {
            KeybindMulti.onKeyInputPre(eventButton - 100, 0, 0, eventButtonState);
            cancel = this.checkKeyBindsForChanges(eventButton - 100);
            if (!this.mouseHandlers.isEmpty()) {
                for (IMouseInputHandler handler : this.mouseHandlers) {
                    if (!handler.onMouseClick(mouseX, mouseY, eventButton, eventButtonState)) continue;
                    return true;
                }
            }
        }
        return cancel;
    }

    public boolean onMouseScroll(int mouseX, int mouseY, double amount) {
        boolean cancel = false;
        if (amount != 0.0 && !this.mouseHandlers.isEmpty()) {
            for (IMouseInputHandler handler : this.mouseHandlers) {
                if (!handler.onMouseScroll(mouseX, mouseY, amount)) continue;
                return true;
            }
        }
        return cancel;
    }

    public void onMouseMove(int mouseX, int mouseY) {
        if (!this.mouseHandlers.isEmpty()) {
            for (IMouseInputHandler handler : this.mouseHandlers) {
                handler.onMouseMove(mouseX, mouseY);
            }
        }
    }

    private boolean isModifierKey(int eventKey) {
        return this.modifierKeys.contains(eventKey);
    }

    private boolean checkKeyBindsForChanges(int eventKey) {
        boolean cancel = false;
        Collection keybinds = this.hotkeyMap.get((Object)eventKey);
        if (!keybinds.isEmpty()) {
            for (IKeybind keybind : keybinds) {
                cancel |= keybind.updateIsPressed();
            }
        }
        return cancel;
    }
}

