/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.reiclothconfig2.impl.builders;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.reiclothconfig2.gui.entries.LongListEntry;
import me.shedaniel.reiclothconfig2.impl.builders.FieldBuilder;

public class LongFieldBuilder
extends FieldBuilder<Long, LongListEntry> {
    private Consumer<Long> saveConsumer = null;
    private Supplier<Optional<String[]>> tooltipSupplier = null;
    private long value;
    private Long min = null;
    private Long max = null;

    public LongFieldBuilder(String resetButtonKey, String fieldNameKey, long value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    public LongFieldBuilder requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public LongFieldBuilder setSaveConsumer(Consumer<Long> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public LongFieldBuilder setDefaultValue(Supplier<Long> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public LongFieldBuilder setDefaultValue(long defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    public LongFieldBuilder setTooltipSupplier(Supplier<Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public LongFieldBuilder setTooltip(Optional<String[]> tooltip) {
        this.tooltipSupplier = () -> tooltip;
        return this;
    }

    public LongFieldBuilder setTooltip(String ... tooltip) {
        this.tooltipSupplier = () -> Optional.ofNullable(tooltip);
        return this;
    }

    public LongFieldBuilder setMin(long min) {
        this.min = min;
        return this;
    }

    public LongFieldBuilder setMax(long max) {
        this.max = max;
        return this;
    }

    public LongFieldBuilder removeMin() {
        this.min = null;
        return this;
    }

    public LongFieldBuilder removeMax() {
        this.max = null;
        return this;
    }

    @Override
    public LongListEntry build() {
        LongListEntry entry = new LongListEntry(this.getFieldNameKey(), this.value, this.getResetButtonKey(), this.defaultValue, this.saveConsumer, this.tooltipSupplier, this.isRequireRestart());
        if (this.min != null) {
            entry.setMinimum(this.min);
        }
        if (this.max != null) {
            entry.setMaximum(this.max);
        }
        return entry;
    }
}

