/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.reiclothconfig2.impl.builders;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.reiclothconfig2.gui.entries.DoubleListEntry;
import me.shedaniel.reiclothconfig2.impl.builders.FieldBuilder;

public class DoubleFieldBuilder
extends FieldBuilder<Double, DoubleListEntry> {
    private Consumer<Double> saveConsumer = null;
    private Supplier<Optional<String[]>> tooltipSupplier = null;
    private double value;
    private Double min = null;
    private Double max = null;

    public DoubleFieldBuilder(String resetButtonKey, String fieldNameKey, double value) {
        super(resetButtonKey, fieldNameKey);
        this.value = value;
    }

    public DoubleFieldBuilder requireRestart() {
        this.requireRestart(true);
        return this;
    }

    public DoubleFieldBuilder setSaveConsumer(Consumer<Double> saveConsumer) {
        this.saveConsumer = saveConsumer;
        return this;
    }

    public DoubleFieldBuilder setDefaultValue(Supplier<Double> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public DoubleFieldBuilder setDefaultValue(double defaultValue) {
        this.defaultValue = () -> defaultValue;
        return this;
    }

    public DoubleFieldBuilder setMin(double min) {
        this.min = min;
        return this;
    }

    public DoubleFieldBuilder setMax(double max) {
        this.max = max;
        return this;
    }

    public DoubleFieldBuilder removeMin() {
        this.min = null;
        return this;
    }

    public DoubleFieldBuilder removeMax() {
        this.max = null;
        return this;
    }

    public DoubleFieldBuilder setTooltipSupplier(Supplier<Optional<String[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
        return this;
    }

    public DoubleFieldBuilder setTooltip(Optional<String[]> tooltip) {
        this.tooltipSupplier = () -> tooltip;
        return this;
    }

    public DoubleFieldBuilder setTooltip(String ... tooltip) {
        this.tooltipSupplier = () -> Optional.ofNullable(tooltip);
        return this;
    }

    @Override
    public DoubleListEntry build() {
        DoubleListEntry entry = new DoubleListEntry(this.getFieldNameKey(), this.value, this.getResetButtonKey(), this.defaultValue, this.saveConsumer, this.tooltipSupplier, this.isRequireRestart());
        if (this.min != null) {
            entry.setMinimum(this.min);
        }
        if (this.max != null) {
            entry.setMaximum(this.max);
        }
        return entry;
    }
}

