/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.reiclothconfig2.gui.widget;

import com.google.common.collect.Lists;
import java.util.AbstractList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import me.shedaniel.rei.gui.widget.Widget;

public abstract class DynamicEntryListWidget<E extends Entry<E>>
extends Widget {
    protected static final int DRAG_OUTSIDE = -2;
    protected final cft client;
    private final List<E> entries = new Entries();
    protected int width;
    protected int height;
    protected int top;
    protected int bottom;
    protected int right;
    protected int left;
    protected boolean verticallyCenter = true;
    protected int yDrag = -2;
    protected boolean visible = true;
    protected boolean renderSelection;
    protected int headerHeight;
    protected double scroll;
    protected boolean scrolling;
    protected E selectedItem;
    protected pc backgroundLocation;

    public DynamicEntryListWidget(cft client, int width, int height, int top, int bottom, pc backgroundLocation) {
        this.client = client;
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
        this.backgroundLocation = backgroundLocation;
    }

    public void setRenderSelection(boolean boolean_1) {
        this.visible = boolean_1;
    }

    protected void setRenderHeader(boolean boolean_1, int headerHeight) {
        this.renderSelection = boolean_1;
        this.headerHeight = headerHeight;
        if (!boolean_1) {
            this.headerHeight = 0;
        }
    }

    public int getItemWidth() {
        return 220;
    }

    public E getSelectedItem() {
        return this.selectedItem;
    }

    public void selectItem(E item) {
        this.selectedItem = item;
    }

    public E getFocusedItem() {
        return (E)((Object)((Entry)super.getFocused()));
    }

    public final List<E> b() {
        return this.entries;
    }

    protected final void clearItems() {
        this.entries.clear();
    }

    protected E getItem(int index) {
        return (E)((Object)((Entry)((Object)this.b().get(index))));
    }

    protected int addItem(E item) {
        this.entries.add(item);
        return this.entries.size() - 1;
    }

    protected int getItemCount() {
        return this.b().size();
    }

    protected boolean isSelected(int index) {
        return Objects.equals(this.getSelectedItem(), this.b().get(index));
    }

    protected final E getItemAtPosition(double mouseX, double mouseY) {
        int listMiddleX = this.left + this.width / 2;
        int minX = listMiddleX - this.getItemWidth() / 2;
        int maxX = listMiddleX + this.getItemWidth() / 2;
        int currentY = xq.c((double)(mouseY - (double)this.top)) - this.headerHeight + (int)this.getScroll() - 4;
        int itemY = 0;
        int itemIndex = -1;
        for (int i = 0; i < this.entries.size(); ++i) {
            E item = this.getItem(i);
            if ((itemY += ((Entry)((Object)item)).getItemHeight()) <= currentY) continue;
            itemIndex = i;
            break;
        }
        return (E)((Object)(mouseX < (double)this.getScrollbarPosition() && mouseX >= (double)minX && mouseX <= (double)maxX && itemIndex >= 0 && currentY >= 0 && itemIndex < this.getItemCount() ? (Entry)((Object)this.b().get(itemIndex)) : null));
    }

    public void updateSize(int width, int height, int top, int bottom) {
        this.width = width;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.left = 0;
        this.right = width;
    }

    public void setLeftPos(int left) {
        this.left = left;
        this.right = left + this.width;
    }

    protected int getMaxScrollPosition() {
        AtomicInteger integer = new AtomicInteger(this.headerHeight);
        this.entries.forEach(item -> integer.addAndGet(item.getItemHeight()));
        return integer.get();
    }

    protected void clickedHeader(int int_1, int int_2) {
    }

    protected void renderHeader(int int_1, int int_2, cum tessellator) {
    }

    protected void drawBackground() {
    }

    protected void renderDecorations(int int_1, int int_2) {
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        this.drawBackground();
        int scrollbarPosition = this.getScrollbarPosition();
        int int_4 = scrollbarPosition + 6;
        cua.g();
        cua.p();
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        this.client.E().a(this.backgroundLocation);
        cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float float_2 = 32.0f;
        buffer.a(7, ddu.o);
        buffer.b((double)this.left, (double)this.bottom, 0.0).a((double)((float)this.left / 32.0f), (double)((float)(this.bottom + (int)this.getScroll()) / 32.0f)).b(32, 32, 32, 255).d();
        buffer.b((double)this.right, (double)this.bottom, 0.0).a((double)((float)this.right / 32.0f), (double)((float)(this.bottom + (int)this.getScroll()) / 32.0f)).b(32, 32, 32, 255).d();
        buffer.b((double)this.right, (double)this.top, 0.0).a((double)((float)this.right / 32.0f), (double)((float)(this.top + (int)this.getScroll()) / 32.0f)).b(32, 32, 32, 255).d();
        buffer.b((double)this.left, (double)this.top, 0.0).a((double)((float)this.left / 32.0f), (double)((float)(this.top + (int)this.getScroll()) / 32.0f)).b(32, 32, 32, 255).d();
        tessellator.b();
        int rowLeft = this.getRowLeft();
        int startY = this.top + 4 - (int)this.getScroll();
        if (this.renderSelection) {
            this.renderHeader(rowLeft, startY, tessellator);
        }
        this.renderList(rowLeft, startY, mouseX, mouseY, delta);
        cua.j();
        this.renderHoleBackground(0, this.top, 255, 255);
        this.renderHoleBackground(this.bottom, this.height, 255, 255);
        cua.m();
        cua.a((cua.r)cua.r.l, (cua.l)cua.l.j, (cua.r)cua.r.o, (cua.l)cua.l.e);
        cua.d();
        cua.j((int)7425);
        cua.z();
        buffer.a(7, ddu.o);
        buffer.b((double)this.left, (double)(this.top + 4), 0.0).a(0.0, 1.0).b(0, 0, 0, 0).d();
        buffer.b((double)this.right, (double)(this.top + 4), 0.0).a(1.0, 1.0).b(0, 0, 0, 0).d();
        buffer.b((double)this.right, (double)this.top, 0.0).a(1.0, 0.0).b(0, 0, 0, 255).d();
        buffer.b((double)this.left, (double)this.top, 0.0).a(0.0, 0.0).b(0, 0, 0, 255).d();
        tessellator.b();
        buffer.a(7, ddu.o);
        buffer.b((double)this.left, (double)this.bottom, 0.0).a(0.0, 1.0).b(0, 0, 0, 255).d();
        buffer.b((double)this.right, (double)this.bottom, 0.0).a(1.0, 1.0).b(0, 0, 0, 255).d();
        buffer.b((double)this.right, (double)(this.bottom - 4), 0.0).a(1.0, 0.0).b(0, 0, 0, 0).d();
        buffer.b((double)this.left, (double)(this.bottom - 4), 0.0).a(0.0, 0.0).b(0, 0, 0, 0).d();
        tessellator.b();
        int maxScroll = this.getMaxScroll();
        this.renderScrollBar(tessellator, buffer, maxScroll, scrollbarPosition, int_4);
        this.renderDecorations(mouseX, mouseY);
        cua.y();
        cua.j((int)7424);
        cua.e();
        cua.l();
    }

    protected void renderScrollBar(cum tessellator, ctq buffer, int maxScroll, int scrollbarPositionMinX, int scrollbarPositionMaxX) {
        if (maxScroll > 0) {
            int int_9 = (this.bottom - this.top) * (this.bottom - this.top) / this.getMaxScrollPosition();
            int_9 = xq.a((int)int_9, (int)32, (int)(this.bottom - this.top - 8));
            int int_10 = (int)this.getScroll() * (this.bottom - this.top - int_9) / maxScroll + this.top;
            if (int_10 < this.top) {
                int_10 = this.top;
            }
            buffer.a(7, ddu.o);
            buffer.b((double)scrollbarPositionMinX, (double)this.bottom, 0.0).a(0.0, 1.0).b(0, 0, 0, 255).d();
            buffer.b((double)scrollbarPositionMaxX, (double)this.bottom, 0.0).a(1.0, 1.0).b(0, 0, 0, 255).d();
            buffer.b((double)scrollbarPositionMaxX, (double)this.top, 0.0).a(1.0, 0.0).b(0, 0, 0, 255).d();
            buffer.b((double)scrollbarPositionMinX, (double)this.top, 0.0).a(0.0, 0.0).b(0, 0, 0, 255).d();
            tessellator.b();
            buffer.a(7, ddu.o);
            buffer.b((double)scrollbarPositionMinX, (double)(int_10 + int_9), 0.0).a(0.0, 1.0).b(128, 128, 128, 255).d();
            buffer.b((double)scrollbarPositionMaxX, (double)(int_10 + int_9), 0.0).a(1.0, 1.0).b(128, 128, 128, 255).d();
            buffer.b((double)scrollbarPositionMaxX, (double)int_10, 0.0).a(1.0, 0.0).b(128, 128, 128, 255).d();
            buffer.b((double)scrollbarPositionMinX, (double)int_10, 0.0).a(0.0, 0.0).b(128, 128, 128, 255).d();
            tessellator.b();
            buffer.a(7, ddu.o);
            buffer.b((double)scrollbarPositionMinX, (double)(int_10 + int_9 - 1), 0.0).a(0.0, 1.0).b(192, 192, 192, 255).d();
            buffer.b((double)(scrollbarPositionMaxX - 1), (double)(int_10 + int_9 - 1), 0.0).a(1.0, 1.0).b(192, 192, 192, 255).d();
            buffer.b((double)(scrollbarPositionMaxX - 1), (double)int_10, 0.0).a(1.0, 0.0).b(192, 192, 192, 255).d();
            buffer.b((double)scrollbarPositionMinX, (double)int_10, 0.0).a(0.0, 0.0).b(192, 192, 192, 255).d();
            tessellator.b();
        }
    }

    protected void centerScrollOn(E item) {
        double d = (this.bottom - this.top) / -2;
        for (int i = 0; i < this.b().indexOf(item) && i < this.getItemCount(); ++i) {
            d += (double)((Entry)((Object)this.getItem(i))).getItemHeight();
        }
        this.capYPosition(d);
    }

    protected void ensureVisible(E item) {
        int int_3;
        if (item == null) {
            return;
        }
        int rowTop = this.getRowTop(this.b().indexOf(item));
        int int_2 = rowTop - this.top - 4 - ((Entry)((Object)item)).getItemHeight();
        if (int_2 < 0) {
            this.scroll(int_2);
        }
        if ((int_3 = this.bottom - rowTop - ((Entry)((Object)item)).getItemHeight() * 2) < 0) {
            this.scroll(-int_3);
        }
    }

    protected void scroll(int int_1) {
        this.capYPosition(this.getScroll() + (double)int_1);
        this.yDrag = -2;
    }

    public double getScroll() {
        return this.scroll;
    }

    public void capYPosition(double double_1) {
        this.scroll = xq.a((double)double_1, (double)0.0, (double)this.getMaxScroll());
    }

    protected int getMaxScroll() {
        return Math.max(0, this.getMaxScrollPosition() - (this.bottom - this.top - 4));
    }

    public int getScrollBottom() {
        return (int)this.getScroll() - this.height - this.headerHeight;
    }

    protected void updateScrollingState(double double_1, double double_2, int int_1) {
        this.scrolling = int_1 == 0 && double_1 >= (double)this.getScrollbarPosition() && double_1 < (double)(this.getScrollbarPosition() + 6);
    }

    protected int getScrollbarPosition() {
        return this.width / 2 + 124;
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        this.updateScrollingState(double_1, double_2, int_1);
        if (!this.isMouseOver(double_1, double_2)) {
            return false;
        }
        E item = this.getItemAtPosition(double_1, double_2);
        if (item != null) {
            if (item.mouseClicked(double_1, double_2, int_1)) {
                this.a((chr)item);
                this.e(true);
                return true;
            }
        } else if (int_1 == 0) {
            this.clickedHeader((int)(double_1 - (double)(this.left + this.width / 2 - this.getItemWidth() / 2)), (int)(double_2 - (double)this.top) + (int)this.getScroll() - 4);
            return true;
        }
        return this.scrolling;
    }

    public boolean mouseReleased(double double_1, double double_2, int int_1) {
        if (this.getFocused() != null) {
            this.getFocused().mouseReleased(double_1, double_2, int_1);
        }
        return false;
    }

    public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (super.mouseDragged(double_1, double_2, int_1, double_3, double_4)) {
            return true;
        }
        if (int_1 == 0 && this.scrolling) {
            if (double_2 < (double)this.top) {
                this.capYPosition(0.0);
            } else if (double_2 > (double)this.bottom) {
                this.capYPosition(this.getMaxScroll());
            } else {
                double double_5 = Math.max(1, this.getMaxScroll());
                int int_2 = this.bottom - this.top;
                int int_3 = xq.a((int)((int)((float)(int_2 * int_2) / (float)this.getMaxScrollPosition())), (int)32, (int)(int_2 - 8));
                double double_6 = Math.max(1.0, double_5 / (double)(int_2 - int_3));
                this.capYPosition(this.getScroll() + double_4 * double_6);
            }
            return true;
        }
        return false;
    }

    public boolean mouseScrolled(double double_3) {
        this.capYPosition(this.getScroll() - double_3 * (double)(this.getMaxScroll() / this.getItemCount()) / 2.0);
        return true;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (super.keyPressed(int_1, int_2, int_3)) {
            return true;
        }
        if (int_1 == 264) {
            this.moveSelection(1);
            return true;
        }
        if (int_1 == 265) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int int_1) {
        if (!this.b().isEmpty()) {
            int int_2 = this.b().indexOf(this.getSelectedItem());
            int int_3 = xq.a((int)(int_2 + int_1), (int)0, (int)(this.getItemCount() - 1));
            Entry itemListWidget$Item_1 = (Entry)((Object)this.b().get(int_3));
            this.selectItem(itemListWidget$Item_1);
            this.ensureVisible(itemListWidget$Item_1);
        }
    }

    public boolean isMouseOver(double double_1, double double_2) {
        return double_2 >= (double)this.top && double_2 <= (double)this.bottom && double_1 >= (double)this.left && double_1 <= (double)this.right;
    }

    protected void renderList(int startX, int startY, int int_3, int int_4, float float_1) {
        int itemCount = this.getItemCount();
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        for (int renderIndex = 0; renderIndex < itemCount; ++renderIndex) {
            E item = this.getItem(renderIndex);
            int itemY = startY + this.headerHeight;
            for (int i = 0; i < this.entries.size() && i < renderIndex; ++i) {
                itemY += ((Entry)((Object)this.entries.get(i))).getItemHeight();
            }
            int itemHeight = ((Entry)((Object)item)).getItemHeight() - 4;
            int itemWidth = this.getItemWidth();
            if (this.visible && this.isSelected(renderIndex)) {
                int itemMinX = this.left + this.width / 2 - itemWidth / 2;
                int itemMaxX = itemMinX + itemWidth;
                cua.z();
                float float_2 = this.isFocused() ? 1.0f : 0.5f;
                cua.c((float)float_2, (float)float_2, (float)float_2, (float)1.0f);
                buffer.a(7, ddu.k);
                buffer.b((double)itemMinX, (double)(itemY + itemHeight + 2), 0.0).d();
                buffer.b((double)itemMaxX, (double)(itemY + itemHeight + 2), 0.0).d();
                buffer.b((double)itemMaxX, (double)(itemY - 2), 0.0).d();
                buffer.b((double)itemMinX, (double)(itemY - 2), 0.0).d();
                tessellator.b();
                cua.c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                buffer.a(7, ddu.k);
                buffer.b((double)(itemMinX + 1), (double)(itemY + itemHeight + 1), 0.0).d();
                buffer.b((double)(itemMaxX - 1), (double)(itemY + itemHeight + 1), 0.0).d();
                buffer.b((double)(itemMaxX - 1), (double)(itemY - 1), 0.0).d();
                buffer.b((double)(itemMinX + 1), (double)(itemY - 1), 0.0).d();
                tessellator.b();
                cua.y();
            }
            int y = this.getRowTop(renderIndex);
            int x = this.getRowLeft();
            cfr.a();
            ((Entry)((Object)item)).render(renderIndex, y, x, itemWidth, itemHeight, int_3, int_4, this.isMouseOver(int_3, int_4) && Objects.equals(this.getItemAtPosition(int_3, int_4), item), float_1);
        }
    }

    protected int getRowLeft() {
        return this.left + this.width / 2 - this.getItemWidth() / 2 + 2;
    }

    protected int getRowTop(int index) {
        int integer = this.top + 4 - (int)this.getScroll() + this.headerHeight;
        for (int i = 0; i < this.entries.size() && i < index; ++i) {
            integer += ((Entry)((Object)this.entries.get(i))).getItemHeight();
        }
        return integer;
    }

    protected boolean isFocused() {
        return false;
    }

    protected void renderHoleBackground(int int_1, int int_2, int int_3, int int_4) {
        cum tessellator_1 = cum.a();
        ctq bufferBuilder_1 = tessellator_1.c();
        this.client.E().a(this.backgroundLocation);
        cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float float_1 = 32.0f;
        bufferBuilder_1.a(7, ddu.o);
        bufferBuilder_1.b((double)this.left, (double)int_2, 0.0).a(0.0, (double)((float)int_2 / 32.0f)).b(64, 64, 64, int_4).d();
        bufferBuilder_1.b((double)(this.left + this.width), (double)int_2, 0.0).a((double)((float)this.width / 32.0f), (double)((float)int_2 / 32.0f)).b(64, 64, 64, int_4).d();
        bufferBuilder_1.b((double)(this.left + this.width), (double)int_1, 0.0).a((double)((float)this.width / 32.0f), (double)((float)int_1 / 32.0f)).b(64, 64, 64, int_3).d();
        bufferBuilder_1.b((double)this.left, (double)int_1, 0.0).a(0.0, (double)((float)int_1 / 32.0f)).b(64, 64, 64, int_3).d();
        tessellator_1.b();
    }

    protected E remove(int int_1) {
        Entry itemListWidget$Item_1 = (Entry)((Object)this.entries.get(int_1));
        return (E)((Object)(this.removeEntry((Entry)((Object)this.entries.get(int_1))) ? itemListWidget$Item_1 : null));
    }

    protected boolean removeEntry(E itemListWidget$Item_1) {
        boolean boolean_1 = this.entries.remove(itemListWidget$Item_1);
        if (boolean_1 && itemListWidget$Item_1 == this.getSelectedItem()) {
            this.selectItem(null);
        }
        return boolean_1;
    }

    class Entries
    extends AbstractList<E> {
        private final List<E> items = Lists.newArrayList();

        private Entries() {
        }

        @Override
        public E get(int int_1) {
            return (Object)((Entry)((Object)this.items.get(int_1)));
        }

        @Override
        public int size() {
            return this.items.size();
        }

        @Override
        public E set(int int_1, E itemListWidget$Item_1) {
            Entry itemListWidget$Item_2 = (Entry)((Object)this.items.set(int_1, itemListWidget$Item_1));
            ((Entry)((Object)itemListWidget$Item_1)).parent = DynamicEntryListWidget.this;
            return (Object)itemListWidget$Item_2;
        }

        @Override
        public void add(int int_1, E itemListWidget$Item_1) {
            this.items.add(int_1, itemListWidget$Item_1);
            ((Entry)((Object)itemListWidget$Item_1)).parent = DynamicEntryListWidget.this;
        }

        @Override
        public E remove(int int_1) {
            return (Object)((Entry)((Object)this.items.remove(int_1)));
        }
    }

    public static abstract class Entry<E extends Entry<E>>
    extends cgm
    implements chr {
        @Deprecated
        DynamicEntryListWidget<E> parent;

        public abstract void render(int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);

        public boolean isMouseOver(double double_1, double double_2) {
            return Objects.equals(this.parent.getItemAtPosition(double_1, double_2), (Object)this);
        }

        public DynamicEntryListWidget<E> getParent() {
            return this.parent;
        }

        public void setParent(DynamicEntryListWidget<E> parent) {
            this.parent = parent;
        }

        public abstract int getItemHeight();
    }
}

