/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.reiclothconfig2.gui.entries;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.reiclothconfig2.gui.entries.TextFieldListEntry;

public class LongListEntry
extends TextFieldListEntry<Long> {
    private static Function<String, String> stripCharacters = s -> {
        StringBuilder stringBuilder_1 = new StringBuilder();
        char[] var2 = s.toCharArray();
        int var3 = var2.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            if (!Character.isDigit(var2[var4]) && var2[var4] != '-') continue;
            stringBuilder_1.append(var2[var4]);
        }
        return stringBuilder_1.toString();
    };
    private long minimum = -9223372036854775807L;
    private long maximum = Long.MAX_VALUE;
    private Consumer<Long> saveConsumer;

    @Deprecated
    public LongListEntry(String fieldName, Long value, Consumer<Long> saveConsumer) {
        this(fieldName, value, "text.cloth-config.reset_value", null, saveConsumer);
    }

    @Deprecated
    public LongListEntry(String fieldName, Long value, String resetButtonKey, Supplier<Long> defaultValue, Consumer<Long> saveConsumer) {
        super(fieldName, value, resetButtonKey, defaultValue);
        this.saveConsumer = saveConsumer;
    }

    @Deprecated
    public LongListEntry(String fieldName, Long value, String resetButtonKey, Supplier<Long> defaultValue, Consumer<Long> saveConsumer, Supplier<Optional<String[]>> tooltipSupplier) {
        this(fieldName, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    public LongListEntry(String fieldName, Long value, String resetButtonKey, Supplier<Long> defaultValue, Consumer<Long> saveConsumer, Supplier<Optional<String[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveConsumer = saveConsumer;
    }

    @Override
    protected String stripAddText(String s) {
        return stripCharacters.apply(s);
    }

    @Override
    protected void textFieldPreRender(cgy widget) {
        try {
            double i = Long.valueOf(this.textFieldWidget.b()).longValue();
            if (i < (double)this.minimum || i > (double)this.maximum) {
                widget.h(0xFF5555);
            } else {
                widget.h(0xE0E0E0);
            }
        }
        catch (NumberFormatException ex) {
            widget.h(0xFF5555);
        }
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    protected boolean isMatchDefault(String text) {
        return this.getDefaultValue().isPresent() ? text.equals(((Long)this.defaultValue.get()).toString()) : false;
    }

    public LongListEntry setMinimum(long minimum) {
        this.minimum = minimum;
        return this;
    }

    public LongListEntry setMaximum(long maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public Long getValue() {
        try {
            return Long.valueOf(this.textFieldWidget.b());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public Optional<String> getError() {
        try {
            long i = Long.valueOf(this.textFieldWidget.b());
            if (i > this.maximum) {
                return Optional.of(dej.a((String)"text.cloth-config.error.too_large", (Object[])new Object[]{this.maximum}));
            }
            if (i < this.minimum) {
                return Optional.of(dej.a((String)"text.cloth-config.error.too_small", (Object[])new Object[]{this.minimum}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(dej.a((String)"text.cloth-config.error.not_valid_number_long", (Object[])new Object[0]));
        }
        return super.getError();
    }
}

