/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.reiclothconfig2.gui.entries;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.reiclothconfig2.api.QueuedTooltip;
import me.shedaniel.reiclothconfig2.gui.entries.BaseListCell;
import me.shedaniel.reiclothconfig2.gui.entries.TooltipListEntry;

public abstract class BaseListEntry<T, C extends BaseListCell>
extends TooltipListEntry<List<T>> {
    protected static final pc CONFIG_TEX = new pc("roughlyenoughitems", "textures/gui/cloth_config.png");
    protected final List<C> cells;
    protected final List<chr> widgets;
    protected boolean expended;
    protected Consumer<List<T>> saveConsumer;
    protected ListLabelWidget labelWidget;
    protected cgu resetWidget;
    protected Function<BaseListEntry, C> createNewInstance;
    protected Supplier<List<T>> defaultValue;
    protected String addTooltip = dej.a((String)"text.cloth-config.list.add", (Object[])new Object[0]);
    protected String removeTooltip = dej.a((String)"text.cloth-config.list.remove", (Object[])new Object[0]);

    @Deprecated
    public BaseListEntry(String fieldName, Supplier<Optional<String[]>> tooltipSupplier, Supplier<List<T>> defaultValue, Function<BaseListEntry, C> createNewInstance, Consumer<List<T>> saveConsumer, String resetButtonKey) {
        this(fieldName, tooltipSupplier, defaultValue, createNewInstance, saveConsumer, resetButtonKey, false);
    }

    public BaseListEntry(String fieldName, Supplier<Optional<String[]>> tooltipSupplier, final Supplier<List<T>> defaultValue, Function<BaseListEntry, C> createNewInstance, Consumer<List<T>> saveConsumer, String resetButtonKey, boolean requiresRestart) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.cells = Lists.newArrayList();
        this.labelWidget = new ListLabelWidget();
        this.widgets = Lists.newArrayList((Object[])new chr[]{this.labelWidget});
        this.resetWidget = new cgu(2131321, 0, 0, cft.s().l.a(dej.a((String)resetButtonKey, (Object[])new Object[0])) + 6, 20, dej.a((String)resetButtonKey, (Object[])new Object[0])){

            public void a(double mouseX, double mouseY) {
                super.a(mouseX, mouseY);
                BaseListEntry.this.widgets.removeAll(BaseListEntry.this.cells);
                BaseListEntry.this.cells.clear();
                ((List)defaultValue.get()).stream().map(t -> BaseListEntry.this.getFromValue(t)).forEach(BaseListEntry.this.cells::add);
                BaseListEntry.this.widgets.addAll(BaseListEntry.this.cells);
                BaseListEntry.this.getScreen().setEdited(true, BaseListEntry.this.isRequiresRestart());
            }
        };
        this.widgets.add((chr)this.resetWidget);
        this.saveConsumer = saveConsumer;
        this.createNewInstance = createNewInstance;
        this.defaultValue = defaultValue;
    }

    protected abstract C getFromValue(T var1);

    public Function<BaseListEntry, C> getCreateNewInstance() {
        return this.createNewInstance;
    }

    public void setCreateNewInstance(Function<BaseListEntry, C> createNewInstance) {
        this.createNewInstance = createNewInstance;
    }

    public String getAddTooltip() {
        return this.addTooltip;
    }

    public void setAddTooltip(String addTooltip) {
        this.addTooltip = addTooltip;
    }

    public String getRemoveTooltip() {
        return this.removeTooltip;
    }

    public void setRemoveTooltip(String removeTooltip) {
        this.removeTooltip = removeTooltip;
    }

    @Override
    public Optional<List<T>> getDefaultValue() {
        return Optional.ofNullable(this.defaultValue.get());
    }

    @Override
    public int getItemHeight() {
        if (this.expended) {
            int i = 24;
            for (BaseListCell entry : this.cells) {
                i += entry.getCellHeight();
            }
            return i;
        }
        return 24;
    }

    @Override
    public List<? extends chr> getChildren() {
        return this.widgets;
    }

    @Override
    public Optional<String> getError() {
        Object error = null;
        for (BaseListCell entry : this.cells) {
            if (!entry.getError().isPresent()) continue;
            if (error != null) {
                return Optional.ofNullable(dej.a((String)"text.cloth-config.multi_error", (Object[])new Object[0]));
            }
            return Optional.ofNullable(entry.getError().get());
        }
        return Optional.ofNullable(error);
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
        ((ListLabelWidget)this.labelWidget).rectangle.x = x - 15;
        ((ListLabelWidget)this.labelWidget).rectangle.y = y;
        ((ListLabelWidget)this.labelWidget).rectangle.width = entryWidth + 15;
        ((ListLabelWidget)this.labelWidget).rectangle.height = 24;
        return this.labelWidget.rectangle.contains(mouseX, mouseY) && this.getParent().isMouseOver(mouseX, mouseY) && !this.resetWidget.a();
    }

    protected boolean isInsideCreateNew(double mouseX, double mouseY) {
        return mouseX >= (double)(((ListLabelWidget)this.labelWidget).rectangle.x + 12) && mouseY >= (double)(((ListLabelWidget)this.labelWidget).rectangle.y + 3) && mouseX <= (double)(((ListLabelWidget)this.labelWidget).rectangle.x + 12 + 11) && mouseY <= (double)(((ListLabelWidget)this.labelWidget).rectangle.y + 3 + 11);
    }

    protected boolean isInsideDelete(double mouseX, double mouseY) {
        return mouseX >= (double)(((ListLabelWidget)this.labelWidget).rectangle.x + 25) && mouseY >= (double)(((ListLabelWidget)this.labelWidget).rectangle.y + 3) && mouseX <= (double)(((ListLabelWidget)this.labelWidget).rectangle.x + 25 + 11) && mouseY <= (double)(((ListLabelWidget)this.labelWidget).rectangle.y + 3 + 11);
    }

    public Optional<String[]> getTooltip(int mouseX, int mouseY) {
        if (this.addTooltip != null && this.isInsideCreateNew(mouseX, mouseY)) {
            return Optional.of(new String[]{this.addTooltip});
        }
        if (this.removeTooltip != null && this.isInsideDelete(mouseX, mouseY)) {
            return Optional.of(new String[]{this.removeTooltip});
        }
        if (this.getTooltipSupplier() != null) {
            return this.getTooltipSupplier().get();
        }
        return Optional.empty();
    }

    @Override
    public void render(int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
        Optional<String[]> tooltip;
        ((ListLabelWidget)this.labelWidget).rectangle.x = x - 19;
        ((ListLabelWidget)this.labelWidget).rectangle.y = y;
        ((ListLabelWidget)this.labelWidget).rectangle.width = entryWidth + 19;
        ((ListLabelWidget)this.labelWidget).rectangle.height = 24;
        if (this.isMouseInside(mouseX, mouseY, x, y, entryWidth, entryHeight) && (tooltip = this.getTooltip(mouseX, mouseY)).isPresent() && tooltip.get().length > 0) {
            this.getScreen().queueTooltip(QueuedTooltip.create(new Point(mouseX, mouseY), tooltip.get()));
        }
        cft.s().E().a(CONFIG_TEX);
        cfr.a();
        cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BaseListCell focused = !this.expended || this.getFocused() == null || !(this.getFocused() instanceof BaseListCell) ? null : (BaseListCell)this.getFocused();
        boolean insideCreateNew = this.isInsideCreateNew(mouseX, mouseY);
        boolean insideDelete = this.isInsideDelete(mouseX, mouseY);
        this.b(x - 15, y + 4, 33, (this.labelWidget.rectangle.contains(mouseX, mouseY) && !insideCreateNew && !insideDelete ? 18 : 0) + (this.expended ? 9 : 0), 9, 9);
        this.b(x - 15 + 13, y + 4, 42, insideCreateNew ? 9 : 0, 9, 9);
        this.b(x - 15 + 26, y + 4, 51, focused == null ? 0 : (insideDelete ? 18 : 9), 9, 9);
        this.resetWidget.h = x + entryWidth - this.resetWidget.b();
        this.resetWidget.i = y;
        this.resetWidget.l = this.isEditable() && this.getDefaultValue().isPresent();
        this.resetWidget.a(mouseX, mouseY, delta);
        cft.s().l.a(dej.a((String)this.getFieldName(), (Object[])new Object[0]), (float)(x + 24), (float)(y + 5), this.labelWidget.rectangle.contains(mouseX, mouseY) && !this.resetWidget.a() && !insideDelete && !insideCreateNew ? -1638890 : -1);
        if (this.expended) {
            int yy = y + 24;
            for (BaseListCell cell : this.cells) {
                cell.render(-1, yy, x + 14, entryWidth - 14, cell.getCellHeight(), mouseX, mouseY, this.getParent().getFocused() != null && this.getParent().getFocused().equals((Object)this) && this.getFocused() != null && this.getFocused().equals((Object)cell), delta);
                yy += cell.getCellHeight();
            }
        }
    }

    public class ListLabelWidget
    implements chr {
        private Rectangle rectangle = new Rectangle();

        public boolean mouseClicked(double double_1, double double_2, int int_1) {
            if (BaseListEntry.this.resetWidget.a()) {
                return false;
            }
            if (BaseListEntry.this.isInsideCreateNew(double_1, double_2)) {
                BaseListEntry.this.expended = true;
                BaseListCell cell = (BaseListCell)((Object)BaseListEntry.this.createNewInstance.apply(BaseListEntry.this));
                BaseListEntry.this.cells.add(0, cell);
                BaseListEntry.this.widgets.add(0, (chr)cell);
                BaseListEntry.this.getScreen().setEdited(true, BaseListEntry.this.isRequiresRestart());
                cft.s().N().a((dfw)dfs.a((wi)wj.kj, (float)1.0f));
                return true;
            }
            if (BaseListEntry.this.isInsideDelete(double_1, double_2)) {
                BaseListCell focused;
                BaseListCell baseListCell = focused = !BaseListEntry.this.expended && BaseListEntry.this.getFocused() == null || !(BaseListEntry.this.getFocused() instanceof BaseListCell) ? null : (BaseListCell)BaseListEntry.this.getFocused();
                if (focused != null) {
                    BaseListEntry.this.cells.remove((Object)focused);
                    BaseListEntry.this.widgets.remove((Object)focused);
                    BaseListEntry.this.getScreen().setEdited(true, BaseListEntry.this.isRequiresRestart());
                    cft.s().N().a((dfw)dfs.a((wi)wj.kj, (float)1.0f));
                }
                return true;
            }
            if (this.rectangle.contains(double_1, double_2)) {
                BaseListEntry.this.expended = !BaseListEntry.this.expended;
                cft.s().N().a((dfw)dfs.a((wi)wj.kj, (float)1.0f));
                return true;
            }
            return false;
        }
    }
}

