/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.reiclothconfig2.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.datafixers.util.Pair;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.shedaniel.reiclothconfig2.api.AbstractConfigEntry;
import me.shedaniel.reiclothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.reiclothconfig2.api.MouseUtils;
import me.shedaniel.reiclothconfig2.api.QueuedTooltip;
import me.shedaniel.reiclothconfig2.gui.ClothConfigTabButton;
import me.shedaniel.reiclothconfig2.gui.ClothRequiresRestartScreen;
import me.shedaniel.reiclothconfig2.gui.widget.DynamicElementListWidget;

public abstract class ClothConfigScreen
extends ckd {
    private static final pc CONFIG_TEX = new pc("roughlyenoughitems", "textures/gui/cloth_config.png");
    private final List<QueuedTooltip> queuedTooltips = Lists.newArrayList();
    public int nextTabIndex;
    public int selectedTabIndex;
    public double tabsScrollVelocity = 0.0;
    public double tabsScrollProgress = 0.0;
    public ListWidget listWidget;
    private ckd parent;
    private LinkedHashMap<String, List<AbstractConfigEntry>> tabbedEntries;
    private List<Pair<String, Integer>> tabs;
    private boolean edited;
    private boolean requiresRestart;
    private boolean confirmSave;
    private cgu buttonQuit;
    private cgu buttonSave;
    private cgu buttonLeftTab;
    private cgu buttonRightTab;
    private Rectangle tabsBounds;
    private Rectangle tabsLeftBounds;
    private Rectangle tabsRightBounds;
    private String title;
    private double tabsMaximumScrolled = -1.0;
    private boolean displayErrors;
    private List<ClothConfigTabButton> tabButtons;
    private boolean smoothScrollingTabs = true;
    private boolean smoothScrollingList = true;
    private pc defaultBackgroundLocation;
    private Map<String, pc> categoryBackgroundLocation;

    public ClothConfigScreen(ckd parent, String title, Map<String, List<Pair<String, Object>>> o, boolean confirmSave, boolean displayErrors, boolean smoothScrollingList, pc defaultBackgroundLocation, Map<String, pc> categoryBackgroundLocation) {
        this.parent = parent;
        this.title = title;
        this.tabbedEntries = Maps.newLinkedHashMap();
        this.smoothScrollingList = smoothScrollingList;
        this.defaultBackgroundLocation = defaultBackgroundLocation;
        o.forEach((tab, pairs) -> {
            ArrayList list = Lists.newArrayList();
            for (Pair pair : pairs) {
                if (pair.getSecond() instanceof AbstractConfigListEntry) {
                    list.add((AbstractConfigListEntry)((Object)((Object)pair.getSecond())));
                    continue;
                }
                throw new IllegalArgumentException("Unsupported Type (" + (String)pair.getFirst() + "): " + pair.getSecond().getClass().getSimpleName());
            }
            list.forEach(entry -> entry.setScreen(this));
            this.tabbedEntries.put((String)tab, list);
        });
        this.nextTabIndex = 0;
        this.selectedTabIndex = 0;
        this.confirmSave = confirmSave;
        this.edited = false;
        this.requiresRestart = false;
        cgk fontRenderer = cft.s().l;
        this.tabs = this.tabbedEntries.keySet().stream().map(s -> new Pair(s, (Object)(fontRenderer.a(dej.a((String)s, (Object[])new Object[0])) + 8))).collect(Collectors.toList());
        this.tabsScrollProgress = 0.0;
        this.tabButtons = Lists.newArrayList();
        this.displayErrors = displayErrors;
        this.categoryBackgroundLocation = categoryBackgroundLocation;
    }

    public void f() {
        super.f();
        for (chr child : this.b()) {
            if (!(child instanceof pt)) continue;
            ((pt)child).Y_();
        }
    }

    public pc getBackgroundLocation() {
        if (this.categoryBackgroundLocation.containsKey(Lists.newArrayList(this.tabbedEntries.keySet()).get(this.selectedTabIndex))) {
            return this.categoryBackgroundLocation.get(Lists.newArrayList(this.tabbedEntries.keySet()).get(this.selectedTabIndex));
        }
        return this.defaultBackgroundLocation;
    }

    public boolean isSmoothScrollingList() {
        return this.smoothScrollingList;
    }

    public void setSmoothScrollingList(boolean smoothScrollingList) {
        this.smoothScrollingList = smoothScrollingList;
    }

    public boolean isSmoothScrollingTabs() {
        return this.smoothScrollingTabs;
    }

    public void setSmoothScrollingTabs(boolean smoothScrolling) {
        this.smoothScrollingTabs = smoothScrolling;
    }

    public boolean isEdited() {
        return this.edited;
    }

    @Deprecated
    public void setEdited(boolean edited) {
        this.edited = edited;
        this.buttonQuit.j = edited ? dej.a((String)"text.cloth-config.cancel_discard", (Object[])new Object[0]) : dej.a((String)"gui.cancel", (Object[])new Object[0]);
        this.buttonSave.l = edited;
    }

    public void setEdited(boolean edited, boolean requiresRestart) {
        this.setEdited(edited);
        if (!this.requiresRestart && requiresRestart) {
            this.requiresRestart = requiresRestart;
        }
    }

    protected void c() {
        super.c();
        this.j.clear();
        this.tabButtons.clear();
        if (this.listWidget != null) {
            this.tabbedEntries.put((String)this.tabs.get(this.selectedTabIndex).getFirst(), this.listWidget.b());
        }
        this.selectedTabIndex = this.nextTabIndex;
        this.listWidget = new ListWidget(this.k, this.m, this.n, 70, this.n - 32, this.getBackgroundLocation());
        this.j.add(this.listWidget);
        this.listWidget.setSmoothScrolling(this.smoothScrollingList);
        if (this.tabbedEntries.size() > this.selectedTabIndex) {
            ((List)Lists.newArrayList(this.tabbedEntries.values()).get(this.selectedTabIndex)).forEach(entry -> this.listWidget.b().add((AbstractConfigEntry)((Object)entry)));
        }
        this.buttonQuit = new cgu(312312, this.m / 2 - 154, this.n - 26, 150, 20, this.edited ? dej.a((String)"text.cloth-config.cancel_discard", (Object[])new Object[0]) : dej.a((String)"gui.cancel", (Object[])new Object[0])){

            public void a(double diawd, double djwaidw) {
                super.a(diawd, djwaidw);
                if (ClothConfigScreen.this.confirmSave && ClothConfigScreen.this.edited) {
                    ClothConfigScreen.this.k.a((ckd)new cjj((cji)new QuitSaveConsumer(), dej.a((String)"text.cloth-config.quit_config", (Object[])new Object[0]), dej.a((String)"text.cloth-config.quit_config_sure", (Object[])new Object[0]), dej.a((String)"text.cloth-config.quit_discard", (Object[])new Object[0]), dej.a((String)"gui.cancel", (Object[])new Object[0]), 939183));
                } else {
                    ClothConfigScreen.this.k.a(ClothConfigScreen.this.parent);
                }
            }
        };
        this.a(this.buttonQuit);
        this.buttonSave = new cgu(312321, this.m / 2 + 4, this.n - 26, 150, 20, ""){

            public void a(double diawd, double djwaidw) {
                super.a(diawd, djwaidw);
                LinkedHashMap map = Maps.newLinkedHashMap();
                ClothConfigScreen.this.tabbedEntries.forEach((s, abstractListEntries) -> {
                    List list = abstractListEntries.stream().map(entry -> new Pair((Object)entry.getFieldName(), entry.getValue())).collect(Collectors.toList());
                    map.put(s, list);
                });
                for (List entries : Lists.newArrayList(ClothConfigScreen.this.tabbedEntries.values())) {
                    for (AbstractConfigEntry entry : entries) {
                        entry.save();
                    }
                }
                ClothConfigScreen.this.onSave(map);
                if (ClothConfigScreen.this.requiresRestart) {
                    ClothConfigScreen.this.k.a((ckd)new ClothRequiresRestartScreen(ClothConfigScreen.this.parent));
                } else {
                    ClothConfigScreen.this.k.a(ClothConfigScreen.this.parent);
                }
            }

            public void a(int int_1, int int_2, float float_1) {
                boolean hasErrors = false;
                if (ClothConfigScreen.this.displayErrors) {
                    for (List entries : Lists.newArrayList(ClothConfigScreen.this.tabbedEntries.values())) {
                        for (AbstractConfigEntry entry : entries) {
                            if (!entry.getError().isPresent()) continue;
                            hasErrors = true;
                            break;
                        }
                        if (!hasErrors) continue;
                        break;
                    }
                }
                this.l = ClothConfigScreen.this.edited && !hasErrors;
                this.j = ClothConfigScreen.this.displayErrors && hasErrors ? dej.a((String)"text.cloth-config.error_cannot_save", (Object[])new Object[0]) : dej.a((String)"text.cloth-config.save_and_done", (Object[])new Object[0]);
                super.a(int_1, int_2, float_1);
            }
        };
        this.a(this.buttonSave);
        this.buttonSave.l = this.edited;
        this.tabsBounds = new Rectangle(0, 41, this.m, 24);
        this.tabsLeftBounds = new Rectangle(0, 41, 18, 24);
        this.tabsRightBounds = new Rectangle(this.m - 18, 41, 18, 24);
        this.buttonLeftTab = new cgu(23123214, 4, 44, 12, 18, ""){

            public void a(double diawd, double djwaidw) {
                super.a(diawd, djwaidw);
                ClothConfigScreen.this.tabsScrollProgress = -2.147483648E9;
                ClothConfigScreen.this.tabsScrollVelocity = 0.0;
                ClothConfigScreen.this.clampTabsScrolled();
            }

            public void a(int mouseX, int mouseY, float float_1) {
                ClothConfigScreen.this.k.E().a(CONFIG_TEX);
                this.n = mouseX >= this.h && mouseY >= this.i && mouseX < this.h + this.f && mouseY < this.i + this.g;
                cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int int_3 = this.a(this.n);
                cua.m();
                cua.a((cua.r)cua.r.l, (cua.l)cua.l.j, (cua.r)cua.r.e, (cua.l)cua.l.n);
                cua.a((cua.r)cua.r.l, (cua.l)cua.l.j);
                this.b(this.h, this.i, 12, 18 * int_3, this.f, this.g);
            }
        };
        this.j.add(this.buttonLeftTab);
        int j = 0;
        for (Pair<String, Integer> tab : this.tabs) {
            this.tabButtons.add(new ClothConfigTabButton(this, j, -100, 43, (Integer)tab.getSecond(), 20, dej.a((String)((String)tab.getFirst()), (Object[])new Object[0])));
            ++j;
        }
        this.tabButtons.forEach(this.j::add);
        this.buttonRightTab = new cgu(31321313, this.m - 16, 44, 12, 18, ""){

            public void a(double diawd, double djwaidw) {
                super.a(diawd, djwaidw);
                ClothConfigScreen.this.tabsScrollProgress = 2.147483647E9;
                ClothConfigScreen.this.tabsScrollVelocity = 0.0;
                ClothConfigScreen.this.clampTabsScrolled();
            }

            public void a(int mouseX, int mouseY, float float_1) {
                ClothConfigScreen.this.k.E().a(CONFIG_TEX);
                this.n = mouseX >= this.h && mouseY >= this.i && mouseX < this.h + this.f && mouseY < this.i + this.g;
                cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int int_3 = this.a(this.n);
                cua.m();
                cua.a((cua.r)cua.r.l, (cua.l)cua.l.j, (cua.r)cua.r.e, (cua.l)cua.l.n);
                cua.a((cua.r)cua.r.l, (cua.l)cua.l.j);
                this.b(this.h, this.i, 0, 18 * int_3, this.f, this.g);
            }
        };
        this.j.add(this.buttonRightTab);
    }

    public boolean mouseScrolled(double double_3) {
        Point location = MouseUtils.getMouseLocation();
        if (this.tabsBounds.contains(location) && !this.tabsLeftBounds.contains(location) && !this.tabsRightBounds.contains(location) && double_3 != 0.0) {
            if (double_3 < 0.0) {
                this.tabsScrollVelocity += 16.0;
            }
            if (double_3 > 0.0) {
                this.tabsScrollVelocity -= 16.0;
            }
            return true;
        }
        if (this.listWidget.isMouseOver(location.x, location.y) && this.listWidget.mouseScrolled(double_3)) {
            return true;
        }
        return super.mouseScrolled(double_3);
    }

    public double getTabsMaximumScrolled() {
        if (this.tabsMaximumScrolled == -1.0) {
            AtomicDouble d = new AtomicDouble();
            this.tabs.forEach(pair -> d.addAndGet((double)((Integer)pair.getSecond() + 2)));
            this.tabsMaximumScrolled = d.get();
        }
        return this.tabsMaximumScrolled;
    }

    public void resetTabsMaximumScrolled() {
        this.tabsMaximumScrolled = -1.0;
        this.tabsScrollVelocity = 0.0;
    }

    public void clampTabsScrolled() {
        int xx = 0;
        for (ClothConfigTabButton tabButton : this.tabButtons) {
            xx += tabButton.b() + 2;
        }
        this.tabsScrollProgress = xx > this.m - 40 ? xq.a((double)this.tabsScrollProgress, (double)0.0, (double)(this.getTabsMaximumScrolled() - (double)this.m + 40.0)) : 0.0;
    }

    public void a(int int_1, int int_2, float float_1) {
        if (this.smoothScrollingTabs) {
            double change = this.tabsScrollVelocity * (double)0.2f;
            if (change != 0.0) {
                if (change > 0.0 && change < 0.2) {
                    change = 0.2;
                } else if (change < 0.0 && change > -0.2) {
                    change = -0.2;
                }
                this.tabsScrollProgress += change;
                this.tabsScrollVelocity -= change;
                if (change > 0.0 == this.tabsScrollVelocity < 0.0) {
                    this.tabsScrollVelocity = 0.0;
                }
                this.clampTabsScrolled();
            }
        } else {
            this.tabsScrollProgress += this.tabsScrollVelocity;
            this.tabsScrollVelocity = 0.0;
            this.clampTabsScrolled();
        }
        int xx = 20 - (int)this.tabsScrollProgress;
        for (ClothConfigTabButton tabButton : this.tabButtons) {
            tabButton.h = xx;
            xx += tabButton.b() + 2;
        }
        this.buttonLeftTab.l = this.tabsScrollProgress > 0.0;
        this.buttonRightTab.l = this.tabsScrollProgress < this.getTabsMaximumScrolled() - (double)this.m + 40.0;
        this.c(0);
        this.listWidget.b().forEach(o -> {
            if (o instanceof AbstractConfigEntry) {
                ((AbstractConfigEntry)((Object)((Object)o))).setScreen(this);
            }
        });
        this.listWidget.render(int_1, int_2, float_1);
        this.overlayBackground(this.tabsBounds, 32, 32, 32, 255, 255);
        this.a(this.k.l, this.title, this.m / 2, 18, -1);
        this.tabButtons.forEach(widget -> widget.a(int_1, int_2, float_1));
        this.overlayBackground(this.tabsLeftBounds, 64, 64, 64, 255, 255);
        this.overlayBackground(this.tabsRightBounds, 64, 64, 64, 255, 255);
        this.drawShades();
        this.buttonLeftTab.a(int_1, int_2, float_1);
        this.buttonRightTab.a(int_1, int_2, float_1);
        if (this.displayErrors && this.isEditable()) {
            ArrayList errors = Lists.newArrayList();
            for (List entries : Lists.newArrayList(this.tabbedEntries.values())) {
                for (AbstractConfigEntry entry : entries) {
                    if (!entry.getError().isPresent()) continue;
                    errors.add(entry.getError().get());
                }
            }
            if (errors.size() > 0) {
                this.k.E().a(CONFIG_TEX);
                cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.b(10, 10, 0, 54, 3, 11);
                if (errors.size() == 1) {
                    this.c(this.k.l, "\u00a7c" + (String)errors.get(0), 18, 12, -1);
                } else {
                    this.c(this.k.l, "\u00a7c" + dej.a((String)"text.cloth-config.multi_error", (Object[])new Object[0]), 18, 12, -1);
                }
            }
        } else if (!this.isEditable()) {
            this.k.E().a(CONFIG_TEX);
            cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.b(10, 10, 0, 54, 3, 11);
            this.c(this.k.l, "\u00a7c" + dej.a((String)"text.cloth-config.not_editable", (Object[])new Object[0]), 18, 12, -1);
        }
        super.a(int_1, int_2, float_1);
        this.queuedTooltips.forEach(queuedTooltip -> this.a(queuedTooltip.getText(), queuedTooltip.getX(), queuedTooltip.getY()));
        this.queuedTooltips.clear();
    }

    public void queueTooltip(QueuedTooltip queuedTooltip) {
        this.queuedTooltips.add(queuedTooltip);
    }

    private void drawShades() {
        cua.m();
        cua.a((cua.r)cua.r.l, (cua.l)cua.l.j, (cua.r)cua.r.o, (cua.l)cua.l.e);
        cua.d();
        cua.j((int)7425);
        cua.z();
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        buffer.a(7, ddu.o);
        buffer.b(this.tabsBounds.getMinX() + 20.0, this.tabsBounds.getMinY() + 4.0, 0.0).a(0.0, 1.0).b(0, 0, 0, 0).d();
        buffer.b(this.tabsBounds.getMaxX() - 20.0, this.tabsBounds.getMinY() + 4.0, 0.0).a(1.0, 1.0).b(0, 0, 0, 0).d();
        buffer.b(this.tabsBounds.getMaxX() - 20.0, this.tabsBounds.getMinY(), 0.0).a(1.0, 0.0).b(0, 0, 0, 255).d();
        buffer.b(this.tabsBounds.getMinX() + 20.0, this.tabsBounds.getMinY(), 0.0).a(0.0, 0.0).b(0, 0, 0, 255).d();
        tessellator.b();
        buffer.a(7, ddu.o);
        buffer.b(this.tabsBounds.getMinX() + 20.0, this.tabsBounds.getMaxY(), 0.0).a(0.0, 1.0).b(0, 0, 0, 255).d();
        buffer.b(this.tabsBounds.getMaxX() - 20.0, this.tabsBounds.getMaxY(), 0.0).a(1.0, 1.0).b(0, 0, 0, 255).d();
        buffer.b(this.tabsBounds.getMaxX() - 20.0, this.tabsBounds.getMaxY() - 4.0, 0.0).a(1.0, 0.0).b(0, 0, 0, 0).d();
        buffer.b(this.tabsBounds.getMinX() + 20.0, this.tabsBounds.getMaxY() - 4.0, 0.0).a(0.0, 0.0).b(0, 0, 0, 0).d();
        tessellator.b();
        cua.y();
        cua.j((int)7424);
        cua.e();
        cua.l();
    }

    protected void overlayBackground(Rectangle rect, int red, int green, int blue, int startAlpha, int endAlpha) {
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        this.k.E().a(this.getBackgroundLocation());
        cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float f = 32.0f;
        buffer.a(7, ddu.o);
        buffer.b(rect.getMinX(), rect.getMaxY(), 0.0).a(rect.getMinX() / 32.0, rect.getMaxY() / 32.0).b(red, green, blue, endAlpha).d();
        buffer.b(rect.getMaxX(), rect.getMaxY(), 0.0).a(rect.getMaxX() / 32.0, rect.getMaxY() / 32.0).b(red, green, blue, endAlpha).d();
        buffer.b(rect.getMaxX(), rect.getMinY(), 0.0).a(rect.getMaxX() / 32.0, rect.getMinY() / 32.0).b(red, green, blue, startAlpha).d();
        buffer.b(rect.getMinX(), rect.getMinY(), 0.0).a(rect.getMinX() / 32.0, rect.getMinY() / 32.0).b(red, green, blue, startAlpha).d();
        tessellator.b();
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 256 && this.ah_()) {
            if (this.confirmSave && this.edited) {
                this.k.a((ckd)new cjj((cji)new QuitSaveConsumer(), dej.a((String)"text.cloth-config.quit_config", (Object[])new Object[0]), dej.a((String)"text.cloth-config.quit_config_sure", (Object[])new Object[0]), dej.a((String)"text.cloth-config.quit_discard", (Object[])new Object[0]), dej.a((String)"gui.cancel", (Object[])new Object[0]), 1));
            } else {
                this.k.a(this.parent);
            }
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    public abstract void onSave(Map<String, List<Pair<String, Object>>> var1);

    public boolean isEditable() {
        return true;
    }

    public class ListWidget
    extends DynamicElementListWidget {
        public ListWidget(cft client, int width, int height, int top, int bottom, pc backgroundLocation) {
            super(client, width, height, top, bottom, backgroundLocation);
            this.visible = false;
        }

        @Override
        public int getItemWidth() {
            return this.width - 80;
        }

        public ClothConfigScreen getScreen() {
            return ClothConfigScreen.this;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.width - 36;
        }

        protected final void clearStuff() {
            this.clearItems();
        }
    }

    private class QuitSaveConsumer
    implements cji {
        private QuitSaveConsumer() {
        }

        public void confirmResult(boolean t, int id) {
            if (!t) {
                ClothConfigScreen.this.k.a((ckd)ClothConfigScreen.this);
            } else {
                ClothConfigScreen.this.k.a(ClothConfigScreen.this.parent);
            }
        }
    }
}

