/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.utils;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.rei.RoughlyEnoughItemsClient;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.api.ScreenHooks;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.config.ItemCheatingMode;
import me.shedaniel.rei.gui.config.ItemListOrderingConfig;
import me.shedaniel.rei.gui.config.RecipeScreenType;
import me.shedaniel.rei.gui.credits.CreditsScreen;
import me.shedaniel.reiclothconfig2.api.ConfigBuilder;
import me.shedaniel.reiclothconfig2.api.ConfigCategory;
import me.shedaniel.reiclothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.reiclothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.reiclothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.reiclothconfig2.gui.entries.IntegerSliderEntry;
import me.shedaniel.reiclothconfig2.gui.entries.StringListEntry;

public class ClothScreenRegistry {
    public static final String RESET = "text.cloth-config.reset_value";

    public static ckd getConfigScreen(ckd parent) {
        ConfigManager configManager = RoughlyEnoughItemsClient.getConfigManager();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle("text.rei.config.title").setSavingRunnable(() -> {
            try {
                configManager.saveConfig();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        ConfigEntryBuilder eb = ConfigEntryBuilder.create();
        ConfigCategory general = builder.getOrCreateCategory("text.rei.config.general");
        general.addEntry(new BooleanListEntry("text.rei.config.cheating", configManager.getConfig().cheating, RESET, () -> false, bool -> {
            configManager.getConfig().cheating = bool;
        }){

            @Override
            public Optional<String[]> getTooltip() {
                String s = null;
                s = this.getValue() == false ? dej.a((String)"text.rei.cheating_disabled", (Object[])new Object[0]) : (cft.s().x() ? dej.a((String)"text.rei.cheating_enabled", (Object[])new Object[0]) : dej.a((String)"text.rei.cheating_limited_enabled", (Object[])new Object[0]));
                return Optional.ofNullable(new String[]{s});
            }
        });
        ConfigCategory appearance = builder.getOrCreateCategory("text.rei.config.appearance");
        appearance.addEntry(eb.startBooleanToggle("text.rei.config.dark_theme", ScreenHelper.isDarkModeEnabled()).setDefaultValue(() -> false).setSaveConsumer(bool -> {
            configManager.getConfig().darkTheme = bool;
        }).setTooltipSupplier(() -> ClothScreenRegistry.getConfigTooltip("dark_theme", new Object[0])).buildEntry());
        appearance.addEntry(eb.startEnumSelector("text.rei.config.recipe_screen_type", RecipeScreenType.class, configManager.getConfig().screenType).setDefaultValue((RecipeScreenType)((Object)((Supplier<RecipeScreenType>)() -> RecipeScreenType.UNSET))).setSaveConsumer(bool -> {
            configManager.getConfig().screenType = (RecipeScreenType)((Object)((Object)bool));
        }).setTooltipSupplier(() -> ClothScreenRegistry.getConfigTooltip("recipe_screen_type", new Object[0])).buildEntry());
        appearance.addEntry(eb.startBooleanToggle("text.rei.config.side_search_box", configManager.getConfig().sideSearchField).setDefaultValue(() -> false).setSaveConsumer(bool -> {
            configManager.getConfig().sideSearchField = bool;
        }).setTooltipSupplier(() -> ClothScreenRegistry.getConfigTooltip("side_search_box", new Object[0])).buildEntry());
        appearance.addEntry(eb.startEnumSelector("text.rei.config.list_ordering", ItemListOrderingConfig.class, ItemListOrderingConfig.from(configManager.getConfig().itemListOrdering, configManager.getConfig().isAscending)).setDefaultValue((ItemListOrderingConfig)((Object)((Supplier<ItemListOrderingConfig>)() -> ItemListOrderingConfig.REGISTRY_ASCENDING))).setSaveConsumer(config -> {
            configManager.getConfig().itemListOrdering = ((ItemListOrderingConfig)((Object)((Object)config))).getOrdering();
            configManager.getConfig().isAscending = ((ItemListOrderingConfig)((Object)((Object)config))).isAscending();
        }).setTooltipSupplier(() -> ClothScreenRegistry.getConfigTooltip("list_ordering", ItemListOrderingConfig.REGISTRY_ASCENDING.toString())).buildEntry());
        appearance.addEntry(eb.startBooleanToggle("text.rei.config.item_list_position", configManager.getConfig().mirrorItemPanel).setDefaultValue(() -> false).setYesNoTextSupplier(bool -> dej.a((String)(bool != false ? "text.rei.config.item_list_position.left" : "text.rei.config.item_list_position.right"), (Object[])new Object[0])).setSaveConsumer(bool -> {
            configManager.getConfig().mirrorItemPanel = bool;
        }).buildEntry());
        appearance.addEntry(new IntegerSliderEntry("text.rei.config.max_recipes_per_page", 2, 99, configManager.getConfig().maxRecipePerPage, RESET, () -> 3, i -> {
            configManager.getConfig().maxRecipePerPage = i;
        }, () -> ClothScreenRegistry.getConfigTooltip("max_recipes_per_page", new Object[0])));
        appearance.addEntry(new BooleanListEntry("text.rei.config.light_gray_recipe_border", configManager.getConfig().lightGrayRecipeBorder, RESET, () -> false, bool -> {
            configManager.getConfig().lightGrayRecipeBorder = bool;
        }, () -> ClothScreenRegistry.getConfigTooltip("light_gray_recipe_border", new Object[0])));
        appearance.addEntry(new BooleanListEntry("text.rei.config.villager_screen_permanent_scroll_bar", configManager.getConfig().villagerScreenPermanentScrollBar, RESET, () -> false, bool -> {
            configManager.getConfig().villagerScreenPermanentScrollBar = bool;
        }, () -> ClothScreenRegistry.getConfigTooltip("villager_screen_permanent_scroll_bar", new Object[0])));
        ConfigCategory action = builder.getOrCreateCategory("text.rei.config.action");
        action.addEntry(new EnumListEntry<ItemCheatingMode>("text.rei.config.item_cheating_mode", ItemCheatingMode.class, configManager.getConfig().itemCheatingMode, RESET, () -> ItemCheatingMode.REI_LIKE, i -> {
            configManager.getConfig().itemCheatingMode = i;
        }, e -> dej.a((String)("text.rei.config.item_cheating_mode." + e.name().toLowerCase(Locale.ROOT)), (Object[])new Object[0]), () -> ClothScreenRegistry.getConfigTooltip("item_cheating_mode", new Object[0])));
        action.addEntry(new StringListEntry("text.rei.give_command", configManager.getConfig().giveCommand, RESET, () -> "/give {player_name} {item_identifier}{nbt} {count}", s -> {
            configManager.getConfig().giveCommand = s;
        }, () -> ClothScreenRegistry.getConfigTooltip("give_command", new Object[0])));
        action.addEntry(new StringListEntry("text.rei.gamemode_command", configManager.getConfig().gamemodeCommand, RESET, () -> "/gamemode {gamemode}", s -> {
            configManager.getConfig().gamemodeCommand = s;
        }, () -> ClothScreenRegistry.getConfigTooltip("gamemode_command", new Object[0])));
        action.addEntry(new StringListEntry("text.rei.weather_command", configManager.getConfig().weatherCommand, RESET, () -> "/weather {weather}", s -> {
            configManager.getConfig().weatherCommand = s;
        }, () -> ClothScreenRegistry.getConfigTooltip("weather_command", new Object[0])));
        action.addEntry(new BooleanListEntry("text.rei.config.register_in_other_thread", configManager.getConfig().registerRecipesInAnotherThread, RESET, () -> true, bool -> {
            configManager.getConfig().registerRecipesInAnotherThread = bool;
        }, () -> ClothScreenRegistry.getConfigTooltip("register_in_other_thread", new Object[0])));
        ConfigCategory modules = builder.getOrCreateCategory("text.rei.config.modules");
        modules.addEntry(new BooleanListEntry("text.rei.config.enable_craftable_only", configManager.getConfig().enableCraftableOnlyButton, RESET, () -> true, bool -> {
            configManager.getConfig().enableCraftableOnlyButton = bool;
        }, () -> ClothScreenRegistry.getConfigTooltip("enable_craftable_only", new Object[0])));
        modules.addEntry(new BooleanListEntry("text.rei.config.enable_util_buttons", configManager.getConfig().showUtilsButtons, RESET, () -> false, bool -> {
            configManager.getConfig().showUtilsButtons = bool;
        }, () -> ClothScreenRegistry.getConfigTooltip("enable_util_buttons", new Object[0])));
        modules.addEntry(new BooleanListEntry("text.rei.config.disable_recipe_book", configManager.getConfig().disableRecipeBook, RESET, () -> false, bool -> {
            configManager.getConfig().disableRecipeBook = bool;
        }, () -> ClothScreenRegistry.getConfigTooltip("disable_recipe_book", new Object[0])));
        return builder.setAfterInitConsumer(screen -> {
            cgu w = new cgu(14, 6, 6, 60, 20, dej.a((String)"text.rei.credits", (Object[])new Object[0])){

                public void a(double mouseX, double mouseY) {
                    super.a(mouseX, mouseY);
                    cft.s().a((ckd)new CreditsScreen(cft.s().m));
                }
            };
            ((ScreenHooks)screen).cloth_getButtonWidgets().add(0, w);
            ((ScreenHooks)screen).cloth_getChildren().add(0, (chr)w);
        }).build();
    }

    private static Optional<String[]> getConfigTooltip(String s, Object ... o) {
        if (dej.a((String)("tooltip.rei.config." + s))) {
            return Optional.ofNullable(dej.a((String)("tooltip.rei.config." + s), (Object[])o).split("\n"));
        }
        return Optional.empty();
    }

    public static void openConfigScreen() {
        cft.s().a(ClothScreenRegistry.getConfigScreenNullable(cft.s().m));
    }

    public static void openConfigScreen(ckd parent) {
        cft.s().a(ClothScreenRegistry.getConfigScreenNullable(parent));
    }

    public static ckd getConfigScreenNullable(final ckd parent) {
        try {
            return ClothScreenRegistry.getConfigScreen(parent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ckd(){

                public void a(int int_1, int int_2, float float_1) {
                    this.c_(0);
                    List list = this.k.l.c(dej.a((String)"text.rei.config_api_failed", (Object[])new Object[0]), this.m - 100);
                    int y = (int)((float)(this.n / 2) - (float)this.k.l.a * 1.3f / 2.0f * (float)list.size());
                    for (int i = 0; i < list.size(); ++i) {
                        String s = (String)list.get(i);
                        this.a(this.k.l, s, this.m / 2, y, -1);
                        y += this.k.l.a;
                    }
                    super.a(int_1, int_2, float_1);
                }

                protected void c() {
                    super.c();
                    this.a(new cgu(139183, this.m / 2 - 100, this.n - 26, 200, 20, dej.a((String)"text.rei.back", (Object[])new Object[0])){

                        public void a(double mouseX, double mouseY) {
                            super.a(mouseX, mouseY);
                            cft.s().a(parent);
                        }
                    });
                }

                public boolean keyPressed(int int_1, int int_2, int int_3) {
                    if (int_1 == 256 && this.ah_()) {
                        this.k.a(parent);
                        return true;
                    }
                    return super.keyPressed(int_1, int_2, int_3);
                }
            };
        }
    }
}

