/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.google.common.collect.Lists;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsClient;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.client.SearchArgument;
import me.shedaniel.rei.gui.config.ItemCheatingMode;
import me.shedaniel.rei.gui.config.ItemListOrdering;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.reiclothconfig2.api.MouseUtils;
import org.apache.commons.lang3.StringUtils;

public class ItemListOverlay
extends Widget {
    private static final String SPACE = " ";
    private static final String EMPTY = "";
    private static final Comparator<ate> ASCENDING_COMPARATOR;
    private static List<ata> searchBlacklisted;
    private final List<SearchArgument[]> lastSearchArgument;
    private List<ate> currentDisplayed = Lists.newArrayList();
    private List<Widget> widgets;
    private int width = 0;
    private int height = 0;
    private int page;
    private Rectangle rectangle;
    private Rectangle listArea;

    public ItemListOverlay(int page) {
        this.page = page;
        this.lastSearchArgument = Lists.newArrayList();
    }

    public static List<String> tryGetItemStackToolTip(ate itemStack, boolean careAboutAdvanced) {
        if (!searchBlacklisted.contains(itemStack.b())) {
            try {
                return itemStack.a((aog)cft.s().i, (aum)(cft.s().t.z && careAboutAdvanced ? aum.a.b : aum.a.a)).stream().map(ij::e).collect(Collectors.toList());
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(itemStack.b());
            }
        }
        return Collections.singletonList(ItemListOverlay.tryGetItemStackName(itemStack));
    }

    public static String tryGetItemStackName(ate stack) {
        if (!searchBlacklisted.contains(stack.b())) {
            try {
                return stack.q().e();
            }
            catch (Throwable e) {
                e.printStackTrace();
                searchBlacklisted.add(stack.b());
            }
        }
        try {
            return dej.a((String)("item." + fc.s.b((Object)stack.b()).toString().replace(":", ".")), (Object[])new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return "ERROR";
        }
    }

    public static boolean filterItem(ate itemStack, List<SearchArgument[]> arguments) {
        if (arguments.isEmpty()) {
            return true;
        }
        AtomicReference<String> mod = null;
        AtomicReference<String> tooltips = null;
        AtomicReference<String> name = null;
        for (SearchArgument[] arguments1 : arguments) {
            boolean b2 = true;
            for (SearchArgument argument : arguments1) {
                if (argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.ALWAYS)) {
                    return true;
                }
                if (argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.MOD) && argument.getFunction(!argument.isInclude()).apply(ItemListOverlay.fillMod(itemStack, mod)).booleanValue()) {
                    b2 = false;
                    break;
                }
                if (argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.TOOLTIP) && argument.getFunction(!argument.isInclude()).apply(ItemListOverlay.fillTooltip(itemStack, tooltips)).booleanValue()) {
                    b2 = false;
                    break;
                }
                if (!argument.getArgumentType().equals((Object)SearchArgument.ArgumentType.TEXT) || !argument.getFunction(!argument.isInclude()).apply(ItemListOverlay.fillName(itemStack, name)).booleanValue()) continue;
                b2 = false;
                break;
            }
            if (!b2) continue;
            return true;
        }
        return false;
    }

    private static String fillMod(ate itemStack, AtomicReference<String> mod) {
        if (mod == null) {
            mod = new AtomicReference<String>(ClientHelper.getInstance().getModFromItem(itemStack.b()).toLowerCase(Locale.ROOT));
        }
        return mod.get();
    }

    private static String fillTooltip(ate itemStack, AtomicReference<String> mod) {
        if (mod == null) {
            mod = new AtomicReference<String>(ItemListOverlay.tryGetItemStackToolTip(itemStack, false).stream().collect(Collectors.joining(EMPTY)).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
        }
        return mod.get();
    }

    private static String fillName(ate itemStack, AtomicReference<String> mod) {
        if (mod == null) {
            mod = new AtomicReference<String>(ItemListOverlay.tryGetItemStackName(itemStack).replace(SPACE, EMPTY).toLowerCase(Locale.ROOT));
        }
        return mod.get();
    }

    public int getFullTotalSlotsPerPage() {
        return this.width * this.height;
    }

    @Override
    public void render(int int_1, int int_2, float float_1) {
        cfr.a();
        this.widgets.forEach(widget -> widget.render(int_1, int_2, float_1));
        ctj player = this.minecraft.i;
        if (this.rectangle.contains(MouseUtils.getMouseLocation()) && ClientHelper.getInstance().isCheating() && !player.bB.s().a() && cft.s().x()) {
            ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(dej.a((String)"text.rei.delete_items", (Object[])new Object[0])));
        }
    }

    public void updateList(DisplayHelper.DisplayBoundsHandler boundsHandler, Rectangle rectangle, int page, String searchTerm, boolean processSearchTerm) {
        this.rectangle = rectangle;
        this.page = page;
        this.widgets = Lists.newLinkedList();
        this.calculateListSize(rectangle);
        if (this.currentDisplayed.isEmpty() || processSearchTerm) {
            this.currentDisplayed = this.processSearchTerm(searchTerm, RoughlyEnoughItemsCore.getItemRegisterer().getItemList(), new ArrayList<ate>(ScreenHelper.inventoryStacks));
        }
        int startX = (int)rectangle.getCenterX() - this.width * 9;
        int startY = (int)rectangle.getCenterY() - this.height * 9;
        this.listArea = new Rectangle(startX, startY, this.width * 18, this.height * 18);
        int fitSlotsPerPage = this.getTotalFitSlotsPerPage(startX, startY, this.listArea);
        int j2 = page * fitSlotsPerPage;
        for (int yy = 0; yy < this.height; ++yy) {
            for (int xx = 0; xx < this.width; ++xx) {
                int x = startX + xx * 18;
                int y = startY + yy * 18;
                if (!this.canBeFit(x, y, this.listArea)) continue;
                if (++j2 > this.currentDisplayed.size()) break;
                this.widgets.add(new SlotWidget(x, y, Collections.singletonList(this.currentDisplayed.get(j2 - 1)), false, true, true){

                    @Override
                    protected void queueTooltip(ate itemStack, float delta) {
                        ctj player = this.minecraft.i;
                        if (!ClientHelper.getInstance().isCheating() || player.bB.s().a()) {
                            super.queueTooltip(itemStack, delta);
                        }
                    }

                    @Override
                    public boolean mouseClicked(double mouseX, double mouseY, int button) {
                        if (this.isCurrentRendererItem() && this.containsMouse(mouseX, mouseY)) {
                            if (ClientHelper.getInstance().isCheating()) {
                                if (this.getCurrentItemStack() != null && !this.getCurrentItemStack().a()) {
                                    ate cheatedStack = this.getCurrentItemStack().i();
                                    if (RoughlyEnoughItemsClient.getConfigManager().getConfig().itemCheatingMode == ItemCheatingMode.REI_LIKE) {
                                        cheatedStack.e(button != 1 ? 1 : cheatedStack.c());
                                    } else if (RoughlyEnoughItemsClient.getConfigManager().getConfig().itemCheatingMode == ItemCheatingMode.JEI_LIKE) {
                                        cheatedStack.e(button != 0 ? 1 : cheatedStack.c());
                                    } else {
                                        cheatedStack.e(1);
                                    }
                                    return ClientHelper.getInstance().tryCheatingStack(cheatedStack);
                                }
                            } else {
                                if (button == 0) {
                                    return ClientHelper.getInstance().executeRecipeKeyBind(this.getCurrentItemStack().i());
                                }
                                if (button == 1) {
                                    return ClientHelper.getInstance().executeUsageKeyBind(this.getCurrentItemStack().i());
                                }
                            }
                        }
                        return false;
                    }
                });
            }
            if (j2 > this.currentDisplayed.size()) break;
        }
    }

    public int getTotalPage() {
        int fitSlotsPerPage = this.getTotalFitSlotsPerPage(this.listArea.x, this.listArea.y, this.listArea);
        if (fitSlotsPerPage > 0) {
            return xq.f((float)(this.getCurrentDisplayed().size() / fitSlotsPerPage));
        }
        return 0;
    }

    public int getTotalFitSlotsPerPage(int startX, int startY, Rectangle listArea) {
        int slots = 0;
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                if (!this.canBeFit(startX + x * 18, startY + y * 18, listArea)) continue;
                ++slots;
            }
        }
        return slots;
    }

    public boolean canBeFit(int left, int top, Rectangle listArea) {
        for (DisplayHelper.DisplayBoundsHandler<?> sortedBoundsHandler : RoughlyEnoughItemsCore.getDisplayHelper().getSortedBoundsHandlers(this.minecraft.m.getClass())) {
            adm fit = sortedBoundsHandler.canItemSlotWidgetFit(!RoughlyEnoughItemsClient.getConfigManager().getConfig().mirrorItemPanel, left, top, this.minecraft.m, listArea);
            if (fit == adm.b) continue;
            return fit == adm.a;
        }
        return true;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        for (Widget widget : this.widgets) {
            if (!widget.keyPressed(int_1, int_2, int_3)) continue;
            return true;
        }
        return false;
    }

    public Rectangle getListArea() {
        return this.listArea;
    }

    public List<ate> getCurrentDisplayed() {
        return this.currentDisplayed;
    }

    private List<ate> processSearchTerm(String searchTerm, List<ate> ol, List<ate> inventoryItems) {
        this.lastSearchArgument.clear();
        List<Object> os = new LinkedList<ate>(ol);
        if (RoughlyEnoughItemsClient.getConfigManager().getConfig().itemListOrdering != ItemListOrdering.registry) {
            os = ol.stream().sorted(ASCENDING_COMPARATOR).collect(Collectors.toList());
        }
        if (!RoughlyEnoughItemsClient.getConfigManager().getConfig().isAscending) {
            Collections.reverse(os);
        }
        String[] splitSearchTerm = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)searchTerm, (String)"|");
        Arrays.stream(splitSearchTerm).forEachOrdered(s -> {
            String[] split = StringUtils.split((String)s);
            SearchArgument[] arguments = new SearchArgument[split.length];
            for (int i2 = 0; i2 < split.length; ++i2) {
                String s1 = split[i2];
                arguments[i2] = s1.startsWith("@-") || s1.startsWith("-@") ? new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(2), false) : (s1.startsWith("@") ? new SearchArgument(SearchArgument.ArgumentType.MOD, s1.substring(1), true) : (s1.startsWith("#-") || s1.startsWith("-#") ? new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(2), false) : (s1.startsWith("#") ? new SearchArgument(SearchArgument.ArgumentType.TOOLTIP, s1.substring(1), true) : (s1.startsWith("-") ? new SearchArgument(SearchArgument.ArgumentType.TEXT, s1.substring(1), false) : new SearchArgument(SearchArgument.ArgumentType.TEXT, s1, true)))));
            }
            if (arguments.length > 0) {
                this.lastSearchArgument.add(arguments);
            } else {
                this.lastSearchArgument.add(new SearchArgument[]{SearchArgument.ALWAYS});
            }
        });
        List<Object> stacks = Collections.emptyList();
        stacks = this.lastSearchArgument.isEmpty() ? Collections.unmodifiableList(os) : Collections.unmodifiableList(os.stream().filter(itemStack -> ItemListOverlay.filterItem(itemStack, this.lastSearchArgument)).collect(Collectors.toList()));
        if (!RoughlyEnoughItemsClient.getConfigManager().isCraftableOnlyEnabled() || stacks.isEmpty() || inventoryItems.isEmpty()) {
            return stacks;
        }
        ArrayList workingItems = Lists.newArrayList(RecipeHelper.getInstance().findCraftableByItems(inventoryItems));
        return stacks.stream().filter(itemStack -> workingItems.stream().anyMatch(stack -> stack.a(itemStack))).collect(Collectors.toList());
    }

    public List<SearchArgument[]> getLastSearchArgument() {
        return this.lastSearchArgument;
    }

    public void calculateListSize(Rectangle rect) {
        int xOffset = 0;
        int yOffset = 0;
        this.width = 0;
        this.height = 0;
        do {
            xOffset += 18;
            if (this.height == 0) {
                ++this.width;
            }
            if (xOffset + 19 <= rect.width) continue;
            xOffset = 0;
            yOffset += 18;
            ++this.height;
        } while (yOffset + 19 <= rect.height);
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (this.rectangle.contains(double_1, double_2)) {
            ctj player = this.minecraft.i;
            if (ClientHelper.getInstance().isCheating() && !player.bB.s().a() && cft.s().x()) {
                ClientHelper.getInstance().sendDeletePacket();
                return true;
            }
            if (!player.bB.s().a() && cft.s().x()) {
                return false;
            }
            for (Widget widget : this.b()) {
                if (!widget.mouseClicked(double_1, double_2, int_1)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Widget> b() {
        return this.widgets;
    }

    static {
        searchBlacklisted = Lists.newArrayList();
        ASCENDING_COMPARATOR = (itemStack, t1) -> {
            if (RoughlyEnoughItemsClient.getConfigManager().getConfig().itemListOrdering.equals((Object)ItemListOrdering.name)) {
                return ItemListOverlay.tryGetItemStackName(itemStack).compareToIgnoreCase(ItemListOverlay.tryGetItemStackName(t1));
            }
            if (RoughlyEnoughItemsClient.getConfigManager().getConfig().itemListOrdering.equals((Object)ItemListOrdering.item_groups)) {
                List<ary> itemGroups = Arrays.asList(ary.a);
                return itemGroups.indexOf(itemStack.b().q()) - itemGroups.indexOf(t1.b().q());
            }
            return 0;
        };
    }
}

