/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.Optional;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.widget.LabelWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;

public abstract class ClickableLabelWidget
extends LabelWidget {
    public boolean clickable;

    public ClickableLabelWidget(int x, int y, String text, boolean clickable) {
        super(x, y, text);
        this.clickable = clickable;
    }

    public ClickableLabelWidget(int x, int y, String text) {
        this(x, y, text, true);
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        int colour = this.getDefaultColor();
        if (this.clickable && this.isHovered(mouseX, mouseY)) {
            colour = this.getHoveredColor();
        }
        this.a(this.font, (this.isHovered(mouseX, mouseY) ? ChatFormatting.UNDERLINE.toString() : "") + this.text, this.x, this.y, colour);
        if (this.clickable && this.getTooltips().isPresent() && this.containsMouse(mouseX, mouseY)) {
            ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.getTooltips().get().split("\n")));
        }
    }

    public int getDefaultColor() {
        return ScreenHelper.isDarkModeEnabled() ? -4473925 : -1;
    }

    public int getHoveredColor() {
        return ScreenHelper.isDarkModeEnabled() ? -1 : -10027060;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.clickable && this.containsMouse(mouseX, mouseY)) {
            this.onLabelClicked();
            return true;
        }
        return false;
    }

    public Optional<String> getTooltips() {
        return Optional.empty();
    }

    public boolean isHovered(int mouseX, int mouseY) {
        return this.clickable && this.containsMouse(mouseX, mouseY);
    }

    public abstract void onLabelClicked();
}

