/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui.widget;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.awt.Rectangle;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.rei.api.AutoCraftingHandler;
import me.shedaniel.rei.api.Identifier;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.widget.ButtonWidget;

public class AutoCraftingButtonWidget
extends ButtonWidget {
    private final Supplier<RecipeDisplay> displaySupplier = () -> (RecipeDisplay)displaySupplier.get();
    private String extraTooltip;
    private cky containerScreen;

    public AutoCraftingButtonWidget(Rectangle rectangle, String text, Supplier<RecipeDisplay> displaySupplier) {
        super(rectangle, text);
        Optional<Identifier> recipe = displaySupplier.get().getRecipeLocation();
        this.extraTooltip = recipe.isPresent() ? dej.a((String)"text.rei.recipe_id", (Object[])new Object[]{ChatFormatting.GRAY.toString(), recipe.get().toString()}) : "";
        this.containerScreen = ScreenHelper.getLastContainerScreen();
    }

    @Override
    public void onPressed() {
        for (AutoCraftingHandler autoCraftingHandler : RecipeHelper.getInstance().getSortedAutoCraftingHandler()) {
            if (!autoCraftingHandler.canHandle(this.displaySupplier, this.minecraft, this.minecraft.m, this.containerScreen, ScreenHelper.getLastOverlay()) || !autoCraftingHandler.handle(this.displaySupplier, this.minecraft, this.minecraft.m, this.containerScreen, ScreenHelper.getLastOverlay())) continue;
            return;
        }
        this.minecraft.a((ckd)this.containerScreen);
        ScreenHelper.getLastOverlay().init();
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        this.enabled = false;
        for (AutoCraftingHandler autoCraftingHandler : RecipeHelper.getInstance().getSortedAutoCraftingHandler()) {
            if (!autoCraftingHandler.canHandle(this.displaySupplier, this.minecraft, this.minecraft.m, this.containerScreen, ScreenHelper.getLastOverlay())) continue;
            this.enabled = true;
            break;
        }
        super.render(mouseX, mouseY, delta);
    }

    @Override
    public Optional<String> getTooltips() {
        if (this.minecraft.t.z) {
            if (this.enabled) {
                return Optional.ofNullable(dej.a((String)"text.auto_craft.move_items", (Object[])new Object[0]) + this.extraTooltip);
            }
            return Optional.ofNullable(dej.a((String)"text.auto_craft.failed_move_items", (Object[])new Object[0]) + this.extraTooltip);
        }
        if (this.enabled) {
            return Optional.ofNullable(dej.a((String)"text.auto_craft.move_items", (Object[])new Object[0]));
        }
        return Optional.ofNullable(dej.a((String)"text.auto_craft.failed_move_items", (Object[])new Object[0]));
    }
}

