/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.zeitheron.hammercore.client.utils.Scissors;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsClient;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.api.Renderer;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.renderers.RecipeRenderer;
import me.shedaniel.rei.gui.widget.AutoCraftingButtonWidget;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.CategoryBaseWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.SlotBaseWidget;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.TabWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.reiclothconfig2.api.MouseUtils;

public class VillagerRecipeViewingScreen
extends ckd {
    private static final int TABS_PER_PAGE = 8;
    private final Map<RecipeCategory<?>, List<RecipeDisplay>> categoryMap;
    private final List<RecipeCategory<?>> categories;
    private final List<Widget> widgets = Lists.newArrayList();
    private final List<ButtonWidget> buttonWidgets;
    private final List<Renderer> recipeRenderers;
    private final List<TabWidget> tabs;
    public Rectangle bounds;
    public Rectangle scrollListBounds;
    private int selectedCategoryIndex = 0;
    private int selectedRecipeIndex = 0;
    private double scroll = 0.0;
    private float scrollBarAlpha = 0.0f;
    private float scrollBarAlphaFuture = 0.0f;
    private long scrollBarAlphaFutureTime = -1L;
    private boolean draggingScrollBar = false;
    private int tabsPage = 0;

    public VillagerRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> map) {
        this.categoryMap = Maps.newLinkedHashMap();
        this.categories = Lists.newArrayList();
        this.buttonWidgets = Lists.newArrayList();
        this.tabs = Lists.newArrayList();
        this.recipeRenderers = Lists.newArrayList();
        RecipeHelper.getInstance().getAllCategories().forEach(category -> {
            if (map.containsKey(category)) {
                this.categories.add((RecipeCategory<?>)category);
                this.categoryMap.put((RecipeCategory<?>)category, (List<RecipeDisplay>)map.get(category));
            }
        });
    }

    protected void c() {
        super.c();
        this.draggingScrollBar = false;
        this.j.clear();
        this.widgets.clear();
        this.buttonWidgets.clear();
        this.recipeRenderers.clear();
        this.tabs.clear();
        int largestWidth = this.m - 100;
        int largestHeight = this.n - 40;
        RecipeCategory<?> category = this.categories.get(this.selectedCategoryIndex);
        RecipeDisplay display = this.categoryMap.get(category).get(this.selectedRecipeIndex);
        int guiWidth = xq.a((int)(category.getDisplayWidth(display) + 30), (int)0, (int)largestWidth) + 100;
        int guiHeight = xq.a((int)(category.getDisplayHeight() + 40), (int)166, (int)largestHeight);
        this.bounds = new Rectangle(this.m / 2 - guiWidth / 2, this.n / 2 - guiHeight / 2, guiWidth, guiHeight);
        List<List<ate>> workingStations = RoughlyEnoughItemsCore.getRecipeHelper().getWorkingStations(category.getIdentifier());
        if (!workingStations.isEmpty()) {
            int ww = xq.d((float)((float)(this.bounds.width - 16) / 18.0f));
            int w = Math.min(ww, workingStations.size());
            int h = xq.f((float)((float)workingStations.size() / (float)ww));
            int xx = this.bounds.x + 16;
            int yy = this.bounds.y + this.bounds.height + 5;
            this.widgets.add(new CategoryBaseWidget(new Rectangle(xx - 6, this.bounds.y + this.bounds.height - 5, 11 + w * 18, 15 + h * 18)));
            int index = 0;
            final List<String> list = Collections.singletonList(ChatFormatting.YELLOW.toString() + dej.a((String)"text.rei.working_station", (Object[])new Object[0]));
            for (List<ate> workingStation : workingStations) {
                this.widgets.add(new SlotWidget(xx, yy, workingStation, true, true, true){

                    @Override
                    protected List<String> getExtraToolTips(ate stack) {
                        return list;
                    }
                });
                xx += 18;
                if (++index < ww) continue;
                index = 0;
                xx = this.bounds.x + 16;
                yy += 18;
            }
        }
        this.widgets.add(new CategoryBaseWidget(this.bounds));
        this.scrollListBounds = new Rectangle(this.bounds.x + 4, this.bounds.y + 17, 102, guiHeight - 17 - 7);
        this.widgets.add(new SlotBaseWidget(this.scrollListBounds));
        Rectangle recipeBounds = new Rectangle(this.bounds.x + 100 + (guiWidth - 100) / 2 - category.getDisplayWidth(display) / 2, this.bounds.y + this.bounds.height / 2 - category.getDisplayHeight() / 2, category.getDisplayWidth(display), category.getDisplayHeight());
        this.widgets.addAll(category.setupDisplay(() -> display, recipeBounds));
        Optional<ButtonAreaSupplier> supplier = RecipeHelper.getInstance().getSpeedCraftButtonArea(category);
        if (supplier.isPresent() && supplier.get().get(recipeBounds) != null) {
            this.widgets.add(new AutoCraftingButtonWidget(supplier.get().get(recipeBounds), supplier.get().getButtonText(), () -> display));
        }
        int index = 0;
        for (RecipeDisplay recipeDisplay : this.categoryMap.get(category)) {
            final int finalIndex = index++;
            RecipeRenderer recipeRenderer = category.getSimpleRenderer(recipeDisplay);
            this.recipeRenderers.add(recipeRenderer);
            this.buttonWidgets.add(new ButtonWidget(this.bounds.x + 5, 0, recipeRenderer.getWidth(), recipeRenderer.getHeight(), ""){

                @Override
                public void onPressed() {
                    VillagerRecipeViewingScreen.this.selectedRecipeIndex = finalIndex;
                    VillagerRecipeViewingScreen.this.c();
                }

                @Override
                protected int getTextureId(boolean boolean_1) {
                    this.enabled = VillagerRecipeViewingScreen.this.selectedRecipeIndex != finalIndex;
                    return super.getTextureId(boolean_1);
                }
            });
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            int j2 = i2 + this.tabsPage * 8;
            if (this.categories.size() <= j2) continue;
            TabWidget tab = new TabWidget(i2, new Rectangle(this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.tabsPage * 8, 8) * 14 + i2 * 28, this.bounds.y - 28, 28, 28)){

                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    if (this.getBounds().contains(mouseX, mouseY)) {
                        cft.s().N().a((dfw)dfs.a((wi)wj.kj, (float)1.0f));
                        if (this.getId() + VillagerRecipeViewingScreen.this.tabsPage * 8 == VillagerRecipeViewingScreen.this.selectedCategoryIndex) {
                            return false;
                        }
                        VillagerRecipeViewingScreen.this.selectedCategoryIndex = this.getId() + VillagerRecipeViewingScreen.this.tabsPage * 8;
                        VillagerRecipeViewingScreen.this.scroll = 0.0;
                        VillagerRecipeViewingScreen.this.selectedRecipeIndex = 0;
                        VillagerRecipeViewingScreen.this.c();
                        return true;
                    }
                    return false;
                }
            };
            this.tabs.add(tab);
            tab.setRenderer(this.categories.get(j2), this.categories.get(j2).getIcon(), this.categories.get(j2).getCategoryName(), tab.getId() + this.tabsPage * 8 == this.selectedCategoryIndex);
        }
        ButtonWidget w = new ButtonWidget(this.bounds.x + 2, this.bounds.y - 16, 10, 10, (ij)new ir("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed() {
                VillagerRecipeViewingScreen.this.tabsPage--;
                if (VillagerRecipeViewingScreen.this.tabsPage < 0) {
                    VillagerRecipeViewingScreen.this.tabsPage = xq.f((float)((float)VillagerRecipeViewingScreen.this.categories.size() / 8.0f)) - 1;
                }
                VillagerRecipeViewingScreen.this.c();
            }
        };
        this.widgets.add(w);
        ButtonWidget w2 = new ButtonWidget(this.bounds.x + this.bounds.width - 12, this.bounds.y - 16, 10, 10, (ij)new ir("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed() {
                VillagerRecipeViewingScreen.this.tabsPage++;
                if (VillagerRecipeViewingScreen.this.tabsPage > xq.f((float)((float)VillagerRecipeViewingScreen.this.categories.size() / 8.0f)) - 1) {
                    VillagerRecipeViewingScreen.this.tabsPage = 0;
                }
                VillagerRecipeViewingScreen.this.c();
            }
        };
        this.widgets.add(w2);
        w2.enabled = this.categories.size() > 8;
        w.enabled = w2.enabled;
        this.widgets.add(new ClickableLabelWidget(this.bounds.x + 4 + this.scrollListBounds.width / 2, this.bounds.y + 6, this.categories.get(this.selectedCategoryIndex).getCategoryName()){

            @Override
            public void onLabelClicked() {
                cft.s().N().a((dfw)dfs.a((wi)wj.kj, (float)1.0f));
                ClientHelper.getInstance().executeViewAllRecipesKeyBind();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(dej.a((String)"text.rei.view_all_categories", (Object[])new Object[0]));
            }

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.font.b((this.isHovered(mouseX, mouseY) ? ChatFormatting.UNDERLINE.toString() : "") + this.text, (float)(this.x - this.font.a(this.text) / 2), (float)this.y, this.getDefaultColor());
                if (this.clickable && this.getTooltips().isPresent() && this.containsMouse(mouseX, mouseY)) {
                    ScreenHelper.getLastOverlay().addTooltip(QueuedTooltip.create(this.getTooltips().get().split("\n")));
                }
            }

            @Override
            public int getDefaultColor() {
                return ScreenHelper.isDarkModeEnabled() ? -4473925 : 0x404040;
            }
        });
        this.j.addAll(this.buttonWidgets);
        this.widgets.addAll(this.tabs);
        this.j.addAll(this.widgets);
        this.j.add(ScreenHelper.getLastOverlay(true, false));
        ScreenHelper.getLastOverlay().init();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int int_1) {
        double scrollbarPositionMinX;
        int actualHeight;
        double height = this.buttonWidgets.stream().map(ButtonWidget::getBounds).collect(Collectors.summingDouble(Rectangle::getHeight));
        if (height > (double)(actualHeight = this.scrollListBounds.height - 2) && this.scrollBarAlpha > 0.0f && mouseY >= (double)(this.scrollListBounds.y + 1) && mouseY <= this.scrollListBounds.getMaxY() - 1.0 && mouseX >= (scrollbarPositionMinX = this.scrollListBounds.getMaxX() - 6.0) & mouseX <= scrollbarPositionMinX + 8.0) {
            this.draggingScrollBar = true;
            this.scrollBarAlpha = 1.0f;
            return false;
        }
        this.draggingScrollBar = false;
        return super.mouseClicked(mouseX, mouseY, int_1);
    }

    public boolean charTyped(char char_1, int int_1) {
        for (chr listener : this.b()) {
            if (!listener.charTyped(char_1, int_1)) continue;
            return true;
        }
        return super.charTyped(char_1, int_1);
    }

    public boolean mouseScrolled(double double_3) {
        double height = this.buttonWidgets.stream().map(ButtonWidget::getBounds).collect(Collectors.summingDouble(Rectangle::getHeight));
        if (this.scrollListBounds.contains(MouseUtils.getMouseLocation()) && height > (double)(this.scrollListBounds.height - 2)) {
            this.scroll = double_3 > 0.0 ? (this.scroll -= 16.0) : (this.scroll += 16.0);
            this.scroll = xq.a((double)this.scroll, (double)0.0, (double)(height - (double)this.scrollListBounds.height + 2.0));
            if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlphaFuture = 1.0f;
            }
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            return true;
        }
        for (chr listener : this.b()) {
            if (!listener.mouseScrolled(double_3)) continue;
            return true;
        }
        if (this.bounds.contains(MouseUtils.getMouseLocation())) {
            if (double_3 < 0.0 && this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.c();
            } else if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() - 1;
                }
                this.c();
                return true;
            }
        }
        return super.mouseScrolled(double_3);
    }

    public void a(int mouseX, int mouseY, float delta) {
        int i2;
        if (RoughlyEnoughItemsClient.getConfigManager().getConfig().villagerScreenPermanentScrollBar) {
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 0.0f;
            this.scrollBarAlpha = 1.0f;
        } else if (this.scrollBarAlphaFutureTime > 0L) {
            long l2 = System.currentTimeMillis() - this.scrollBarAlphaFutureTime;
            if ((float)l2 > 300.0f) {
                if (this.scrollBarAlphaFutureTime == 0L) {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                    this.scrollBarAlphaFutureTime = -1L;
                } else if ((float)l2 > 2000.0f && this.scrollBarAlphaFuture == 1.0f) {
                    this.scrollBarAlphaFuture = 0.0f;
                    this.scrollBarAlphaFutureTime = System.currentTimeMillis();
                } else {
                    this.scrollBarAlpha = this.scrollBarAlphaFuture;
                }
            } else if (this.scrollBarAlphaFuture == 0.0f) {
                this.scrollBarAlpha = Math.min(this.scrollBarAlpha, 1.0f - Math.min(1.0f, (float)l2 / 300.0f));
            } else if (this.scrollBarAlphaFuture == 1.0f) {
                this.scrollBarAlpha = Math.max(Math.min(1.0f, (float)l2 / 300.0f), this.scrollBarAlpha);
            }
        }
        this.a(0, 0, this.m, this.n, -1072689136, -804253680);
        int yOffset = 0;
        this.widgets.forEach(widget -> {
            cfr.a();
            widget.render(mouseX, mouseY, delta);
        });
        cfr.a();
        ScreenHelper.getLastOverlay().render(mouseX, mouseY, delta);
        cua.G();
        Scissors.begin();
        Scissors.scissor(0, this.scrollListBounds.y + 1, this.m, this.scrollListBounds.height - 2);
        for (i2 = 0; i2 < this.buttonWidgets.size(); ++i2) {
            ButtonWidget buttonWidget = this.buttonWidgets.get(i2);
            buttonWidget.getBounds().y = this.scrollListBounds.y + 1 + yOffset - (int)this.scroll;
            if (buttonWidget.getBounds().getMaxY() > this.scrollListBounds.getMinY() && buttonWidget.getBounds().getMinY() < this.scrollListBounds.getMaxY()) {
                cfr.a();
                buttonWidget.render(mouseX, mouseY, delta);
            }
            yOffset += buttonWidget.getBounds().height;
        }
        for (i2 = 0; i2 < this.buttonWidgets.size(); ++i2) {
            if (!(this.buttonWidgets.get(i2).getBounds().getMaxY() > this.scrollListBounds.getMinY()) || !(this.buttonWidgets.get(i2).getBounds().getMinY() < this.scrollListBounds.getMaxY())) continue;
            cfr.a();
            this.recipeRenderers.get(i2).setBlitOffset(1.0f);
            this.recipeRenderers.get(i2).render(this.buttonWidgets.get((int)i2).getBounds().x, this.buttonWidgets.get((int)i2).getBounds().y, mouseX, mouseY, delta);
        }
        double height = this.buttonWidgets.stream().map(ButtonWidget::getBounds).collect(Collectors.summingDouble(Rectangle::getHeight));
        if (height > (double)(this.scrollListBounds.height - 2)) {
            cum tessellator = cum.a();
            ctq buffer = tessellator.c();
            double maxScroll = height - (double)this.scrollListBounds.height + 2.0;
            int scrollBarHeight = xq.c((double)((double)((this.scrollListBounds.height - 2) * (this.scrollListBounds.height - 2)) / maxScroll));
            int minY = (int)(this.scroll * (double)(this.scrollListBounds.height - 2 - (scrollBarHeight = xq.a((int)scrollBarHeight, (int)32, (int)(this.scrollListBounds.height - 2 - 8)))) / maxScroll) + this.scrollListBounds.y + 1;
            if (minY < this.scrollListBounds.y + 1) {
                minY = this.scrollListBounds.y + 1;
            }
            double scrollbarPositionMinX = this.scrollListBounds.getMaxX() - 6.0;
            double scrollbarPositionMaxX = this.scrollListBounds.getMaxX() - 2.0;
            cfr.a();
            cua.z();
            cua.m();
            cua.d();
            cua.a((cua.r)cua.r.l, (cua.l)cua.l.j, (cua.r)cua.r.e, (cua.l)cua.l.n);
            cua.j((int)7425);
            buffer.a(7, ddu.l);
            float b2 = ScreenHelper.isDarkModeEnabled() ? 0.37f : 1.0f;
            buffer.b(scrollbarPositionMinX, (double)(minY + scrollBarHeight), 1000.0).a(b2, b2, b2, this.scrollBarAlpha).d();
            buffer.b(scrollbarPositionMaxX, (double)(minY + scrollBarHeight), 1000.0).a(b2, b2, b2, this.scrollBarAlpha).d();
            buffer.b(scrollbarPositionMaxX, (double)minY, 1000.0).a(b2, b2, b2, this.scrollBarAlpha).d();
            buffer.b(scrollbarPositionMinX, (double)minY, 1000.0).a(b2, b2, b2, this.scrollBarAlpha).d();
            tessellator.b();
            cua.j((int)7424);
            cua.l();
            cua.e();
            cua.y();
        }
        Scissors.end();
        cua.H();
        ScreenHelper.getLastOverlay().lateRender(mouseX, mouseY, delta);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int int_1, double double_3, double double_4) {
        int actualHeight;
        double height;
        if (int_1 == 0 && this.scrollBarAlpha > 0.0f && this.draggingScrollBar && (height = this.buttonWidgets.stream().map(ButtonWidget::getBounds).collect(Collectors.summingDouble(Rectangle::getHeight)).doubleValue()) > (double)(actualHeight = this.scrollListBounds.height - 2) && mouseY >= (double)(this.scrollListBounds.y + 1) && mouseY <= this.scrollListBounds.getMaxY() - 1.0) {
            int int_3 = xq.a((int)((int)((double)(actualHeight * actualHeight) / height)), (int)32, (int)(actualHeight - 8));
            double double_6 = Math.max(1.0, Math.max(1.0, height) / (double)(actualHeight - int_3));
            this.scrollBarAlphaFutureTime = System.currentTimeMillis();
            this.scrollBarAlphaFuture = 1.0f;
            this.scroll = xq.a((double)(this.scroll + double_4 * double_6), (double)0.0, (double)(height - (double)this.scrollListBounds.height + 2.0));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, int_1, double_3, double_4);
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if ((int_1 == 256 || this.k.t.ae.a(int_1, int_2)) && this.ah_()) {
            cft.s().a((ckd)ScreenHelper.getLastContainerScreen());
            ScreenHelper.getLastOverlay().init();
            return true;
        }
        if (ClientHelper.getInstance().getNextPageKeyBinding().a(int_1, int_2)) {
            if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                ++this.selectedRecipeIndex;
                if (this.selectedRecipeIndex >= this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size()) {
                    this.selectedRecipeIndex = 0;
                }
                this.c();
                return true;
            }
            return false;
        }
        if (ClientHelper.getInstance().getPreviousPageKeyBinding().a(int_1, int_2)) {
            if (this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() > 1) {
                --this.selectedRecipeIndex;
                if (this.selectedRecipeIndex < 0) {
                    this.selectedRecipeIndex = this.categoryMap.get(this.categories.get(this.selectedCategoryIndex)).size() - 1;
                }
                this.c();
                return true;
            }
            return false;
        }
        for (chr listener : this.b()) {
            if (!listener.keyPressed(int_1, int_2, int_3)) continue;
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }
}

