/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.rei.RoughlyEnoughItemsClient;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.Identifier;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.widget.AutoCraftingButtonWidget;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.CategoryBaseWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.RecipeChoosePageWidget;
import me.shedaniel.rei.gui.widget.SlotWidget;
import me.shedaniel.rei.gui.widget.TabWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.reiclothconfig2.api.MouseUtils;

public class RecipeViewingScreen
extends ckd {
    public static final Identifier CHEST_GUI_TEXTURE = new Identifier("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final int TABS_PER_PAGE = 5;
    private final List<Widget> preWidgets = Lists.newArrayList();
    private final List<Widget> widgets = Lists.newArrayList();
    private final List<TabWidget> tabs;
    private final Map<RecipeCategory<?>, List<RecipeDisplay>> categoriesMap;
    private final List<RecipeCategory<?>> categories;
    public int guiWidth;
    public int guiHeight;
    public int page;
    public int categoryPages = 0;
    public int largestWidth;
    public int largestHeight;
    public boolean choosePageActivated;
    public RecipeChoosePageWidget recipeChoosePageWidget;
    private Rectangle bounds;
    private RecipeCategory<RecipeDisplay> selectedCategory;
    private ButtonWidget recipeBack;
    private ButtonWidget recipeNext;
    private ButtonWidget categoryBack;
    private ButtonWidget categoryNext;

    public RecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> categoriesMap) {
        cgd window = cft.s().f;
        this.bounds = new Rectangle(window.p() / 2 - this.guiWidth / 2, window.q() / 2 - this.guiHeight / 2, 176, 186);
        this.categoriesMap = categoriesMap;
        this.categories = Lists.newArrayList();
        RecipeHelper.getInstance().getAllCategories().forEach(category -> {
            if (categoriesMap.containsKey(category)) {
                this.categories.add((RecipeCategory<?>)category);
            }
        });
        this.selectedCategory = this.categories.get(0);
        this.tabs = new ArrayList<TabWidget>();
        this.choosePageActivated = false;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (int_1 == 256 && this.choosePageActivated) {
            this.choosePageActivated = false;
            this.c();
            return true;
        }
        if ((int_1 == 256 || this.k.t.ae.a(int_1, int_2)) && this.ah_()) {
            cft.s().a((ckd)ScreenHelper.getLastContainerScreen());
            ScreenHelper.getLastOverlay().init();
            return true;
        }
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.keyPressed(int_1, int_2, int_3);
        }
        if (ClientHelper.getInstance().getNextPageKeyBinding().a(int_1, int_2)) {
            if (this.recipeNext.enabled) {
                this.recipeNext.onPressed();
            }
            return this.recipeNext.enabled;
        }
        if (ClientHelper.getInstance().getPreviousPageKeyBinding().a(int_1, int_2)) {
            if (this.recipeBack.enabled) {
                this.recipeBack.onPressed();
            }
            return this.recipeBack.enabled;
        }
        for (chr element : this.b()) {
            if (!element.keyPressed(int_1, int_2, int_3)) continue;
            return true;
        }
        return super.keyPressed(int_1, int_2, int_3);
    }

    public boolean e() {
        return false;
    }

    public void c() {
        super.c();
        this.j.clear();
        this.tabs.clear();
        this.preWidgets.clear();
        this.widgets.clear();
        this.largestWidth = this.m - 100;
        this.largestHeight = this.n - 40;
        this.guiWidth = xq.a((int)(this.getCurrentDisplayed().stream().map(display -> this.selectedCategory.getDisplayWidth((RecipeDisplay)display)).max(Integer::compareTo).orElse(150) + 30), (int)0, (int)this.largestWidth);
        this.guiHeight = xq.c((double)xq.a((double)(((double)this.selectedCategory.getDisplayHeight() + 7.0) * ((double)this.getRecipesPerPage() + 1.0) + 40.0), (double)186.0, (double)this.largestHeight));
        this.bounds = new Rectangle(this.m / 2 - this.guiWidth / 2, this.n / 2 - this.guiHeight / 2, this.guiWidth, this.guiHeight);
        this.page = xq.a((int)this.page, (int)0, (int)(this.getTotalPages(this.selectedCategory) - 1));
        ButtonWidget w = new ButtonWidget(this.bounds.x + 2, this.bounds.y - 16, 10, 10, (ij)new ir("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed() {
                --RecipeViewingScreen.this.categoryPages;
                if (RecipeViewingScreen.this.categoryPages < 0) {
                    RecipeViewingScreen.this.categoryPages = xq.f((float)((float)RecipeViewingScreen.this.categories.size() / 5.0f)) - 1;
                }
                RecipeViewingScreen.this.c();
            }
        };
        this.widgets.add(w);
        ButtonWidget w2 = new ButtonWidget(this.bounds.x + this.bounds.width - 12, this.bounds.y - 16, 10, 10, (ij)new ir("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed() {
                ++RecipeViewingScreen.this.categoryPages;
                if (RecipeViewingScreen.this.categoryPages > xq.f((float)((float)RecipeViewingScreen.this.categories.size() / 5.0f)) - 1) {
                    RecipeViewingScreen.this.categoryPages = 0;
                }
                RecipeViewingScreen.this.c();
            }
        };
        this.widgets.add(w2);
        w2.enabled = this.categories.size() > 5;
        w.enabled = w2.enabled;
        this.categoryBack = new ButtonWidget((int)this.bounds.getX() + 5, (int)this.bounds.getY() + 5, 12, 12, (ij)new ir("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed() {
                int currentCategoryIndex = RecipeViewingScreen.this.categories.indexOf(RecipeViewingScreen.this.selectedCategory);
                if (--currentCategoryIndex < 0) {
                    currentCategoryIndex = RecipeViewingScreen.this.categories.size() - 1;
                }
                RecipeViewingScreen.this.selectedCategory = (RecipeCategory)RecipeViewingScreen.this.categories.get(currentCategoryIndex);
                RecipeViewingScreen.this.categoryPages = xq.c((double)((double)currentCategoryIndex / 5.0));
                RecipeViewingScreen.this.page = 0;
                RecipeViewingScreen.this.c();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(dej.a((String)"text.rei.previous_category", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.categoryBack);
        this.widgets.add(new ClickableLabelWidget((int)this.bounds.getCenterX(), (int)this.bounds.getY() + 7, ""){

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                this.text = RecipeViewingScreen.this.selectedCategory.getCategoryName();
                super.render(mouseX, mouseY, delta);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(dej.a((String)"text.rei.view_all_categories", (Object[])new Object[0]));
            }

            @Override
            public void onLabelClicked() {
                cft.s().N().a((dfw)dfs.a((wi)wj.kj, (float)1.0f));
                ClientHelper.getInstance().executeViewAllRecipesKeyBind();
            }
        });
        this.categoryNext = new ButtonWidget((int)this.bounds.getMaxX() - 17, (int)this.bounds.getY() + 5, 12, 12, (ij)new ir("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed() {
                int currentCategoryIndex = RecipeViewingScreen.this.categories.indexOf(RecipeViewingScreen.this.selectedCategory);
                if (++currentCategoryIndex >= RecipeViewingScreen.this.categories.size()) {
                    currentCategoryIndex = 0;
                }
                RecipeViewingScreen.this.selectedCategory = (RecipeCategory)RecipeViewingScreen.this.categories.get(currentCategoryIndex);
                RecipeViewingScreen.this.categoryPages = xq.c((double)((double)currentCategoryIndex / 5.0));
                RecipeViewingScreen.this.page = 0;
                RecipeViewingScreen.this.c();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(dej.a((String)"text.rei.next_category", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.categoryNext);
        this.categoryBack.enabled = this.categories.size() > 1;
        this.categoryNext.enabled = this.categories.size() > 1;
        this.recipeBack = new ButtonWidget((int)this.bounds.getX() + 5, (int)this.bounds.getY() + 21, 12, 12, (ij)new ir("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed() {
                --RecipeViewingScreen.this.page;
                if (RecipeViewingScreen.this.page < 0) {
                    RecipeViewingScreen.this.page = RecipeViewingScreen.this.getTotalPages(RecipeViewingScreen.this.selectedCategory) - 1;
                }
                RecipeViewingScreen.this.c();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(dej.a((String)"text.rei.previous_page", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.recipeBack);
        this.widgets.add(new ClickableLabelWidget((int)this.bounds.getCenterX(), (int)this.bounds.getY() + 23, "", this.categoriesMap.get(this.selectedCategory).size() > this.getRecipesPerPageByHeight()){

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                this.text = String.format("%d/%d", RecipeViewingScreen.this.page + 1, RecipeViewingScreen.this.getTotalPages(RecipeViewingScreen.this.selectedCategory));
                super.render(mouseX, mouseY, delta);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(dej.a((String)"text.rei.choose_page", (Object[])new Object[0]));
            }

            @Override
            public void onLabelClicked() {
                cft.s().N().a((dfw)dfs.a((wi)wj.kj, (float)1.0f));
                RecipeViewingScreen.this.choosePageActivated = true;
                RecipeViewingScreen.this.c();
            }
        });
        this.recipeNext = new ButtonWidget((int)this.bounds.getMaxX() - 17, (int)this.bounds.getY() + 21, 12, 12, (ij)new ir("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed() {
                ++RecipeViewingScreen.this.page;
                if (RecipeViewingScreen.this.page >= RecipeViewingScreen.this.getTotalPages(RecipeViewingScreen.this.selectedCategory)) {
                    RecipeViewingScreen.this.page = 0;
                }
                RecipeViewingScreen.this.c();
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(dej.a((String)"text.rei.next_page", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.recipeNext);
        this.recipeNext.enabled = this.categoriesMap.get(this.selectedCategory).size() > this.getRecipesPerPageByHeight();
        this.recipeBack.enabled = this.recipeNext.enabled;
        for (int i2 = 0; i2 < 5; ++i2) {
            int j = i2 + this.categoryPages * 5;
            if (this.categories.size() <= j) continue;
            TabWidget tab = new TabWidget(i2, new Rectangle(this.bounds.x + this.bounds.width / 2 - Math.min(this.categories.size() - this.categoryPages * 5, 5) * 14 + i2 * 28, this.bounds.y - 28, 28, 28)){

                public boolean mouseClicked(double mouseX, double mouseY, int button) {
                    if (this.getBounds().contains(mouseX, mouseY)) {
                        cft.s().N().a((dfw)dfs.a((wi)wj.kj, (float)1.0f));
                        if (this.getId() + RecipeViewingScreen.this.categoryPages * 5 == RecipeViewingScreen.this.categories.indexOf(RecipeViewingScreen.this.selectedCategory)) {
                            return false;
                        }
                        RecipeViewingScreen.this.selectedCategory = (RecipeCategory)RecipeViewingScreen.this.categories.get(this.getId() + RecipeViewingScreen.this.categoryPages * 5);
                        RecipeViewingScreen.this.page = 0;
                        RecipeViewingScreen.this.c();
                        return true;
                    }
                    return false;
                }
            };
            this.tabs.add(tab);
            tab.setRenderer(this.categories.get(j), this.categories.get(j).getIcon(), this.categories.get(j).getCategoryName(), tab.getId() + this.categoryPages * 5 == this.categories.indexOf(this.selectedCategory));
        }
        Optional<ButtonAreaSupplier> supplier = RecipeHelper.getInstance().getSpeedCraftButtonArea(this.selectedCategory);
        int recipeHeight = this.selectedCategory.getDisplayHeight();
        List<RecipeDisplay> currentDisplayed = this.getCurrentDisplayed();
        for (int i3 = 0; i3 < currentDisplayed.size(); ++i3) {
            int finalI = i3;
            Supplier<RecipeDisplay> displaySupplier = () -> (RecipeDisplay)currentDisplayed.get(finalI);
            int displayWidth = this.selectedCategory.getDisplayWidth(displaySupplier.get());
            Rectangle displayBounds = new Rectangle((int)this.getBounds().getCenterX() - displayWidth / 2, this.getBounds().y + 40 + recipeHeight * i3 + 7 * i3, displayWidth, recipeHeight);
            this.widgets.addAll(this.selectedCategory.setupDisplay(displaySupplier, displayBounds));
            if (!supplier.isPresent() || supplier.get().get(displayBounds) == null) continue;
            this.widgets.add(new AutoCraftingButtonWidget(supplier.get().get(displayBounds), supplier.get().getButtonText(), displaySupplier));
        }
        this.recipeChoosePageWidget = this.choosePageActivated ? new RecipeChoosePageWidget(this, this.page, this.getTotalPages(this.selectedCategory)) : null;
        List<List<ate>> workingStations = RoughlyEnoughItemsCore.getRecipeHelper().getWorkingStations(this.selectedCategory.getIdentifier());
        if (!workingStations.isEmpty()) {
            int hh = xq.d((float)((float)(this.bounds.height - 16) / 18.0f));
            int actualHeight = Math.min(hh, workingStations.size());
            int innerWidth = xq.f((float)((float)workingStations.size() / (float)hh));
            int xx = this.bounds.x - (10 + innerWidth * 18) + 6;
            int yy = this.bounds.y + 16;
            this.preWidgets.add(new CategoryBaseWidget(new Rectangle(xx - 6, yy - 6, 15 + innerWidth * 18, 11 + actualHeight * 18)));
            int index = 0;
            final List<String> list = Collections.singletonList(ChatFormatting.YELLOW.toString() + dej.a((String)"text.rei.working_station", (Object[])new Object[0]));
            xx += (innerWidth - 1) * 18;
            for (List<ate> workingStation : workingStations) {
                this.preWidgets.add(new SlotWidget(xx, yy, workingStation, true, true, true){

                    @Override
                    protected List<String> getExtraToolTips(ate stack) {
                        return list;
                    }
                });
                yy += 18;
                if (++index < hh) continue;
                index = 0;
                yy = this.bounds.y + 16;
                xx -= 18;
            }
        }
        this.j.addAll(this.tabs);
        this.j.add(ScreenHelper.getLastOverlay(true, false));
        this.j.addAll(this.widgets);
        this.j.addAll(this.preWidgets);
    }

    public List<Widget> getWidgets() {
        return this.widgets;
    }

    public List<RecipeDisplay> getCurrentDisplayed() {
        ArrayList list = Lists.newArrayList();
        int recipesPerPage = this.getRecipesPerPage();
        for (int i2 = 0; i2 <= recipesPerPage; ++i2) {
            if (this.page * (recipesPerPage + 1) + i2 >= this.categoriesMap.get(this.selectedCategory).size()) continue;
            list.add(this.categoriesMap.get(this.selectedCategory).get(this.page * (recipesPerPage + 1) + i2));
        }
        return list;
    }

    public RecipeCategory<?> getSelectedCategory() {
        return this.selectedCategory;
    }

    public int getPage() {
        return this.page;
    }

    public int getCategoryPage() {
        return this.categoryPages;
    }

    private int getRecipesPerPage() {
        if (this.selectedCategory.getFixedRecipesPerPage() > 0) {
            return this.selectedCategory.getFixedRecipesPerPage() - 1;
        }
        int height = this.selectedCategory.getDisplayHeight();
        return xq.a((int)(xq.c((double)(((double)this.largestHeight - 40.0) / ((double)height + 7.0))) - 1), (int)0, (int)Math.min(RoughlyEnoughItemsClient.getConfigManager().getConfig().maxRecipePerPage - 1, this.selectedCategory.getMaximumRecipePerPage() - 1));
    }

    private int getRecipesPerPageByHeight() {
        int height = this.selectedCategory.getDisplayHeight();
        return xq.a((int)xq.c((double)(((double)this.guiHeight - 40.0) / ((double)height + 7.0))), (int)0, (int)Math.min(RoughlyEnoughItemsClient.getConfigManager().getConfig().maxRecipePerPage - 1, this.selectedCategory.getMaximumRecipePerPage() - 1));
    }

    public void a(int mouseX, int mouseY, float delta) {
        this.a(0, 0, this.m, this.n, -1072689136, -804253680);
        this.preWidgets.forEach(widget -> {
            cfr.a();
            widget.render(mouseX, mouseY, delta);
        });
        if (this.selectedCategory != null) {
            this.selectedCategory.drawCategoryBackground(this.bounds, mouseX, mouseY, delta);
        } else {
            new CategoryBaseWidget(this.bounds).render();
            if (ScreenHelper.isDarkModeEnabled()) {
                RecipeViewingScreen.a((int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)-12566464);
                RecipeViewingScreen.a((int)(this.bounds.x + 17), (int)(this.bounds.y + 21), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 33), (int)-12566464);
            } else {
                RecipeViewingScreen.a((int)(this.bounds.x + 17), (int)(this.bounds.y + 5), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 17), (int)-6381922);
                RecipeViewingScreen.a((int)(this.bounds.x + 17), (int)(this.bounds.y + 21), (int)(this.bounds.x + this.bounds.width - 17), (int)(this.bounds.y + 33), (int)-6381922);
            }
        }
        this.tabs.stream().filter(tabWidget -> !tabWidget.isSelected()).forEach(tabWidget -> tabWidget.render(mouseX, mouseY, delta));
        cfr.a();
        super.a(mouseX, mouseY, delta);
        this.widgets.forEach(widget -> {
            cfr.a();
            widget.render(mouseX, mouseY, delta);
        });
        cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        cfr.a();
        this.tabs.stream().filter(TabWidget::isSelected).forEach(tabWidget -> tabWidget.render(mouseX, mouseY, delta));
        cfr.a();
        ScreenHelper.getLastOverlay().render(mouseX, mouseY, delta);
        ScreenHelper.getLastOverlay().lateRender(mouseX, mouseY, delta);
        if (this.choosePageActivated) {
            this.e = 500.0f;
            this.a(0, 0, this.m, this.n, -1072689136, -804253680);
            this.e = 0.0f;
            this.recipeChoosePageWidget.render(mouseX, mouseY, delta);
        }
    }

    public int getTotalPages(RecipeCategory category) {
        return xq.f((double)((double)this.categoriesMap.get(category).size() / (double)(this.getRecipesPerPage() + 1)));
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public boolean charTyped(char char_1, int int_1) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.charTyped(char_1, int_1);
        }
        for (chr listener : this.b()) {
            if (!listener.charTyped(char_1, int_1)) continue;
            return true;
        }
        return super.charTyped(char_1, int_1);
    }

    public boolean mouseDragged(double double_1, double double_2, int int_1, double double_3, double double_4) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.mouseDragged(double_1, double_2, int_1, double_3, double_4);
        }
        return super.mouseDragged(double_1, double_2, int_1, double_3, double_4);
    }

    public boolean mouseReleased(double double_1, double double_2, int int_1) {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget.mouseReleased(double_1, double_2, int_1);
        }
        return super.mouseReleased(double_1, double_2, int_1);
    }

    public boolean mouseScrolled(double amount) {
        for (chr listener : this.b()) {
            if (!listener.mouseScrolled(amount)) continue;
            return true;
        }
        if (this.getBounds().contains(MouseUtils.getMouseLocation())) {
            if (amount > 0.0 && this.recipeBack.enabled) {
                this.recipeBack.onPressed();
            } else if (amount < 0.0 && this.recipeNext.enabled) {
                this.recipeNext.onPressed();
            }
        }
        if (new Rectangle(this.bounds.x, this.bounds.y - 28, this.bounds.width, 28).contains(MouseUtils.getMouseLocation())) {
            if (amount > 0.0 && this.categoryBack.enabled) {
                this.categoryBack.onPressed();
            } else if (amount < 0.0 && this.categoryNext.enabled) {
                this.categoryNext.onPressed();
            }
        }
        return super.mouseScrolled(amount);
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (this.choosePageActivated) {
            if (this.recipeChoosePageWidget.containsMouse(double_1, double_2)) {
                return this.recipeChoosePageWidget.mouseClicked(double_1, double_2, int_1);
            }
            this.choosePageActivated = false;
            this.c();
            return false;
        }
        for (chr entry : this.b()) {
            if (!entry.mouseClicked(double_1, double_2, int_1)) continue;
            this.a(entry);
            if (int_1 == 0) {
                this.e(true);
            }
            return true;
        }
        return false;
    }

    public chr getFocused() {
        if (this.choosePageActivated) {
            return this.recipeChoosePageWidget;
        }
        return super.getFocused();
    }
}

