/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.gui;

import com.google.common.collect.Lists;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsClient;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.ContainerScreenHooks;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.Identifier;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.RecipeHelperImpl;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.client.Weather;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.gui.widget.ButtonWidget;
import me.shedaniel.rei.gui.widget.ClickableLabelWidget;
import me.shedaniel.rei.gui.widget.CraftableToggleButtonWidget;
import me.shedaniel.rei.gui.widget.ItemListOverlay;
import me.shedaniel.rei.gui.widget.QueuedTooltip;
import me.shedaniel.rei.gui.widget.SearchFieldWidget;
import me.shedaniel.rei.gui.widget.Widget;
import me.shedaniel.rei.utils.ClothScreenRegistry;
import me.shedaniel.reiclothconfig2.api.MouseUtils;
import org.apache.logging.log4j.util.TriConsumer;

public class ContainerScreenOverlay
extends Widget {
    private static final pc CHEST_GUI_TEXTURE = new pc("roughlyenoughitems", "textures/gui/recipecontainer.png");
    private static final List<QueuedTooltip> QUEUED_TOOLTIPS = Lists.newArrayList();
    public static String searchTerm = "";
    private static int page = 0;
    private static ItemListOverlay itemListOverlay;
    private final List<Widget> widgets = Lists.newLinkedList();
    public boolean shouldReInit = false;
    private Rectangle rectangle;
    private cgd window;
    private CraftableToggleButtonWidget toggleButtonWidget;
    private ButtonWidget buttonLeft;
    private ButtonWidget buttonRight;

    public static ItemListOverlay getItemListOverlay() {
        return itemListOverlay;
    }

    public void init() {
        this.init(false);
    }

    public void init(boolean setPage) {
        this.shouldReInit = false;
        this.b().clear();
        this.window = cft.s().f;
        final DisplayHelper.DisplayBoundsHandler<?> boundsHandler = RoughlyEnoughItemsCore.getDisplayHelper().getResponsibleBoundsHandler(cft.s().m.getClass());
        this.rectangle = RoughlyEnoughItemsClient.getConfigManager().getConfig().mirrorItemPanel ? boundsHandler.getLeftBounds(cft.s().m) : boundsHandler.getRightBounds(cft.s().m);
        itemListOverlay = new ItemListOverlay(page);
        this.widgets.add(itemListOverlay);
        itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(this.rectangle), page, searchTerm, false);
        this.buttonLeft = new ButtonWidget(this.rectangle.x, this.rectangle.y + 5, 16, 16, (ij)new ir("text.rei.left_arrow", new Object[0])){

            @Override
            public void onPressed() {
                page--;
                if (page < 0) {
                    page = ContainerScreenOverlay.this.getTotalPage();
                }
                itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(ContainerScreenOverlay.this.rectangle), page, searchTerm, false);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(dej.a((String)"text.rei.previous_page", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.buttonLeft);
        this.buttonRight = new ButtonWidget(this.rectangle.x + this.rectangle.width - 18, this.rectangle.y + 5, 16, 16, (ij)new ir("text.rei.right_arrow", new Object[0])){

            @Override
            public void onPressed() {
                page++;
                if (page > ContainerScreenOverlay.this.getTotalPage()) {
                    page = 0;
                }
                itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(ContainerScreenOverlay.this.rectangle), page, searchTerm, false);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(dej.a((String)"text.rei.next_page", (Object[])new Object[0]));
            }
        };
        this.widgets.add(this.buttonRight);
        if (setPage) {
            page = xq.a((int)page, (int)0, (int)this.getTotalPage());
        }
        this.widgets.add(new ButtonWidget(RoughlyEnoughItemsClient.getConfigManager().getConfig().mirrorItemPanel ? this.window.p() - 30 : 10, 10, 20, 20, ""){

            @Override
            public void onPressed() {
                if (ckd.q()) {
                    ClientHelper.getInstance().setCheating(!ClientHelper.getInstance().isCheating());
                    return;
                }
                ClothScreenRegistry.openConfigScreen((ckd)ScreenHelper.getLastContainerScreen());
            }

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                super.render(mouseX, mouseY, delta);
                cfr.a();
                if (ClientHelper.getInstance().isCheating() && cft.s().x()) {
                    3.a((int)this.getBounds().x, (int)this.getBounds().y, (int)(this.getBounds().x + 20), (int)(this.getBounds().y + 20), (int)721354752);
                }
                cft.s().E().a(CHEST_GUI_TEXTURE);
                cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.b(this.getBounds().x + 3, this.getBounds().y + 3, 0, 0, 14, 14);
            }

            @Override
            public Optional<String> getTooltips() {
                String tooltips = dej.a((String)"text.rei.config_tooltip", (Object[])new Object[0]);
                tooltips = tooltips + "\n  ";
                tooltips = !ClientHelper.getInstance().isCheating() ? tooltips + "\n" + dej.a((String)"text.rei.cheating_disabled", (Object[])new Object[0]) : (cft.s().x() ? tooltips + "\n" + dej.a((String)"text.rei.cheating_enabled", (Object[])new Object[0]) : tooltips + "\n" + dej.a((String)"text.rei.cheating_limited_enabled", (Object[])new Object[0]));
                return Optional.ofNullable(tooltips);
            }
        });
        if (RoughlyEnoughItemsClient.getConfigManager().getConfig().showUtilsButtons) {
            this.widgets.add(new ButtonWidget(RoughlyEnoughItemsClient.getConfigManager().getConfig().mirrorItemPanel ? this.window.p() - 55 : 35, 10, 20, 20, ""){

                @Override
                public void onPressed() {
                    cft.s().i.f(RoughlyEnoughItemsClient.getConfigManager().getConfig().gamemodeCommand.replaceAll("\\{gamemode}", ContainerScreenOverlay.this.getNextGameMode().b()));
                }

                @Override
                public void render(int mouseX, int mouseY, float delta) {
                    this.text = ContainerScreenOverlay.this.getGameModeShortText(ContainerScreenOverlay.this.getCurrentGameMode());
                    super.render(mouseX, mouseY, delta);
                }

                @Override
                public Optional<String> getTooltips() {
                    return Optional.ofNullable(dej.a((String)"text.rei.gamemode_button.tooltip", (Object[])new Object[]{ContainerScreenOverlay.this.getGameModeText(ContainerScreenOverlay.this.getNextGameMode())}));
                }
            });
            int xxx = RoughlyEnoughItemsClient.getConfigManager().getConfig().mirrorItemPanel ? this.window.p() - 30 : 10;
            for (final Weather weather : Weather.values()) {
                this.widgets.add(new ButtonWidget(xxx, 35, 20, 20, ""){

                    @Override
                    public void onPressed() {
                        cft.s().i.f(RoughlyEnoughItemsClient.getConfigManager().getConfig().weatherCommand.replaceAll("\\{weather}", weather.name().toLowerCase(Locale.ROOT)));
                    }

                    @Override
                    public void render(int mouseX, int mouseY, float delta) {
                        super.render(mouseX, mouseY, delta);
                        cfr.a();
                        cft.s().E().a(CHEST_GUI_TEXTURE);
                        cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        this.b(this.getBounds().x + 3, this.getBounds().y + 3, weather.getId() * 14, 14, 14, 14);
                    }

                    @Override
                    public Optional<String> getTooltips() {
                        return Optional.ofNullable(dej.a((String)"text.rei.weather_button.tooltip", (Object[])new Object[]{dej.a((String)weather.getTranslateKey(), (Object[])new Object[0])}));
                    }
                });
                xxx += RoughlyEnoughItemsClient.getConfigManager().getConfig().mirrorItemPanel ? -25 : 25;
            }
        }
        this.widgets.add(new ClickableLabelWidget(this.rectangle.x + this.rectangle.width / 2, this.rectangle.y + 10, "", this.getTotalPage() > 0){

            @Override
            public void render(int mouseX, int mouseY, float delta) {
                page = xq.a((int)page, (int)0, (int)ContainerScreenOverlay.this.getTotalPage());
                this.text = String.format("%s/%s", page + 1, ContainerScreenOverlay.this.getTotalPage() + 1);
                super.render(mouseX, mouseY, delta);
            }

            @Override
            public Optional<String> getTooltips() {
                return Optional.ofNullable(dej.a((String)"text.rei.go_back_first_page", (Object[])new Object[0]));
            }

            @Override
            public void onLabelClicked() {
                cft.s().N().a((dfw)dfs.a((wi)wj.kj, (float)1.0f));
                page = 0;
                itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(ContainerScreenOverlay.this.rectangle), page, searchTerm, false);
            }
        });
        this.buttonRight.enabled = this.getTotalPage() > 0;
        this.buttonLeft.enabled = this.buttonRight.enabled;
        if (ScreenHelper.searchField == null) {
            ScreenHelper.searchField = new SearchFieldWidget(0, 0, 0, 0);
        }
        ScreenHelper.searchField.getBounds().setBounds(this.getTextFieldArea());
        this.widgets.add(ScreenHelper.searchField);
        ScreenHelper.searchField.setText(searchTerm);
        ScreenHelper.searchField.setChangedListener(s -> {
            searchTerm = s;
            itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(this.rectangle), page, searchTerm, true);
        });
        if (RoughlyEnoughItemsClient.getConfigManager().getConfig().enableCraftableOnlyButton) {
            this.toggleButtonWidget = new CraftableToggleButtonWidget(this.getCraftableToggleArea()){

                @Override
                public void onPressed() {
                    RoughlyEnoughItemsClient.getConfigManager().toggleCraftableOnly();
                    itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(ContainerScreenOverlay.this.rectangle), page, searchTerm, true);
                }

                @Override
                public void lateRender(int mouseX, int mouseY, float delta) {
                    this.e = 300.0f;
                    super.lateRender(mouseX, mouseY, delta);
                }
            };
            this.widgets.add(this.toggleButtonWidget);
        } else {
            this.toggleButtonWidget = null;
        }
        itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(this.rectangle), page, searchTerm, false);
    }

    private Weather getNextWeather() {
        try {
            Weather current = this.getCurrentWeather();
            int next = current.getId() + 1;
            if (next >= 3) {
                next = 0;
            }
            return Weather.byId(next);
        }
        catch (Exception e) {
            return Weather.CLEAR;
        }
    }

    private Weather getCurrentWeather() {
        crg world = cft.s().g;
        if (world.Y()) {
            return Weather.THUNDER;
        }
        if (world.g().o()) {
            return Weather.RAIN;
        }
        return Weather.CLEAR;
    }

    private String getGameModeShortText(axv gameMode) {
        return dej.a((String)("text.rei.short_gamemode." + gameMode.b()), (Object[])new Object[0]);
    }

    private String getGameModeText(axv gameMode) {
        return dej.a((String)("selectWorld.gameMode." + gameMode.b()), (Object[])new Object[0]);
    }

    private axv getNextGameMode() {
        try {
            axv current = this.getCurrentGameMode();
            int next = current.a() + 1;
            if (next > 3) {
                next = 0;
            }
            return axv.a((int)next);
        }
        catch (Exception e) {
            return axv.a;
        }
    }

    private axv getCurrentGameMode() {
        return cft.s().o().a(cft.s().i.do().getId()).b();
    }

    private Rectangle getTextFieldArea() {
        int widthRemoved;
        int n = widthRemoved = RoughlyEnoughItemsClient.getConfigManager().getConfig().enableCraftableOnlyButton ? 22 : 2;
        if (RoughlyEnoughItemsClient.getConfigManager().getConfig().sideSearchField) {
            return new Rectangle(this.rectangle.x + 2, this.window.q() - 22, this.rectangle.width - 6 - widthRemoved, 18);
        }
        if (cft.s().m instanceof RecipeViewingScreen) {
            RecipeViewingScreen widget = (RecipeViewingScreen)cft.s().m;
            return new Rectangle(widget.getBounds().x, this.window.q() - 22, widget.getBounds().width - widthRemoved, 18);
        }
        if (cft.s().m instanceof VillagerRecipeViewingScreen) {
            VillagerRecipeViewingScreen widget = (VillagerRecipeViewingScreen)cft.s().m;
            return new Rectangle(widget.bounds.x, this.window.q() - 22, widget.bounds.width - widthRemoved, 18);
        }
        return new Rectangle(ScreenHelper.getLastContainerScreenHooks().rei_getContainerLeft(), this.window.q() - 22, ScreenHelper.getLastContainerScreenHooks().rei_getContainerWidth() - widthRemoved, 18);
    }

    private Rectangle getCraftableToggleArea() {
        Rectangle searchBoxArea = this.getTextFieldArea();
        searchBoxArea.setLocation(searchBoxArea.x + searchBoxArea.width + 4, searchBoxArea.y - 1);
        searchBoxArea.setSize(20, 20);
        return searchBoxArea;
    }

    private String getCheatModeText() {
        return dej.a((String)String.format("%s%s", "text.rei.", ClientHelper.getInstance().isCheating() ? "cheat" : "nocheat"), (Object[])new Object[0]);
    }

    public Rectangle getRectangle() {
        return this.rectangle;
    }

    @Override
    public void render(int mouseX, int mouseY, float delta) {
        ContainerScreenHooks hooks;
        List<ate> currentStacks = ClientHelper.getInstance().getInventoryItemsTypes();
        if (RoughlyEnoughItemsCore.getDisplayHelper().getBaseBoundsHandler() != null && RoughlyEnoughItemsCore.getDisplayHelper().getBaseBoundsHandler().shouldRecalculateArea(!RoughlyEnoughItemsClient.getConfigManager().getConfig().mirrorItemPanel, this.rectangle)) {
            this.shouldReInit = true;
        }
        if (this.shouldReInit) {
            this.init(true);
        } else if (RoughlyEnoughItemsClient.getConfigManager().isCraftableOnlyEnabled() && (!this.hasSameListContent(new LinkedList<ate>(ScreenHelper.inventoryStacks), currentStacks) || currentStacks.size() != ScreenHelper.inventoryStacks.size())) {
            ScreenHelper.inventoryStacks = ClientHelper.getInstance().getInventoryItemsTypes();
            DisplayHelper.DisplayBoundsHandler<?> boundsHandler = RoughlyEnoughItemsCore.getDisplayHelper().getResponsibleBoundsHandler(cft.s().m.getClass());
            itemListOverlay.updateList(boundsHandler, boundsHandler.getItemListArea(this.rectangle), page, searchTerm, true);
        }
        if (cft.s().m instanceof cky && SearchFieldWidget.isSearching) {
            cfr.a();
            this.e = 200.0f;
            hooks = (ContainerScreenHooks)cft.s().m;
            int left = hooks.rei_getContainerLeft();
            int top = hooks.rei_getContainerTop();
            for (aqx slot : ((cky)cft.s().m).h.c) {
                if (slot.e()) {
                    if (ItemListOverlay.filterItem(slot.d(), itemListOverlay.getLastSearchArgument())) continue;
                }
                this.a(left + slot.f, top + slot.g, left + slot.f + 16, top + slot.g + 16, -601874400, -601874400);
            }
            this.e = 0.0f;
        }
        cua.c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        cfr.a();
        this.renderWidgets(mouseX, mouseY, delta);
        if (cft.s().m instanceof cky) {
            hooks = (ContainerScreenHooks)cft.s().m;
            for (RecipeHelperImpl.ScreenClickArea area : RecipeHelper.getInstance().getScreenClickAreas()) {
                if (!area.getScreenClass().equals(cft.s().m.getClass()) || !area.getRectangle().contains(mouseX - hooks.rei_getContainerLeft(), mouseY - hooks.rei_getContainerTop())) continue;
                String collect = Arrays.asList(area.getCategories()).stream().map(identifier -> RecipeHelper.getInstance().getCategory((Identifier)identifier).getCategoryName()).collect(Collectors.joining(", "));
                QUEUED_TOOLTIPS.add(QueuedTooltip.create(dej.a((String)"text.rei.view_recipes_for", (Object[])new Object[]{collect})));
                break;
            }
        }
    }

    public void lateRender(int mouseX, int mouseY, float delta) {
        ckd currentScreen;
        ScreenHelper.searchField.laterRender(mouseX, mouseY, delta);
        if (this.toggleButtonWidget != null) {
            this.toggleButtonWidget.lateRender(mouseX, mouseY, delta);
        }
        if (!((currentScreen = cft.s().m) instanceof RecipeViewingScreen) || !((RecipeViewingScreen)currentScreen).choosePageActivated) {
            QUEUED_TOOLTIPS.stream().filter(Objects::nonNull).forEach(this::renderTooltip);
        }
        QUEUED_TOOLTIPS.clear();
    }

    public void renderTooltip(QueuedTooltip tooltip) {
        if (tooltip.getConsumer() == null) {
            this.renderTooltip(tooltip.getText(), tooltip.getX(), tooltip.getY());
        } else {
            tooltip.getConsumer().accept(tooltip);
        }
    }

    public void renderTooltip(List<String> lines, int mouseX, int mouseY) {
        if (lines.isEmpty()) {
            return;
        }
        int width = lines.stream().map(arg_0 -> ((cgk)this.font).a(arg_0)).max(Integer::compareTo).get();
        int height = lines.size() <= 1 ? 8 : lines.size() * 10;
        ScreenHelper.drawHoveringWidget(mouseX, mouseY, (TriConsumer<Integer, Integer, Float>)((TriConsumer)(x, y, aFloat) -> {
            cua.E();
            cfr.a();
            cua.g();
            this.e = 1000.0f;
            this.a(x - 3, y - 4, x + width + 3, y - 3, -267386864, -267386864);
            this.a(x - 3, y + height + 3, x + width + 3, y + height + 4, -267386864, -267386864);
            this.a(x - 3, y - 3, x + width + 3, y + height + 3, -267386864, -267386864);
            this.a(x - 4, y - 3, x - 3, y + height + 3, -267386864, -267386864);
            this.a(x + width + 3, y - 3, x + width + 4, y + height + 3, -267386864, -267386864);
            this.a(x - 3, y - 3 + 1, x - 3 + 1, y + height + 3 - 1, 0x505000FF, 1344798847);
            this.a(x + width + 2, y - 3 + 1, x + width + 3, y + height + 3 - 1, 0x505000FF, 1344798847);
            this.a(x - 3, y - 3, x + width + 3, y - 3 + 1, 0x505000FF, 0x505000FF);
            this.a(x - 3, y + height + 2, x + width + 3, y + height + 3, 1344798847, 1344798847);
            int currentY = y;
            for (int lineIndex = 0; lineIndex < lines.size(); ++lineIndex) {
                cua.j();
                this.font.a((String)lines.get(lineIndex), (float)x.intValue(), (float)currentY, -1);
                cua.k();
                currentY += lineIndex == 0 ? 12 : 10;
            }
            this.e = 0.0f;
            cua.f();
            cfr.a();
            cua.D();
        }), width, height, 0.0f);
    }

    private boolean hasSameListContent(List<ate> list1, List<ate> list2) {
        list1.sort((itemStack, t1) -> ItemListOverlay.tryGetItemStackName(itemStack).compareToIgnoreCase(ItemListOverlay.tryGetItemStackName(t1)));
        list2.sort((itemStack, t1) -> ItemListOverlay.tryGetItemStackName(itemStack).compareToIgnoreCase(ItemListOverlay.tryGetItemStackName(t1)));
        return list1.stream().map(ItemListOverlay::tryGetItemStackName).collect(Collectors.joining("")).equals(list2.stream().map(ItemListOverlay::tryGetItemStackName).collect(Collectors.joining("")));
    }

    public void addTooltip(QueuedTooltip queuedTooltip) {
        QUEUED_TOOLTIPS.add(queuedTooltip);
    }

    public void renderWidgets(int int_1, int int_2, float float_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return;
        }
        this.buttonRight.enabled = this.getTotalPage() > 0;
        this.buttonLeft.enabled = this.buttonRight.enabled;
        this.widgets.forEach(widget -> {
            cfr.a();
            widget.render(int_1, int_2, float_1);
        });
        cfr.a();
    }

    private int getTotalPage() {
        return itemListOverlay.getTotalPage();
    }

    public boolean mouseScrolled(double amount) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (this.isInside(MouseUtils.getMouseLocation())) {
            if (amount > 0.0 && this.buttonLeft.enabled) {
                this.buttonLeft.onPressed();
            } else if (amount < 0.0 && this.buttonRight.enabled) {
                this.buttonRight.onPressed();
            } else {
                return false;
            }
            return true;
        }
        for (Widget widget : this.widgets) {
            if (!widget.mouseScrolled(amount)) continue;
            return true;
        }
        return false;
    }

    public boolean keyPressed(int int_1, int int_2, int int_3) {
        if (ScreenHelper.isOverlayVisible()) {
            for (chr chr2 : this.widgets) {
                if (!chr2.keyPressed(int_1, int_2, int_3)) continue;
                return true;
            }
        }
        if (ClientHelper.getInstance().getHideKeyBinding().a(int_1, int_2)) {
            ScreenHelper.toggleOverlayVisible();
            return true;
        }
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        ate itemStack = null;
        if (cft.s().m instanceof cky && ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot() != null && !ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot().d().a()) {
            itemStack = ScreenHelper.getLastContainerScreenHooks().rei_getHoveredSlot().d();
        }
        if (itemStack != null && !itemStack.a()) {
            if (ClientHelper.getInstance().getRecipeKeyBinding().a(int_1, int_2)) {
                return ClientHelper.getInstance().executeRecipeKeyBind(itemStack);
            }
            if (ClientHelper.getInstance().getUsageKeyBinding().a(int_1, int_2)) {
                return ClientHelper.getInstance().executeUsageKeyBind(itemStack);
            }
        }
        if (ClientHelper.getInstance().getFocusSearchFieldKeyBinding().a(int_1, int_2)) {
            ScreenHelper.searchField.setFocused(true);
            this.a((chr)ScreenHelper.searchField);
            return true;
        }
        return false;
    }

    public boolean charTyped(char char_1, int int_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        for (chr chr2 : this.widgets) {
            if (!chr2.charTyped(char_1, int_1)) continue;
            return true;
        }
        return false;
    }

    public List<? extends chr> b() {
        return this.widgets;
    }

    public boolean mouseClicked(double double_1, double double_2, int int_1) {
        if (!ScreenHelper.isOverlayVisible()) {
            return false;
        }
        if (cft.s().m instanceof cky) {
            ContainerScreenHooks hooks = (ContainerScreenHooks)cft.s().m;
            for (RecipeHelperImpl.ScreenClickArea area : RecipeHelper.getInstance().getScreenClickAreas()) {
                if (!area.getScreenClass().equals(cft.s().m.getClass()) || !area.getRectangle().contains(double_1 - (double)hooks.rei_getContainerLeft(), double_2 - (double)hooks.rei_getContainerTop())) continue;
                ClientHelper.getInstance().executeViewAllRecipesFromCategories(Arrays.asList(area.getCategories()));
                cft.s().N().a((dfw)dfs.a((wi)wj.kj, (float)1.0f));
                return true;
            }
        }
        for (chr chr2 : this.widgets) {
            if (!chr2.mouseClicked(double_1, double_2, int_1)) continue;
            this.a(chr2);
            if (int_1 == 0) {
                this.e(true);
            }
            return true;
        }
        return false;
    }

    public boolean isInside(double mouseX, double mouseY) {
        if (!this.rectangle.contains(mouseX, mouseY)) {
            return false;
        }
        for (DisplayHelper.DisplayBoundsHandler<?> handler : RoughlyEnoughItemsCore.getDisplayHelper().getSortedBoundsHandlers(cft.s().m.getClass())) {
            adm in = handler.isInZone(!RoughlyEnoughItemsClient.getConfigManager().getConfig().mirrorItemPanel, mouseX, mouseY);
            if (in == adm.b) continue;
            return in == adm.a;
        }
        return true;
    }

    public boolean isInside(Point point) {
        return this.isInside(point.getX(), point.getY());
    }
}

