/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsClient;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.AutoCraftingHandler;
import me.shedaniel.rei.api.ButtonAreaSupplier;
import me.shedaniel.rei.api.DisplayVisibilityHandler;
import me.shedaniel.rei.api.Identifier;
import me.shedaniel.rei.api.LiveRecipeGenerator;
import me.shedaniel.rei.api.PluginDisabler;
import me.shedaniel.rei.api.PluginFunction;
import me.shedaniel.rei.api.REIPluginEntry;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.BaseBoundsHandlerImpl;
import me.shedaniel.rei.client.DisplayHelperImpl;
import me.shedaniel.rei.client.ScreenHelper;

public class RecipeHelperImpl
implements RecipeHelper {
    private static final Comparator<DisplayVisibilityHandler> VISIBILITY_HANDLER_COMPARATOR;
    private static final Comparator<avk> RECIPE_COMPARATOR;
    private final List<AutoCraftingHandler> autoCraftingHandlers = Lists.newArrayList();
    private final List<RecipeFunction> recipeFunctions = Lists.newArrayList();
    private final List<ScreenClickArea> screenClickAreas = Lists.newArrayList();
    private final AtomicInteger recipeCount = new AtomicInteger();
    private final Map<Identifier, List<RecipeDisplay>> recipeCategoryListMap = Maps.newHashMap();
    private final List<RecipeCategory> categories = Lists.newArrayList();
    private final Map<Identifier, ButtonAreaSupplier> speedCraftAreaSupplierMap = Maps.newHashMap();
    private final Map<Identifier, List<List<ate>>> categoryWorkingStations = Maps.newHashMap();
    private final List<DisplayVisibilityHandler> displayVisibilityHandlers = Lists.newArrayList();
    private final List<LiveRecipeGenerator<?>> liveRecipeGenerators = Lists.newArrayList();
    private avl recipeManager;

    @Override
    public List<ate> findCraftableByItems(List<ate> inventoryItems) {
        ArrayList<ate> craftables = new ArrayList<ate>();
        for (List<RecipeDisplay> value : this.recipeCategoryListMap.values()) {
            for (RecipeDisplay recipeDisplay : value) {
                int slotsCraftable = 0;
                List<List<ate>> requiredInput = recipeDisplay.getRequiredItems();
                block2: for (List<ate> slot : requiredInput) {
                    if (slot.isEmpty()) {
                        ++slotsCraftable;
                        continue;
                    }
                    boolean slotDone = false;
                    for (ate possibleType : inventoryItems) {
                        for (ate slotPossible : slot) {
                            if (!ate.d((ate)slotPossible, (ate)possibleType)) continue;
                            ++slotsCraftable;
                            slotDone = true;
                            break;
                        }
                        if (!slotDone) continue;
                        continue block2;
                    }
                }
                if (slotsCraftable != recipeDisplay.getRequiredItems().size()) continue;
                craftables.addAll(recipeDisplay.getOutput());
            }
        }
        return craftables.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public void registerCategory(RecipeCategory category) {
        this.categories.add(category);
        this.recipeCategoryListMap.put(category.getIdentifier(), Lists.newLinkedList());
        this.categoryWorkingStations.put(category.getIdentifier(), Lists.newLinkedList());
    }

    @Override
    public void registerWorkingStations(Identifier category, List<ate> ... workingStations) {
        this.categoryWorkingStations.get(category).addAll(Arrays.asList(workingStations));
    }

    @Override
    public void registerWorkingStations(Identifier category, ate ... workingStations) {
        this.categoryWorkingStations.get(category).addAll(Arrays.asList(workingStations).stream().map(Collections::singletonList).collect(Collectors.toList()));
    }

    @Override
    public List<List<ate>> getWorkingStations(Identifier category) {
        return this.categoryWorkingStations.get(category);
    }

    @Override
    public void registerDisplay(Identifier categoryIdentifier, RecipeDisplay display) {
        if (!this.recipeCategoryListMap.containsKey(categoryIdentifier)) {
            return;
        }
        this.recipeCount.incrementAndGet();
        this.recipeCategoryListMap.get(categoryIdentifier).add(display);
    }

    private void registerDisplay(Identifier categoryIdentifier, RecipeDisplay display, int index) {
        if (!this.recipeCategoryListMap.containsKey(categoryIdentifier)) {
            return;
        }
        this.recipeCount.incrementAndGet();
        this.recipeCategoryListMap.get(categoryIdentifier).add(index, display);
    }

    @Override
    public Map<RecipeCategory<?>, List<RecipeDisplay>> getRecipesFor(ate stack) {
        HashMap categoriesMap = new HashMap();
        this.categories.forEach(f -> {
            List cfr_ignored_0 = categoriesMap.put(f.getIdentifier(), Lists.newArrayList());
        });
        for (Map.Entry<Identifier, List<RecipeDisplay>> entry : this.recipeCategoryListMap.entrySet()) {
            RecipeCategory category2 = this.getCategory(entry.getKey());
            for (RecipeDisplay recipeDisplay : entry.getValue()) {
                for (ate outputStack : recipeDisplay.getOutput()) {
                    if (!(category2.checkTags() ? ate.b((ate)stack, (ate)outputStack) : ate.c((ate)stack, (ate)outputStack))) continue;
                    ((List)categoriesMap.get(recipeDisplay.getRecipeCategory())).add(recipeDisplay);
                }
            }
        }
        for (LiveRecipeGenerator liveRecipeGenerator : this.liveRecipeGenerators) {
            liveRecipeGenerator.getRecipeFor(stack).ifPresent(o -> ((List)categoriesMap.get(liveRecipeGenerator.getCategoryIdentifier())).addAll(o));
        }
        LinkedHashMap recipeCategoryListMap = Maps.newLinkedHashMap();
        this.categories.forEach(category -> {
            if (categoriesMap.containsKey(category.getIdentifier()) && !((List)categoriesMap.get(category.getIdentifier())).isEmpty()) {
                recipeCategoryListMap.put(category, ((List)categoriesMap.get(category.getIdentifier())).stream().filter(display -> this.isDisplayVisible((RecipeDisplay)display)).collect(Collectors.toList()));
            }
        });
        for (RecipeCategory category2 : Lists.newArrayList(recipeCategoryListMap.keySet())) {
            if (!((List)recipeCategoryListMap.get(category2)).isEmpty()) continue;
            recipeCategoryListMap.remove(category2);
        }
        return recipeCategoryListMap;
    }

    @Override
    public RecipeCategory getCategory(Identifier identifier) {
        return this.categories.stream().filter(category -> category.getIdentifier().equals(identifier)).findFirst().orElse(null);
    }

    @Override
    public avl getRecipeManager() {
        return this.recipeManager;
    }

    @Override
    public Map<RecipeCategory<?>, List<RecipeDisplay>> getUsagesFor(ate stack) {
        HashMap categoriesMap = new HashMap();
        this.categories.forEach(f -> {
            List cfr_ignored_0 = categoriesMap.put(f.getIdentifier(), Lists.newArrayList());
        });
        for (Map.Entry<Identifier, List<RecipeDisplay>> entry : this.recipeCategoryListMap.entrySet()) {
            RecipeCategory category2 = this.getCategory(entry.getKey());
            block1: for (RecipeDisplay recipeDisplay : entry.getValue()) {
                boolean found = false;
                for (List<ate> input : recipeDisplay.getInput()) {
                    for (ate itemStack : input) {
                        if (!(category2.checkTags() ? ate.b((ate)itemStack, (ate)stack) : ate.c((ate)itemStack, (ate)stack))) continue;
                        ((List)categoriesMap.get(recipeDisplay.getRecipeCategory())).add(recipeDisplay);
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    continue block1;
                }
            }
        }
        for (LiveRecipeGenerator liveRecipeGenerator : this.liveRecipeGenerators) {
            liveRecipeGenerator.getUsageFor(stack).ifPresent(o -> ((List)categoriesMap.get(liveRecipeGenerator.getCategoryIdentifier())).addAll(o));
        }
        LinkedHashMap recipeCategoryListMap = Maps.newLinkedHashMap();
        this.categories.forEach(category -> {
            if (categoriesMap.containsKey(category.getIdentifier()) && !((List)categoriesMap.get(category.getIdentifier())).isEmpty()) {
                recipeCategoryListMap.put(category, ((List)categoriesMap.get(category.getIdentifier())).stream().filter(display -> this.isDisplayVisible((RecipeDisplay)display)).collect(Collectors.toList()));
            }
        });
        for (RecipeCategory category2 : Lists.newArrayList(recipeCategoryListMap.keySet())) {
            if (!((List)recipeCategoryListMap.get(category2)).isEmpty()) continue;
            recipeCategoryListMap.remove(category2);
        }
        return recipeCategoryListMap;
    }

    @Override
    public List<RecipeCategory> getAllCategories() {
        return new LinkedList<RecipeCategory>(this.categories);
    }

    @Override
    public Optional<ButtonAreaSupplier> getSpeedCraftButtonArea(RecipeCategory category) {
        if (!this.speedCraftAreaSupplierMap.containsKey(category.getIdentifier())) {
            return Optional.ofNullable(bounds -> new Rectangle((int)bounds.getMaxX() - 16, (int)bounds.getMaxY() - 16, 10, 10));
        }
        return Optional.ofNullable(this.speedCraftAreaSupplierMap.get(category.getIdentifier()));
    }

    @Override
    public void registerSpeedCraftButtonArea(Identifier category, ButtonAreaSupplier rectangle) {
        if (rectangle == null) {
            if (this.speedCraftAreaSupplierMap.containsKey(category)) {
                this.speedCraftAreaSupplierMap.remove(category);
            }
        } else {
            this.speedCraftAreaSupplierMap.put(category, rectangle);
        }
    }

    @Override
    public void registerDefaultSpeedCraftButtonArea(Identifier category) {
        this.registerSpeedCraftButtonArea(category, bounds -> new Rectangle((int)bounds.getMaxX() - 16, (int)bounds.getMaxY() - 16, 10, 10));
    }

    public void recipesLoaded(avl recipeManager) {
        this.recipeCount.set(0);
        this.recipeManager = recipeManager;
        this.recipeCategoryListMap.clear();
        this.categories.clear();
        this.speedCraftAreaSupplierMap.clear();
        this.screenClickAreas.clear();
        this.categoryWorkingStations.clear();
        this.recipeFunctions.clear();
        this.displayVisibilityHandlers.clear();
        this.liveRecipeGenerators.clear();
        this.autoCraftingHandlers.clear();
        ((DisplayHelperImpl)RoughlyEnoughItemsCore.getDisplayHelper()).resetCache();
        BaseBoundsHandlerImpl baseBoundsHandler = new BaseBoundsHandlerImpl();
        RoughlyEnoughItemsCore.getDisplayHelper().registerBoundsHandler(baseBoundsHandler);
        ((DisplayHelperImpl)RoughlyEnoughItemsCore.getDisplayHelper()).setBaseBoundsHandler(baseBoundsHandler);
        long startTime = System.currentTimeMillis();
        LinkedList<REIPluginEntry> plugins = new LinkedList<REIPluginEntry>(RoughlyEnoughItemsCore.getPlugins());
        plugins.sort((first, second) -> second.getPriority() - first.getPriority());
        RoughlyEnoughItemsCore.LOGGER.info("[REI] Loading %d plugins: %s", (Object)plugins.size(), (Object)plugins.stream().map(REIPluginEntry::getPluginIdentifier).map(Identifier::toString).collect(Collectors.joining(", ")));
        Collections.reverse(plugins);
        RoughlyEnoughItemsCore.getItemRegisterer().getModifiableItemList().clear();
        PluginDisabler pluginDisabler = RoughlyEnoughItemsClient.getPluginDisabler();
        plugins.forEach(plugin -> {
            Identifier identifier = plugin.getPluginIdentifier();
            try {
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_ITEMS)) {
                    plugin.registerItems(RoughlyEnoughItemsCore.getItemRegisterer());
                }
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_CATEGORIES)) {
                    plugin.registerPluginCategories(this);
                }
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_RECIPE_DISPLAYS)) {
                    plugin.registerRecipeDisplays(this);
                }
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_BOUNDS)) {
                    plugin.registerBounds(RoughlyEnoughItemsCore.getDisplayHelper());
                }
                if (pluginDisabler.isFunctionEnabled(identifier, PluginFunction.REGISTER_OTHERS)) {
                    plugin.registerOthers(this);
                }
            }
            catch (Exception e) {
                RoughlyEnoughItemsCore.LOGGER.error("[REI] " + identifier.toString() + " plugin failed to load!", (Throwable)e);
            }
        });
        if (!this.recipeFunctions.isEmpty()) {
            List<avk> allSortedRecipes = this.getAllSortedRecipes();
            Collections.reverse(allSortedRecipes);
            this.recipeFunctions.forEach(recipeFunction -> {
                try {
                    allSortedRecipes.stream().filter(recipe -> recipeFunction.recipeFilter.test((avk)recipe)).forEach(t -> this.registerDisplay(recipeFunction.category, (RecipeDisplay)recipeFunction.mappingFunction.apply(t), 0));
                }
                catch (Exception e) {
                    RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to add recipes!", (Throwable)e);
                }
            });
        }
        if (this.getDisplayVisibilityHandlers().isEmpty()) {
            this.registerRecipeVisibilityHandler(new DisplayVisibilityHandler(){

                @Override
                public adm handleDisplay(RecipeCategory<?> category, RecipeDisplay display) {
                    return adm.a;
                }

                @Override
                public float getPriority() {
                    return -1.0f;
                }
            });
        }
        ((DisplayHelperImpl)RoughlyEnoughItemsCore.getDisplayHelper()).resetCache();
        ScreenHelper.getOptionalOverlay().ifPresent(overlay -> {
            overlay.shouldReInit = true;
        });
        long usedTime = System.currentTimeMillis() - startTime;
        RoughlyEnoughItemsCore.LOGGER.info("[REI] Registered %d stack entries, %d recipes displays, %d bounds handler, %d visibility handlers and %d categories (%s) in %d ms.", (Object)RoughlyEnoughItemsCore.getItemRegisterer().getItemList().size(), (Object)this.recipeCount.get(), (Object)RoughlyEnoughItemsCore.getDisplayHelper().getAllBoundsHandlers().size(), (Object)this.getDisplayVisibilityHandlers().size(), (Object)this.categories.size(), (Object)String.join((CharSequence)", ", this.categories.stream().map(RecipeCategory::getCategoryName).collect(Collectors.toList())), (Object)usedTime);
    }

    @Override
    public AutoCraftingHandler registerAutoCraftingHandler(AutoCraftingHandler handler) {
        this.autoCraftingHandlers.add(handler);
        return handler;
    }

    @Override
    public List<AutoCraftingHandler> getSortedAutoCraftingHandler() {
        return this.autoCraftingHandlers.stream().sorted(Comparator.comparingDouble(AutoCraftingHandler::getPriority).reversed()).collect(Collectors.toList());
    }

    @Override
    public int getRecipeCount() {
        return this.recipeCount.get();
    }

    @Override
    public List<avk> getAllSortedRecipes() {
        return this.getRecipeManager().b().stream().sorted(RECIPE_COMPARATOR).collect(Collectors.toList());
    }

    @Override
    public Map<RecipeCategory<?>, List<RecipeDisplay>> getAllRecipes() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        this.categories.forEach(recipeCategory -> {
            List list;
            if (this.recipeCategoryListMap.containsKey(recipeCategory.getIdentifier()) && !(list = this.recipeCategoryListMap.get(recipeCategory.getIdentifier()).stream().filter(display -> this.isDisplayVisible((RecipeDisplay)display)).collect(Collectors.toList())).isEmpty()) {
                map.put(recipeCategory, list);
            }
        });
        return map;
    }

    @Override
    public List<RecipeDisplay> getAllRecipesFromCategory(RecipeCategory category) {
        return this.recipeCategoryListMap.get(category.getIdentifier());
    }

    @Override
    public void registerRecipeVisibilityHandler(DisplayVisibilityHandler visibilityHandler) {
        this.displayVisibilityHandlers.add(visibilityHandler);
    }

    @Override
    public void unregisterRecipeVisibilityHandler(DisplayVisibilityHandler visibilityHandler) {
        this.displayVisibilityHandlers.remove(visibilityHandler);
    }

    @Override
    public List<DisplayVisibilityHandler> getDisplayVisibilityHandlers() {
        return Collections.unmodifiableList(this.displayVisibilityHandlers);
    }

    @Override
    public boolean isDisplayVisible(RecipeDisplay display, boolean respectConfig) {
        return this.isDisplayVisible(display);
    }

    @Override
    public boolean isDisplayVisible(RecipeDisplay display) {
        RecipeCategory category = this.getCategory(display.getRecipeCategory());
        List list = this.getDisplayVisibilityHandlers().stream().sorted(VISIBILITY_HANDLER_COMPARATOR).collect(Collectors.toList());
        for (DisplayVisibilityHandler displayVisibilityHandler : list) {
            try {
                adm visibility = displayVisibilityHandler.handleDisplay(category, display);
                if (visibility == adm.b) continue;
                return visibility == adm.a;
            }
            catch (Throwable throwable) {
                RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to check if the recipe is visible!", throwable);
            }
        }
        return true;
    }

    @Override
    public void registerScreenClickArea(Rectangle rectangle, Class<? extends cky> screenClass, Identifier ... categories) {
        this.screenClickAreas.add(new ScreenClickArea(screenClass, rectangle, categories));
    }

    @Override
    public <T extends avk> void registerRecipes(Identifier category, Class<T> recipeClass, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipe -> recipeClass.isAssignableFrom(recipe.getClass()), mappingFunction));
    }

    @Override
    public <T extends avk> void registerRecipes(Identifier category, Function<avk, Boolean> recipeFilter, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipeFilter::apply, mappingFunction));
    }

    @Override
    public <T extends avk> void registerRecipes(Identifier category, Predicate<avk> recipeFilter, Function<T, RecipeDisplay> mappingFunction) {
        this.recipeFunctions.add(new RecipeFunction(category, recipeFilter, mappingFunction));
    }

    @Override
    public void registerLiveRecipeGenerator(LiveRecipeGenerator<?> liveRecipeGenerator) {
        this.liveRecipeGenerators.add(liveRecipeGenerator);
    }

    @Override
    public List<ScreenClickArea> getScreenClickAreas() {
        return this.screenClickAreas;
    }

    static {
        RECIPE_COMPARATOR = (o1, o2) -> {
            int int_1 = o1.b().b().compareTo(o2.b().b());
            if (int_1 == 0) {
                int_1 = o1.b().a().compareTo(o2.b().a());
            }
            return int_1;
        };
        Comparator<DisplayVisibilityHandler> comparator = Comparator.comparingDouble(DisplayVisibilityHandler::getPriority);
        VISIBILITY_HANDLER_COMPARATOR = comparator.reversed();
    }

    private class RecipeFunction {
        Identifier category;
        Predicate<avk> recipeFilter;
        Function mappingFunction;

        public RecipeFunction(Identifier category, Predicate<avk> recipeFilter, Function<?, RecipeDisplay> mappingFunction) {
            this.category = category;
            this.recipeFilter = recipeFilter;
            this.mappingFunction = mappingFunction;
        }
    }

    public class ScreenClickArea {
        Class<? extends cky> screenClass;
        Rectangle rectangle;
        Identifier[] categories;

        private ScreenClickArea(Class<? extends cky> screenClass, Rectangle rectangle, Identifier[] categories) {
            this.screenClass = screenClass;
            this.rectangle = rectangle;
            this.categories = categories;
        }

        public Class<? extends cky> getScreenClass() {
            return this.screenClass;
        }

        public Rectangle getRectangle() {
            return this.rectangle;
        }

        public Identifier[] getCategories() {
            return this.categories;
        }
    }
}

