/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Rectangle;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;

public class DisplayHelperImpl
implements DisplayHelper {
    private static final Comparator<DisplayHelper.DisplayBoundsHandler<?>> BOUNDS_HANDLER_COMPARATOR;
    private static final DisplayHelper.DisplayBoundsHandler<Object> EMPTY;
    private List<DisplayHelper.DisplayBoundsHandler<?>> screenDisplayBoundsHandlers = Lists.newArrayList();
    private Map<Class<?>, DisplayHelper.DisplayBoundsHandler<?>> handlerCache = Maps.newHashMap();
    private BaseBoundsHandler baseBoundsHandler;

    @Override
    public List<DisplayHelper.DisplayBoundsHandler<?>> getSortedBoundsHandlers(Class<?> screenClass) {
        return this.screenDisplayBoundsHandlers.stream().filter(handler -> handler.getBaseSupportedClass().isAssignableFrom(screenClass)).sorted(BOUNDS_HANDLER_COMPARATOR).collect(Collectors.toList());
    }

    @Override
    public List<DisplayHelper.DisplayBoundsHandler<?>> getAllBoundsHandlers() {
        return this.screenDisplayBoundsHandlers;
    }

    @Override
    public DisplayHelper.DisplayBoundsHandler<?> getResponsibleBoundsHandler(Class<?> screenClass) {
        Optional<DisplayHelper.DisplayBoundsHandler> any = this.handlerCache.entrySet().stream().filter(entry -> ((Class)entry.getKey()).equals(screenClass)).map(Map.Entry::getValue).findAny();
        if (any.isPresent()) {
            return any.get();
        }
        this.handlerCache.put(screenClass, this.screenDisplayBoundsHandlers.stream().filter(handler -> handler.getBaseSupportedClass().isAssignableFrom(screenClass)).sorted(BOUNDS_HANDLER_COMPARATOR).findAny().orElse(EMPTY));
        return this.handlerCache.get(screenClass);
    }

    @Override
    public void registerBoundsHandler(DisplayHelper.DisplayBoundsHandler<?> handler) {
        this.screenDisplayBoundsHandlers.add(handler);
    }

    @Override
    public BaseBoundsHandler getBaseBoundsHandler() {
        return this.baseBoundsHandler;
    }

    public void setBaseBoundsHandler(BaseBoundsHandler baseBoundsHandler) {
        this.baseBoundsHandler = baseBoundsHandler;
    }

    public void resetCache() {
        this.handlerCache.clear();
    }

    static {
        EMPTY = new DisplayHelper.DisplayBoundsHandler(){

            public Class getBaseSupportedClass() {
                return null;
            }

            public Rectangle getLeftBounds(Object screen) {
                return new Rectangle();
            }

            public Rectangle getRightBounds(Object screen) {
                return new Rectangle();
            }

            @Override
            public float getPriority() {
                return -10.0f;
            }
        };
        Comparator<DisplayHelper.DisplayBoundsHandler> comparator = Comparator.comparingDouble(DisplayHelper.DisplayBoundsHandler::getPriority);
        BOUNDS_HANDLER_COMPARATOR = comparator.reversed();
    }
}

