/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import blue.endless.jankson.Jankson;
import blue.endless.jankson.JsonObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.ConfigManager;
import me.shedaniel.rei.client.ConfigObject;
import org.dimdev.riftloader.RiftLoader;

public class ConfigManagerImpl
implements ConfigManager {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Jankson JANKSON = Jankson.builder().build();
    private final File configFile;
    private final File veryOldConfigFile;
    private final File oldConfigFile;
    private ConfigObject config;
    private boolean craftableOnly;

    public ConfigManagerImpl() {
        this.veryOldConfigFile = new File(RiftLoader.instance.configDir, "rei.json");
        this.oldConfigFile = new File(RiftLoader.instance.configDir, "roughlyenoughitems/config.json");
        this.configFile = new File(RiftLoader.instance.configDir, "roughlyenoughitems/config.json5");
        this.craftableOnly = false;
        try {
            this.loadConfig();
            RoughlyEnoughItemsCore.LOGGER.info("[REI] Config is loaded.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveConfig() throws IOException {
        this.configFile.getParentFile().mkdirs();
        if (!this.configFile.exists() && !this.configFile.createNewFile()) {
            RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to save config! Overwriting with default config.");
            this.config = new ConfigObject();
            return;
        }
        try {
            String result = JANKSON.toJson(this.config).toJson(true, true, 0);
            if (!this.configFile.exists()) {
                this.configFile.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(this.configFile, false);
            out.write(result.getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to save config! Overwriting with default config.");
            this.config = new ConfigObject();
            return;
        }
    }

    @Override
    public void loadConfig() throws IOException {
        this.configFile.getParentFile().mkdirs();
        if (!this.configFile.exists() && this.veryOldConfigFile.exists()) {
            RoughlyEnoughItemsCore.LOGGER.info("[REI] Detected old config file, trying to move it.");
            try {
                Files.move(this.veryOldConfigFile.toPath(), this.configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                e.printStackTrace();
                RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to move config file.");
            }
        }
        if (!this.configFile.exists() && this.oldConfigFile.exists()) {
            RoughlyEnoughItemsCore.LOGGER.info("[REI] Detected old config file, trying to move it.");
            try {
                Files.move(this.oldConfigFile.toPath(), this.configFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                e.printStackTrace();
                RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to move config file.");
            }
        }
        if (!this.configFile.exists() || !this.configFile.canRead()) {
            RoughlyEnoughItemsCore.LOGGER.warn("[REI] Config not found! Creating one.");
            this.config = new ConfigObject();
            this.saveConfig();
            return;
        }
        boolean failed = false;
        try {
            JsonObject configJson = JANKSON.load(this.configFile);
            String regularized = configJson.toJson(false, false, 0);
            this.config = (ConfigObject)GSON.fromJson(regularized, ConfigObject.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            failed = true;
        }
        if (failed || this.config == null) {
            RoughlyEnoughItemsCore.LOGGER.error("[REI] Failed to load config! Overwriting with default config.");
            this.config = new ConfigObject();
        }
        this.saveConfig();
    }

    @Override
    public ConfigObject getConfig() {
        return this.config;
    }

    @Override
    public boolean isCraftableOnlyEnabled() {
        return this.craftableOnly;
    }

    @Override
    public void toggleCraftableOnly() {
        this.craftableOnly = !this.craftableOnly;
    }
}

