/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.rei.RoughlyEnoughItemsClient;
import me.shedaniel.rei.api.ClientHelper;
import me.shedaniel.rei.api.Identifier;
import me.shedaniel.rei.api.Identifiers;
import me.shedaniel.rei.api.RecipeCategory;
import me.shedaniel.rei.api.RecipeDisplay;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.KeybindRegistry;
import me.shedaniel.rei.client.ScreenHelper;
import me.shedaniel.rei.gui.PreRecipeViewingScreen;
import me.shedaniel.rei.gui.RecipeViewingScreen;
import me.shedaniel.rei.gui.VillagerRecipeViewingScreen;
import me.shedaniel.rei.gui.config.RecipeScreenType;
import me.shedaniel.rei.network.CreateItemPacket;
import me.shedaniel.rei.network.DeleteItemPacket;
import org.dimdev.riftloader.RiftLoader;

public class ClientHelperImpl
implements ClientHelper {
    public static ClientHelperImpl instance = new ClientHelperImpl();
    private final Map<String, String> modNameCache = Maps.newHashMap();

    public String getFormattedModNoItalicFromItem(ata item) {
        String mod = this.getModFromItem(item);
        if (mod.equalsIgnoreCase("")) {
            return "";
        }
        return ChatFormatting.BLUE.toString() + mod;
    }

    @Override
    public String getFormattedModFromItem(ata item) {
        String mod = this.getModFromItem(item);
        if (mod.equalsIgnoreCase("")) {
            return "";
        }
        return ChatFormatting.BLUE.toString() + ChatFormatting.ITALIC.toString() + mod;
    }

    @Override
    public String getFormattedModFromIdentifier(Identifier identifier) {
        String mod = this.getModFromIdentifier(identifier);
        if (mod.equalsIgnoreCase("")) {
            return "";
        }
        return ChatFormatting.BLUE.toString() + ChatFormatting.ITALIC.toString() + mod;
    }

    @Override
    public cfp getRecipeKeyBinding() {
        return KeybindRegistry.recipe;
    }

    @Override
    public cfp getUsageKeyBinding() {
        return KeybindRegistry.usage;
    }

    @Override
    public cfp getHideKeyBinding() {
        return KeybindRegistry.hide;
    }

    @Override
    public cfp getPreviousPageKeyBinding() {
        return KeybindRegistry.previousPage;
    }

    @Override
    public cfp getNextPageKeyBinding() {
        return KeybindRegistry.nextPage;
    }

    @Override
    public cfp getFocusSearchFieldKeyBinding() {
        return KeybindRegistry.focusSearchField;
    }

    @Override
    public String getModFromItem(ata item) {
        if (item.equals(atf.a)) {
            return "";
        }
        return this.getModFromIdentifier(Identifiers.of(fc.s.b((Object)item)));
    }

    @Override
    public String getModFromIdentifier(Identifier identifier) {
        if (identifier == null) {
            return "";
        }
        Optional<Object> any = Optional.ofNullable(this.modNameCache.getOrDefault(identifier.getNamespace(), null));
        if (any.isPresent()) {
            return any.get();
        }
        String modid = identifier.getNamespace();
        String s = RiftLoader.instance.getMods().stream().filter(modInfo -> modInfo.id.equalsIgnoreCase(modid)).findFirst().map(modInfo -> {
            if (modInfo.name == null) {
                return modInfo.id;
            }
            return modInfo.name;
        }).orElse(modid);
        this.modNameCache.put(modid, s);
        return s;
    }

    @Override
    public boolean isCheating() {
        return RoughlyEnoughItemsClient.getConfigManager().getConfig().cheating;
    }

    @Override
    public void setCheating(boolean cheating) {
        RoughlyEnoughItemsClient.getConfigManager().getConfig().cheating = cheating;
        try {
            RoughlyEnoughItemsClient.getConfigManager().saveConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void sendDeletePacket() {
        if (ScreenHelper.getLastContainerScreen() instanceof clh) {
            cft.s().i.bB.g(ate.a);
            return;
        }
        if (cft.s().x()) {
            cft.s().o().a((iv)new DeleteItemPacket());
        }
    }

    @Override
    public boolean tryCheatingStack(ate cheatedStack) {
        if (cft.s().x()) {
            try {
                cft.s().o().a((iv)new CreateItemPacket(cheatedStack.i()));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        Identifier identifier = Identifiers.of(fc.s.b((Object)cheatedStack.b()));
        String tagMessage = cheatedStack.i().n() != null && !cheatedStack.i().n().isEmpty() ? cheatedStack.i().n().toString() : "";
        String og = cheatedStack.C() == 1 ? RoughlyEnoughItemsClient.getConfigManager().getConfig().giveCommand.replaceAll(" \\{count}", "") : RoughlyEnoughItemsClient.getConfigManager().getConfig().giveCommand;
        String madeUpCommand = og.replaceAll("\\{player_name}", cft.s().i.bv()).replaceAll("\\{item_name}", identifier.getPath()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", tagMessage).replaceAll("\\{count}", String.valueOf(cheatedStack.C()));
        if (madeUpCommand.length() > 256) {
            madeUpCommand = og.replaceAll("\\{player_name}", cft.s().i.bv()).replaceAll("\\{item_name}", identifier.getPath()).replaceAll("\\{item_identifier}", identifier.toString()).replaceAll("\\{nbt}", "").replaceAll("\\{count}", String.valueOf(cheatedStack.C()));
            cft.s().i.a((ij)new ir("text.rei.too_long_nbt", new Object[0]), false);
        }
        cft.s().i.f(madeUpCommand);
        return true;
    }

    @Override
    public boolean executeRecipeKeyBind(ate stack) {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = RecipeHelper.getInstance().getRecipesFor(stack);
        if (map.keySet().size() > 0) {
            this.openRecipeViewingScreen(map);
        }
        return map.keySet().size() > 0;
    }

    @Override
    public boolean executeUsageKeyBind(ate stack) {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = RecipeHelper.getInstance().getUsagesFor(stack);
        if (map.keySet().size() > 0) {
            this.openRecipeViewingScreen(map);
        }
        return map.keySet().size() > 0;
    }

    @Override
    public List<ate> getInventoryItemsTypes() {
        ImmutableList field_7543 = ImmutableList.of((Object)cft.s().i.bB.a, (Object)cft.s().i.bB.b, (Object)cft.s().i.bB.c);
        ArrayList<ate> inventoryStacks = new ArrayList<ate>();
        field_7543.forEach(itemStacks -> itemStacks.forEach(itemStack -> {
            if (!itemStack.a()) {
                inventoryStacks.add((ate)itemStack);
            }
        }));
        return inventoryStacks;
    }

    @Override
    public boolean executeViewAllRecipesKeyBind() {
        Map<RecipeCategory<?>, List<RecipeDisplay>> map = RecipeHelper.getInstance().getAllRecipes();
        if (map.keySet().size() > 0) {
            this.openRecipeViewingScreen(map);
        }
        return map.keySet().size() > 0;
    }

    @Override
    public boolean executeViewAllRecipesFromCategory(Identifier category) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        Optional<RecipeCategory> any = RecipeHelper.getInstance().getAllCategories().stream().filter(c -> c.getIdentifier().equals(category)).findAny();
        if (!any.isPresent()) {
            return false;
        }
        RecipeCategory recipeCategory = any.get();
        map.put(recipeCategory, RecipeHelper.getInstance().getAllRecipesFromCategory(recipeCategory));
        if (map.keySet().size() > 0) {
            this.openRecipeViewingScreen(map);
        }
        return map.keySet().size() > 0;
    }

    @Override
    public boolean executeViewAllRecipesFromCategories(List<Identifier> categories) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (Identifier category : categories) {
            Optional<RecipeCategory> any = RecipeHelper.getInstance().getAllCategories().stream().filter(c -> c.getIdentifier().equals(category)).findAny();
            if (!any.isPresent()) continue;
            RecipeCategory recipeCategory = any.get();
            map.put(recipeCategory, RecipeHelper.getInstance().getAllRecipesFromCategory(recipeCategory));
        }
        if (map.keySet().size() > 0) {
            this.openRecipeViewingScreen(map);
        }
        return map.keySet().size() > 0;
    }

    @Override
    public void openRecipeViewingScreen(Map<RecipeCategory<?>, List<RecipeDisplay>> map) {
        if (RoughlyEnoughItemsClient.getConfigManager().getConfig().screenType == RecipeScreenType.VILLAGER) {
            cft.s().a((ckd)new VillagerRecipeViewingScreen(map));
        } else if (RoughlyEnoughItemsClient.getConfigManager().getConfig().screenType == RecipeScreenType.UNSET) {
            cft.s().a((ckd)new PreRecipeViewingScreen(map));
        } else {
            cft.s().a((ckd)new RecipeViewingScreen(map));
        }
    }

    static {
        ClientHelperImpl.instance.modNameCache.put("minecraft", "Minecraft");
        ClientHelperImpl.instance.modNameCache.put("c", "Common");
    }
}

