/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.client;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.BaseBoundsHandler;
import me.shedaniel.rei.api.DisplayHelper;

public class BaseBoundsHandlerImpl
implements BaseBoundsHandler {
    private static final Function<Rectangle, String> RECTANGLE_STRING_FUNCTION = rectangle -> rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height;
    private static final Comparator<Rectangle> RECTANGLE_COMPARATOR = BaseBoundsHandlerImpl::compare;
    private static final Comparator<Pair<Pair<Class<?>, Float>, Function<Boolean, List<Rectangle>>>> LIST_PAIR_COMPARATOR;
    private String lastArea = null;
    private List<Pair<Pair<Class<?>, Float>, Function<Boolean, List<Rectangle>>>> list = Lists.newArrayList();

    private static int compare(Rectangle o1, Rectangle o2) {
        return RECTANGLE_STRING_FUNCTION.apply(o1).compareTo(RECTANGLE_STRING_FUNCTION.apply(o2));
    }

    @Override
    public Class getBaseSupportedClass() {
        return ckd.class;
    }

    @Override
    public Rectangle getLeftBounds(ckd screen) {
        return new Rectangle();
    }

    @Override
    public Rectangle getRightBounds(ckd screen) {
        return new Rectangle();
    }

    @Override
    public float getPriority() {
        return -5.0f;
    }

    @Override
    public adm isInZone(boolean isOnRightSide, double mouseX, double mouseY) {
        for (Rectangle zone : this.getCurrentExclusionZones(cft.s().m.getClass(), isOnRightSide)) {
            if (!zone.contains(mouseX, mouseY)) continue;
            return adm.c;
        }
        return adm.b;
    }

    @Override
    public boolean shouldRecalculateArea(boolean isOnRightSide, Rectangle rectangle) {
        if (this.lastArea == null) {
            this.lastArea = this.getStringFromCurrent(isOnRightSide);
            return false;
        }
        if (this.lastArea.contentEquals(this.getStringFromCurrent(isOnRightSide))) {
            return false;
        }
        this.lastArea = this.getStringFromCurrent(isOnRightSide);
        return true;
    }

    private DisplayHelper.DisplayBoundsHandler getHandler() {
        return RoughlyEnoughItemsCore.getDisplayHelper().getResponsibleBoundsHandler(cft.s().m.getClass());
    }

    private String getStringFromCurrent(boolean isOnRightSide) {
        return this.getStringFromAreas(isOnRightSide ? this.getHandler().getRightBounds(cft.s().m) : this.getHandler().getLeftBounds(cft.s().m), this.getCurrentExclusionZones(cft.s().m.getClass(), isOnRightSide));
    }

    @Override
    public adm canItemSlotWidgetFit(boolean isOnRightSide, int left, int top, ckd screen, Rectangle fullBounds) {
        List<Rectangle> currentExclusionZones = this.getCurrentExclusionZones(cft.s().m.getClass(), isOnRightSide);
        for (Rectangle currentExclusionZone : currentExclusionZones) {
            if (left + 18 < currentExclusionZone.x || top + 18 < currentExclusionZone.y || left > currentExclusionZone.x + currentExclusionZone.width || top > currentExclusionZone.y + currentExclusionZone.height) continue;
            return adm.c;
        }
        return adm.b;
    }

    @Override
    public List<Rectangle> getCurrentExclusionZones(Class<?> currentScreenClass, boolean isOnRightSide) {
        List<Pair> only = this.list.stream().filter(pair -> ((Class)((Pair)pair.getFirst()).getFirst()).isAssignableFrom(currentScreenClass)).collect(Collectors.toList());
        only.sort(LIST_PAIR_COMPARATOR);
        ArrayList rectangles = Lists.newArrayList();
        only.forEach(pair -> rectangles.addAll((Collection)((Function)pair.getSecond()).apply(isOnRightSide)));
        return rectangles;
    }

    @Override
    public void registerExclusionZones(Class<?> screenClass, Function<Boolean, List<Rectangle>> supplier) {
        this.list.add(new Pair((Object)new Pair(screenClass, (Object)Float.valueOf(0.0f)), supplier));
    }

    public String getStringFromAreas(Rectangle rectangle, List<Rectangle> exclusionZones) {
        ArrayList sorted = Lists.newArrayList(exclusionZones);
        sorted.sort(RECTANGLE_COMPARATOR);
        return RECTANGLE_STRING_FUNCTION.apply(rectangle) + ":" + sorted.stream().map(RECTANGLE_STRING_FUNCTION::apply).collect(Collectors.joining("|"));
    }

    static {
        Comparator<Pair> comparator = Comparator.comparingDouble(value -> ((Float)((Pair)value.getFirst()).getSecond()).floatValue());
        LIST_PAIR_COMPARATOR = comparator.reversed();
    }
}

