/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class Identifier
implements Comparable<Identifier> {
    private static final SimpleCommandExceptionType field_200118_c = new SimpleCommandExceptionType((Message)new ir("argument.id.invalid", new Object[0]));
    protected final String namespace;
    protected final String path;

    protected Identifier(String[] p_i47923_1_) {
        this.namespace = StringUtils.isEmpty((CharSequence)p_i47923_1_[0]) ? "minecraft" : p_i47923_1_[0];
        this.path = p_i47923_1_[1];
        if (!this.namespace.chars().allMatch(p_195825_0_ -> p_195825_0_ == 95 || p_195825_0_ == 45 || p_195825_0_ >= 97 && p_195825_0_ <= 122 || p_195825_0_ >= 48 && p_195825_0_ <= 57 || p_195825_0_ == 46)) {
            throw new i("Non [a-z0-9_.-] character in namespace of location: " + this.namespace + ':' + this.path);
        }
        if (!this.path.chars().allMatch(p_195827_0_ -> p_195827_0_ == 95 || p_195827_0_ == 45 || p_195827_0_ >= 97 && p_195827_0_ <= 122 || p_195827_0_ >= 48 && p_195827_0_ <= 57 || p_195827_0_ == 47 || p_195827_0_ == 46)) {
            throw new i("Non [a-z0-9/._-] character in path of location: " + this.namespace + ':' + this.path);
        }
    }

    public Identifier(String resourceName) {
        this(Identifier.decompose(resourceName, ':'));
    }

    public Identifier(String namespaceIn, String pathIn) {
        this(new String[]{namespaceIn, pathIn});
    }

    public static Identifier of(String p_195828_0_, char p_195828_1_) {
        return new Identifier(Identifier.decompose(p_195828_0_, p_195828_1_));
    }

    @Nullable
    public static Identifier makeResourceLocation(String string) {
        try {
            return new Identifier(string);
        }
        catch (i var2) {
            return null;
        }
    }

    protected static String[] decompose(String p_195823_0_, char p_195823_1_) {
        String[] astring = new String[]{"minecraft", p_195823_0_};
        int i2 = p_195823_0_.indexOf(p_195823_1_);
        if (i2 >= 0) {
            astring[1] = p_195823_0_.substring(i2 + 1, p_195823_0_.length());
            if (i2 >= 1) {
                astring[0] = p_195823_0_.substring(0, i2);
            }
        }
        return astring;
    }

    public static Identifier read(StringReader reader) throws CommandSyntaxException {
        int i2 = reader.getCursor();
        while (reader.canRead() && Identifier.isValidPathCharacter(reader.peek())) {
            reader.skip();
        }
        String s = reader.getString().substring(i2, reader.getCursor());
        try {
            return new Identifier(s);
        }
        catch (i var4) {
            reader.setCursor(i2);
            throw field_200118_c.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static boolean isValidPathCharacter(char charIn) {
        return charIn >= '0' && charIn <= '9' || charIn >= 'a' && charIn <= 'z' || charIn == '_' || charIn == ':' || charIn == '/' || charIn == '.' || charIn == '-';
    }

    public String getPath() {
        return this.path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String toString() {
        return this.namespace + ':' + this.path;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof Identifier)) {
            return false;
        }
        Identifier resourcelocation = (Identifier)p_equals_1_;
        return this.namespace.equals(resourcelocation.namespace) && this.path.equals(resourcelocation.path);
    }

    public int hashCode() {
        return 31 * this.namespace.hashCode() + this.path.hashCode();
    }

    @Override
    public int compareTo(Identifier p_compareTo_1_) {
        int i2 = this.path.compareTo(p_compareTo_1_.path);
        if (i2 == 0) {
            i2 = this.namespace.compareTo(p_compareTo_1_.namespace);
        }
        return i2;
    }

    public static class Serializer
    implements JsonDeserializer<Identifier>,
    JsonSerializer<Identifier> {
        public Identifier deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return new Identifier(xj.a((JsonElement)p_deserialize_1_, (String)"location"));
        }

        public JsonElement serialize(Identifier p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            return new JsonPrimitive(p_serialize_1_.toString());
        }
    }
}

