/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.shedaniel.rei.RoughlyEnoughItemsClient;
import me.shedaniel.rei.api.DisplayHelper;
import me.shedaniel.rei.api.Identifier;
import me.shedaniel.rei.api.ItemRegistry;
import me.shedaniel.rei.api.REIPluginEntry;
import me.shedaniel.rei.api.RecipeHelper;
import me.shedaniel.rei.client.DisplayHelperImpl;
import me.shedaniel.rei.client.ItemRegistryImpl;
import me.shedaniel.rei.client.RecipeHelperImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RoughlyEnoughItemsCore {
    public static final Logger LOGGER;
    public static final ExecutorService SYNC_RECIPES;
    private static final RecipeHelper RECIPE_HELPER;
    private static final ItemRegistry ITEM_REGISTRY;
    private static final DisplayHelper DISPLAY_HELPER;

    public static RecipeHelper getRecipeHelper() {
        return RECIPE_HELPER;
    }

    public static ItemRegistry getItemRegisterer() {
        return ITEM_REGISTRY;
    }

    public static DisplayHelper getDisplayHelper() {
        return DISPLAY_HELPER;
    }

    public static List<REIPluginEntry> getPlugins() {
        return new LinkedList<REIPluginEntry>(RoughlyEnoughItemsClient.plugins.values());
    }

    public static Optional<Identifier> getPluginIdentifier(REIPluginEntry plugin) {
        for (Identifier identifier : RoughlyEnoughItemsClient.plugins.keySet()) {
            if (identifier == null || !RoughlyEnoughItemsClient.plugins.get(identifier).equals(plugin)) continue;
            return Optional.of(identifier);
        }
        return Optional.empty();
    }

    static {
        SYNC_RECIPES = Executors.newSingleThreadScheduledExecutor(r2 -> new Thread(r2, "REI-SyncRecipes"));
        RECIPE_HELPER = new RecipeHelperImpl();
        ITEM_REGISTRY = new ItemRegistryImpl();
        DISPLAY_HELPER = new DisplayHelperImpl();
        LOGGER = LogManager.getFormatterLogger((String)"REI");
    }
}

