/*
 * Decompiled with CFR 0.152.
 */
package blue.endless.jankson;

import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonNull;
import blue.endless.jankson.impl.Marshaller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JsonObject
extends JsonElement
implements Map<String, JsonElement> {
    protected Marshaller marshaller = Marshaller.getFallback();
    private List<Entry> entries = new ArrayList<Entry>();

    @Nullable
    public JsonObject getObject(@Nonnull String name) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(name)) continue;
            if (entry.value instanceof JsonObject) {
                return (JsonObject)entry.value;
            }
            return null;
        }
        return null;
    }

    public JsonElement put(@Nonnull String key, @Nonnull JsonElement elem, @Nullable String comment) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(key)) continue;
            JsonElement result = entry.value;
            entry.value = elem;
            entry.comment = comment;
            return result;
        }
        Entry entry = new Entry();
        if (elem instanceof JsonObject) {
            ((JsonObject)elem).marshaller = this.marshaller;
        }
        if (elem instanceof JsonArray) {
            ((JsonArray)elem).marshaller = this.marshaller;
        }
        entry.key = key;
        entry.value = elem;
        entry.comment = comment;
        this.entries.add(entry);
        return null;
    }

    @Nonnull
    public JsonElement putDefault(@Nonnull String key, @Nonnull JsonElement elem, @Nullable String comment) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(key)) continue;
            return entry.value;
        }
        Entry entry = new Entry();
        entry.key = key;
        entry.value = elem;
        entry.comment = comment;
        this.entries.add(entry);
        return elem;
    }

    @Nullable
    public <T> T putDefault(@Nonnull String key, @Nonnull T elem, @Nullable String comment) {
        return this.putDefault(key, elem, elem.getClass(), comment);
    }

    @Nullable
    public <T> T putDefault(@Nonnull String key, @Nonnull T elem, Class<? extends T> clazz, @Nullable String comment) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(key)) continue;
            return this.marshaller.marshall(clazz, entry.value);
        }
        Entry entry = new Entry();
        entry.key = key;
        entry.value = this.marshaller.serialize(elem);
        if (entry.value == null) {
            entry.value = JsonNull.INSTANCE;
        }
        entry.comment = comment;
        this.entries.add(entry);
        return elem;
    }

    @Nonnull
    public JsonObject getDelta(@Nonnull JsonObject defaults) {
        JsonObject result = new JsonObject();
        for (Entry entry : this.entries) {
            String key = entry.key;
            JsonElement defaultValue = defaults.get(key);
            if (defaultValue == null) {
                result.put(entry.key, entry.value, entry.comment);
                continue;
            }
            if (entry.value instanceof JsonObject && defaultValue instanceof JsonObject) {
                JsonObject subDelta = ((JsonObject)entry.value).getDelta((JsonObject)defaultValue);
                if (subDelta.isEmpty()) continue;
                result.put(entry.key, subDelta, entry.comment);
                continue;
            }
            if (entry.value.equals(defaultValue)) continue;
            result.put(entry.key, entry.value, entry.comment);
        }
        return result;
    }

    @Nullable
    public String getComment(@Nonnull String name) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(name)) continue;
            return entry.comment;
        }
        return null;
    }

    public void setComment(@Nonnull String name, @Nullable String comment) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(name)) continue;
            entry.comment = comment;
            return;
        }
    }

    @Override
    public String toJson(boolean comments, boolean newlines, int depth) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        if (newlines && this.entries.size() > 0) {
            builder.append('\n');
        }
        for (int i2 = 0; i2 < this.entries.size(); ++i2) {
            int j2;
            Entry entry = this.entries.get(i2);
            if (newlines) {
                for (j2 = 0; j2 < depth + 1; ++j2) {
                    builder.append("\t");
                }
            }
            if (comments && entry.comment != null) {
                builder.append("/* ");
                builder.append(entry.comment);
                builder.append(" */ ");
                if (newlines) {
                    builder.append('\n');
                    for (j2 = 0; j2 < depth + 1; ++j2) {
                        builder.append("\t");
                    }
                }
            }
            builder.append("\"");
            builder.append(entry.key);
            builder.append("\": ");
            if (entry.value instanceof JsonObject) {
                builder.append(((JsonObject)entry.value).toJson(comments, newlines, depth + 1));
            } else if (entry.value instanceof JsonArray) {
                builder.append(((JsonArray)entry.value).toJson(comments, newlines, depth + 1));
            } else {
                builder.append(entry.value.toJson(comments, newlines, depth + 1));
            }
            if (i2 >= this.entries.size() - 1) continue;
            if (newlines) {
                builder.append(",\n");
                continue;
            }
            builder.append(", ");
        }
        if (this.entries.size() > 0) {
            if (newlines) {
                builder.append('\n');
                if (depth > 0) {
                    for (int j3 = 0; j3 < depth; ++j3) {
                        builder.append("\t");
                    }
                }
            } else {
                builder.append(' ');
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public String toString() {
        return this.toJson(true, false, 0);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof JsonObject)) {
            return false;
        }
        JsonObject otherObject = (JsonObject)other;
        if (this.entries.size() != otherObject.entries.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.entries.size(); ++i2) {
            Entry b2;
            Entry a2 = this.entries.get(i2);
            if (a2.equals(b2 = otherObject.entries.get(i2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.entries.hashCode();
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Nullable
    public <E> E get(@Nonnull Class<E> clazz, @Nonnull String key) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Cannot get from empty key");
        }
        JsonElement elem = this.get(key);
        return this.marshaller.marshall(clazz, elem);
    }

    @Nullable
    public <E> E recursiveGet(@Nonnull Class<E> clazz, @Nonnull String key) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Cannot get from empty key");
        }
        String[] parts = key.split("\\.");
        JsonObject cur = this;
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String s = parts[i2];
            if (s.isEmpty()) {
                throw new IllegalArgumentException("Cannot get from broken key '" + key + "'");
            }
            JsonElement elem = cur.get(s);
            if (i2 < parts.length - 1) {
                if (!(elem instanceof JsonObject)) {
                    return null;
                }
            } else {
                return this.marshaller.marshall(clazz, elem);
            }
            cur = (JsonObject)elem;
        }
        throw new IllegalArgumentException("Cannot get from broken key '" + key + "'");
    }

    public <E extends JsonElement> E recursiveGetOrCreate(@Nonnull Class<E> clazz, @Nonnull String key, @Nonnull E fallback, @Nullable String comment) {
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Cannot get from empty key");
        }
        String[] parts = key.split("\\.");
        JsonObject cur = this;
        for (int i2 = 0; i2 < parts.length; ++i2) {
            String s = parts[i2];
            if (s.isEmpty()) {
                throw new IllegalArgumentException("Cannot get from broken key '" + key + "'");
            }
            JsonElement elem = cur.get(s);
            if (i2 < parts.length - 1) {
                if (elem instanceof JsonObject) {
                    cur = (JsonObject)elem;
                    continue;
                }
                JsonObject replacement = new JsonObject();
                cur.put(s, replacement);
                cur = replacement;
                continue;
            }
            if (elem != null && clazz.isAssignableFrom(elem.getClass())) {
                return (E)elem;
            }
            JsonElement result = fallback.clone();
            cur.put(key, result, comment);
            return (E)result;
        }
        throw new IllegalArgumentException("Cannot get from broken key '" + key + "'");
    }

    @Override
    public JsonObject clone() {
        JsonObject result = new JsonObject();
        for (Entry entry : this.entries) {
            result.put(entry.key, entry.value.clone(), entry.comment);
        }
        return result;
    }

    @Override
    @Nullable
    public JsonElement put(@Nonnull String key, @Nonnull JsonElement elem) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(key)) continue;
            JsonElement result = entry.value;
            entry.value = elem;
            return result;
        }
        Entry entry = new Entry();
        entry.key = key;
        entry.value = elem;
        this.entries.add(entry);
        return null;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (key == null) {
            return false;
        }
        if (!(key instanceof String)) {
            return false;
        }
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase((String)key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(@Nullable Object val) {
        if (val == null) {
            return false;
        }
        if (!(val instanceof JsonElement)) {
            return false;
        }
        for (Entry entry : this.entries) {
            if (!entry.value.equals(val)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, JsonElement>> entrySet() {
        HashSet<Map.Entry<String, JsonElement>> result = new HashSet<Map.Entry<String, JsonElement>>();
        for (final Entry entry : this.entries) {
            result.add(new Map.Entry<String, JsonElement>(){

                @Override
                public String getKey() {
                    return entry.key;
                }

                @Override
                public JsonElement getValue() {
                    return entry.value;
                }

                @Override
                public JsonElement setValue(JsonElement value) {
                    JsonElement oldValue = entry.value;
                    entry.value = value;
                    return oldValue;
                }
            });
        }
        return result;
    }

    @Override
    @Nullable
    public JsonElement get(@Nullable Object key) {
        if (key == null || !(key instanceof String)) {
            return null;
        }
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase((String)key)) continue;
            return entry.value;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    @Nonnull
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        for (Entry entry : this.entries) {
            keys.add(entry.key);
        }
        return keys;
    }

    @Override
    public void putAll(Map<? extends String, ? extends JsonElement> map) {
        for (Map.Entry<? extends String, ? extends JsonElement> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Nullable
    public JsonElement remove(@Nullable Object key) {
        if (key == null || !(key instanceof String)) {
            return null;
        }
        for (int i2 = 0; i2 < this.entries.size(); ++i2) {
            Entry entry = this.entries.get(i2);
            if (!entry.key.equalsIgnoreCase((String)key)) continue;
            return this.entries.remove((int)i2).value;
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Collection<JsonElement> values() {
        ArrayList<JsonElement> values = new ArrayList<JsonElement>();
        for (Entry entry : this.entries) {
            values.add(entry.value);
        }
        return values;
    }

    private static final class Entry {
        protected String comment;
        protected String key;
        protected JsonElement value;

        private Entry() {
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof Entry)) {
                return false;
            }
            Entry o2 = (Entry)other;
            if (!Objects.equals(this.comment, o2.comment)) {
                return false;
            }
            if (!this.key.equals(o2.key)) {
                return false;
            }
            return this.value.equals(o2.value);
        }

        public int hashCode() {
            return Objects.hash(this.comment, this.key, this.value);
        }
    }
}

