/*
 * Decompiled with CFR 0.152.
 */
package blue.endless.jankson;

import blue.endless.jankson.JsonElement;
import blue.endless.jankson.impl.Marshaller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JsonArray
extends JsonElement
implements Collection<JsonElement>,
Iterable<JsonElement> {
    private List<Entry> entries = new ArrayList<Entry>();
    protected Marshaller marshaller = Marshaller.getFallback();

    public JsonArray() {
    }

    public <T> JsonArray(T[] ts, Marshaller marshaller) {
        this.marshaller = marshaller;
        for (T t : ts) {
            this.add(marshaller.serialize(t));
        }
    }

    public JsonArray(Collection<?> ts, Marshaller marshaller) {
        this.marshaller = marshaller;
        for (Object t : ts) {
            this.add(marshaller.serialize(t));
        }
    }

    public JsonElement get(int i2) {
        return this.entries.get((int)i2).value;
    }

    public String getComment(int i2) {
        return this.entries.get((int)i2).comment;
    }

    @Override
    public String toJson(boolean comments, boolean newlines, int depth) {
        int j2;
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        if (newlines) {
            builder.append('\n');
            for (j2 = 0; j2 < depth + 1; ++j2) {
                builder.append("\t");
            }
        }
        for (int i2 = 0; i2 < this.entries.size(); ++i2) {
            int j3;
            Entry entry = this.entries.get(i2);
            if (entry.comment != null) {
                builder.append("/* ");
                builder.append(entry.comment);
                builder.append(" */ ");
                if (newlines) {
                    builder.append('\n');
                    for (j3 = 0; j3 < depth + 1; ++j3) {
                        builder.append("\t");
                    }
                }
            }
            builder.append(entry.value.toJson(comments, newlines, depth + 1));
            if (i2 >= this.entries.size() - 1) continue;
            if (newlines) {
                builder.append(",\n");
                for (j3 = 0; j3 < depth + 1; ++j3) {
                    builder.append("\t");
                }
                continue;
            }
            builder.append(", ");
        }
        if (this.entries.size() > 0) {
            if (newlines) {
                builder.append('\n');
                for (j2 = 0; j2 < depth; ++j2) {
                    builder.append("\t");
                }
            } else {
                builder.append(' ');
            }
        }
        builder.append(']');
        return builder.toString();
    }

    public String toString() {
        return this.toJson(true, false, 0);
    }

    public boolean add(@Nonnull JsonElement e, String comment) {
        if (this.contains(e)) {
            return false;
        }
        Entry entry = new Entry();
        entry.value = e;
        entry.comment = comment;
        this.entries.add(entry);
        return true;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null || !(other instanceof JsonArray)) {
            return false;
        }
        List<Entry> a2 = this.entries;
        List<Entry> b2 = ((JsonArray)other).entries;
        if (a2.size() != b2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < a2.size(); ++i2) {
            Entry ae = a2.get(i2);
            Entry be = b2.get(i2);
            if (!ae.value.equals(be.value)) {
                return false;
            }
            if (Objects.equals(ae.comment, be.comment)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.entries.hashCode();
    }

    @Nullable
    public <E> E get(@Nonnull Class<E> clazz, int index) {
        JsonElement elem = this.get(index);
        return this.marshaller.marshall(clazz, elem);
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Override
    public JsonArray clone() {
        JsonArray result = new JsonArray();
        result.marshaller = this.marshaller;
        for (Entry entry : this.entries) {
            result.add(entry.value.clone(), entry.comment);
        }
        return result;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean add(@Nonnull JsonElement e) {
        Entry entry = new Entry();
        entry.value = e;
        this.entries.add(entry);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends JsonElement> c) {
        boolean result = false;
        for (JsonElement jsonElement : c) {
            result |= this.add(jsonElement);
        }
        return result;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean contains(Object o2) {
        if (o2 == null || !(o2 instanceof JsonElement)) {
            return false;
        }
        for (Entry entry : this.entries) {
            if (!entry.value.equals(o2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o2 : c) {
            if (this.contains(o2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean remove(Object o2) {
        for (int i2 = 0; i2 < this.entries.size(); ++i2) {
            Entry cur = this.entries.get(i2);
            if (!cur.value.equals(o2)) continue;
            this.entries.remove(i2);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll not supported");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll not supported");
    }

    public JsonElement[] toArray() {
        JsonElement[] result = new JsonElement[this.entries.size()];
        for (int i2 = 0; i2 < this.entries.size(); ++i2) {
            result[i2] = this.entries.get((int)i2).value;
        }
        return result;
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        if (a2.length < this.entries.size()) {
            a2 = new Object[this.entries.size()];
        }
        for (int i2 = 0; i2 < this.entries.size(); ++i2) {
            a2[i2] = this.entries.get((int)i2).value;
        }
        if (a2.length > this.entries.size()) {
            a2[this.entries.size()] = null;
        }
        return a2;
    }

    @Override
    public Iterator<JsonElement> iterator() {
        return new EntryIterator(this.entries);
    }

    private static class Entry {
        String comment;
        JsonElement value;

        private Entry() {
        }

        public boolean equals(Object other) {
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry o2 = (Entry)other;
            return Objects.equals(this.comment, o2.comment) && Objects.equals(this.value, o2.value);
        }

        public int hashCode() {
            return Objects.hash(this.comment, this.value);
        }
    }

    private static class EntryIterator
    implements Iterator<JsonElement> {
        private final Iterator<Entry> delegate;

        public EntryIterator(List<Entry> list) {
            this.delegate = list.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public JsonElement next() {
            return this.delegate.next().value;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }
}

