/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.mixin.IMixinCommandBlockBaseLogic;
import fi.dy.masa.tweakeroo.renderer.RenderUtils;
import fi.dy.masa.tweakeroo.util.SnapAimMode;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MiscUtils {
    private static ij[] previousSignText;
    private static String previousChatText;
    private static final Date DATE;
    private static double lastRealPitch;
    private static double lastRealYaw;
    private static float cameraYaw;
    private static float cameraPitch;
    private static boolean freeCameraSpectator;

    public static void setFreeCameraSpectator(boolean isSpectator) {
        freeCameraSpectator = isSpectator;
    }

    public static boolean getFreeCameraSpectator() {
        return freeCameraSpectator;
    }

    public static boolean getUpdateExec(bjm te) {
        return ((IMixinCommandBlockBaseLogic)te.c()).getUpdateLastExecution();
    }

    public static String getChatTimestamp() {
        SimpleDateFormat sdf = new SimpleDateFormat(Configs.Generic.CHAT_TIME_FORMAT.getStringValue());
        DATE.setTime(System.currentTimeMillis());
        return sdf.format(DATE);
    }

    public static void setLastChatText(String text) {
        previousChatText = text;
    }

    public static String getLastChatText() {
        return previousChatText;
    }

    public static int getChatBackgroundColor(int colorOrig) {
        int newColor = Configs.Generic.CHAT_BACKGROUND_COLOR.getIntegerValue();
        return newColor & 0xFFFFFF | (int)((double)(newColor >>> 24) / 255.0 * ((double)(colorOrig >>> 24) / 255.0) / 0.5 * 255.0) << 24;
    }

    public static void copyTextFromSign(bkc te) {
        int size = te.a.length;
        previousSignText = new ij[size];
        for (int i = 0; i < size; ++i) {
            MiscUtils.previousSignText[i] = te.a(i);
        }
    }

    public static void applyPreviousTextToSign(bkc te) {
        if (previousSignText != null) {
            int size = Math.min(te.a.length, previousSignText.length);
            for (int i = 0; i < size; ++i) {
                te.a(i, previousSignText[i]);
            }
        }
    }

    public static double getLastRealPitch() {
        return lastRealPitch;
    }

    public static double getLastRealYaw() {
        return lastRealYaw;
    }

    public static float getCameraYaw() {
        return cameraYaw;
    }

    public static float getCameraPitch() {
        return cameraPitch;
    }

    public static void setCameraYaw(float yaw) {
        cameraYaw = yaw;
    }

    public static void setCameraPitch(float pitch) {
        cameraPitch = pitch;
    }

    public static void setEntityRotations(aer entity, float yaw, float pitch) {
        entity.w = yaw;
        entity.x = pitch;
        entity.y = yaw;
        entity.z = pitch;
    }

    public static float getSnappedPitch(double realPitch) {
        if (Configs.Generic.SNAP_AIM_MODE.getOptionListValue() == SnapAimMode.YAW) {
            return (float)realPitch;
        }
        if (lastRealPitch != realPitch) {
            lastRealPitch = realPitch;
            RenderUtils.notifyRotationChanged();
        }
        if (FeatureToggle.TWEAK_SNAP_AIM_LOCK.getBooleanValue()) {
            return (float)Configs.Internal.SNAP_AIM_LAST_PITCH.getDoubleValue();
        }
        double step = Configs.Generic.SNAP_AIM_PITCH_STEP.getDoubleValue();
        int limit = Configs.Generic.SNAP_AIM_PITCH_OVERSHOOT.getBooleanValue() ? 180 : 90;
        double snappedPitch = realPitch < 0.0 ? -MiscUtils.calculateSnappedAngle(-realPitch, step) : MiscUtils.calculateSnappedAngle(realPitch, step);
        snappedPitch = xq.a((double)xq.g((double)snappedPitch), (double)(-limit), (double)limit);
        if (Configs.Internal.SNAP_AIM_LAST_PITCH.getDoubleValue() != snappedPitch) {
            String g = GuiBase.TXT_GREEN;
            String r = GuiBase.TXT_RST;
            String str = String.format("%s%s%s (step %s%s%s)", g, String.valueOf(xq.g((double)snappedPitch)), r, g, String.valueOf(step), r);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.snapped_to_pitch", (Object[])new Object[]{str});
            Configs.Internal.SNAP_AIM_LAST_PITCH.setDoubleValue(snappedPitch);
        }
        return xq.g((float)((float)snappedPitch));
    }

    public static float getSnappedYaw(double realYaw) {
        if (Configs.Generic.SNAP_AIM_MODE.getOptionListValue() == SnapAimMode.PITCH) {
            return (float)realYaw;
        }
        if (lastRealYaw != realYaw) {
            lastRealYaw = realYaw;
            RenderUtils.notifyRotationChanged();
        }
        if (FeatureToggle.TWEAK_SNAP_AIM_LOCK.getBooleanValue()) {
            return (float)Configs.Internal.SNAP_AIM_LAST_YAW.getDoubleValue();
        }
        double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
        double snappedYaw = MiscUtils.calculateSnappedAngle(realYaw, step);
        if (Configs.Internal.SNAP_AIM_LAST_YAW.getDoubleValue() != snappedYaw) {
            String g = GuiBase.TXT_GREEN;
            String r = GuiBase.TXT_RST;
            String str = String.format("%s%s%s (step %s%s%s)", g, String.valueOf(xq.g((double)snappedYaw)), r, g, String.valueOf(step), r);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.snapped_to_yaw", (Object[])new Object[]{str});
            Configs.Internal.SNAP_AIM_LAST_YAW.setDoubleValue(snappedYaw);
        }
        return xq.g((float)((float)snappedYaw));
    }

    public static double calculateSnappedAngle(double realRotation, double step) {
        double offsetRealRotation = xq.b((double)realRotation, (double)360.0) + step / 2.0;
        return xq.b((double)((double)((int)(offsetRealRotation / step)) * step), (double)360.0);
    }

    static {
        previousChatText = "";
        DATE = new Date();
    }
}

