/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public class InventoryUtils {
    private static final List<aew> REPAIR_MODE_SLOTS = new ArrayList<aew>();
    private static final List<Integer> REPAIR_MODE_SLOT_NUMBES = new ArrayList<Integer>();
    private static final HashSet<ata> UNSTACKING_ITEMS = new HashSet();

    public static void setUnstackingItems(List<String> names) {
        UNSTACKING_ITEMS.clear();
        for (String name : names) {
            try {
                ata item = (ata)fc.s.b(new pc(name));
                if (item == null || item == atf.a) continue;
                UNSTACKING_ITEMS.add(item);
            }
            catch (Exception e) {
                Tweakeroo.logger.warn("Failed to set an unstacking protected item from name '{}'", (Object)name, (Object)e);
            }
        }
    }

    public static void setRepairModeSlots(List<String> names) {
        REPAIR_MODE_SLOTS.clear();
        REPAIR_MODE_SLOT_NUMBES.clear();
        for (String name : names) {
            aew type = null;
            switch (name) {
                case "mainhand": {
                    type = aew.a;
                    break;
                }
                case "offhand": {
                    type = aew.b;
                    break;
                }
                case "head": {
                    type = aew.f;
                    break;
                }
                case "chest": {
                    type = aew.e;
                    break;
                }
                case "legs": {
                    type = aew.d;
                    break;
                }
                case "feet": {
                    type = aew.c;
                }
            }
            if (type == null) continue;
            REPAIR_MODE_SLOTS.add(type);
            REPAIR_MODE_SLOT_NUMBES.add(InventoryUtils.getSlotNumberForEquipmentType(type, null));
        }
    }

    private static boolean isConfiguredRepairSlot(int slotNum, aog player) {
        if (REPAIR_MODE_SLOTS.contains(aew.a) && slotNum - 36 == player.bB.d) {
            return true;
        }
        return REPAIR_MODE_SLOT_NUMBES.contains(slotNum);
    }

    @Nullable
    private static aew getEquipmentTypeForSlot(int slotNum, aog player) {
        if (REPAIR_MODE_SLOTS.contains(aew.a) && slotNum - 36 == player.bB.d) {
            return aew.a;
        }
        switch (slotNum) {
            case 45: {
                return aew.b;
            }
            case 5: {
                return aew.f;
            }
            case 6: {
                return aew.e;
            }
            case 7: {
                return aew.d;
            }
            case 8: {
                return aew.c;
            }
        }
        return null;
    }

    private static int getSlotNumberForEquipmentType(aew type, @Nullable aog player) {
        switch (type) {
            case a: {
                return player != null ? player.bB.d + 36 : -1;
            }
            case b: {
                return 45;
            }
            case f: {
                return 5;
            }
            case e: {
                return 6;
            }
            case d: {
                return 7;
            }
            case c: {
                return 8;
            }
        }
        return -1;
    }

    public static void swapHotbarWithInventoryRow(aog player, int row) {
        apv container = player.bD;
        row = xq.a((int)row, (int)0, (int)2);
        int slot = row * 9 + 9;
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            fi.dy.masa.malilib.util.InventoryUtils.swapSlots((apv)container, (int)slot, (int)hotbarSlot);
            ++slot;
        }
    }

    public static void restockNewStackToHand(aog player, adk hand, ate stackReference, boolean allowHotbar) {
        int slotWithItem = -1;
        if (stackReference.b().k()) {
            int minDurability = InventoryUtils.getMinDurability(stackReference);
            slotWithItem = InventoryUtils.findSlotWithSuitableReplacementToolWithDurabilityLeft(player.bD, stackReference, minDurability);
        } else {
            slotWithItem = InventoryUtils.findSlotWithItem(player.bD, stackReference, allowHotbar, true);
        }
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
        }
    }

    public static void preRestockHand(aog player, adk hand, boolean allowHotbar) {
        ate stackHand = player.b(hand);
        if (!stackHand.a() && stackHand.C() <= 4 && stackHand.c() > 4 && FeatureToggle.TWEAK_HAND_RESTOCK.getBooleanValue() && Configs.Generic.HAND_RESTOCK_PRE.getBooleanValue() && player.bE == player.bD && player.bB.s().a()) {
            cft mc = cft.s();
            apv container = player.bD;
            int endSlot = allowHotbar ? 44 : 35;
            int currentMainHandSlot = player.bB.d + 36;
            int currentSlot = hand == adk.a ? currentMainHandSlot : 45;
            for (int slotNum = 9; slotNum <= endSlot; ++slotNum) {
                aqx slot;
                ate stackSlot;
                if (slotNum == currentMainHandSlot || !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqualIgnoreDurability((ate)(stackSlot = (slot = (aqx)container.c.get(slotNum)).d()), (ate)stackHand)) continue;
                int button = stackSlot.C() + stackHand.C() <= stackHand.c() ? 0 : 1;
                mc.e.a(container.d, slot.e, button, aqa.a, player);
                mc.e.a(container.d, currentSlot, 0, aqa.a, player);
                break;
            }
        }
    }

    public static void trySwapCurrentToolIfNearlyBroken() {
        if (FeatureToggle.TWEAK_SWAP_ALMOST_BROKEN_TOOLS.getBooleanValue()) {
            cft mc = cft.s();
            ctj player = mc.i;
            for (adk hand : adk.values()) {
                int minDurability;
                ate stack = player.b(hand);
                if (stack.a() || !InventoryUtils.isItemAtLowDurability(stack, minDurability = InventoryUtils.getMinDurability(stack))) continue;
                InventoryUtils.swapItemWithHigherDurabilityToHand((aog)player, hand, stack, minDurability);
            }
        }
    }

    public static void trySwitchToEffectiveTool(el pos) {
        if (FeatureToggle.TWEAK_TOOL_SWITCH.getBooleanValue()) {
            apv container;
            int slotNumber;
            cft mc = cft.s();
            ctj player = mc.i;
            blc state = mc.g.a_(pos);
            ate stack = player.cB();
            if ((stack.a() || stack.a(state) <= 1.0f) && (slotNumber = InventoryUtils.findSlotWithEffectiveItemWithDurabilityLeft(container = player.bD, state)) != -1 && slotNumber - 36 != player.bB.d) {
                InventoryUtils.swapItemToHand((aog)player, adk.a, slotNumber);
            }
        }
    }

    private static boolean isItemAtLowDurability(ate stack, int minDurability) {
        return stack.b().k() && stack.g() >= stack.h() - minDurability;
    }

    private static int getMinDurability(ate stack) {
        int minDurability = Configs.Generic.ITEM_SWAP_DURABILITY_THRESHOLD.getIntegerValue();
        if ((double)minDurability / (double)stack.h() >= 0.05) {
            minDurability = (int)((double)stack.h() * 0.05);
        }
        return minDurability;
    }

    private static void swapItemWithHigherDurabilityToHand(aog player, adk hand, ate stackReference, int minDurabilityLeft) {
        int slotWithItem = InventoryUtils.findSlotWithSuitableReplacementToolWithDurabilityLeft(player.bD, stackReference, minDurabilityLeft);
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.swapped_low_durability_item_for_better_durability", (Object[])new Object[0]);
            return;
        }
        slotWithItem = fi.dy.masa.malilib.util.InventoryUtils.findEmptySlotInPlayerInventory((apv)player.bD, (boolean)false, (boolean)false);
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.swapped_low_durability_item_off_players_hand", (Object[])new Object[0]);
            return;
        }
        apv container = player.bD;
        for (aqx slot : container.c) {
            ate stack;
            if (slot.e <= 8 || (stack = slot.d()).a() || stack.b().k()) continue;
            slotWithItem = slot.e;
            break;
        }
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.swapped_low_durability_item_for_dummy_item", (Object[])new Object[0]);
        }
    }

    public static void repairModeSwapItems(aog player) {
        if (player.bE == player.bD) {
            for (aew type : REPAIR_MODE_SLOTS) {
                InventoryUtils.repairModeHandleSlot(player, type);
            }
        }
    }

    private static void repairModeHandleSlot(aog player, aew type) {
        aqx slot;
        int slotRepairableItem;
        int slotNum = InventoryUtils.getSlotNumberForEquipmentType(type, player);
        if (slotNum == -1) {
            return;
        }
        ate stack = player.b(type);
        if (!(stack.a() || stack.e() && stack.f() && awg.a((awe)awi.G, (ate)stack) > 0 || (slotRepairableItem = InventoryUtils.findRepairableItemNotInRepairableSlot(slot = player.bE.a(slotNum), player)) == -1)) {
            InventoryUtils.swapItemToEqupmentSlot(player, type, slotRepairableItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.repair_mode.swapped_repairable_item_to_slot", (Object[])new Object[]{type.d()});
        }
    }

    private static int findRepairableItemNotInRepairableSlot(aqx targetSlot, aog player) {
        apv containerPlayer = player.bE;
        for (aqx slot : containerPlayer.c) {
            ate stack;
            if (!slot.e() || InventoryUtils.isConfiguredRepairSlot(slot.e, player) || !(stack = slot.d()).e() || !stack.f() || !targetSlot.a(stack) || awg.a((awe)awi.G, (ate)stack) <= 0) continue;
            return slot.e;
        }
        return -1;
    }

    public static int findSlotWithItem(apv container, ate stackReference, boolean allowHotbar, boolean reverse) {
        int startSlot = reverse ? container.c.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.c.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof aqm;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            aqx slot = (aqx)container.c.get(slotNum);
            if (isPlayerInv && !fi.dy.masa.malilib.util.InventoryUtils.isRegularInventorySlot((int)slot.e, (boolean)false) || !allowHotbar && InventoryUtils.isHotbarSlot(slot) || !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqualIgnoreDurability((ate)slot.d(), (ate)stackReference)) continue;
            return slot.e;
        }
        return -1;
    }

    private static boolean isHotbarSlot(aqx slot) {
        return slot.e >= 36 && slot.e <= 44;
    }

    private static void swapItemToHand(aog player, adk hand, int slotNumber) {
        if (slotNumber != -1 && player.bE == player.bD) {
            cft mc = cft.s();
            apv container = player.bD;
            if (hand == adk.a) {
                int currentHotbarSlot = player.bB.d;
                aqx slot = container.a(slotNumber);
                if (slot != null && InventoryUtils.isHotbarSlot(slot)) {
                    player.bB.d = slotNumber - 36;
                    mc.o().a((iv)new nj(player.bB.d));
                } else {
                    mc.e.a(container.d, slotNumber, currentHotbarSlot, aqa.c, (aog)mc.i);
                }
            } else if (hand == adk.b) {
                int currentHotbarSlot = player.bB.d;
                mc.e.a(container.d, slotNumber, currentHotbarSlot, aqa.c, (aog)mc.i);
                mc.e.a(container.d, 45, currentHotbarSlot, aqa.c, (aog)mc.i);
                mc.e.a(container.d, slotNumber, currentHotbarSlot, aqa.c, (aog)mc.i);
            }
        }
    }

    private static void swapItemToEqupmentSlot(aog player, aew type, int sourceSlotNumber) {
        if (sourceSlotNumber != -1 && player.bE == player.bD) {
            cft mc = cft.s();
            apv container = player.bD;
            if (type == aew.a) {
                int currentHotbarSlot = player.bB.d;
                mc.e.a(container.d, sourceSlotNumber, currentHotbarSlot, aqa.c, (aog)mc.i);
            } else if (type == aew.b) {
                int tempSlot = (player.bB.d + 1) % 9;
                mc.e.a(container.d, sourceSlotNumber, tempSlot, aqa.c, (aog)mc.i);
                mc.e.a(container.d, 45, tempSlot, aqa.c, (aog)mc.i);
                mc.e.a(container.d, sourceSlotNumber, tempSlot, aqa.c, (aog)mc.i);
            } else {
                int armorSlot = InventoryUtils.getSlotNumberForEquipmentType(type, player);
                mc.e.a(container.d, sourceSlotNumber, 0, aqa.a, (aog)mc.i);
                mc.e.a(container.d, armorSlot, 0, aqa.a, (aog)mc.i);
                mc.e.a(container.d, sourceSlotNumber, 0, aqa.a, (aog)mc.i);
            }
        }
    }

    private static int findSlotWithSuitableReplacementToolWithDurabilityLeft(apv container, ate stackReference, int minDurabilityLeft) {
        for (aqx slot : container.c) {
            ate stackSlot = slot.d();
            if (!fi.dy.masa.malilib.util.InventoryUtils.isRegularInventorySlot((int)slot.e, (boolean)false) || !stackSlot.b(stackReference) || stackSlot.h() - stackSlot.g() <= minDurabilityLeft || !InventoryUtils.hasSameIshEnchantments(stackReference, stackSlot)) continue;
            return slot.e;
        }
        return -1;
    }

    private static boolean hasSameIshEnchantments(ate stackReference, ate stack) {
        int level = awg.a((awe)awi.t, (ate)stackReference);
        if (level > 0) {
            return awg.a((awe)awi.t, (ate)stack) >= level;
        }
        level = awg.a((awe)awi.v, (ate)stackReference);
        if (level > 0) {
            return awg.a((awe)awi.v, (ate)stack) >= level;
        }
        return true;
    }

    private static int findSlotWithEffectiveItemWithDurabilityLeft(apv container, blc state) {
        int slotNum = -1;
        float bestSpeed = -1.0f;
        for (aqx slot : container.c) {
            int effLevel;
            ate stack;
            if (slot.e <= 8 || !slot.e() || (stack = slot.d()).h() - stack.g() <= InventoryUtils.getMinDurability(stack)) continue;
            float speed = stack.a(state);
            if (speed > 1.0f && (effLevel = awg.a((awe)awi.s, (ate)stack)) > 0) {
                speed += (float)(effLevel * effLevel + 1);
            }
            if (!(speed > 1.0f) || slotNum != -1 && !(speed > bestSpeed)) continue;
            slotNum = slot.e;
            bestSpeed = speed;
        }
        return slotNum;
    }

    private static void tryCombineStacksInInventory(aog player, ate stackReference) {
        ArrayList<aqx> slots = new ArrayList<aqx>();
        apv container = player.bD;
        cft mc = cft.s();
        for (aqx slot : container.c) {
            ate stack;
            if (slot.e < 8 || (stack = slot.d()).C() >= stack.c() || !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqual((ate)stackReference, (ate)stack)) continue;
            slots.add(slot);
        }
        block1: for (int i = 0; i < slots.size(); ++i) {
            aqx slot1 = (aqx)slots.get(i);
            for (int j = i + 1; j < slots.size(); ++j) {
                aqx slot2 = (aqx)slots.get(j);
                ate stack = slot1.d();
                if (stack.C() < stack.c()) {
                    mc.e.a(container.d, slot1.e, 0, aqa.a, player);
                    mc.e.a(container.d, slot2.e, 0, aqa.a, player);
                    if (!player.bB.i().a()) {
                        mc.e.a(container.d, slot1.e, 0, aqa.a, player);
                    }
                    if (slot2.d().C() >= slot2.d().c()) {
                        slots.remove(j);
                        --j;
                    }
                }
                if (!slot1.e()) continue block1;
            }
        }
    }

    public static boolean canUnstackingItemNotFitInInventory(ate stack, aog player) {
        if (FeatureToggle.TWEAK_ITEM_UNSTACKING_PROTECTION.getBooleanValue() && stack.C() > 1 && UNSTACKING_ITEMS.contains(stack.b()) && fi.dy.masa.malilib.util.InventoryUtils.findEmptySlotInPlayerInventory((apv)player.bD, (boolean)false, (boolean)false) == -1) {
            InventoryUtils.tryCombineStacksInInventory(player, stack);
            if (fi.dy.masa.malilib.util.InventoryUtils.findEmptySlotInPlayerInventory((apv)player.bD, (boolean)false, (boolean)false) == -1) {
                return true;
            }
        }
        return false;
    }

    public static void switchToPickedBlock() {
        el pos;
        blc stateTargeted;
        ate stack;
        cft mc = cft.s();
        ctj player = mc.i;
        crg world = mc.g;
        double reach = mc.e.c();
        boolean isCreative = player.bV.d;
        ceb trace = player.a(reach, mc.ab(), cec.a);
        if (trace != null && trace.a == ceb.a.b && !(stack = (stateTargeted = world.a_(pos = trace.a())).c().a((axk)world, pos, stateTargeted)).a()) {
            if (isCreative) {
                player.bB.a(stack);
                mc.e.a(player.b(adk.a), 36 + player.bB.d);
            } else {
                int slot = fi.dy.masa.malilib.util.InventoryUtils.findSlotWithItem((apv)player.bD, (ate)stack, (boolean)true);
                if (slot != -1) {
                    int currentHotbarSlot = player.bB.d;
                    mc.e.a(player.bD.d, slot, currentHotbarSlot, aqa.c, (aog)mc.i);
                }
            }
        }
    }

    public static boolean cleanUpShulkerBoxNBT(ate stack) {
        boolean changed = false;
        gy nbt = stack.n();
        if (nbt != null) {
            if (nbt.c("BlockEntityTag", 10)) {
                gy tag = nbt.p("BlockEntityTag");
                if (tag.c("Items", 9) && tag.d("Items", 10).size() == 0) {
                    tag.r("Items");
                    changed = true;
                }
                if (tag.isEmpty()) {
                    nbt.r("BlockEntityTag");
                }
            }
            if (nbt.isEmpty()) {
                stack.c(null);
                changed = true;
            }
        }
        return changed;
    }
}

