/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.tweaks;

import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.mixin.IMixinFlatGenSettings;
import fi.dy.masa.tweakeroo.util.CameraEntity;
import fi.dy.masa.tweakeroo.util.IMinecraftAccessor;
import fi.dy.masa.tweakeroo.util.InventoryUtils;
import fi.dy.masa.tweakeroo.util.PotionRestriction;
import java.util.Collection;
import javax.annotation.Nullable;

public class MiscTweaks {
    public static final PotionRestriction POTION_RESTRICTION = new PotionRestriction();
    private static long lastPotionWarning;
    private static int periodicAttackCounter;
    private static int periodicUseCounter;

    public static void onTick(cft mc) {
        ctj player = mc.i;
        if (player == null) {
            return;
        }
        MiscTweaks.doPeriodicClicks(mc);
        MiscTweaks.doPotionWarnings((aog)player);
        if (FeatureToggle.TWEAK_REPAIR_MODE.getBooleanValue()) {
            InventoryUtils.repairModeSwapItems((aog)player);
        }
        CameraEntity.movementTick(player.e.h, player.e.g);
    }

    private static void doPeriodicClicks(cft mc) {
        if (GuiUtils.getCurrentScreen() == null) {
            if (FeatureToggle.TWEAK_PERIODIC_ATTACK.getBooleanValue() && ++periodicAttackCounter >= Configs.Generic.PERIODIC_ATTACK_INTERVAL.getIntegerValue()) {
                ((IMinecraftAccessor)mc).leftClickMouseAccessor();
                periodicAttackCounter = 0;
            }
            if (FeatureToggle.TWEAK_PERIODIC_USE.getBooleanValue() && ++periodicUseCounter >= Configs.Generic.PERIODIC_USE_INTERVAL.getIntegerValue()) {
                ((IMinecraftAccessor)mc).rightClickMouseAccessor();
                periodicUseCounter = 0;
            }
        }
    }

    private static void doPotionWarnings(aog player) {
        if (FeatureToggle.TWEAK_POTION_WARNING.getBooleanValue() && player.bJ().V() - lastPotionWarning >= 100L) {
            lastPotionWarning = player.bJ().V();
            Collection effects = player.cn();
            if (!effects.isEmpty()) {
                int minDuration = -1;
                int count = 0;
                for (aek effect : effects) {
                    if (!MiscTweaks.potionWarningShouldInclude(effect)) continue;
                    ++count;
                    if (effect.b() >= minDuration && minDuration >= 0) continue;
                    minDuration = effect.b();
                }
                if (count > 0) {
                    InfoUtils.printActionbarMessage((String)"tweakeroo.message.potion_effects_running_out", (Object[])new Object[]{count, minDuration / 20});
                }
            }
        }
    }

    private static boolean potionWarningShouldInclude(aek effect) {
        return !effect.d() && (effect.a().k() || !Configs.Generic.POTION_WARNING_BENEFICIAL_ONLY.getBooleanValue()) && effect.b() <= Configs.Generic.POTION_WARNING_THRESHOLD.getIntegerValue() && POTION_RESTRICTION.isAllowed(effect.a());
    }

    @Nullable
    public static buc[] parseBlockString(String blockString) {
        return IMixinFlatGenSettings.getLayersFromStringInvoker(blockString).toArray(new buc[0]);
    }
}

