/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.renderer;

import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.mixin.IMixinAbstractHorse;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import fi.dy.masa.tweakeroo.util.RayTraceUtils;
import fi.dy.masa.tweakeroo.util.SnapAimMode;

public class RenderUtils {
    private static long lastRotationChangeTime;

    public static void renderHotbarSwapOverlay(cft mc) {
        ctj player = mc.i;
        if (player != null) {
            int scaledWidth = GuiUtils.getScaledWindowWidth();
            int scaledHeight = GuiUtils.getScaledWindowHeight();
            int offX = Configs.Generic.HOTBAR_SWAP_OVERLAY_OFFSET_X.getIntegerValue();
            int offY = Configs.Generic.HOTBAR_SWAP_OVERLAY_OFFSET_Y.getIntegerValue();
            int startX = offX;
            int startY = offY;
            HudAlignment align = (HudAlignment)Configs.Generic.HOTBAR_SWAP_OVERLAY_ALIGNMENT.getOptionListValue();
            switch (align) {
                case TOP_RIGHT: {
                    startX = scaledWidth - offX - 162;
                    break;
                }
                case BOTTOM_LEFT: {
                    startY = scaledHeight - offY - 54;
                    break;
                }
                case BOTTOM_RIGHT: {
                    startX = scaledWidth - offX - 162;
                    startY = scaledHeight - offY - 54;
                    break;
                }
                case CENTER: {
                    startX = scaledWidth / 2 - offX - 81;
                    startY = scaledHeight / 2 - offY - 27;
                    break;
                }
            }
            int x = startX;
            int y = startY;
            cgk textRenderer = mc.l;
            fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            fi.dy.masa.malilib.render.RenderUtils.bindTexture((pc)clp.a);
            fi.dy.masa.malilib.render.RenderUtils.drawTexturedRect((int)(x - 1), (int)(y - 1), (int)7, (int)83, (int)162, (int)54);
            for (int row = 1; row <= 3; ++row) {
                textRenderer.a(String.valueOf(row), (float)(x - 10), (float)(y + 4), 0xFFFFFF);
                for (int column = 0; column < 9; ++column) {
                    ate stack = player.bB.a(row * 9 + column);
                    if (!stack.a()) {
                        InventoryOverlay.renderStackAt((ate)stack, (float)x, (float)y, (float)1.0f, (cft)mc);
                    }
                    x += 18;
                }
                y += 18;
                x = startX;
            }
        }
    }

    public static void renderInventoryOverlay(cft mc) {
        ceb trace;
        axy world = WorldUtils.getBestWorld((cft)mc);
        aog player = world.b(mc.i.bt());
        if (player == null) {
            player = mc.i;
        }
        if ((trace = RayTraceUtils.getRayTraceFromEntity(world, (aer)player, false)) == null) {
            return;
        }
        ade inv = null;
        bhi block = null;
        afa entityLivingBase = null;
        if (trace.a == ceb.a.b) {
            el pos = trace.a();
            bji te = world.f(pos);
            if (te instanceof ade) {
                bcs blockTmp;
                adq cont;
                inv = (ade)te;
                blc state = world.a_(pos);
                if (state.c() instanceof bdh && (cont = ((bdh)state.c()).a(state, world, pos, true)) instanceof add) {
                    inv = (add)cont;
                }
                if ((blockTmp = world.a_(pos).c()) instanceof bhi) {
                    block = (bhi)blockTmp;
                }
            }
        } else if (trace.a == ceb.a.c) {
            aer entity = trace.d;
            if (entity instanceof afa) {
                entityLivingBase = (afa)entity;
            }
            if (entity instanceof ade) {
                inv = (ade)entity;
            } else if (entity instanceof aob) {
                inv = ((aob)entity).dD();
            } else if (entity instanceof ako) {
                inv = ((IMixinAbstractHorse)entity).getHorseChest();
            }
        }
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 26;
        int y = yCenter - 92;
        if (inv != null && inv.T_() > 0) {
            boolean isHorse = entityLivingBase instanceof ako;
            int totalSlots = isHorse ? inv.T_() - 2 : inv.T_();
            int firstSlot = isHorse ? 2 : 0;
            InventoryOverlay.InventoryRenderType type = entityLivingBase instanceof aob ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getInventoryType((ade)inv);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)totalSlots);
            int rows = (int)Math.ceil(totalSlots / props.slotsPerRow);
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (entityLivingBase != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            fi.dy.masa.malilib.render.RenderUtils.setShulkerboxBackgroundTintColor((bhi)block, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
            if (isHorse) {
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)1, (int)2, (cft)mc);
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (ade)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)1, (int)0, (int)2, (cft)mc);
                xInv += 36;
            }
            if (totalSlots > 0) {
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)totalSlots, (cft)mc);
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (ade)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)firstSlot, (int)totalSlots, (cft)mc);
            }
        }
        if (entityLivingBase != null) {
            InventoryOverlay.renderEquipmentOverlayBackground((int)x, (int)y, (afa)entityLivingBase);
            InventoryOverlay.renderEquipmentStacks((afa)entityLivingBase, (int)x, (int)y, (cft)mc);
        }
    }

    public static void renderPlayerInventoryOverlay(cft mc) {
        int x = GuiUtils.getScaledWindowWidth() / 2 - 88;
        int y = GuiUtils.getScaledWindowHeight() / 2 + 10;
        int slotOffsetX = 8;
        int slotOffsetY = 8;
        InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.GENERIC;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)y, (int)9, (int)27, (cft)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (ade)mc.i.bB, (int)(x + slotOffsetX), (int)(y + slotOffsetY), (int)9, (int)9, (int)27, (cft)mc);
    }

    public static void renderHotbarScrollOverlay(cft mc) {
        aof inv = mc.i.bB;
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 88;
        int y = yCenter + 6;
        InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.GENERIC;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)y, (int)9, (int)27, (cft)mc);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)(y + 70), (int)9, (int)9, (cft)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (ade)inv, (int)(x + 8), (int)(y + 8), (int)9, (int)9, (int)27, (cft)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (ade)inv, (int)(x + 8), (int)(y + 78), (int)9, (int)0, (int)9, (cft)mc);
        int currentRow = Configs.Internal.HOTBAR_SCROLL_CURRENT_ROW.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutline((int)(x + 5), (int)(y + currentRow * 18 + 5), (int)166, (int)22, (int)2, (int)-57312);
    }

    public static float getLavaFog(aer entity, float originalFog) {
        if (entity instanceof afa) {
            afa living = (afa)entity;
            int resp = awg.d((afa)living);
            float baseFog = 0.6f;
            float respDecrement = 0.13000001f;
            float fog = 0.6f;
            if (living.a(aem.m)) {
                fog -= 0.24000001f;
            }
            if (resp > 0) {
                fog -= (float)resp * 0.13000001f;
                fog = Math.max(0.12f, fog);
            }
            return fog < 0.6f ? fog : originalFog;
        }
        return originalFog;
    }

    public static void overrideLavaFog(aer entity) {
        float fog = RenderUtils.getLavaFog(entity, 2.0f);
        if (fog < 2.0f) {
            cua.a((float)fog);
        }
    }

    public static void renderDirectionsCursor(float zLevel, float partialTicks) {
        cft mc = cft.s();
        cua.G();
        int width = GuiUtils.getScaledWindowWidth();
        int height = GuiUtils.getScaledWindowHeight();
        cua.b((double)(width / 2), (double)(height / 2), (double)zLevel);
        aer entity = mc.S();
        cua.b((float)(entity.z + (entity.x - entity.z) * partialTicks), (float)-1.0f, (float)0.0f, (float)0.0f);
        cua.b((float)(entity.y + (entity.w - entity.y) * partialTicks), (float)0.0f, (float)1.0f, (float)0.0f);
        cua.b((float)-1.0f, (float)-1.0f, (float)-1.0f);
        dhq.m((int)10);
        cua.H();
    }

    public static void notifyRotationChanged() {
        lastRotationChangeTime = System.currentTimeMillis();
    }

    public static void renderSnapAimAngleIndicator() {
        long current = System.currentTimeMillis();
        if (current - lastRotationChangeTime < 750L) {
            cft mc = cft.s();
            int xCenter = GuiUtils.getScaledWindowWidth() / 2;
            int yCenter = GuiUtils.getScaledWindowHeight() / 2;
            SnapAimMode mode = (SnapAimMode)Configs.Generic.SNAP_AIM_MODE.getOptionListValue();
            if (mode != SnapAimMode.PITCH) {
                RenderUtils.renderSnapAimAngleIndicatorYaw(xCenter, yCenter, 80, 10, mc);
            }
            if (mode != SnapAimMode.YAW) {
                RenderUtils.renderSnapAimAngleIndicatorPitch(xCenter, yCenter, 10, 50, mc);
            }
        }
    }

    private static void renderSnapAimAngleIndicatorYaw(int xCenter, int yCenter, int width, int height, cft mc) {
        double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
        double realYaw = xq.b((double)MiscUtils.getLastRealYaw(), (double)360.0);
        double snappedYaw = MiscUtils.calculateSnappedAngle(realYaw, step);
        double startYaw = snappedYaw - step / 2.0;
        int x = xCenter - width / 2;
        int y = yCenter + 10;
        int lineX = x + (int)(xq.g((double)(realYaw - startYaw)) / step * (double)width);
        cgk textRenderer = mc.l;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int bgColor = Configs.Generic.SNAP_AIM_INDICATOR_COLOR.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((int)x, (int)y, (int)width, (int)height, (int)bgColor, (int)-1);
        fi.dy.masa.malilib.render.RenderUtils.drawRect((int)lineX, (int)y, (int)2, (int)height, (int)-1);
        String str = String.valueOf(xq.g((double)snappedYaw)) + "\u00b0";
        textRenderer.b(str, (float)(xCenter - textRenderer.a(str) / 2), (float)(y + height + 2), -1);
        str = "<  " + String.valueOf(xq.g((double)(snappedYaw - step))) + "\u00b0";
        textRenderer.b(str, (float)(x - textRenderer.a(str)), (float)(y + height + 2), -1);
        str = String.valueOf(xq.g((double)(snappedYaw + step))) + "\u00b0  >";
        textRenderer.b(str, (float)(x + width), (float)(y + height + 2), -1);
    }

    private static void renderSnapAimAngleIndicatorPitch(int xCenter, int yCenter, int width, int height, cft mc) {
        double step = Configs.Generic.SNAP_AIM_PITCH_STEP.getDoubleValue();
        int limit = Configs.Generic.SNAP_AIM_PITCH_OVERSHOOT.getBooleanValue() ? 180 : 90;
        double realPitch = xq.g((double)MiscUtils.getLastRealPitch());
        double snappedPitch = realPitch < 0.0 ? -MiscUtils.calculateSnappedAngle(-realPitch, step) : MiscUtils.calculateSnappedAngle(realPitch, step);
        snappedPitch = xq.a((double)xq.g((double)snappedPitch), (double)(-limit), (double)limit);
        int x = xCenter - width / 2;
        int y = yCenter - height - 10;
        RenderUtils.renderPitchIndicator(x, y, width, height, realPitch, snappedPitch, step, true, mc);
    }

    public static void renderPitchLockIndicator(cft mc) {
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int width = 10;
        int height = 50;
        int x = xCenter - width / 2;
        int y = yCenter - height - 10;
        double currentPitch = mc.i.x;
        double centerPitch = 0.0;
        double indicatorRange = 180.0;
        RenderUtils.renderPitchIndicator(x, y, width, height, currentPitch, centerPitch, indicatorRange, false, mc);
    }

    private static void renderPitchIndicator(int x, int y, int width, int height, double currentPitch, double centerPitch, double indicatorRange, boolean isSnapRange, cft mc) {
        String strDown;
        String strUp;
        double startPitch = centerPitch - indicatorRange / 2.0;
        double printedRange = isSnapRange ? indicatorRange : indicatorRange / 2.0;
        int lineY = y + (int)((xq.g((double)currentPitch) - startPitch) / indicatorRange * (double)height);
        double angleUp = centerPitch - printedRange;
        double angleDown = centerPitch + printedRange;
        if (isSnapRange) {
            strUp = String.format("%6.1f\u00b0 ^", xq.g((double)angleUp));
            strDown = String.format("%6.1f\u00b0 v", xq.g((double)angleDown));
        } else {
            strUp = String.format("%6.1f\u00b0", angleUp);
            strDown = String.format("%6.1f\u00b0", angleDown);
        }
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        cgk textRenderer = mc.l;
        int bgColor = Configs.Generic.SNAP_AIM_INDICATOR_COLOR.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((int)x, (int)y, (int)width, (int)height, (int)bgColor, (int)-1);
        fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(x - 1), (int)(lineY - 1), (int)(width + 2), (int)2, (int)-1);
        String str = String.format("%6.1f\u00b0", xq.g((double)(isSnapRange ? centerPitch : currentPitch)));
        textRenderer.b(str, (float)(x + width + 4), (float)(y + height / 2 - 4), -1);
        textRenderer.b(strUp, (float)(x + width + 4), (float)(y - 4), -1);
        textRenderer.b(strDown, (float)(x + width + 4), (float)(y + height - 4), -1);
    }
}

