/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import java.util.Collections;
import java.util.List;

public class GuiConfigs
extends GuiConfigsBase {
    private static ConfigGuiTab tab = ConfigGuiTab.TWEAK_TOGGLES;

    public GuiConfigs() {
        super(10, 50, "tweakeroo", null, "tweakeroo.gui.title.configs", new Object[0]);
    }

    public void c() {
        super.c();
        this.clearOptions();
        int x = 10;
        int y = 26;
        for (ConfigGuiTab tab : ConfigGuiTab.values()) {
            x += this.createButton(x, y, -1, tab);
        }
    }

    private int createButton(int x, int y, int width, ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(GuiConfigs.tab != tab);
        this.addButton((ButtonBase)button, new ButtonListener(tab, this));
        return button.getWidth() + 2;
    }

    protected int getConfigWidth() {
        ConfigGuiTab tab = GuiConfigs.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            return 120;
        }
        if (tab == ConfigGuiTab.FIXES || tab == ConfigGuiTab.TWEAK_TOGGLES || tab == ConfigGuiTab.DISABLE_TOGGLES) {
            return 80;
        }
        if (tab == ConfigGuiTab.LISTS) {
            return 200;
        }
        return super.getConfigWidth();
    }

    protected boolean useKeybindSearch() {
        return tab == ConfigGuiTab.TWEAK_HOTKEYS || tab == ConfigGuiTab.GENERIC_HOTKEYS || tab == ConfigGuiTab.DISABLE_HOTKEYS;
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        Object configs;
        ConfigGuiTab tab = GuiConfigs.tab;
        if (tab == ConfigGuiTab.GENERIC) {
            configs = Configs.Generic.OPTIONS;
        } else if (tab == ConfigGuiTab.FIXES) {
            configs = Configs.Fixes.OPTIONS;
        } else if (tab == ConfigGuiTab.LISTS) {
            configs = Configs.Lists.OPTIONS;
        } else if (tab == ConfigGuiTab.DISABLE_TOGGLES) {
            configs = ConfigUtils.createConfigWrapperForType((ConfigType)ConfigType.BOOLEAN, (List)ImmutableList.copyOf(Configs.Disable.OPTIONS));
        } else if (tab == ConfigGuiTab.DISABLE_HOTKEYS) {
            configs = ConfigUtils.createConfigWrapperForType((ConfigType)ConfigType.HOTKEY, (List)ImmutableList.copyOf(Configs.Disable.OPTIONS));
        } else if (tab == ConfigGuiTab.TWEAK_TOGGLES) {
            configs = ConfigUtils.createConfigWrapperForType((ConfigType)ConfigType.BOOLEAN, (List)ImmutableList.copyOf((Object[])FeatureToggle.values()));
        } else if (tab == ConfigGuiTab.TWEAK_HOTKEYS) {
            configs = ConfigUtils.createConfigWrapperForType((ConfigType)ConfigType.HOTKEY, (List)ImmutableList.copyOf((Object[])FeatureToggle.values()));
        } else if (tab == ConfigGuiTab.GENERIC_HOTKEYS) {
            configs = Hotkeys.HOTKEY_LIST;
        } else {
            return Collections.emptyList();
        }
        return GuiConfigsBase.ConfigOptionWrapper.createFor(configs);
    }

    public static enum ConfigGuiTab {
        GENERIC("tweakeroo.gui.button.config_gui.generic"),
        FIXES("tweakeroo.gui.button.config_gui.fixes"),
        LISTS("tweakeroo.gui.button.config_gui.lists"),
        TWEAK_TOGGLES("tweakeroo.gui.button.config_gui.tweak_toggles"),
        TWEAK_HOTKEYS("tweakeroo.gui.button.config_gui.tweak_hotkeys"),
        GENERIC_HOTKEYS("tweakeroo.gui.button.config_gui.generic_hotkeys"),
        DISABLE_TOGGLES("tweakeroo.gui.button.config_gui.disable_toggle"),
        DISABLE_HOTKEYS("tweakeroo.gui.button.config_gui.disable_hotkeys"),
        PLACEMENT("tweakeroo.gui.button.config_gui.placement");

        private final String translationKey;

        private ConfigGuiTab(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getDisplayName() {
            return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
        }
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final GuiConfigs parent;
        private final ConfigGuiTab tab;

        public ButtonListener(ConfigGuiTab tab, GuiConfigs parent) {
            this.tab = tab;
            this.parent = parent;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            tab = this.tab;
            if (this.tab != ConfigGuiTab.PLACEMENT) {
                this.parent.reCreateListWidget();
                ((WidgetListConfigOptions)this.parent.getListWidget()).resetScrollbarPosition();
                this.parent.c();
            }
        }
    }
}

