/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.event;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.hotkeys.KeyCallbackAdjustable;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.config.Hotkeys;
import fi.dy.masa.tweakeroo.util.SnapAimMode;
import java.util.List;

public class InputHandler
implements IKeybindProvider,
IKeyboardInputHandler,
IMouseInputHandler {
    private static final InputHandler INSTANCE = new InputHandler();
    private LeftRight lastSidewaysInput = LeftRight.NONE;
    private ForwardBack lastForwardInput = ForwardBack.NONE;

    private InputHandler() {
    }

    public static InputHandler getInstance() {
        return INSTANCE;
    }

    public void addKeysToMap(IKeybindManager manager) {
        for (FeatureToggle toggle : FeatureToggle.values()) {
            manager.addKeybindToMap(toggle.getKeybind());
        }
        for (IHotkey iHotkey : Hotkeys.HOTKEY_LIST) {
            manager.addKeybindToMap(iHotkey.getKeybind());
        }
        for (IHotkey iHotkey : Configs.Disable.OPTIONS) {
            manager.addKeybindToMap(iHotkey.getKeybind());
        }
    }

    public void addHotkeys(IKeybindManager manager) {
        manager.addHotkeysForCategory("Tweakeroo", "tweakeroo.hotkeys.category.disable_toggle_hotkeys", Configs.Disable.OPTIONS);
        manager.addHotkeysForCategory("Tweakeroo", "tweakeroo.hotkeys.category.generic_hotkeys", Hotkeys.HOTKEY_LIST);
        manager.addHotkeysForCategory("Tweakeroo", "tweakeroo.hotkeys.category.tweak_toggle_hotkeys", (List)ImmutableList.copyOf((Object[])FeatureToggle.values()));
    }

    public boolean onKeyInput(int keyCode, int scanCode, int modifiers, boolean eventKeyState) {
        cft mc = cft.s();
        if (GuiUtils.getCurrentScreen() == null && eventKeyState) {
            this.storeLastMovementDirection(keyCode, scanCode, mc);
        }
        return false;
    }

    public boolean onMouseClick(int mouseX, int mouseY, int eventButton, boolean eventButtonState) {
        el posFront;
        cft mc = cft.s();
        if (GuiUtils.getCurrentScreen() == null && mc.i != null && mc.i.bV.d && eventButtonState && mc.t.ah.a(eventButton) && FeatureToggle.TWEAK_ANGEL_BLOCK.getBooleanValue() && mc.s != null && mc.s.a == ceb.a.a && mc.g.c(posFront = PositionUtils.getPositionInfrontOfEntity((aer)mc.i))) {
            eq facing = PositionUtils.getClosestLookingDirection((aer)mc.i).d();
            cee hitVec = PositionUtils.getHitVecCenter((el)posFront, (eq)facing);
            ate stack = mc.i.cB();
            if (!stack.a() && stack.b() instanceof arj) {
                mc.e.a(mc.i, mc.g, posFront, facing, hitVec, adk.a);
                return true;
            }
            stack = mc.i.cC();
            if (!stack.a() && stack.b() instanceof arj) {
                mc.e.a(mc.i, mc.g, posFront, facing, hitVec, adk.b);
                return true;
            }
        }
        return false;
    }

    public boolean onMouseScroll(int mouseX, int mouseY, double dWheel) {
        if (GuiUtils.getCurrentScreen() == null && dWheel != 0.0) {
            String preGreen = GuiBase.TXT_GREEN;
            String rst = GuiBase.TXT_RST;
            if (FeatureToggle.TWEAK_HOTBAR_SCROLL.getBooleanValue() && Hotkeys.HOTBAR_SCROLL.getKeybind().isKeybindHeld()) {
                int currentRow = Configs.Internal.HOTBAR_SCROLL_CURRENT_ROW.getIntegerValue();
                int newRow = currentRow + (dWheel < 0.0 ? 1 : -1);
                int max = 2;
                if (newRow < 0) {
                    newRow = max;
                } else if (newRow > max) {
                    newRow = 0;
                }
                Configs.Internal.HOTBAR_SCROLL_CURRENT_ROW.setIntegerValue(newRow);
                return true;
            }
            if (FeatureToggle.TWEAK_FLY_SPEED.getKeybind().isKeybindHeld()) {
                ConfigDouble config = Configs.getActiveFlySpeedConfig();
                double newValue = config.getDoubleValue() + (dWheel > 0.0 ? 0.005 : -0.005);
                config.setDoubleValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strIndex = preGreen + (Configs.Internal.FLY_SPEED_PRESET.getIntegerValue() + 1) + rst;
                String strValue = preGreen + String.format("%.3f", config.getDoubleValue()) + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_fly_speed_to", (Object[])new Object[]{strIndex, strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_AFTER_CLICKER.getKeybind().isKeybindHeld()) {
                int newValue = Configs.Generic.AFTER_CLICKER_CLICK_COUNT.getIntegerValue() + (dWheel > 0.0 ? 1 : -1);
                Configs.Generic.AFTER_CLICKER_CLICK_COUNT.setIntegerValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strValue = preGreen + Configs.Generic.AFTER_CLICKER_CLICK_COUNT.getIntegerValue() + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_after_clicker_count_to", (Object[])new Object[]{strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_PLACEMENT_LIMIT.getKeybind().isKeybindHeld()) {
                int newValue = Configs.Generic.PLACEMENT_LIMIT.getIntegerValue() + (dWheel > 0.0 ? 1 : -1);
                Configs.Generic.PLACEMENT_LIMIT.setIntegerValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strValue = preGreen + Configs.Generic.PLACEMENT_LIMIT.getIntegerValue() + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_placement_limit_to", (Object[])new Object[]{strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_HOTBAR_SLOT_CYCLE.getKeybind().isKeybindHeld()) {
                int newValue = Configs.Generic.HOTBAR_SLOT_CYCLE_MAX.getIntegerValue() + (dWheel > 0.0 ? 1 : -1);
                Configs.Generic.HOTBAR_SLOT_CYCLE_MAX.setIntegerValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strValue = preGreen + Configs.Generic.HOTBAR_SLOT_CYCLE_MAX.getIntegerValue() + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_hotbar_slot_cycle_max_to", (Object[])new Object[]{strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_HOTBAR_SLOT_RANDOMIZER.getKeybind().isKeybindHeld()) {
                int newValue = Configs.Generic.HOTBAR_SLOT_RANDOMIZER_MAX.getIntegerValue() + (dWheel > 0.0 ? 1 : -1);
                Configs.Generic.HOTBAR_SLOT_RANDOMIZER_MAX.setIntegerValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strValue = preGreen + Configs.Generic.HOTBAR_SLOT_RANDOMIZER_MAX.getIntegerValue() + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_hotbar_slot_randomizer_max_to", (Object[])new Object[]{strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_BREAKING_GRID.getKeybind().isKeybindHeld()) {
                int newValue = Configs.Generic.BREAKING_GRID_SIZE.getIntegerValue() + (dWheel > 0.0 ? 1 : -1);
                Configs.Generic.BREAKING_GRID_SIZE.setIntegerValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strValue = preGreen + Configs.Generic.BREAKING_GRID_SIZE.getIntegerValue() + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_breaking_grid_size_to", (Object[])new Object[]{strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_PLACEMENT_GRID.getKeybind().isKeybindHeld()) {
                int newValue = Configs.Generic.PLACEMENT_GRID_SIZE.getIntegerValue() + (dWheel > 0.0 ? 1 : -1);
                Configs.Generic.PLACEMENT_GRID_SIZE.setIntegerValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String strValue = preGreen + Configs.Generic.PLACEMENT_GRID_SIZE.getIntegerValue() + rst;
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_placement_grid_size_to", (Object[])new Object[]{strValue});
                return true;
            }
            if (FeatureToggle.TWEAK_SNAP_AIM.getKeybind().isKeybindHeld()) {
                SnapAimMode mode = (SnapAimMode)Configs.Generic.SNAP_AIM_MODE.getOptionListValue();
                ConfigDouble config = mode == SnapAimMode.PITCH ? Configs.Generic.SNAP_AIM_PITCH_STEP : Configs.Generic.SNAP_AIM_YAW_STEP;
                double newValue = config.getDoubleValue() * (dWheel > 0.0 ? 2.0 : 0.5);
                config.setDoubleValue(newValue);
                KeyCallbackAdjustable.setValueChanged();
                String val = preGreen + String.valueOf(config.getDoubleValue()) + rst;
                String key = mode == SnapAimMode.PITCH ? "tweakeroo.message.set_snap_aim_pitch_step_to" : "tweakeroo.message.set_snap_aim_yaw_step_to";
                InfoUtils.printActionbarMessage((String)key, (Object[])new Object[]{val});
                return true;
            }
            if (FeatureToggle.TWEAK_ZOOM.getKeybind().isKeybindHeld() || FeatureToggle.TWEAK_ZOOM.getBooleanValue() && Hotkeys.ZOOM_ACTIVATE.getKeybind().isKeybindHeld()) {
                double newValue = Configs.Generic.ZOOM_FOV.getDoubleValue() + (double)(dWheel > 0.0 ? 1 : -1);
                Configs.Generic.ZOOM_FOV.setDoubleValue(newValue);
                if (FeatureToggle.TWEAK_ZOOM.getKeybind().isKeybindHeld()) {
                    KeyCallbackAdjustable.setValueChanged();
                }
                String strValue = String.format("%s%.1f%s", preGreen, Configs.Generic.ZOOM_FOV.getDoubleValue(), rst);
                InfoUtils.printActionbarMessage((String)"tweakeroo.message.set_zoom_fov_to", (Object[])new Object[]{strValue});
                return true;
            }
        }
        return false;
    }

    public LeftRight getLastSidewaysInput() {
        return this.lastSidewaysInput;
    }

    public ForwardBack getLastForwardInput() {
        return this.lastForwardInput;
    }

    private void storeLastMovementDirection(int eventKey, int scanCode, cft mc) {
        if (mc.t.X.a(eventKey, scanCode)) {
            this.lastForwardInput = ForwardBack.FORWARD;
        } else if (mc.t.Z.a(eventKey, scanCode)) {
            this.lastForwardInput = ForwardBack.BACK;
        } else if (mc.t.Y.a(eventKey, scanCode)) {
            this.lastSidewaysInput = LeftRight.LEFT;
        } else if (mc.t.aa.a(eventKey, scanCode)) {
            this.lastSidewaysInput = LeftRight.RIGHT;
        }
    }

    public void handleMovementKeys(cth movement) {
        cfw settings = cft.s().t;
        if (settings.Y.d() && settings.aa.d()) {
            if (this.lastSidewaysInput == LeftRight.LEFT) {
                movement.a = 1.0f;
                movement.e = true;
                movement.f = false;
            } else if (this.lastSidewaysInput == LeftRight.RIGHT) {
                movement.a = -1.0f;
                movement.e = false;
                movement.f = true;
            }
        }
        if (settings.Z.d() && settings.X.d()) {
            if (this.lastForwardInput == ForwardBack.FORWARD) {
                movement.b = 1.0f;
                movement.c = true;
                movement.d = false;
            } else if (this.lastForwardInput == ForwardBack.BACK) {
                movement.b = -1.0f;
                movement.c = false;
                movement.d = true;
            }
        }
    }

    public static enum ForwardBack {
        NONE,
        FORWARD,
        BACK;

    }

    public static enum LeftRight {
        NONE,
        LEFT,
        RIGHT;

    }
}

