/*
 * Decompiled with CFR 0.152.
 */
package com.chocohead.rift;

import com.chocohead.rift.ClassMapping;
import com.chocohead.rift.MappingBlob;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.MethodRemapper;
import org.objectweb.asm.commons.Remapper;

public class RemappingClassAdapter
extends ClassRemapper {
    public RemappingClassAdapter(ClassVisitor cv, MappingBlob mapping) {
        super(cv, (Remapper)new BlobRemapper(mapping));
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor mv) {
        return new AsmMethodRemapper(mv, this.remapper);
    }

    private static class AsmMethodRemapper
    extends MethodRemapper {
        private static final Set<Handle> META_FACTORIES = ImmutableSet.of((Object)new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), (Object)new Handle(6, "java/lang/invoke/LambdaMetafactory", "altMetafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false));

        public AsmMethodRemapper(MethodVisitor mv, Remapper remapper) {
            super(mv, remapper);
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            if (META_FACTORIES.contains(bsm)) {
                String owner = Type.getReturnType((String)desc).getInternalName();
                String ownerDesc = ((Type)bsmArgs[0]).getDescriptor();
                name = this.remapper.mapMethodName(owner, name, ownerDesc);
            }
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }
    }

    private static class BlobRemapper
    extends Remapper {
        private final Map<String, ClassMapping> mappings;

        public BlobRemapper(MappingBlob mapping) {
            this.mappings = mapping.mappings;
        }

        public String map(String name) {
            ClassMapping map = this.mappings.get(name);
            return map != null ? map.mcpName : name;
        }

        public String mapFieldName(String owner, String name, String descriptor) {
            ClassMapping map = this.mappings.get(owner);
            if (map == null) {
                return name;
            }
            return map.fields.getOrDefault(name + ";;" + descriptor, name);
        }

        public String mapMethodName(String owner, String name, String descriptor) {
            ClassMapping map = this.mappings.get(owner);
            if (map == null) {
                return name;
            }
            return map.methods.getOrDefault(name + descriptor, name);
        }
    }
}

